/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.xdp;

import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.cos.util.ByteStream;
import com.adobe.internal.pdf.cos.util.OutputByteBuffer;
import com.adobe.internal.pdf.cos.util.exceptions.PDFIOException;
import com.adobe.internal.pdf.cos.util.filter.Base64Engine;
import com.adobe.internal.xfdf.XFDFObject;
import com.adobe.pdf.exceptions.XDPException;
import com.adobe.pdf.exceptions.XDPParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XDP2PDFReader {
    private OutputByteBuffer mPDFFileBuffer = null;
    private OutputStream mBase64pdfStream = null;
    private boolean hasAnnots;
    private boolean emptyAnnots;
    private boolean hasXFA;

    public PDFDocument createFromXDP(ByteStream byteStream) throws IOException {
        try {
            this.mPDFFileBuffer = new OutputByteBuffer();
            this.mBase64pdfStream = new Base64Engine.OutputDecodeStream(this.mPDFFileBuffer);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse((InputStream)byteStream, (DefaultHandler)new FirstPass());
            PDFDocument pDFDocument = new PDFDocument(this.mPDFFileBuffer);
            if (this.hasXFA) {
                pDFDocument.importXFA(byteStream.getByteBuffer());
            }
            if (this.hasAnnots) {
                XFDFObject.deleteAnnotations(pDFDocument);
                if (!this.emptyAnnots) {
                    byteStream.setPosition(0L);
                    XFDFObject.importAnnotations(byteStream, pDFDocument);
                }
            }
            return pDFDocument;
        }
        catch (SAXException sAXException) {
            throw new XDPParseException(sAXException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XDPException(parserConfigurationException.getMessage());
        }
        catch (TransformerException transformerException) {
            throw new XDPException(transformerException.getMessage());
        }
    }

    class FirstPass
    extends DefaultHandler {
        boolean inPdfNode = false;
        boolean inDocumentNode = false;
        boolean inChunkNode = false;
        boolean inXfdf = false;
        boolean inAnnots = false;
        boolean inDatasets = false;
        boolean inData = false;

        FirstPass() {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4 = string2;
            if (this.inAnnots) {
                XDP2PDFReader.this.emptyAnnots = false;
            }
            if (this.inData) {
                XDP2PDFReader.this.hasXFA = true;
            }
            if (string4 == null || string4.length() == 0) {
                string4 = string3;
            }
            if (string4 == null || string4.length() == 0) {
                throw new XDPParseException("Wrong XML structure");
            }
            if (string4.equals("xfdf")) {
                this.inXfdf = true;
            }
            if (this.inXfdf && string4.equals("annots")) {
                this.inAnnots = true;
                XDP2PDFReader.this.hasAnnots = true;
                XDP2PDFReader.this.emptyAnnots = true;
            }
            if (this.inDatasets) {
                if (string4.equals("xfa:data")) {
                    this.inData = true;
                }
            } else if (string4.equals("xfa:datasets")) {
                this.inDatasets = true;
            }
            if (this.inDocumentNode) {
                if (string4.equals("chunk")) {
                    this.inChunkNode = true;
                }
            } else if (this.inPdfNode) {
                if (string4.equals("document")) {
                    this.inDocumentNode = true;
                }
            } else if (string4.equals("pdf")) {
                this.inPdfNode = true;
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            String string4 = string2;
            if (string4 == null || string4.length() == 0) {
                string4 = string3;
            }
            if (string4 == null || string4.length() == 0) {
                throw new XDPParseException("Wrong XML structure");
            }
            if (this.inXfdf && string4.equals("xfdf")) {
                this.inXfdf = false;
            }
            if (this.inAnnots && string4.equals("annots")) {
                this.inAnnots = false;
            }
            if (this.inDocumentNode && string4.equals("document")) {
                this.inAnnots = false;
            }
            if (this.inPdfNode && string4.equals("pdf")) {
                this.inAnnots = false;
            }
            if (this.inChunkNode && string4.equals("chunk")) {
                this.inChunkNode = false;
                try {
                    XDP2PDFReader.this.mBase64pdfStream.close();
                }
                catch (IOException iOException) {
                    throw new PDFIOException(iOException.getMessage());
                }
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            try {
                if (this.inChunkNode) {
                    byte[] byArray = new byte[100];
                    while (n2 > 0) {
                        int n3 = Math.min(n2, 100);
                        for (int i = 0; i < n3; ++i) {
                            byArray[i] = (byte)cArray[n++];
                        }
                        XDP2PDFReader.this.mBase64pdfStream.write(byArray, 0, n3);
                        n2 -= n3;
                    }
                }
            }
            catch (IOException iOException) {
                throw new PDFIOException("Trouble decoding Base64 portion of XDP file");
            }
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }
    }
}

