/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.xdp;

import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.PDFInteractiveForm;
import com.adobe.internal.pdf.cos.util.filter.Base64Engine;
import com.adobe.internal.xfa.PDFFormSupport;
import com.adobe.internal.xfa.PDFXFAOutput;
import com.adobe.internal.xfdf.PDF2XFDFAnnotationsReader;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class PDF2XDPWriter
implements XMLReader {
    ContentHandler mOutputHandler;
    PDFDocument mDoc;

    public PDF2XDPWriter(PDFDocument pDFDocument) {
        this.mDoc = pDFDocument;
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        int n;
        Object object;
        AttributesImpl attributesImpl;
        if (this.mOutputHandler == null) {
            throw new SAXException("No content handler");
        }
        this.mOutputHandler.startDocument();
        this.mOutputHandler.processingInstruction("xfa", "generator=\"XPAAJ_V1.0\" APIVersion=\"1.4.3161.0\"");
        AttributesImpl attributesImpl2 = new AttributesImpl();
        AttributesImpl attributesImpl3 = new AttributesImpl();
        attributesImpl3.addAttribute("", "", "xmlns:xdp", "CDATA", "http://ns.adobe.com/xdp/");
        this.mOutputHandler.startElement("", "", "xdp:xdp", attributesImpl3);
        PDFInteractiveForm pDFInteractiveForm = this.mDoc.getInteractiveForm();
        InputStream inputStream = null;
        if (pDFInteractiveForm != null) {
            inputStream = PDFFormSupport.getFullXFAStream(pDFInteractiveForm);
        }
        if (inputStream != null && inputStream.available() > 0) {
            attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "", "xmlns:xfa", "CDATA", "http://www.xfa.org/schema/xfa-data/1.0/");
            this.mOutputHandler.startElement("", "", "xfa:datasets", attributesImpl);
            this.mOutputHandler.startElement("", "", "xfa:data", attributesImpl2);
            object = new PDFXFAOutput(pDFInteractiveForm, true);
            ((PDFXFAOutput)object).setContentHandler(this.mOutputHandler);
            ((PDFXFAOutput)object).HandleData(new InputSource(inputStream));
            this.mOutputHandler.endElement("", "", "xfa:data");
            this.mOutputHandler.endElement("", "", "xfa:datasets");
        }
        attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "", "xmlns", "CDATA", "http://ns.adobe.com/xdp/pdf/");
        this.mOutputHandler.startElement("", "", "pdf", attributesImpl);
        this.mOutputHandler.startElement("", "", "document", attributesImpl2);
        this.mOutputHandler.startElement("", "", "chunk", attributesImpl2);
        object = this.mDoc.save(false);
        Base64Engine.InputEncodeStream inputEncodeStream = new Base64Engine.InputEncodeStream((InputStream)object);
        byte[] byArray = new byte[78];
        char[] cArray = new char[78];
        char[] cArray2 = new char[]{'\n'};
        while ((n = inputEncodeStream.read(byArray)) >= 0) {
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                char c = (char)byArray[i];
                if (c == '\r' || c == '\n') continue;
                cArray[n2++] = (char)byArray[i];
            }
            this.mOutputHandler.characters(cArray, 0, n2);
            this.mOutputHandler.characters(cArray2, 0, 1);
            if (n > 0) continue;
        }
        this.mOutputHandler.endElement("", "", "chunk");
        this.mOutputHandler.endElement("", "", "document");
        this.mOutputHandler.endElement("", "", "pdf");
        PDF2XFDFAnnotationsReader pDF2XFDFAnnotationsReader = new PDF2XFDFAnnotationsReader(this.mDoc);
        pDF2XFDFAnnotationsReader.setContentHandler(this.mOutputHandler);
        pDF2XFDFAnnotationsReader.HandleAnnotations(false);
        this.mOutputHandler.endElement("", "", "xdp:xdp");
        this.mOutputHandler.endDocument();
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.mOutputHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.mOutputHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void parse(String string) throws IOException, SAXException {
    }
}

