/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdfedit;

import com.adobe.internal.pdfedit.CharacterTypeRange;
import com.adobe.internal.pdfedit.CharacterTypeTable;
import com.adobe.internal.pdfedit.PDECharacter;
import com.adobe.internal.pdfedit.PDEWord;
import com.adobe.internal.pdfedit.Wordafier;
import java.util.ArrayList;
import java.util.ListIterator;

class Wordafier1
extends Wordafier {
    private static ArrayList charTypes = new ArrayList();
    private CharacterTypeTable charTypeTable = new CharacterTypeTable(charTypes);

    Wordafier1() {
    }

    PDEWord extractNextWord(ArrayList arrayList) {
        PDEWord pDEWord = null;
        boolean bl = true;
        while (bl) {
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                PDECharacter pDECharacter = (PDECharacter)listIterator.next();
                if (!this.charTypeTable.isWhitespace(pDECharacter.getUnicodeString().charAt(0))) continue;
                listIterator.remove();
            }
        }
        return pDEWord;
    }

    boolean isWordBreak(PDECharacter pDECharacter, PDECharacter pDECharacter2) {
        return this.charTypeTable.isWordBreak(pDECharacter.getUnicodeString().charAt(0));
    }

    boolean isPunctuation(PDECharacter pDECharacter, PDECharacter pDECharacter2) {
        return this.charTypeTable.isPunctuation(pDECharacter.getUnicodeString().charAt(0));
    }

    boolean isWhitespace(PDECharacter pDECharacter) {
        return this.charTypeTable.isWhitespace(pDECharacter.getUnicodeString().charAt(0));
    }

    boolean isComma(PDECharacter pDECharacter) {
        return this.charTypeTable.isComma(pDECharacter.getUnicodeString().charAt(0));
    }

    boolean isHyphen(PDECharacter pDECharacter) {
        return this.charTypeTable.isHyphen(pDECharacter.getUnicodeString().charAt(0));
    }

    boolean isPeriod(PDECharacter pDECharacter) {
        return this.charTypeTable.isPeriod(pDECharacter.getUnicodeString().charAt(0));
    }

    boolean isDigit(PDECharacter pDECharacter) {
        return this.charTypeTable.isDigit(pDECharacter.getUnicodeString().charAt(0));
    }

    boolean isLetter(PDECharacter pDECharacter) {
        return this.charTypeTable.isLetter(pDECharacter.getUnicodeString().charAt(0));
    }

    boolean isUppercase(PDECharacter pDECharacter) {
        return this.charTypeTable.isUppercase(pDECharacter.getUnicodeString().charAt(0));
    }

    boolean isSoftHyphen(PDECharacter pDECharacter) {
        return this.charTypeTable.isSoftHyphen(pDECharacter.getUnicodeString().charAt(0));
    }

    boolean isLigature(PDECharacter pDECharacter) {
        return this.charTypeTable.isLigature(pDECharacter.getUnicodeString().charAt(0));
    }

    static {
        charTypes.add(new CharacterTypeRange('\u0001', '\u001f', CharacterTypeRange.WORD_BREAK | CharacterTypeRange.WHITESPACE));
        charTypes.add(new CharacterTypeRange(' ', ' ', CharacterTypeRange.WORD_BREAK | CharacterTypeRange.WHITESPACE));
        charTypes.add(new CharacterTypeRange('!', '+', CharacterTypeRange.WORD_BREAK | CharacterTypeRange.PUNCTUATION));
        charTypes.add(new CharacterTypeRange(',', ',', CharacterTypeRange.WORD_BREAK | CharacterTypeRange.PUNCTUATION | CharacterTypeRange.COMMA));
        charTypes.add(new CharacterTypeRange('-', '-', CharacterTypeRange.WORD_BREAK | CharacterTypeRange.PUNCTUATION | CharacterTypeRange.HYPHEN));
        charTypes.add(new CharacterTypeRange('.', '.', CharacterTypeRange.WORD_BREAK | CharacterTypeRange.PUNCTUATION | CharacterTypeRange.PERIOD));
        charTypes.add(new CharacterTypeRange('/', '/', CharacterTypeRange.WORD_BREAK | CharacterTypeRange.PUNCTUATION));
        charTypes.add(new CharacterTypeRange('0', '9', CharacterTypeRange.DIGIT));
        charTypes.add(new CharacterTypeRange(':', '@', CharacterTypeRange.WORD_BREAK | CharacterTypeRange.PUNCTUATION));
        charTypes.add(new CharacterTypeRange('A', 'Z', CharacterTypeRange.LETTER | CharacterTypeRange.UPPERCASE));
        charTypes.add(new CharacterTypeRange('[', '`', CharacterTypeRange.WORD_BREAK | CharacterTypeRange.PUNCTUATION));
        charTypes.add(new CharacterTypeRange('a', 'z', CharacterTypeRange.LETTER));
        charTypes.add(new CharacterTypeRange('{', '~', CharacterTypeRange.WORD_BREAK | CharacterTypeRange.PUNCTUATION));
        charTypes.add(new CharacterTypeRange('\u00a0', '\u00a0', CharacterTypeRange.WHITESPACE));
        charTypes.add(new CharacterTypeRange('\u00ad', '\u00ad', CharacterTypeRange.PUNCTUATION | CharacterTypeRange.SOFT_HYPHEN));
        charTypes.add(new CharacterTypeRange('\u00c0', '\u00d6', CharacterTypeRange.LETTER));
        charTypes.add(new CharacterTypeRange('\u00d8', '\u00f6', CharacterTypeRange.LETTER));
        charTypes.add(new CharacterTypeRange('\u00f8', '\u02b8', CharacterTypeRange.LETTER));
        charTypes.add(new CharacterTypeRange('\u0300', '\u036f', CharacterTypeRange.LETTER));
        charTypes.add(new CharacterTypeRange('\u0391', '\u0588', CharacterTypeRange.LETTER));
        charTypes.add(new CharacterTypeRange('\u0590', '\u0652', CharacterTypeRange.LETTER));
        charTypes.add(new CharacterTypeRange('\u0660', '\u0669', CharacterTypeRange.DIGIT));
        charTypes.add(new CharacterTypeRange('\u066a', '\u066d', CharacterTypeRange.WORD_BREAK | CharacterTypeRange.PUNCTUATION));
        charTypes.add(new CharacterTypeRange('\u0671', '\u06f9', CharacterTypeRange.LETTER));
        charTypes.add(new CharacterTypeRange('\u0900', '\u1fff', CharacterTypeRange.LETTER));
        charTypes.add(new CharacterTypeRange('\u2000', '\u200f', CharacterTypeRange.WORD_BREAK | CharacterTypeRange.WHITESPACE));
        charTypes.add(new CharacterTypeRange('\u2010', '\u2010', CharacterTypeRange.WORD_BREAK | CharacterTypeRange.PUNCTUATION | CharacterTypeRange.HYPHEN));
        charTypes.add(new CharacterTypeRange('\u2011', '\u2011', CharacterTypeRange.PUNCTUATION | CharacterTypeRange.HYPHEN));
        charTypes.add(new CharacterTypeRange('\u2012', '\u2027', CharacterTypeRange.WORD_BREAK | CharacterTypeRange.PUNCTUATION));
        charTypes.add(new CharacterTypeRange('\u2028', '\u202f', CharacterTypeRange.WORD_BREAK | CharacterTypeRange.WHITESPACE));
        charTypes.add(new CharacterTypeRange('\u2030', '\u204d', CharacterTypeRange.WORD_BREAK | CharacterTypeRange.PUNCTUATION));
        charTypes.add(new CharacterTypeRange('\u206a', '\u206f', CharacterTypeRange.WORD_BREAK | CharacterTypeRange.WHITESPACE));
        charTypes.add(new CharacterTypeRange('\u2070', '\u209f', CharacterTypeRange.LETTER));
        charTypes.add(new CharacterTypeRange('\u20a0', '\u20cf', CharacterTypeRange.DIGIT));
        charTypes.add(new CharacterTypeRange('\u20d0', '\u20ff', CharacterTypeRange.LETTER));
        charTypes.add(new CharacterTypeRange('\u2190', '\u23ff', CharacterTypeRange.WORD_BREAK | CharacterTypeRange.PUNCTUATION));
        charTypes.add(new CharacterTypeRange('\u3021', '\u3029', CharacterTypeRange.DIGIT));
        charTypes.add(new CharacterTypeRange('\u302a', '\u302f', CharacterTypeRange.LETTER));
        charTypes.add(new CharacterTypeRange('\u3031', '\u3035', CharacterTypeRange.LETTER));
        charTypes.add(new CharacterTypeRange('\u3099', '\u309c', CharacterTypeRange.PUNCTUATION));
        charTypes.add(new CharacterTypeRange('\u3100', '\u318f', CharacterTypeRange.LETTER));
        charTypes.add(new CharacterTypeRange('\u3371', '\u3376', CharacterTypeRange.LETTER | CharacterTypeRange.LIGATURE));
        charTypes.add(new CharacterTypeRange('\u3380', '\u33dd', CharacterTypeRange.LETTER | CharacterTypeRange.LIGATURE));
        charTypes.add(new CharacterTypeRange('\uac00', '\ud7af', CharacterTypeRange.LETTER));
        charTypes.add(new CharacterTypeRange('\ufb00', '\ufb06', CharacterTypeRange.LETTER | CharacterTypeRange.LIGATURE));
        charTypes.add(new CharacterTypeRange('\ufb1f', '\ufb1f', CharacterTypeRange.LETTER | CharacterTypeRange.LIGATURE));
        charTypes.add(new CharacterTypeRange('\ufb20', '\ufbe7', CharacterTypeRange.LETTER));
        charTypes.add(new CharacterTypeRange('\ufbea', '\ufbf8', CharacterTypeRange.LETTER | CharacterTypeRange.LIGATURE));
        charTypes.add(new CharacterTypeRange('\ufbfc', '\ufbff', CharacterTypeRange.LETTER));
        charTypes.add(new CharacterTypeRange('\ufc00', '\ufdfd', CharacterTypeRange.LETTER | CharacterTypeRange.LIGATURE));
        charTypes.add(new CharacterTypeRange('\ufe70', '\ufef4', CharacterTypeRange.LETTER));
        charTypes.add(new CharacterTypeRange('\ufef5', '\ufefc', CharacterTypeRange.LETTER | CharacterTypeRange.LIGATURE));
        charTypes.add(new CharacterTypeRange('\uff01', '\uff0b', CharacterTypeRange.WORD_BREAK | CharacterTypeRange.PUNCTUATION));
        charTypes.add(new CharacterTypeRange('\uff0c', '\uff0c', CharacterTypeRange.WORD_BREAK | CharacterTypeRange.PUNCTUATION | CharacterTypeRange.COMMA));
        charTypes.add(new CharacterTypeRange('\uff0d', '\uff0d', CharacterTypeRange.WORD_BREAK | CharacterTypeRange.PUNCTUATION | CharacterTypeRange.HYPHEN));
        charTypes.add(new CharacterTypeRange('\uff0e', '\uff0e', CharacterTypeRange.WORD_BREAK | CharacterTypeRange.PUNCTUATION | CharacterTypeRange.COMMA));
        charTypes.add(new CharacterTypeRange('\uff0f', '\uff0f', CharacterTypeRange.WORD_BREAK | CharacterTypeRange.PUNCTUATION));
        charTypes.add(new CharacterTypeRange('\uff10', '\uff19', CharacterTypeRange.DIGIT));
        charTypes.add(new CharacterTypeRange('\uff1a', '\uff20', CharacterTypeRange.WORD_BREAK | CharacterTypeRange.PUNCTUATION));
        charTypes.add(new CharacterTypeRange('\uff21', '\uff3a', CharacterTypeRange.LETTER | CharacterTypeRange.UPPERCASE));
        charTypes.add(new CharacterTypeRange('\uff40', '\uff40', CharacterTypeRange.WORD_BREAK | CharacterTypeRange.PUNCTUATION));
        charTypes.add(new CharacterTypeRange('\uff41', '\uff5a', CharacterTypeRange.LETTER));
        charTypes.add(new CharacterTypeRange('\uff5b', '\uff5e', CharacterTypeRange.WORD_BREAK | CharacterTypeRange.PUNCTUATION));
    }
}

