/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdfedit;

import com.adobe.internal.pdfedit.HorizontalCharacterSorter;
import com.adobe.internal.pdfedit.HorizontalTextRunSorter;
import com.adobe.internal.pdfedit.PDECharacter;
import com.adobe.internal.pdfedit.PDETextObject;
import com.adobe.internal.pdfedit.PDETextObjectList;
import com.adobe.internal.pdfedit.PDETextRun;
import com.adobe.internal.pdfedit.PDETextRunList;
import com.adobe.internal.pdfedit.PDEWord;
import com.adobe.internal.pdfedit.PDEWordList;
import com.adobe.internal.pdfedit.VerticalCharacterSorter;
import com.adobe.internal.pdfedit.VerticalTextRunSorter;
import com.adobe.internal.pdfedit.Wordafier;
import com.adobe.internal.pdfedit.Wordafier1;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;

public class PDEWordafier {
    private int pageNumber;
    private PDETextObjectList textObjects;
    private TreeSet sortedHorizTextRuns;
    private TreeSet sortedVertTextRuns;
    private TreeSet sortedHorizCharacters;
    private TreeSet sortedVertCharacters;

    PDEWordafier(int n, PDETextObjectList pDETextObjectList) {
        this.pageNumber = n;
        this.textObjects = pDETextObjectList;
        this.sortCharacters();
    }

    private void sortTextRuns() {
        this.sortedHorizTextRuns = new TreeSet(new HorizontalTextRunSorter());
        this.sortedVertTextRuns = new TreeSet(new VerticalTextRunSorter());
        Iterator iterator = this.textObjects.iterator();
        while (iterator.hasNext()) {
            PDETextObject pDETextObject = (PDETextObject)iterator.next();
            PDETextRunList pDETextRunList = pDETextObject.getTextRuns();
            if (pDETextRunList == null) continue;
            Iterator iterator2 = pDETextRunList.iterator();
            while (iterator2.hasNext()) {
                PDETextRun pDETextRun = (PDETextRun)iterator2.next();
                if (pDETextRun.isHorizontalWritingMode()) {
                    this.sortedHorizTextRuns.add(pDETextRun);
                    continue;
                }
                this.sortedVertTextRuns.add(pDETextRun);
            }
        }
    }

    private void sortCharacters() {
        this.sortedHorizCharacters = new TreeSet(new HorizontalCharacterSorter());
        this.sortedVertCharacters = new TreeSet(new VerticalCharacterSorter());
        Iterator iterator = this.textObjects.iterator();
        while (iterator.hasNext()) {
            PDETextObject pDETextObject = (PDETextObject)iterator.next();
            PDETextRunList pDETextRunList = pDETextObject.getTextRuns();
            if (pDETextRunList == null) continue;
            Iterator iterator2 = pDETextRunList.iterator();
            while (iterator2.hasNext()) {
                PDETextRun pDETextRun = (PDETextRun)iterator2.next();
                if (pDETextRun.isHorizontalWritingMode()) {
                    this.sortedHorizCharacters.addAll(pDETextRun.getCharacters());
                    continue;
                }
                this.sortedVertCharacters.addAll(pDETextRun.getCharacters());
            }
        }
    }

    PDEWordList buildWordList1() {
        PDEWordList pDEWordList = new PDEWordList();
        ArrayList arrayList = new ArrayList(this.sortedHorizCharacters);
        Wordafier1 wordafier1 = new Wordafier1();
        while (arrayList.size() > 0) {
            PDEWord pDEWord = ((Wordafier)wordafier1).extractNextWord(arrayList);
            if (pDEWord == null) continue;
            pDEWordList.add(pDEWord);
        }
        return pDEWordList;
    }

    PDEWordList buildWordList() {
        PDEWordList pDEWordList = new PDEWordList();
        Wordafier1 wordafier1 = new Wordafier1();
        ArrayList arrayList = new ArrayList(this.sortedHorizCharacters);
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Object object = null;
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        while (arrayList.size() > 0) {
            Object object2;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext() && !bl4) {
                object2 = (PDECharacter)iterator.next();
                if (!wordafier1.isWhitespace((PDECharacter)object2)) {
                    if (object == null) {
                        bl = false;
                        bl2 = false;
                        bl3 = false;
                        arrayList2.add(object2);
                        iterator.remove();
                        object = object2;
                        d = ((PDECharacter)object).getSpaceCharWidth();
                        d2 = ((PDECharacter)object2).getVerticalFontSize();
                        if (wordafier1.isLetter((PDECharacter)object2)) {
                            bl = true;
                            continue;
                        }
                        if (wordafier1.isDigit((PDECharacter)object2)) {
                            bl2 = true;
                            continue;
                        }
                        if (!wordafier1.isPunctuation((PDECharacter)object2, null)) continue;
                        bl3 = true;
                        continue;
                    }
                    boolean bl5 = false;
                    if (((PDECharacter)object).getTextRun() != ((PDECharacter)object2).getTextRun()) {
                        d = ((PDECharacter)object).getSpaceCharWidth();
                        d2 = ((PDECharacter)object2).getVerticalFontSize();
                    }
                    double d3 = ((PDECharacter)object).getXDistanceTo((PDECharacter)object2);
                    double d4 = Math.abs(d3);
                    double d5 = ((PDECharacter)object).getAbsYDistanceTo((PDECharacter)object2);
                    if (d4 <= 0.5 * d || d3 < 0.0 && ((PDECharacter)object).getWidth() + d3 >= 0.0 && d5 <= 0.1 * d2) {
                        boolean bl6 = wordafier1.isWordBreak((PDECharacter)object2, null);
                        boolean bl7 = wordafier1.isPunctuation((PDECharacter)object2, null);
                        if (bl6) {
                            char c;
                            bl4 = true;
                            if (bl && bl7) {
                                bl5 = true;
                                c = ((PDECharacter)object2).getUnicodeString().charAt(0);
                                if (c == '\'' || c == '\u2019') {
                                    bl4 = false;
                                }
                            } else if (bl2) {
                                c = wordafier1.isDigit((PDECharacter)object2);
                                boolean bl8 = wordafier1.isComma((PDECharacter)object2);
                                boolean bl9 = wordafier1.isPeriod((PDECharacter)object2);
                                if (c != '\u0000' || bl8 || bl9) {
                                    bl5 = true;
                                    bl4 = false;
                                }
                            } else if (bl3 && bl7) {
                                bl5 = true;
                                bl4 = false;
                            }
                        } else if (bl3 && !bl7) {
                            bl5 = false;
                            bl4 = true;
                        } else {
                            bl5 = true;
                        }
                        if (!bl5) continue;
                        arrayList2.add(object2);
                        object = object2;
                        iterator.remove();
                        continue;
                    }
                    if (!(((PDECharacter)object).getAbsYDistanceTo((PDECharacter)object2) > 0.1 * d2)) continue;
                    break;
                }
                iterator.remove();
                if (object == null) continue;
                bl4 = true;
            }
            object2 = PDECharacter.createUnicodeString(arrayList2);
            ArrayList arrayList3 = PDECharacter.createBoundingQuads(arrayList2);
            PDEWord pDEWord = new PDEWord((String)object2, this.pageNumber, arrayList3);
            pDEWordList.add(pDEWord);
            arrayList2.clear();
            object = null;
            bl4 = false;
        }
        return pDEWordList;
    }
}

