/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdfedit;

import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdfedit.PDEContentOperator;
import com.adobe.internal.pdfedit.PDEContentParser;
import com.adobe.internal.pdfedit.PDEOperandStack;
import com.adobe.internal.pdfedit.PDEPageDescription;
import com.adobe.pdf.exceptions.PDFException;

class PDETextStateOperator
extends PDEContentOperator {
    static final int Tc = 1;
    static final int Tw = 2;
    static final int Tz = 3;
    static final int TL = 4;
    static final int Tf = 5;
    static final int Tr = 6;
    static final int Ts = 7;

    PDETextStateOperator(int n, ASName aSName) {
        super(n, aSName);
    }

    public void process(PDEContentParser pDEContentParser, PDEPageDescription pDEPageDescription) {
        if (!pDEPageDescription.isStatePageDescLevel() && !pDEPageDescription.isStateTextObject()) {
            throw new PDFException("text state operation not allowed in state " + pDEPageDescription.getState());
        }
        PDEOperandStack pDEOperandStack = pDEContentParser.getOperandStack();
        switch (this.getType()) {
            case 1: {
                double d = pDEOperandStack.popNumber().doubleValue();
                pDEPageDescription.operator_Tc(d);
                break;
            }
            case 2: {
                double d = pDEOperandStack.popNumber().doubleValue();
                pDEPageDescription.operator_Tw(d);
                break;
            }
            case 3: {
                double d = pDEOperandStack.popNumber().doubleValue();
                pDEPageDescription.operator_Tz(d);
                break;
            }
            case 4: {
                double d = pDEOperandStack.popNumber().doubleValue();
                pDEPageDescription.operator_TL(d);
                break;
            }
            case 5: {
                double d = pDEOperandStack.popNumber().doubleValue();
                ASName aSName = pDEOperandStack.popName();
                pDEPageDescription.operator_Tf(aSName, d);
                break;
            }
            case 6: {
                int n = pDEOperandStack.popNumber().intValue();
                pDEPageDescription.operator_Tr(n);
                break;
            }
            case 7: {
                double d = pDEOperandStack.popNumber().doubleValue();
                pDEPageDescription.operator_Ts(d);
            }
        }
    }
}

