/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdfedit;

import com.adobe.internal.pdf.cos.util.ASArray;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ASString;
import com.adobe.internal.pdfedit.PDEContentOperator;
import com.adobe.internal.pdfedit.PDEContentParser;
import com.adobe.internal.pdfedit.PDEOperandStack;
import com.adobe.internal.pdfedit.PDEPageDescription;
import com.adobe.pdf.exceptions.PDFException;

class PDETextShowingOperator
extends PDEContentOperator {
    static final int Tj = 1;
    static final int TJ = 2;
    static final int SingleQuote = 3;
    static final int DoubleQuote = 4;

    PDETextShowingOperator(int n, ASName aSName) {
        super(n, aSName);
    }

    public void process(PDEContentParser pDEContentParser, PDEPageDescription pDEPageDescription) {
        if (!pDEPageDescription.isStateTextObject()) {
            throw new PDFException("text showing operation not allowed in state " + pDEPageDescription.getState());
        }
        PDEOperandStack pDEOperandStack = pDEContentParser.getOperandStack();
        switch (this.getType()) {
            case 1: {
                ASString aSString = pDEOperandStack.popString();
                pDEPageDescription.operator_Tj(aSString);
                break;
            }
            case 2: {
                ASArray aSArray = pDEOperandStack.popArray();
                pDEPageDescription.operator_TJ(aSArray);
                break;
            }
            case 3: {
                ASString aSString = pDEOperandStack.popString();
                pDEPageDescription.operator_SingleQuote(aSString);
                break;
            }
            case 4: {
                ASString aSString = pDEOperandStack.popString();
                double d = pDEOperandStack.popNumber().doubleValue();
                double d2 = pDEOperandStack.popNumber().doubleValue();
                pDEPageDescription.operator_DoubleQuote(d2, d, aSString);
            }
        }
    }
}

