/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdfedit;

import com.adobe.internal.pdf.PDFFont;
import com.adobe.internal.pdf.PDFFontSimple;
import com.adobe.internal.pdf.PDFFontType0;
import com.adobe.internal.pdf.PDFSimpleFontEncoding;
import com.adobe.internal.pdf.PDFToUnicodeCMap;
import com.adobe.internal.pdf.PDFType0FontEncoding;
import com.adobe.internal.pdf.PDFWritingMode;
import com.adobe.internal.pdf.cos.util.ASArray;
import com.adobe.internal.pdf.cos.util.ASCoordinate;
import com.adobe.internal.pdf.cos.util.ASMatrix;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ASNumber;
import com.adobe.internal.pdf.cos.util.ASQuad;
import com.adobe.internal.pdf.cos.util.ASRectangle;
import com.adobe.internal.pdf.cos.util.ASString;
import com.adobe.internal.pdf.cos.util.encodings.StandardEncoding;
import com.adobe.internal.pdfedit.PDECharacter;
import com.adobe.internal.pdfedit.PDEGState;
import com.adobe.internal.pdfedit.PDEGlyphInfo;
import com.adobe.internal.pdfedit.PDEGlyphOffsetInfo;
import com.adobe.internal.pdfedit.PDETextState;
import com.adobe.internal.pdfedit.StringContainer;
import com.adobe.pdf.exceptions.PDFException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PDETextRun
implements StringContainer {
    private ASArray tjArray;
    private ASMatrix tm;
    private PDEGState gState;
    private ArrayList characterList;

    PDETextRun(ASString aSString, ASMatrix aSMatrix, PDEGState pDEGState) {
        this.tjArray = new ASArray();
        this.tjArray.add(aSString);
        this.tm = new ASMatrix(aSMatrix);
        this.gState = new PDEGState(pDEGState);
    }

    PDETextRun(ASArray aSArray, ASMatrix aSMatrix, PDEGState pDEGState) {
        this.tjArray = aSArray;
        this.tm = new ASMatrix(aSMatrix);
        this.gState = new PDEGState(pDEGState);
    }

    PDETextRun(PDETextRun pDETextRun) {
        this.tjArray = new ASArray();
        Iterator iterator = pDETextRun.tjArray.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof ASString) {
                this.tjArray.add(new ASString(((ASString)e).getBytes()));
                continue;
            }
            this.tjArray.add(new ASNumber((ASNumber)e));
        }
        this.tm = new ASMatrix(pDETextRun.getTextMatrix());
        this.gState = new PDEGState(pDETextRun.getGState());
    }

    public String toString() {
        return this.getUnicodeString();
    }

    public ASString getEncodedString() {
        if (this.tjArray.size() > 1) {
            Object object;
            int n = 0;
            Iterator iterator = this.tjArray.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!(object instanceof ASString)) continue;
                n += ((ASString)object).getBytes().length;
            }
            object = new byte[n];
            int n2 = 0;
            iterator = this.tjArray.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof ASString)) continue;
                byte[] byArray = ((ASString)e).getBytes();
                int n3 = byArray.length;
                System.arraycopy(byArray, 0, object, n2, n3);
                n2 += n3;
            }
            return new ASString((byte[])object);
        }
        return (ASString)this.tjArray.get(0);
    }

    String getUnicodeString(byte by) {
        byte[] byArray = new byte[]{by};
        return this.getUnicodeString(new ASString(byArray));
    }

    String getUnicodeString(char c) {
        byte[] byArray = new byte[]{(byte)((c & 0xFF00) >> 8), (byte)(c & 0xFF)};
        return this.getUnicodeString(new ASString(byArray));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getUnicodeString(ASString aSString) {
        String string = null;
        PDFFont pDFFont = this.getTextState().getFont();
        if (pDFFont instanceof PDFFontSimple) {
            PDFSimpleFontEncoding pDFSimpleFontEncoding;
            PDFToUnicodeCMap pDFToUnicodeCMap = ((PDFFontSimple)pDFFont).getToUnicodeCMap();
            if (pDFToUnicodeCMap != null) {
                string = pDFToUnicodeCMap.toUnicode(aSString, false);
            }
            if (pDFToUnicodeCMap != null) {
                if (!string.equals("\ufffd")) return string;
            }
            if ((pDFSimpleFontEncoding = ((PDFFontSimple)pDFFont).getEncoding()) != null) {
                return pDFSimpleFontEncoding.toUnicode(aSString);
            }
            StandardEncoding standardEncoding = StandardEncoding.getEncoding();
            return standardEncoding.toUnicode(aSString);
        }
        if (!(pDFFont instanceof PDFFontType0)) return string;
        PDFToUnicodeCMap pDFToUnicodeCMap = ((PDFFontType0)pDFFont).getToUnicodeCMap();
        if (pDFToUnicodeCMap == null) throw new PDFException("need to handle composite fonts using pre-defined cmaps");
        PDFType0FontEncoding pDFType0FontEncoding = ((PDFFontType0)pDFFont).getEncoding();
        ASName aSName = null;
        if (!pDFType0FontEncoding.isPredefinedCMap()) throw new PDFException("need to handle custom cmap");
        aSName = pDFType0FontEncoding.getCMapName();
        if (aSName == ASName.k_Identity_H) return pDFToUnicodeCMap.toUnicode(aSString, true);
        if (aSName != ASName.k_Identity_V) throw new PDFException("need to handle other encodings");
        return pDFToUnicodeCMap.toUnicode(aSString, true);
    }

    public String getUnicodeString() {
        return this.getUnicodeString(this.getEncodedString());
    }

    boolean isHorizontalWritingMode() {
        PDFWritingMode pDFWritingMode = this.getTextState().getFont().getWritingMode();
        return pDFWritingMode == PDFWritingMode.HORIZONTAL;
    }

    int getCharCodeCount() {
        int n = this.getTextState().getFont().getCharCodeSize();
        return this.getEncodedString().getBytes().length / n;
    }

    double getCharWidth(int n) {
        PDFFont pDFFont = this.getTextState().getFont();
        return pDFFont.getGlyphWidth(n);
    }

    double getCharHeight(int n) {
        PDFFont pDFFont = this.getTextState().getFont();
        return pDFFont.getGlyphHeight(n);
    }

    double getFontAscent() {
        double d;
        PDFFont pDFFont = this.getTextState().getFont();
        double d2 = pDFFont.getBBox().top();
        return d2 > (d = pDFFont.getAscent()) ? d2 : d;
    }

    double getFontDescent() {
        double d;
        PDFFont pDFFont = this.getTextState().getFont();
        double d2 = pDFFont.getBBox().bottom();
        return d2 < (d = pDFFont.getDescent()) ? d2 : d;
    }

    ASCoordinate getDeviceSpaceOrigin() {
        ASCoordinate aSCoordinate = new ASCoordinate(0.0, 0.0);
        aSCoordinate = aSCoordinate.transform(this.getFontMatrix());
        ASMatrix aSMatrix = this.getTextSpaceToDeviceSpaceCTM();
        return aSCoordinate.transform(aSMatrix);
    }

    PDEGlyphInfo getHorizGlyphInfo(int n, int n2) {
        PDEGlyphOffsetInfo[] pDEGlyphOffsetInfoArray = new PDEGlyphOffsetInfo[n2];
        PDETextState pDETextState = this.getTextState();
        int n3 = pDETextState.getFont().getCharCodeSize();
        double d = pDETextState.getFontSize();
        double d2 = pDETextState.getHorizScaling() / 100.0;
        double d3 = pDETextState.getCharSpacing();
        double d4 = pDETextState.getWordSpacing();
        double d5 = d * d2;
        int n4 = this.getTextState().getFont().getCharCode(' ');
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int n5 = n + n2 - 1;
        int n6 = 0;
        Iterator iterator = this.tjArray.iterator();
        block0: while (iterator.hasNext() && n6 <= n5) {
            int n7;
            Object e = iterator.next();
            if (e instanceof ASNumber) {
                double d9 = ((ASNumber)e).intValue();
                d6 += -d9 / 1000.0 * d * d2;
                continue;
            }
            if (!(e instanceof ASString)) continue;
            byte[] byArray = null;
            char[] cArray = null;
            if (n3 == 1) {
                byArray = ((ASString)e).getBytes();
                n7 = byArray.length;
            } else {
                cArray = ((ASString)e).getChars();
                n7 = cArray.length;
            }
            for (int i = 0; i < n7; ++i) {
                if (n6 < n) {
                    ++n6;
                    continue;
                }
                if (n6 > n5) continue block0;
                int n8 = n3 == 1 ? byArray[i] : cArray[i];
                if (n8 < 0) {
                    n8 += 256;
                }
                double d10 = this.getCharWidth(n8) / 1000.0;
                pDEGlyphOffsetInfoArray[n6 - n] = new PDEGlyphOffsetInfo(d6 * d5, d10 * d5);
                if (d6 < d7) {
                    d7 = d6;
                }
                if ((d6 += d10 * d5) > d8) {
                    d8 = d6;
                }
                d6 += d3 * d2;
                if (n8 != n4) continue;
                d6 += d4 * d2;
            }
        }
        return new PDEGlyphInfo(pDEGlyphOffsetInfoArray, d7, d8);
    }

    ArrayList getCharacters() {
        ArrayList<PDECharacter> arrayList = new ArrayList<PDECharacter>();
        PDETextState pDETextState = this.getTextState();
        int n = pDETextState.getFont().getCharCodeSize();
        double d = pDETextState.getFontSize();
        double d2 = pDETextState.getHorizScaling() / 100.0;
        double d3 = pDETextState.getCharSpacing();
        double d4 = pDETextState.getWordSpacing();
        double d5 = d * d2;
        int n2 = this.getTextState().getFont().getCharCode(' ');
        ASMatrix aSMatrix = this.getTextSpaceToDeviceSpaceCTM();
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int n3 = 0;
        Iterator iterator = this.tjArray.iterator();
        while (iterator.hasNext()) {
            int n4;
            Object e = iterator.next();
            if (e instanceof ASNumber) {
                double d9 = ((ASNumber)e).intValue();
                d6 += -d9 / 1000.0 * d * d2;
                continue;
            }
            if (!(e instanceof ASString)) continue;
            byte[] byArray = null;
            char[] cArray = null;
            if (n == 1) {
                byArray = ((ASString)e).getBytes();
                n4 = byArray.length;
            } else {
                cArray = ((ASString)e).getChars();
                n4 = cArray.length;
            }
            for (int i = 0; i < n4; ++i) {
                int n5 = n == 1 ? byArray[i] : cArray[i];
                if (n5 < 0) {
                    n5 += 256;
                }
                double d10 = this.getCharWidth(n5) / 1000.0;
                if (d6 < d7) {
                    d7 = d6;
                }
                ASCoordinate aSCoordinate = new ASCoordinate(d6, 0.0);
                ASCoordinate aSCoordinate2 = new ASCoordinate(d6 += d10 * d5, 0.0);
                if (d6 > d8) {
                    d8 = d6;
                }
                d6 += d3 * d2;
                if (n5 == n2) {
                    d6 += d4 * d2;
                }
                aSCoordinate = aSCoordinate.transform(aSMatrix);
                aSCoordinate2 = aSCoordinate2.transform(aSMatrix);
                PDECharacter pDECharacter = new PDECharacter(this, n3++, n5, aSCoordinate, aSCoordinate2);
                arrayList.add(pDECharacter);
            }
        }
        return arrayList;
    }

    ASMatrix getFontMatrix() {
        PDETextState pDETextState = this.getTextState();
        double d = pDETextState.getFontSize();
        double d2 = pDETextState.getHorizScaling() / 100.0;
        double d3 = pDETextState.getRise();
        return new ASMatrix(d * d2, 0.0, 0.0, d, 0.0, d3);
    }

    ASMatrix getTextSpaceToDeviceSpaceCTM() {
        return this.tm.concat(this.getGState().getCTM());
    }

    boolean isRotatedOrSkewed() {
        ASMatrix aSMatrix = this.getTextSpaceToDeviceSpaceCTM();
        return aSMatrix.getb() != 0.0 || aSMatrix.getc() != 0.0;
    }

    private ASQuad getTextSpaceQuadHorizontal(int n, int n2, boolean bl) {
        ASCoordinate aSCoordinate;
        Object object;
        PDETextState pDETextState = this.getTextState();
        int n3 = pDETextState.getFont().getCharCodeSize();
        double d = pDETextState.getFontSize();
        double d2 = pDETextState.getHorizScaling() / 100.0;
        double d3 = pDETextState.getCharSpacing();
        double d4 = pDETextState.getWordSpacing();
        ASMatrix aSMatrix = this.getFontMatrix();
        double d5 = this.getFontAscent() / 1000.0 * d;
        double d6 = this.getFontDescent() / 1000.0 * d;
        int n4 = this.getTextState().getFont().getCharCode(' ');
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        int n5 = n + n2 - 1;
        int n6 = 0;
        Iterator iterator = this.tjArray.iterator();
        while (iterator.hasNext() && n6 <= n5) {
            double d10;
            int n7;
            int n8;
            object = iterator.next();
            if (object instanceof ASNumber) {
                double d11 = ((ASNumber)object).intValue();
                d7 += -d11 / 1000.0 * d * d2;
                continue;
            }
            if (!(object instanceof ASString)) continue;
            if (n3 == 1) {
                byte[] byArray = ((ASString)object).getBytes();
                for (n8 = 0; n8 < byArray.length && n6 <= n5; ++n6, ++n8) {
                    n7 = byArray[n8];
                    if (n7 < 0) {
                        n7 += 256;
                    }
                    d10 = this.getCharWidth(n7) / 1000.0;
                    if (n6 == n || d7 < d8) {
                        d8 = d7;
                    }
                    d7 += d10 * d * d2;
                    if (n6 >= n && d7 > d9) {
                        d9 = d7;
                    }
                    d7 += d3 * d2;
                    if (n7 != n4) continue;
                    d7 += d4 * d2;
                }
                continue;
            }
            char[] cArray = ((ASString)object).getChars();
            for (n8 = 0; n8 < cArray.length && n6 <= n5; ++n6, ++n8) {
                n7 = cArray[n8];
                d10 = this.getCharWidth(n7) / 1000.0;
                if (n6 == n || d7 < d8) {
                    d8 = d7;
                }
                d7 += d10 * d * d2;
                if (n6 >= n && d7 > d9) {
                    d9 = d7;
                }
                d7 += d3 * d2;
                if (n7 != n4) continue;
                d7 += d4 * d2;
            }
        }
        if (!bl) {
            object = new ASCoordinate(d8, d6);
            aSCoordinate = new ASCoordinate(d9, d5);
        } else if (d7 >= 0.0) {
            object = new ASCoordinate(d8, d6);
            aSCoordinate = new ASCoordinate(d7, d5);
        } else {
            object = new ASCoordinate(d9, d6);
            aSCoordinate = new ASCoordinate(d7 += d9, d5);
        }
        return new ASQuad(new ASRectangle((ASCoordinate)object, aSCoordinate));
    }

    private ASQuad getTextSpaceQuadVertical(int n, int n2, boolean bl) {
        Object object;
        Object object2;
        PDETextState pDETextState = this.getTextState();
        double d = pDETextState.getFontSize();
        double d2 = pDETextState.getHorizScaling();
        double d3 = pDETextState.getCharSpacing();
        double d4 = pDETextState.getWordSpacing();
        double d5 = pDETextState.getRise();
        ASMatrix aSMatrix = new ASMatrix(d * d2, 0.0, 0.0, d, 0.0, d5);
        double d6 = 0.0;
        double d7 = 0.0;
        int n3 = n + n2 - 1;
        int n4 = 0;
        Iterator iterator = this.tjArray.iterator();
        block0: while (iterator.hasNext() && n4 <= n3) {
            int n5 = 0;
            object2 = iterator.next();
            if (object2 instanceof ASNumber) {
                n5 = ((ASNumber)object2).intValue();
                d6 += (double)(-n5 / 1000) * d + d3 + d4;
                continue;
            }
            if (!(object2 instanceof ASString)) continue;
            object = ((ASString)object2).getBytes();
            for (int i = 0; i < ((byte[])object).length; ++i) {
                if (n4 < n) {
                    ++n4;
                    continue;
                }
                if (n4 > n3) continue block0;
                double d8 = this.getCharWidth(object[n4]) / 1000.0;
                if (d8 > d7) {
                    d7 = d8;
                }
                double d9 = this.getCharHeight(object[n4]) / 1000.0;
                d6 += d9 * d + d3 + d4;
            }
        }
        ASMatrix aSMatrix2 = aSMatrix.concat(this.tm.preMultiply(-d7 / 2.0, d6));
        object2 = aSMatrix.concat(this.tm.preMultiply(d7 / 2.0, d6));
        object = aSMatrix.concat(this.tm.preMultiply(d7 / 2.0, 0.0));
        ASMatrix aSMatrix3 = aSMatrix.concat(this.tm.preMultiply(-d7 / 2.0, 0.0));
        ASCoordinate aSCoordinate = new ASCoordinate(aSMatrix2.getx(), aSMatrix2.gety());
        ASCoordinate aSCoordinate2 = new ASCoordinate(((ASMatrix)object2).getx(), ((ASMatrix)object2).gety());
        ASCoordinate aSCoordinate3 = new ASCoordinate(((ASMatrix)object).getx(), ((ASMatrix)object).gety());
        ASCoordinate aSCoordinate4 = new ASCoordinate(aSMatrix3.getx(), aSMatrix3.gety());
        return new ASQuad(aSCoordinate, aSCoordinate2, aSCoordinate3, aSCoordinate4);
    }

    ASQuad getTextSpaceBoundingQuad(int n, int n2, boolean bl) {
        if (this.isHorizontalWritingMode()) {
            return this.getTextSpaceQuadHorizontal(n, n2, bl);
        }
        return this.getTextSpaceQuadVertical(n, n2, bl);
    }

    ASQuad getTextSpaceBoundingQuadMin() {
        return this.getTextSpaceBoundingQuad(0, this.getCharCodeCount(), false);
    }

    ASQuad getTextSpaceBoundingQuadMax() {
        return this.getTextSpaceBoundingQuad(0, this.getCharCodeCount(), true);
    }

    public List getBoundingQuadsMin() {
        ArrayList<ASQuad> arrayList = new ArrayList<ASQuad>(1);
        ASMatrix aSMatrix = this.getTextSpaceToDeviceSpaceCTM();
        ASQuad aSQuad = this.getTextSpaceBoundingQuadMin().transform(aSMatrix);
        arrayList.add(aSQuad);
        return arrayList;
    }

    public List getBoundingQuadsMax() {
        ArrayList<ASQuad> arrayList = new ArrayList<ASQuad>(1);
        ASMatrix aSMatrix = this.getTextSpaceToDeviceSpaceCTM();
        ASQuad aSQuad = this.getTextSpaceBoundingQuadMax().transform(aSMatrix);
        arrayList.add(aSQuad);
        return arrayList;
    }

    ASMatrix getTextMatrix() {
        return this.tm;
    }

    PDETextState getTextState() {
        return this.gState.getTextState();
    }

    PDEGState getGState() {
        return this.gState;
    }
}

