/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdfedit;

import com.adobe.internal.pdf.cos.util.ASArray;
import com.adobe.internal.pdf.cos.util.ASMatrix;
import com.adobe.internal.pdf.cos.util.ASQuad;
import com.adobe.internal.pdf.cos.util.ASString;
import com.adobe.internal.pdfedit.PDEGState;
import com.adobe.internal.pdfedit.PDETextRun;
import com.adobe.internal.pdfedit.PDETextRunList;

class PDETextObject {
    private PDETextRunList textRuns = new PDETextRunList();
    private ASMatrix tm = ASMatrix.createIdentityMatrix();
    private ASMatrix tlm = ASMatrix.createIdentityMatrix();
    private ASMatrix trm = ASMatrix.createIdentityMatrix();

    PDETextObject() {
    }

    PDETextObject(PDETextObject pDETextObject) {
        this.textRuns = new PDETextRunList(pDETextObject.getTextRuns());
        this.tm = pDETextObject.getTextMatrix();
        this.tlm = pDETextObject.getTextLineMatrix();
        this.trm = pDETextObject.getTextRenderingMatrix();
    }

    PDETextRunList getTextRuns() {
        return this.textRuns;
    }

    void addTextRun(ASString aSString, PDEGState pDEGState) {
        PDETextRun pDETextRun = new PDETextRun(aSString, this.tm, pDEGState);
        this.textRuns.add(pDETextRun);
        this.adjustTextMatrix(pDETextRun);
    }

    void addTextRun(ASArray aSArray, PDEGState pDEGState) {
        PDETextRun pDETextRun = new PDETextRun(aSArray, this.tm, pDEGState);
        this.textRuns.add(pDETextRun);
        this.adjustTextMatrix(pDETextRun);
    }

    void adjustTextMatrix(PDETextRun pDETextRun) {
        ASQuad aSQuad = pDETextRun.getTextSpaceBoundingQuadMax();
        double d = aSQuad.p2().x() - aSQuad.p1().x();
        double d2 = aSQuad.p2().y() - aSQuad.p1().y();
        this.tm = this.tm.preMultiply(d, d2);
    }

    ASMatrix getTextMatrix() {
        return this.tm;
    }

    void setTextMatrix(ASMatrix aSMatrix) {
        this.tm = aSMatrix;
    }

    ASMatrix getTextLineMatrix() {
        return this.tlm;
    }

    void setTextLineMatrix(ASMatrix aSMatrix) {
        this.tlm = aSMatrix;
    }

    ASMatrix getTextRenderingMatrix() {
        return this.trm;
    }

    void setTextRenderingMatrix(ASMatrix aSMatrix) {
        this.trm = aSMatrix;
    }

    public String toString() {
        return this.textRuns.toString();
    }
}

