/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdfedit;

import com.adobe.internal.pdf.cos.util.ASCoordinate;
import com.adobe.internal.pdfedit.PDEBezierSegment;
import com.adobe.internal.pdfedit.PDELineSegment;
import com.adobe.internal.pdfedit.PDEPathSegmentList;

class PDESubPath {
    private PDEPathSegmentList segments;
    private boolean closed = false;
    private ASCoordinate startPoint;
    private ASCoordinate currentPoint;

    PDESubPath(ASCoordinate aSCoordinate) {
        this.segments = new PDEPathSegmentList();
        this.startPoint = aSCoordinate;
        this.currentPoint = aSCoordinate;
    }

    PDESubPath(PDESubPath pDESubPath) {
        this.segments = new PDEPathSegmentList(pDESubPath.segments);
        this.closed = pDESubPath.closed;
        this.startPoint = pDESubPath.startPoint;
        this.currentPoint = pDESubPath.currentPoint;
    }

    void lineTo(ASCoordinate aSCoordinate) {
        PDELineSegment pDELineSegment = new PDELineSegment(this.currentPoint, aSCoordinate);
        this.segments.add(pDELineSegment);
        this.currentPoint = aSCoordinate;
    }

    void curveTo(ASCoordinate aSCoordinate, ASCoordinate aSCoordinate2, ASCoordinate aSCoordinate3) {
        PDEBezierSegment pDEBezierSegment = new PDEBezierSegment(this.currentPoint, aSCoordinate, aSCoordinate2, aSCoordinate3);
        this.segments.add(pDEBezierSegment);
        this.currentPoint = aSCoordinate3;
    }

    void curveToV(ASCoordinate aSCoordinate, ASCoordinate aSCoordinate2) {
        PDEBezierSegment pDEBezierSegment = new PDEBezierSegment(this.currentPoint, this.currentPoint, aSCoordinate, aSCoordinate2);
        this.segments.add(pDEBezierSegment);
        this.currentPoint = aSCoordinate2;
    }

    void curveToY(ASCoordinate aSCoordinate, ASCoordinate aSCoordinate2) {
        PDEBezierSegment pDEBezierSegment = new PDEBezierSegment(this.currentPoint, aSCoordinate, aSCoordinate2, aSCoordinate2);
        this.segments.add(pDEBezierSegment);
        this.currentPoint = aSCoordinate2;
    }

    void close() {
        this.lineTo(this.startPoint);
        this.closed = true;
    }

    boolean isEmpty() {
        return this.segments.isEmpty();
    }

    boolean isClosed() {
        return this.closed;
    }

    ASCoordinate getCurrentPoint() {
        return this.currentPoint;
    }

    PDEPathSegmentList getPathSegmentList() {
        return this.segments;
    }
}

