/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdfedit;

import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdfedit.PDEContentOperator;
import com.adobe.internal.pdfedit.PDEContentParser;
import com.adobe.internal.pdfedit.PDEOperandStack;
import com.adobe.internal.pdfedit.PDEPageDescription;
import com.adobe.pdf.exceptions.PDFException;

class PDEPathConstructionOperator
extends PDEContentOperator {
    static final int m = 1;
    static final int l = 2;
    static final int c = 3;
    static final int v = 4;
    static final int y = 5;
    static final int h = 6;
    static final int re = 7;

    PDEPathConstructionOperator(int n, ASName aSName) {
        super(n, aSName);
    }

    public void process(PDEContentParser pDEContentParser, PDEPageDescription pDEPageDescription) {
        if (this.getType() == 1 && this.getType() == 7) {
            if (!pDEPageDescription.isStatePageDescLevel() && !pDEPageDescription.isStatePathObject()) {
                throw new PDFException("m and re path construction operations not allowed in state " + pDEPageDescription.getState());
            }
            if (!pDEPageDescription.isStatePathObject()) {
                throw new PDFException("path construction operation not allowed in state " + pDEPageDescription.getState());
            }
        }
        PDEOperandStack pDEOperandStack = pDEContentParser.getOperandStack();
        switch (this.getType()) {
            case 1: {
                if (pDEPageDescription.isStatePageDescLevel()) {
                    pDEPageDescription.createNewPath();
                }
                double d = pDEOperandStack.popNumber().doubleValue();
                double d2 = pDEOperandStack.popNumber().doubleValue();
                pDEPageDescription.operator_m(d2, d);
                break;
            }
            case 2: {
                double d = pDEOperandStack.popNumber().doubleValue();
                double d3 = pDEOperandStack.popNumber().doubleValue();
                pDEPageDescription.operator_l(d3, d);
                break;
            }
            case 3: {
                double d = pDEOperandStack.popNumber().doubleValue();
                double d4 = pDEOperandStack.popNumber().doubleValue();
                double d5 = pDEOperandStack.popNumber().doubleValue();
                double d6 = pDEOperandStack.popNumber().doubleValue();
                double d7 = pDEOperandStack.popNumber().doubleValue();
                double d8 = pDEOperandStack.popNumber().doubleValue();
                pDEPageDescription.operator_c(d8, d7, d6, d5, d4, d);
                break;
            }
            case 4: {
                double d = pDEOperandStack.popNumber().doubleValue();
                double d9 = pDEOperandStack.popNumber().doubleValue();
                double d10 = pDEOperandStack.popNumber().doubleValue();
                double d11 = pDEOperandStack.popNumber().doubleValue();
                pDEPageDescription.operator_v(d11, d10, d9, d);
                break;
            }
            case 5: {
                double d = pDEOperandStack.popNumber().doubleValue();
                double d12 = pDEOperandStack.popNumber().doubleValue();
                double d13 = pDEOperandStack.popNumber().doubleValue();
                double d14 = pDEOperandStack.popNumber().doubleValue();
                pDEPageDescription.operator_y(d14, d13, d12, d);
                break;
            }
            case 6: {
                pDEPageDescription.operator_h();
                break;
            }
            case 7: {
                if (pDEPageDescription.isStatePageDescLevel()) {
                    pDEPageDescription.createNewPath();
                }
                double d = pDEOperandStack.popNumber().doubleValue();
                double d15 = pDEOperandStack.popNumber().doubleValue();
                double d16 = pDEOperandStack.popNumber().doubleValue();
                double d17 = pDEOperandStack.popNumber().doubleValue();
                pDEPageDescription.operator_re(d17, d16, d15, d);
            }
        }
    }
}

