/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdfedit;

import com.adobe.internal.pdf.PDFRectangle;
import com.adobe.internal.pdf.cos.util.ASCoordinate;
import com.adobe.internal.pdfedit.PDESubPath;
import com.adobe.internal.pdfedit.PDESubPathList;

class PDEPath {
    private PDESubPath currentSubPath;
    private PDESubPathList subPathList = new PDESubPathList();
    private ASCoordinate currentPoint;
    private boolean show = true;

    PDEPath() {
    }

    PDEPath(PDEPath pDEPath) {
        if (pDEPath.currentSubPath != null) {
            this.currentSubPath = new PDESubPath(pDEPath.currentSubPath);
        }
        if (pDEPath.subPathList != null) {
            this.subPathList = new PDESubPathList(pDEPath.subPathList);
        }
        this.currentPoint = new ASCoordinate(pDEPath.currentPoint);
    }

    PDEPath(PDFRectangle pDFRectangle) {
        ASCoordinate aSCoordinate = new ASCoordinate(pDFRectangle.llx(), pDFRectangle.lly());
        ASCoordinate aSCoordinate2 = new ASCoordinate(pDFRectangle.urx(), pDFRectangle.lly());
        ASCoordinate aSCoordinate3 = new ASCoordinate(pDFRectangle.urx(), pDFRectangle.ury());
        ASCoordinate aSCoordinate4 = new ASCoordinate(pDFRectangle.llx(), pDFRectangle.ury());
        this.moveTo(aSCoordinate);
        this.lineTo(aSCoordinate2);
        this.lineTo(aSCoordinate3);
        this.lineTo(aSCoordinate4);
        this.close();
    }

    void moveTo(ASCoordinate aSCoordinate) {
        if (this.currentSubPath == null || this.currentSubPath.isEmpty()) {
            this.currentSubPath = new PDESubPath(aSCoordinate);
        }
        this.currentPoint = aSCoordinate;
    }

    void lineTo(ASCoordinate aSCoordinate) {
        this.createSubPathIfNecessary();
        this.currentSubPath.lineTo(aSCoordinate);
        this.currentPoint = aSCoordinate;
    }

    void curveTo(ASCoordinate aSCoordinate, ASCoordinate aSCoordinate2, ASCoordinate aSCoordinate3) {
        this.createSubPathIfNecessary();
        this.currentSubPath.curveTo(aSCoordinate, aSCoordinate2, aSCoordinate3);
        this.currentPoint = aSCoordinate3;
    }

    void curveToV(ASCoordinate aSCoordinate, ASCoordinate aSCoordinate2) {
        this.currentSubPath.curveToV(aSCoordinate, aSCoordinate2);
        this.currentPoint = aSCoordinate2;
    }

    void curveToY(ASCoordinate aSCoordinate, ASCoordinate aSCoordinate2) {
        this.currentSubPath.curveToY(aSCoordinate, aSCoordinate2);
        this.currentPoint = aSCoordinate2;
    }

    void close() {
        if (this.currentSubPath != null) {
            this.currentSubPath.close();
            this.subPathList.add(this.currentSubPath);
            this.currentPoint = this.currentSubPath.getCurrentPoint();
            this.currentSubPath = null;
        }
    }

    private void createSubPathIfNecessary() {
        if (this.currentSubPath == null) {
            this.currentSubPath = new PDESubPath(this.currentPoint);
        }
    }

    PDESubPathList getSubPathList() {
        return this.subPathList;
    }

    boolean getShow() {
        return this.show;
    }

    void setShow(boolean bl) {
        this.show = bl;
    }
}

