/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdfedit;

import com.adobe.internal.pdf.PDFDashPattern;
import com.adobe.internal.pdf.PDFExtGState;
import com.adobe.internal.pdf.PDFFont;
import com.adobe.internal.pdf.PDFLineCap;
import com.adobe.internal.pdf.PDFLineJoin;
import com.adobe.internal.pdf.PDFPage;
import com.adobe.internal.pdf.PDFRenderingIntent;
import com.adobe.internal.pdf.PDFResources;
import com.adobe.internal.pdf.PDFXObject;
import com.adobe.internal.pdf.PDFXObjectForm;
import com.adobe.internal.pdf.cos.util.ASArray;
import com.adobe.internal.pdf.cos.util.ASCoordinate;
import com.adobe.internal.pdf.cos.util.ASMatrix;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ASString;
import com.adobe.internal.pdf.cos.util.ByteStream;
import com.adobe.internal.pdfedit.PDEContentParser;
import com.adobe.internal.pdfedit.PDEGState;
import com.adobe.internal.pdfedit.PDEGStateStack;
import com.adobe.internal.pdfedit.PDEPath;
import com.adobe.internal.pdfedit.PDEProcessingState;
import com.adobe.internal.pdfedit.PDETextObject;
import com.adobe.internal.pdfedit.PDETextState;

class PDEPageDescription {
    private PDEProcessingState processState = PDEProcessingState.PAGE_DESCRIPTION_LEVEL;
    private PDEGStateStack gStateStack;
    private PDEPath currentPath;
    private PDETextObject currentTextObj;
    private PDFPage page;

    PDEPageDescription(PDFPage pDFPage) {
        this.page = pDFPage;
        this.reset();
    }

    void reset() {
        this.processState = PDEProcessingState.PAGE_DESCRIPTION_LEVEL;
        this.gStateStack = new PDEGStateStack(new PDEGState(this.page));
        this.currentPath = null;
        this.currentTextObj = null;
    }

    PDFPage getPage() {
        return this.page;
    }

    PDEGState getGState() {
        return this.gStateStack.peek();
    }

    void pushGState() {
        PDEGState pDEGState = new PDEGState(this.gStateStack.peek());
        this.gStateStack.push(pDEGState);
    }

    PDEGState popGState() {
        return this.gStateStack.pop();
    }

    PDEProcessingState getState() {
        return this.processState;
    }

    boolean isStatePageDescLevel() {
        return this.processState == PDEProcessingState.PAGE_DESCRIPTION_LEVEL;
    }

    boolean isStateTextObject() {
        return this.processState == PDEProcessingState.TEXT_OBJECT;
    }

    boolean isStatePathObject() {
        return this.processState == PDEProcessingState.PATH_OBJECT;
    }

    boolean isStateClippingPathObject() {
        return this.processState == PDEProcessingState.CLIPPING_PATH_OBJECT;
    }

    boolean isStateInlineImageObject() {
        return this.processState == PDEProcessingState.INLINE_IMAGE_OBJECT;
    }

    PDFResources getResources() {
        return this.page.getResources();
    }

    void operator_w(double d) {
        this.getGState().setLineWidth(d);
    }

    void operator_J(PDFLineCap pDFLineCap) {
        this.getGState().setLineCap(pDFLineCap);
    }

    void operator_j(PDFLineJoin pDFLineJoin) {
        this.getGState().setLineJoin(pDFLineJoin);
    }

    void operator_M(double d) {
        this.getGState().setMiterLimit(d);
    }

    void operator_d(PDFDashPattern pDFDashPattern) {
        this.getGState().setDashPattern(pDFDashPattern);
    }

    void operator_ri(PDFRenderingIntent pDFRenderingIntent) {
        this.getGState().setRenderingIntent(pDFRenderingIntent);
    }

    void operator_i(double d) {
        this.getGState().setFlatness(d);
    }

    void operator_gs(PDFExtGState pDFExtGState) {
        this.getGState().loadExtGState(pDFExtGState);
    }

    void operator_q() {
        this.pushGState();
    }

    void operator_Q() {
        this.popGState();
    }

    void operator_cm(double d, double d2, double d3, double d4, double d5, double d6) {
        ASMatrix aSMatrix = new ASMatrix(d, d2, d3, d4, d5, d6);
        PDEGState pDEGState = this.getGState();
        pDEGState.setCTM(aSMatrix.concat(pDEGState.getCTM()));
    }

    void operator_m(double d, double d2) {
        this.currentPath.moveTo(new ASCoordinate(d, d2));
    }

    void operator_l(double d, double d2) {
        this.currentPath.lineTo(new ASCoordinate(d, d2));
    }

    void operator_c(double d, double d2, double d3, double d4, double d5, double d6) {
        this.currentPath.curveTo(new ASCoordinate(d, d2), new ASCoordinate(d3, d4), new ASCoordinate(d5, d6));
    }

    void operator_v(double d, double d2, double d3, double d4) {
        this.currentPath.curveToV(new ASCoordinate(d, d2), new ASCoordinate(d3, d4));
    }

    void operator_y(double d, double d2, double d3, double d4) {
        this.currentPath.curveToV(new ASCoordinate(d, d2), new ASCoordinate(d3, d4));
    }

    void operator_h() {
        this.currentPath.close();
    }

    void operator_re(double d, double d2, double d3, double d4) {
        this.currentPath.moveTo(new ASCoordinate(d, d2));
        this.currentPath.lineTo(new ASCoordinate(d + d3, d2));
        this.currentPath.lineTo(new ASCoordinate(d + d3, d2 + d4));
        this.currentPath.lineTo(new ASCoordinate(d, d2 + d4));
        this.currentPath.close();
    }

    void createNewPath() {
        this.processState = PDEProcessingState.PATH_OBJECT;
        this.currentPath = new PDEPath();
    }

    void endPath() {
        this.processState = PDEProcessingState.PAGE_DESCRIPTION_LEVEL;
    }

    PDEPath getCurrentPath() {
        return this.currentPath;
    }

    void operator_S() {
        this.endPath();
    }

    void operator_s() {
        this.currentPath.close();
        this.endPath();
    }

    void operator_f() {
        this.currentPath.close();
        this.endPath();
    }

    void operator_fStar() {
        this.currentPath.close();
        this.endPath();
    }

    void operator_B() {
        this.endPath();
    }

    void operator_BStar() {
        this.endPath();
    }

    void operator_b() {
        this.currentPath.close();
        this.endPath();
    }

    void operator_bStar() {
        this.currentPath.close();
        this.endPath();
    }

    void operator_n() {
        this.currentPath.setShow(false);
        this.endPath();
    }

    void operator_W() {
        this.processState = PDEProcessingState.CLIPPING_PATH_OBJECT;
        this.getGState().addPathToClip(this.currentPath);
    }

    void operator_WStar() {
        this.processState = PDEProcessingState.CLIPPING_PATH_OBJECT;
        this.getGState().addPathToClip(this.currentPath);
    }

    void operator_Tc(double d) {
        this.getTextState().setCharSpacing(d);
    }

    void operator_Tw(double d) {
        this.getTextState().setWordSpacing(d);
    }

    void operator_Tz(double d) {
        this.getTextState().setHorizScaling(d);
    }

    void operator_TL(double d) {
        this.getTextState().setLeading(d);
    }

    void operator_Tf(ASName aSName, double d) {
        PDETextState pDETextState = this.getTextState();
        pDETextState.setFontName(aSName);
        pDETextState.setFontSize(d);
        PDFFont pDFFont = this.getResources().getFontMap().get(aSName);
        pDETextState.setFont(pDFFont);
    }

    void operator_Tr(int n) {
        this.getTextState().setRenderingMode(n);
    }

    void operator_Ts(double d) {
        this.getTextState().setRise(d);
    }

    void operator_BT() {
        this.processState = PDEProcessingState.TEXT_OBJECT;
        this.currentTextObj = new PDETextObject();
    }

    void operator_ET() {
        this.processState = PDEProcessingState.PAGE_DESCRIPTION_LEVEL;
    }

    void operator_Td(double d, double d2) {
        PDETextObject pDETextObject = this.getCurrentTextObj();
        ASMatrix aSMatrix = pDETextObject.getTextLineMatrix();
        aSMatrix = aSMatrix.preMultiply(d, d2);
        pDETextObject.setTextLineMatrix(aSMatrix);
        pDETextObject.setTextMatrix(aSMatrix);
    }

    void operator_TD(double d, double d2) {
        this.operator_TL(-d2);
        this.operator_Td(d, d2);
    }

    void operator_Tm(double d, double d2, double d3, double d4, double d5, double d6) {
        ASMatrix aSMatrix;
        ASMatrix aSMatrix2 = aSMatrix = new ASMatrix(d, d2, d3, d4, d5, d6);
        this.currentTextObj.setTextMatrix(aSMatrix);
        this.currentTextObj.setTextLineMatrix(aSMatrix2);
    }

    void operator_TStar() {
        double d = this.getTextState().getLeading();
        this.operator_Td(0.0, -d);
    }

    void operator_Tj(ASString aSString) {
        this.currentTextObj.addTextRun(aSString, this.getGState());
    }

    void operator_SingleQuote(ASString aSString) {
        this.operator_TStar();
        this.operator_Tj(aSString);
    }

    void operator_DoubleQuote(double d, double d2, ASString aSString) {
        PDETextState pDETextState = this.getTextState();
        this.operator_Tw(d);
        this.operator_Tc(d2);
        this.currentTextObj.addTextRun(aSString, this.getGState());
    }

    void operator_TJ(ASArray aSArray) {
        this.currentTextObj.addTextRun(aSArray, this.getGState());
    }

    PDETextState getTextState() {
        return this.getGState().getTextState();
    }

    PDETextObject getCurrentTextObj() {
        return this.currentTextObj;
    }

    void operator_BI() {
        this.processState = PDEProcessingState.INLINE_IMAGE_OBJECT;
    }

    void operator_EI() {
        this.processState = PDEProcessingState.PAGE_DESCRIPTION_LEVEL;
    }

    void operator_Do(ASName aSName) {
        PDFXObject pDFXObject = this.getResources().getXObjectMap().get(aSName);
        if (pDFXObject instanceof PDFXObjectForm) {
            PDFXObjectForm pDFXObjectForm = (PDFXObjectForm)pDFXObject;
            ByteStream byteStream = pDFXObjectForm.getCosStream().getStream();
            PDEContentParser pDEContentParser = new PDEContentParser(this, byteStream);
        }
    }
}

