/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdfedit;

import com.adobe.internal.pdf.cos.util.ASArray;
import com.adobe.internal.pdf.cos.util.ASDictionary;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ASNumber;
import com.adobe.internal.pdf.cos.util.ASString;
import com.adobe.pdf.exceptions.PDFException;
import java.util.ArrayList;

class PDEOperandStack {
    private ArrayList stack;
    public static ASString openDict = new ASString("<<");
    public static ASString closeDict = new ASString(">>");
    public static ASString openArray = new ASString("[");
    public static ASString closeArray = new ASString("]");

    PDEOperandStack() {
        this.stack = new ArrayList();
    }

    PDEOperandStack(PDEOperandStack pDEOperandStack) {
        this.stack = new ArrayList(pDEOperandStack.stack);
    }

    void push(Object object) {
        this.stack.add(object);
    }

    void pushNumber(ASNumber aSNumber) {
        this.stack.add(aSNumber);
    }

    void pushBoolean(Boolean bl) {
        this.stack.add(bl);
    }

    void pushNumber(ASName aSName) {
        this.stack.add(aSName);
    }

    void pushNumber(ASString aSString) {
        this.stack.add(aSString);
    }

    boolean peekTypeIsNumber() {
        Object object = this.peek();
        return object instanceof ASNumber;
    }

    boolean peekTypeIsBoolean() {
        Object object = this.peek();
        return object instanceof Boolean;
    }

    boolean peekTypeIsName() {
        Object object = this.peek();
        return object instanceof ASName;
    }

    boolean peekTypeIsString() {
        Object object = this.peek();
        return object instanceof ASString;
    }

    boolean peekTypeIsArray() {
        Object object = this.peek();
        return object instanceof ASString && (ASString)object == closeArray;
    }

    boolean peekTypeIsDictionary() {
        Object object = this.peek();
        return object instanceof ASString && (ASString)object == closeDict;
    }

    ASNumber peekNumber() {
        Object object = this.peek();
        if (object instanceof ASNumber) {
            return (ASNumber)object;
        }
        throw new PDFException("unexpected operand type");
    }

    Boolean peekBoolean() {
        Object object = this.peek();
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new PDFException("unexpected operand type");
    }

    ASName peekName() {
        Object object = this.peek();
        if (object instanceof ASName) {
            return (ASName)object;
        }
        throw new PDFException("unexpected operand type");
    }

    ASString peekString() {
        Object object = this.peek();
        if (object instanceof ASString) {
            return (ASString)object;
        }
        throw new PDFException("unexpected operand type");
    }

    ASNumber popNumber() {
        Object object = this.pop();
        if (object instanceof ASNumber) {
            return (ASNumber)object;
        }
        throw new PDFException("unexpected operand type");
    }

    Boolean popBoolean() {
        Object object = this.pop();
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new PDFException("unexpected operand type");
    }

    ASName popName() {
        Object object = this.pop();
        if (object instanceof ASName) {
            return (ASName)object;
        }
        throw new PDFException("unexpected operand type");
    }

    ASString popString() {
        Object object = this.pop();
        if (object instanceof ASString) {
            return (ASString)object;
        }
        throw new PDFException("unexpected operand type");
    }

    ASArray popArray() {
        ASArray aSArray = new ASArray();
        if (this.popString() == closeArray) {
            while (!this.peekTypeIsString() || this.peekTypeIsString() && this.peekString() != openArray) {
                Object object = this.peekTypeIsArray() ? this.popArray() : (this.peekTypeIsDictionary() ? this.popDictionary() : this.pop());
                aSArray.add(0, object);
            }
        } else {
            throw new PDFException("unexpected operand type");
        }
        this.popString();
        return aSArray;
    }

    ASDictionary popDictionary() {
        ASDictionary aSDictionary = new ASDictionary();
        if (this.peekTypeIsString() && this.popString() == closeDict) {
            while (!this.peekTypeIsString() || this.peekTypeIsString() && this.peekString() != openDict) {
                Object object = this.peekTypeIsArray() ? this.popArray() : (this.peekTypeIsDictionary() ? this.popDictionary() : this.pop());
                ASName aSName = this.popName();
                aSDictionary.put(aSName, object);
            }
        } else {
            throw new PDFException("unexpected operand type");
        }
        this.popString();
        return aSDictionary;
    }

    ASDictionary popImageDictionary() {
        ASDictionary aSDictionary = new ASDictionary();
        while (!this.isEmpty()) {
            Object object = this.peekTypeIsArray() ? this.popArray() : (this.peekTypeIsDictionary() ? this.popDictionary() : this.pop());
            ASName aSName = this.popName();
            aSDictionary.put(aSName, object);
        }
        return aSDictionary;
    }

    private Object peek() {
        return this.stack.get(this.stack.size() - 1);
    }

    private Object pop() {
        return this.stack.remove(this.stack.size() - 1);
    }

    boolean isEmpty() {
        return this.stack.isEmpty();
    }
}

