/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdfedit;

import com.adobe.internal.pdf.cos.util.ASDictionary;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdfedit.PDEContentOperator;
import com.adobe.internal.pdfedit.PDEContentParser;
import com.adobe.internal.pdfedit.PDEOperandStack;
import com.adobe.internal.pdfedit.PDEPageDescription;
import com.adobe.pdf.exceptions.PDFException;

class PDEInlineImageOperator
extends PDEContentOperator {
    static final int BI = 1;
    static final int ID = 2;
    static final int EI = 3;

    PDEInlineImageOperator(int n, ASName aSName) {
        super(n, aSName);
    }

    public void process(PDEContentParser pDEContentParser, PDEPageDescription pDEPageDescription) {
        PDEOperandStack pDEOperandStack = pDEContentParser.getOperandStack();
        switch (this.getType()) {
            case 1: {
                if (!pDEPageDescription.isStatePageDescLevel()) {
                    throw new PDFException(" BI in-line image operation not allowed in state " + pDEPageDescription.getState());
                }
                pDEPageDescription.operator_BI();
                break;
            }
            case 2: {
                if (!pDEPageDescription.isStateInlineImageObject()) {
                    throw new PDFException("ID in-line image operation not allowed in state " + pDEPageDescription.getState());
                }
                ASDictionary aSDictionary = pDEOperandStack.popImageDictionary();
                pDEContentParser.skipInlineImage(aSDictionary);
                break;
            }
            case 3: {
                if (!pDEPageDescription.isStateInlineImageObject()) {
                    throw new PDFException("EI in-line image operation not allowed in state " + pDEPageDescription.getState());
                }
                pDEPageDescription.operator_EI();
            }
        }
    }
}

