/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdfedit;

import com.adobe.internal.pdf.PDFDashPattern;
import com.adobe.internal.pdf.PDFExtGState;
import com.adobe.internal.pdf.PDFLineCap;
import com.adobe.internal.pdf.PDFLineJoin;
import com.adobe.internal.pdf.PDFRenderingIntent;
import com.adobe.internal.pdf.PDFResources;
import com.adobe.internal.pdf.cos.util.ASArray;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdfedit.PDEContentOperator;
import com.adobe.internal.pdfedit.PDEContentParser;
import com.adobe.internal.pdfedit.PDEOperandStack;
import com.adobe.internal.pdfedit.PDEPageDescription;
import com.adobe.pdf.exceptions.PDFException;

class PDEGeneralGStateOperator
extends PDEContentOperator {
    static final int w = 1;
    static final int J = 2;
    static final int j = 3;
    static final int M = 4;
    static final int d = 5;
    static final int ri = 6;
    static final int i = 7;
    static final int gs = 8;

    PDEGeneralGStateOperator(int n, ASName aSName) {
        super(n, aSName);
    }

    void process(PDEContentParser pDEContentParser, PDEPageDescription pDEPageDescription) {
        if (!pDEPageDescription.isStatePageDescLevel() && !pDEPageDescription.isStateTextObject()) {
            throw new PDFException("general graphics state operation not allowed in state " + pDEPageDescription.getState());
        }
        PDEOperandStack pDEOperandStack = pDEContentParser.getOperandStack();
        switch (this.getType()) {
            case 1: {
                double d = pDEOperandStack.popNumber().doubleValue();
                pDEPageDescription.operator_w(d);
                break;
            }
            case 2: {
                PDFLineCap pDFLineCap = PDFLineCap.getLineCapForValue(pDEOperandStack.popNumber().intValue());
                pDEPageDescription.operator_J(pDFLineCap);
                break;
            }
            case 3: {
                PDFLineJoin pDFLineJoin = PDFLineJoin.getLineJoinForValue(pDEOperandStack.popNumber().intValue());
                pDEPageDescription.operator_j(pDFLineJoin);
                break;
            }
            case 4: {
                double d = pDEOperandStack.popNumber().doubleValue();
                pDEPageDescription.operator_M(d);
                break;
            }
            case 5: {
                int n = pDEOperandStack.popNumber().intValue();
                ASArray aSArray = pDEOperandStack.popArray();
                int n2 = aSArray.size();
                double[] dArray = new double[n2];
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = ((Number)aSArray.get(i)).doubleValue();
                }
                PDFDashPattern pDFDashPattern = new PDFDashPattern(dArray, n);
                pDEPageDescription.operator_d(pDFDashPattern);
                break;
            }
            case 6: {
                PDFRenderingIntent pDFRenderingIntent = PDFRenderingIntent.getIntentForValue(pDEOperandStack.popName());
                pDEPageDescription.operator_ri(pDFRenderingIntent);
                break;
            }
            case 7: {
                double d = pDEOperandStack.popNumber().doubleValue();
                pDEPageDescription.operator_i(d);
                break;
            }
            case 8: {
                ASName aSName = pDEOperandStack.popName();
                PDFResources pDFResources = pDEPageDescription.getResources();
                PDFExtGState pDFExtGState = pDFResources.getExtGState(aSName);
                pDEPageDescription.operator_gs(pDFExtGState);
            }
        }
    }
}

