/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdfedit;

import com.adobe.internal.pdf.PDFDashPattern;
import com.adobe.internal.pdf.PDFExtGState;
import com.adobe.internal.pdf.PDFLineCap;
import com.adobe.internal.pdf.PDFLineJoin;
import com.adobe.internal.pdf.PDFPage;
import com.adobe.internal.pdf.PDFRenderingIntent;
import com.adobe.internal.pdf.cos.util.ASMatrix;
import com.adobe.internal.pdfedit.PDEPath;
import com.adobe.internal.pdfedit.PDETextState;

class PDEGState {
    private ASMatrix ctm = ASMatrix.createIdentityMatrix();
    private PDEPath clippingPath;
    private double lineWidth = 1.0;
    private PDFLineCap lineCap = PDFLineCap.BUTT_CAP;
    private PDFLineJoin lineJoin = PDFLineJoin.MITER_JOIN;
    private double miterLimit = 10.0;
    private PDFDashPattern dashPattern = new PDFDashPattern();
    private PDFRenderingIntent renderingIntent = PDFRenderingIntent.RELATIVE_COLORIMETRIC;
    private boolean strokeAdjustment = false;
    private double strokeAlpha = 1.0;
    private double nonStrokeAlpha = 1.0;
    private boolean alphaSource = false;
    private boolean strokeOverprint = false;
    private boolean nonStrokeOverprint = false;
    private int overprintMode = 0;
    private double flatness = 1.0;
    private double smoothness = 0.0;
    private boolean textKnockout = true;
    private PDETextState textState = new PDETextState();

    PDEGState(PDFPage pDFPage) {
        this.clippingPath = new PDEPath(pDFPage.getCropBox());
    }

    PDEGState(PDEGState pDEGState) {
        this.ctm = pDEGState.ctm;
        this.clippingPath = new PDEPath(pDEGState.clippingPath);
        this.lineWidth = pDEGState.lineWidth;
        this.lineCap = pDEGState.lineCap;
        this.lineJoin = pDEGState.lineJoin;
        this.miterLimit = pDEGState.miterLimit;
        this.dashPattern = new PDFDashPattern(pDEGState.dashPattern);
        this.renderingIntent = pDEGState.renderingIntent;
        this.strokeAdjustment = pDEGState.strokeAdjustment;
        this.strokeAlpha = pDEGState.strokeAlpha;
        this.nonStrokeAlpha = pDEGState.nonStrokeAlpha;
        this.alphaSource = pDEGState.alphaSource;
        this.strokeOverprint = pDEGState.strokeOverprint;
        this.nonStrokeOverprint = pDEGState.nonStrokeOverprint;
        this.flatness = pDEGState.flatness;
        this.smoothness = pDEGState.smoothness;
        this.textState = new PDETextState(pDEGState.textState);
    }

    ASMatrix getCTM() {
        return this.ctm;
    }

    void setCTM(ASMatrix aSMatrix) {
        this.ctm = aSMatrix;
    }

    void addPathToClip(PDEPath pDEPath) {
    }

    double getLineWidth() {
        return this.lineWidth;
    }

    void setLineWidth(double d) {
        this.lineWidth = d;
    }

    PDFLineCap getLineCap() {
        return this.lineCap;
    }

    void setLineCap(PDFLineCap pDFLineCap) {
        this.lineCap = pDFLineCap;
    }

    PDFLineJoin getLineJoin() {
        return this.lineJoin;
    }

    void setLineJoin(PDFLineJoin pDFLineJoin) {
        this.lineJoin = pDFLineJoin;
    }

    double getMiterLimit() {
        return this.miterLimit;
    }

    void setMiterLimit(double d) {
        this.miterLimit = d;
    }

    PDFDashPattern getDashPattern() {
        return this.dashPattern;
    }

    void setDashPattern(PDFDashPattern pDFDashPattern) {
        this.dashPattern = pDFDashPattern;
    }

    PDFRenderingIntent getRenderingIntent() {
        return this.renderingIntent;
    }

    void setRenderingIntent(PDFRenderingIntent pDFRenderingIntent) {
        this.renderingIntent = pDFRenderingIntent;
    }

    boolean getStrokeAdjustment() {
        return this.strokeAdjustment;
    }

    void setStrokeAdjustment(boolean bl) {
        this.strokeAdjustment = bl;
    }

    double getStrokeAlpha() {
        return this.strokeAlpha;
    }

    void setStrokeAlpha(double d) {
        this.strokeAlpha = d;
    }

    double getNonStrokeAlpha() {
        return this.nonStrokeAlpha;
    }

    void setNonStrokeAlpha(double d) {
        this.nonStrokeAlpha = d;
    }

    boolean getAlphaSource() {
        return this.alphaSource;
    }

    void setAlphaSource(boolean bl) {
        this.alphaSource = bl;
    }

    boolean getStrokeOverprint() {
        return this.strokeOverprint;
    }

    void setStrokeOverprint(boolean bl) {
        this.strokeOverprint = bl;
    }

    boolean getNonStrokeOverprint() {
        return this.nonStrokeOverprint;
    }

    void setNonStrokeOverprint(boolean bl) {
        this.nonStrokeOverprint = bl;
    }

    int getOverprintMode() {
        return this.overprintMode;
    }

    void setOverprintMode(int n) {
        this.overprintMode = n;
    }

    double getFlatness() {
        return this.flatness;
    }

    void setFlatness(double d) {
        this.flatness = d;
    }

    double getSmoothness() {
        return this.smoothness;
    }

    void setSmoothness(double d) {
        this.smoothness = d;
    }

    boolean getTextKnockout() {
        return this.textKnockout;
    }

    void setTextKnockout(boolean bl) {
        this.textKnockout = bl;
    }

    PDETextState getTextState() {
        return this.textState;
    }

    void setTextState(PDETextState pDETextState) {
        this.textState = pDETextState;
    }

    void loadExtGState(PDFExtGState pDFExtGState) {
        if (pDFExtGState.containsLineWidth()) {
            this.setLineWidth(pDFExtGState.getLineWidth());
        }
        if (pDFExtGState.containsLineCap()) {
            this.setLineCap(PDFLineCap.getLineCapForValue(pDFExtGState.getLineCap()));
        }
        if (pDFExtGState.containsLineJoin()) {
            this.setLineJoin(PDFLineJoin.getLineJoinForValue(pDFExtGState.getLineJoin()));
        }
        if (pDFExtGState.containsMiterLimit()) {
            this.setMiterLimit(pDFExtGState.getMiterLimit());
        }
        if (pDFExtGState.containsRenderingIntent()) {
            this.setRenderingIntent(PDFRenderingIntent.getIntentForValue(pDFExtGState.getRenderingIntent()));
        }
        if (pDFExtGState.containsStrokeOverprint()) {
            this.setStrokeOverprint(pDFExtGState.getStrokeOverprint());
        }
        if (pDFExtGState.containsNonStrokeOverprint()) {
            this.setNonStrokeOverprint(pDFExtGState.getNonStrokeOverprint());
        } else if (pDFExtGState.containsStrokeOverprint()) {
            this.setNonStrokeOverprint(pDFExtGState.getStrokeOverprint());
        }
        if (pDFExtGState.containsOverprintMode()) {
            this.setOverprintMode(pDFExtGState.getOverprintMode());
        }
        if (pDFExtGState.containsFlatness()) {
            this.setFlatness(pDFExtGState.getFlatness());
        }
        if (pDFExtGState.containsSmoothness()) {
            this.setSmoothness(pDFExtGState.getSmoothness());
        }
        if (pDFExtGState.containsStrokeAdjustment()) {
            this.setStrokeAdjustment(pDFExtGState.getStrokeAdjustment());
        }
        if (pDFExtGState.containsStrokeAlpha()) {
            this.setStrokeAlpha(pDFExtGState.getStrokeAlpha());
        }
        if (pDFExtGState.containsNonStrokeAlpha()) {
            this.setNonStrokeAlpha(pDFExtGState.getNonStrokeAlpha());
        }
        if (pDFExtGState.containsAlphaSource()) {
            this.setAlphaSource(pDFExtGState.getAlphaSource());
        }
        if (pDFExtGState.containsTextKnockout()) {
            this.setTextKnockout(pDFExtGState.getTextKnockout());
        }
    }
}

