/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdfedit;

import com.adobe.internal.pdf.PDFContents;
import com.adobe.internal.pdf.PDFPage;
import com.adobe.internal.pdf.PDFResources;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdfedit.PDEContentParser;
import com.adobe.internal.pdfedit.PDEPageDescription;
import com.adobe.internal.pdfedit.PDEPath;
import com.adobe.internal.pdfedit.PDEPathList;
import com.adobe.internal.pdfedit.PDETextObject;
import com.adobe.internal.pdfedit.PDETextObjectList;
import com.adobe.internal.pdfedit.PDEWordList;
import com.adobe.internal.pdfedit.PDEWordafier;
import java.util.HashSet;

public class PDEContents {
    private static HashSet textOps = new HashSet();
    private static HashSet pathOps;
    private PDFPage page;
    private PDFContents contents;
    private PDFResources resources;
    private PDEPageDescription pageDesc;
    private PDEContentParser parser;

    public PDEContents(PDFPage pDFPage) {
        this.page = pDFPage;
        this.contents = pDFPage.getContents();
        this.resources = pDFPage.getResources();
        if (this.contents != null) {
            this.pageDesc = new PDEPageDescription(pDFPage);
            this.parser = new PDEContentParser(this.pageDesc, this.contents.listIterator());
        } else {
            this.parser = null;
        }
    }

    public PDETextObjectList getTextObjects() {
        PDETextObjectList pDETextObjectList = new PDETextObjectList();
        if (this.contents != null) {
            ASName aSName;
            this.parser.setClientOperators(textOps);
            this.parser.reset();
            while ((aSName = this.parser.nextOperator()) != null) {
                PDETextObject pDETextObject = this.pageDesc.getCurrentTextObj();
                pDETextObjectList.add(pDETextObject);
            }
        }
        return pDETextObjectList;
    }

    public PDEWordList getWordList() {
        PDETextObjectList pDETextObjectList = this.getTextObjects();
        PDEWordafier pDEWordafier = new PDEWordafier(this.page.getIndex() + 1, pDETextObjectList);
        PDEWordList pDEWordList = pDEWordafier.buildWordList();
        return pDEWordList;
    }

    PDEPathList getPaths() {
        PDEPathList pDEPathList = new PDEPathList();
        if (this.contents != null) {
            ASName aSName;
            this.parser.setClientOperators(pathOps);
            this.parser.reset();
            while ((aSName = this.parser.nextOperator()) != null) {
                PDEPath pDEPath = this.pageDesc.getCurrentPath();
                pDEPathList.add(pDEPath);
            }
        }
        return pDEPathList;
    }

    static {
        textOps.add(ASName.k_ET);
        pathOps = new HashSet();
        pathOps.add(ASName.k_S);
        pathOps.add(ASName.k_s);
        pathOps.add(ASName.k_f);
        pathOps.add(ASName.k_F);
        pathOps.add(ASName.k_fStar);
        pathOps.add(ASName.k_B);
        pathOps.add(ASName.k_BStar);
        pathOps.add(ASName.k_b);
        pathOps.add(ASName.k_bStar);
        pathOps.add(ASName.k_n);
    }
}

