/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdfedit;

import com.adobe.internal.pdf.PDFContents;
import com.adobe.internal.pdf.cos.util.ASArray;
import com.adobe.internal.pdf.cos.util.ASDictionary;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ByteOps;
import com.adobe.internal.pdf.cos.util.ByteStream;
import com.adobe.internal.pdfedit.ByteStreamTokenizer;
import com.adobe.internal.pdfedit.PDEContentExecutor;
import com.adobe.internal.pdfedit.PDEContentOperator;
import com.adobe.internal.pdfedit.PDEOperandStack;
import com.adobe.internal.pdfedit.PDEPageDescription;
import com.adobe.pdf.exceptions.PDFException;
import com.adobe.pdf.exceptions.PDFParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;

class PDEContentParser {
    private static HashMap operators = new HashMap();
    private PDEOperandStack operandStack;
    private PDEOperandStack lastOperandStack;
    private PDEPageDescription pageDesc;
    private PDFContents.PDFContentStreamsIterator byteStmIter;
    private ByteStream byteStm;
    private ByteStreamTokenizer.RefOperand refOperand = new ByteStreamTokenizer.RefOperand();
    private ByteStreamTokenizer.RefOperator refOperator = new ByteStreamTokenizer.RefOperator();
    private HashSet clientOperators;

    PDEContentParser(PDEPageDescription pDEPageDescription, ListIterator listIterator) {
        this.pageDesc = pDEPageDescription;
        this.byteStm = null;
        this.byteStmIter = (PDFContents.PDFContentStreamsIterator)listIterator;
        this.init();
    }

    PDEContentParser(PDEPageDescription pDEPageDescription, ByteStream byteStream) {
        this.pageDesc = pDEPageDescription;
        this.byteStm = byteStream;
        this.byteStmIter = null;
        this.init();
    }

    void init() {
        this.operandStack = new PDEOperandStack();
        this.lastOperandStack = new PDEOperandStack();
    }

    void reset() {
        this.init();
        this.pageDesc.reset();
    }

    ASName nextOperator() {
        if (this.byteStm == null) {
            this.byteStm = this.getNextByteStream();
        }
        boolean bl = false;
        block5: while (this.byteStm != null && !bl) {
            int n = ByteStreamTokenizer.nextToken(this.byteStm, this.refOperand, this.refOperator);
            switch (n) {
                case 0: {
                    this.operandStack.push(this.refOperand.operand);
                    continue block5;
                }
                case 1: {
                    bl = this.isClientOperator(this.refOperator.operator);
                    if (bl) {
                        this.lastOperandStack = new PDEOperandStack(this.operandStack);
                    }
                    this.handleOperator(this.refOperator.operator);
                    continue block5;
                }
                case -1: {
                    this.byteStm = this.getNextByteStream();
                    continue block5;
                }
            }
            throw new PDFException("unrecognized token");
        }
        if (!this.operandStack.isEmpty()) {
            throw new PDFException("problem parsing content");
        }
        if (bl) {
            return this.refOperator.operator;
        }
        return null;
    }

    private ByteStream getNextByteStream() {
        if (this.byteStmIter != null && this.byteStmIter.hasNext()) {
            return (ByteStream)this.byteStmIter.next();
        }
        return null;
    }

    void setClientOperators(HashSet hashSet) {
        this.clientOperators = hashSet;
    }

    private boolean isClientOperator(ASName aSName) {
        return this.clientOperators.contains(aSName);
    }

    private void handleOperator(ASName aSName) {
        PDEContentOperator pDEContentOperator = this.getContentOperator(aSName);
        if (pDEContentOperator == null) {
            throw new PDFException("unexpected operator in content stream");
        }
        pDEContentOperator.process(this, this.pageDesc);
    }

    protected PDEContentOperator getContentOperator(ASName aSName) {
        return (PDEContentOperator)operators.get(aSName);
    }

    PDEOperandStack getOperandStack() {
        return this.operandStack;
    }

    PDEOperandStack getLastOperandStack() {
        return this.lastOperandStack;
    }

    boolean isStackEmpty() {
        return this.operandStack.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void skipInlineImage(ASDictionary aSDictionary) {
        byte by;
        Object object;
        int n = 0;
        int n2 = 0;
        long l = 0L;
        long l2 = 0L;
        boolean bl = false;
        if (aSDictionary.containsKey(ASName.k_IM)) {
            bl = aSDictionary.getBoolean(ASName.k_IM);
        } else if (aSDictionary.containsKey(ASName.k_ImageMask)) {
            bl = aSDictionary.getBoolean(ASName.k_ImageMask);
        }
        if (bl) {
            n = 1;
            n2 = 1;
        } else {
            if (aSDictionary.containsKey(ASName.k_BPC)) {
                n = aSDictionary.getNumber(ASName.k_BPC).intValue();
            } else {
                if (!aSDictionary.containsKey(ASName.k_BitsPerComponent)) throw new PDFException("image dictionary did not contain required BPC entry");
                n = aSDictionary.getNumber(ASName.k_BitsPerComponent).intValue();
            }
            if (aSDictionary.containsKey(ASName.k_CS)) {
                object = aSDictionary.get(ASName.k_CS);
            } else {
                if (!aSDictionary.containsKey(ASName.k_ColorSpace)) throw new PDFException("image dictionary did not contain required CS entry");
                object = aSDictionary.get(ASName.k_ColorSpace);
            }
            if (object instanceof ASName) {
                if (object == ASName.k_G || object == ASName.k_DeviceGray) {
                    n2 = 1;
                } else if (object == ASName.k_RGB || object == ASName.k_DeviceRGB) {
                    n2 = 3;
                } else {
                    if (object != ASName.k_CMYK) {
                        if (object != ASName.k_DeviceCMYK) throw new PDFException("image dictionary contained unknown CS type");
                    }
                    n2 = 4;
                }
            } else {
                if (!(object instanceof ASArray)) throw new PDFException("image dictionary contained unknown CS type");
                n2 = this.countCSComponents((ASArray)object);
            }
        }
        if (aSDictionary.containsKey(ASName.k_W)) {
            l = aSDictionary.getNumber(ASName.k_W).longValue();
        } else {
            if (!aSDictionary.containsKey(ASName.k_Width)) throw new PDFException("image dictionary missing required width");
            l = aSDictionary.getNumber(ASName.k_Width).longValue();
        }
        if (aSDictionary.containsKey(ASName.k_H)) {
            l2 = aSDictionary.getNumber(ASName.k_H).longValue();
        } else {
            if (!aSDictionary.containsKey(ASName.k_Height)) throw new PDFException("image dictionary missing required height");
            l2 = aSDictionary.getNumber(ASName.k_Height).longValue();
        }
        if (n != 1 && n != 2 && n != 4 && n != 8) {
            throw new PDFException("invalid image dictionary");
        }
        if (n2 != 1 && n2 != 3 && n2 != 4) {
            throw new PDFException("invalid image dictionary");
        }
        if (l * l2 == 0L) {
            throw new PDFException("invalid image dictionary");
        }
        object = null;
        if (aSDictionary.containsKey(ASName.k_F)) {
            object = aSDictionary.getArray(ASName.k_F);
        } else if (aSDictionary.containsKey(ASName.k_Filter)) {
            object = aSDictionary.getArray(ASName.k_Filter);
        }
        boolean bl2 = true;
        if (object != null && (((ArrayList)object).contains(ASName.k_ASCIIHexDecode) || ((ArrayList)object).contains(ASName.k_ASCII85Decode))) {
            bl2 = false;
        }
        if (bl2 && !ByteOps.isWhitespace(by = this.byteStm.get())) {
            this.byteStm.unget();
        }
        if (object != null && ((ArrayList)object).size() != 0) {
            by = 0;
            ASName aSName = ((ASArray)object).getName(0);
            if (aSName == ASName.k_AHx || aSName == ASName.k_ASCIIHexDecode) {
                while (this.byteStm.get() != 62) {
                }
                return;
            }
            if (aSName == ASName.k_A85 || aSName == ASName.k_ASCII85Decode) {
                byte by2 = this.byteStm.get();
                byte by3 = this.byteStm.get();
                do {
                    if (by2 == 126 && by3 == 62) {
                        return;
                    }
                    by2 = by3;
                    by3 = this.byteStm.get();
                } while (by == 0);
                return;
            } else {
                if (aSName == ASName.k_LZW) return;
                if (aSName == ASName.k_LZWDecode) return;
                if (aSName == ASName.k_Fl) return;
                if (aSName == ASName.k_FlateDecode) return;
                if (aSName == ASName.k_RL) return;
                if (aSName == ASName.k_RunLengthDecode) return;
                if (aSName == ASName.k_CCF) return;
                if (aSName == ASName.k_CCITTFaxDecode) return;
                if (aSName == ASName.k_DCT) return;
                if (aSName != ASName.k_DCTDecode) throw new PDFException("image dictionary contains unsupported filter");
            }
            return;
        } else {
            long l3 = ((long)(n * n2) * l + 7L) / 8L;
            long l4 = l2 * l3;
            if (l4 > this.byteStm.bytesAvailable()) throw new PDFParseException(this.byteStm.getPosition());
            this.byteStm.setPosition(this.byteStm.getPosition() + l4);
            by = this.byteStm.get();
            if (ByteOps.isWhitespace(by)) return;
            boolean bl3 = false;
            byte by4 = this.byteStm.get();
            do {
                if (by == 69 && by4 == 73) {
                    bl3 = true;
                    this.byteStm.unget();
                    this.byteStm.unget();
                    continue;
                }
                by = by4;
                by4 = this.byteStm.get();
            } while (!bl3);
        }
    }

    private int countCSComponents(ASArray aSArray) {
        ASName aSName = aSArray.getName(0);
        if (aSName == ASName.k_DeviceGray || aSName == ASName.k_CalGray || aSName == ASName.k_Separation || aSName == ASName.k_Indexed) {
            return 1;
        }
        if (aSName == ASName.k_DeviceRGB || aSName == ASName.k_CalRGB || aSName == ASName.k_Lab) {
            return 3;
        }
        if (aSName == ASName.k_DeviceCMYK) {
            return 4;
        }
        if (aSName == ASName.k_ICCBased) {
            ASDictionary aSDictionary = aSArray.getDictionary(1);
            return aSDictionary.getNumber(ASName.k_N).intValue();
        }
        if (aSName == ASName.k_DeviceN) {
            ASArray aSArray2 = aSArray.getArray(1);
            return aSArray2.size();
        }
        throw new PDFException("CS array contained unknown CS type");
    }

    static {
        PDEContentExecutor.bindCallbackObjects(operators);
    }
}

