/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdfedit;

import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdfedit.PDEContentOperator;
import com.adobe.internal.pdfedit.PDEContentParser;
import com.adobe.internal.pdfedit.PDEOperandStack;
import com.adobe.internal.pdfedit.PDEPageDescription;
import com.adobe.pdf.exceptions.PDFException;

class PDEColorOperator
extends PDEContentOperator {
    static final int CS = 1;
    static final int cs = 2;
    static final int SC = 3;
    static final int SCN = 4;
    static final int sc = 5;
    static final int scn = 6;
    static final int G = 7;
    static final int g = 8;
    static final int RG = 9;
    static final int rg = 10;
    static final int K = 11;
    static final int k = 12;

    PDEColorOperator(int n, ASName aSName) {
        super(n, aSName);
    }

    public void process(PDEContentParser pDEContentParser, PDEPageDescription pDEPageDescription) {
        if (!pDEPageDescription.isStatePageDescLevel() && !pDEPageDescription.isStateTextObject()) {
            throw new PDFException("color operation not allowed in state " + pDEPageDescription.getState());
        }
        PDEOperandStack pDEOperandStack = pDEContentParser.getOperandStack();
        switch (this.getType()) {
            case 1: 
            case 2: {
                ASName aSName = pDEOperandStack.popName();
                break;
            }
            case 3: 
            case 5: {
                while (!pDEContentParser.isStackEmpty()) {
                    pDEOperandStack.popNumber();
                }
                break;
            }
            case 4: 
            case 6: {
                if (pDEOperandStack.peekTypeIsName()) {
                    ASName aSName = pDEOperandStack.popName();
                }
                while (!pDEContentParser.isStackEmpty()) {
                    pDEOperandStack.popNumber();
                }
                break;
            }
            case 7: 
            case 8: {
                float f = pDEOperandStack.popNumber().floatValue();
                break;
            }
            case 9: 
            case 10: {
                float f = pDEOperandStack.popNumber().floatValue();
                float f2 = pDEOperandStack.popNumber().floatValue();
                float f3 = pDEOperandStack.popNumber().floatValue();
                break;
            }
            case 11: 
            case 12: {
                float f = pDEOperandStack.popNumber().floatValue();
                float f4 = pDEOperandStack.popNumber().floatValue();
                float f5 = pDEOperandStack.popNumber().floatValue();
                float f6 = pDEOperandStack.popNumber().floatValue();
            }
        }
    }
}

