/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdfedit;

import com.adobe.internal.pdf.PDFFont;
import com.adobe.internal.pdf.cos.util.ASCoordinate;
import com.adobe.internal.pdf.cos.util.ASMatrix;
import com.adobe.internal.pdf.cos.util.ASQuad;
import com.adobe.internal.pdf.cos.util.ASRectangle;
import com.adobe.internal.pdfedit.PDETextRun;
import com.adobe.internal.pdfedit.PDETextState;
import java.util.ArrayList;
import java.util.Iterator;

public class PDECharacter {
    private PDETextRun textRun;
    private int index;
    private int charCode;
    private ASCoordinate origin;
    private ASCoordinate end;

    PDECharacter(PDETextRun pDETextRun, int n, int n2, ASCoordinate aSCoordinate, ASCoordinate aSCoordinate2) {
        this.textRun = pDETextRun;
        this.index = n;
        this.charCode = n2;
        this.origin = aSCoordinate;
        this.end = aSCoordinate2;
    }

    PDETextRun getTextRun() {
        return this.textRun;
    }

    int getIndex() {
        return this.index;
    }

    int getCharCode() {
        return this.charCode;
    }

    ASCoordinate getOrigin() {
        return this.origin;
    }

    ASCoordinate getEnd() {
        return this.end;
    }

    public String toString() {
        return this.getUnicodeString();
    }

    String getUnicodeString() {
        if (this.textRun.getTextState().getFont().getCharCodeSize() == 1) {
            return this.textRun.getUnicodeString((byte)this.charCode);
        }
        return this.textRun.getUnicodeString((char)this.charCode);
    }

    double getVerticalFontSize() {
        double d = this.textRun.getTextState().getFontSize();
        double d2 = this.textRun.getTextSpaceToDeviceSpaceCTM().getd();
        return d * d2;
    }

    double getSpaceCharWidth() {
        PDETextState pDETextState = this.textRun.getTextState();
        PDFFont pDFFont = pDETextState.getFont();
        double d = pDETextState.getFontSize();
        double d2 = pDETextState.getHorizScaling() / 100.0;
        double d3 = pDETextState.getCharSpacing();
        double d4 = pDETextState.getWordSpacing();
        int n = pDFFont.getCharCode(' ');
        double d5 = (pDFFont.getGlyphWidth(n) / 1000.0 * d + d3 + d4) * d2;
        double d6 = this.textRun.getTextSpaceToDeviceSpaceCTM().geta();
        return d5 * d6;
    }

    double getWidth() {
        return this.origin.distanceTo(this.end);
    }

    double getBaselineAngle() {
        return this.origin.angleTo(this.end);
    }

    double getBaselineAngleDelta(PDECharacter pDECharacter) {
        double d = this.getBaselineAngle();
        double d2 = pDECharacter.getBaselineAngle();
        return d2 - d;
    }

    double getXDistanceTo(PDECharacter pDECharacter) {
        double d = this.getBaselineAngle();
        double d2 = this.end.angleTo(pDECharacter.origin);
        double d3 = this.end.distanceTo(pDECharacter.origin);
        return d3 * Math.cos(d2 - d);
    }

    double getAbsXDistanceTo(PDECharacter pDECharacter) {
        return Math.abs(this.getXDistanceTo(pDECharacter));
    }

    double getYDistanceTo(PDECharacter pDECharacter) {
        double d = this.getBaselineAngle();
        double d2 = this.end.angleTo(pDECharacter.origin);
        double d3 = this.end.distanceTo(pDECharacter.origin);
        return d3 * Math.sin(d2 - d);
    }

    double getAbsYDistanceTo(PDECharacter pDECharacter) {
        return Math.abs(this.getYDistanceTo(pDECharacter));
    }

    private static ASQuad mergeQuads(ArrayList arrayList) {
        boolean bl = true;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ASQuad aSQuad = (ASQuad)iterator.next();
            if (bl) {
                d = aSQuad.p1().x();
                d2 = aSQuad.p3().x();
                d3 = aSQuad.p3().y();
                d4 = aSQuad.p1().y();
                bl = false;
                continue;
            }
            if (aSQuad.p1().x() < d) {
                d = aSQuad.p1().x();
            }
            if (aSQuad.p3().x() > d2) {
                d2 = aSQuad.p3().x();
            }
            if (aSQuad.p3().y() > d3) {
                d3 = aSQuad.p3().y();
            }
            if (!(aSQuad.p1().y() < d4)) continue;
            d4 = aSQuad.p1().y();
        }
        ASRectangle aSRectangle = new ASRectangle(d, d4, d2, d3);
        return new ASQuad(aSRectangle);
    }

    static ArrayList createBoundingQuads(ArrayList arrayList) {
        Object object;
        Object object2;
        Object object3;
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        PDETextRun pDETextRun = null;
        int n = 0;
        int n2 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object3 = (PDECharacter)iterator.next();
            if (pDETextRun == null) {
                pDETextRun = ((PDECharacter)object3).getTextRun();
                n2 = n = ((PDECharacter)object3).getIndex();
                continue;
            }
            if (((PDECharacter)object3).getTextRun() == pDETextRun && ((PDECharacter)object3).getIndex() == n2 + 1) {
                ++n2;
                continue;
            }
            object2 = pDETextRun.getTextSpaceBoundingQuad(n, n2 - n + 1, false);
            object = pDETextRun.getTextSpaceToDeviceSpaceCTM();
            object2 = ((ASQuad)object2).transform((ASMatrix)object);
            if (pDETextRun.isRotatedOrSkewed()) {
                if (!arrayList3.isEmpty()) {
                    ASQuad aSQuad = PDECharacter.mergeQuads(arrayList3);
                    arrayList2.add(aSQuad);
                    arrayList3.clear();
                }
                arrayList2.add(object2);
            } else {
                arrayList3.add(object2);
            }
            pDETextRun = ((PDECharacter)object3).getTextRun();
            n2 = n = ((PDECharacter)object3).getIndex();
        }
        object3 = pDETextRun.getTextSpaceBoundingQuad(n, n2 - n + 1, false);
        object2 = pDETextRun.getTextSpaceToDeviceSpaceCTM();
        object3 = ((ASQuad)object3).transform((ASMatrix)object2);
        if (pDETextRun.isRotatedOrSkewed()) {
            if (!arrayList3.isEmpty()) {
                object = PDECharacter.mergeQuads(arrayList3);
                arrayList2.add(object);
                arrayList3.clear();
            }
            arrayList2.add(object3);
        } else {
            arrayList3.add(object3);
        }
        if (!arrayList3.isEmpty()) {
            object = PDECharacter.mergeQuads(arrayList3);
            arrayList2.add(object);
        }
        return arrayList2;
    }

    static String createUnicodeString(ArrayList arrayList) {
        String string = "";
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            PDECharacter pDECharacter = (PDECharacter)iterator.next();
            string = string + pDECharacter.getUnicodeString();
        }
        return string;
    }
}

