/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdfedit;

import com.adobe.internal.pdfedit.CharacterTypeRange;
import java.util.ArrayList;
import java.util.Iterator;

class CharacterTypeTable {
    private ArrayList charTypeTable;

    CharacterTypeTable(ArrayList arrayList) {
        this.charTypeTable = arrayList;
    }

    private CharacterTypeRange findCharacterType(char c) {
        Iterator iterator = this.charTypeTable.iterator();
        while (iterator.hasNext()) {
            CharacterTypeRange characterTypeRange = (CharacterTypeRange)iterator.next();
            if (!characterTypeRange.contains(c)) continue;
            return characterTypeRange;
        }
        return null;
    }

    boolean isWordBreak(char c) {
        CharacterTypeRange characterTypeRange = this.findCharacterType(c);
        if (characterTypeRange != null) {
            return characterTypeRange.isWordBreak();
        }
        return false;
    }

    boolean isPunctuation(char c) {
        CharacterTypeRange characterTypeRange = this.findCharacterType(c);
        if (characterTypeRange != null) {
            return characterTypeRange.isPunctuation();
        }
        return false;
    }

    boolean isWhitespace(char c) {
        CharacterTypeRange characterTypeRange = this.findCharacterType(c);
        if (characterTypeRange != null) {
            return characterTypeRange.isWhitespace();
        }
        return false;
    }

    boolean isComma(char c) {
        CharacterTypeRange characterTypeRange = this.findCharacterType(c);
        if (characterTypeRange != null) {
            return characterTypeRange.isComma();
        }
        return false;
    }

    boolean isHyphen(char c) {
        CharacterTypeRange characterTypeRange = this.findCharacterType(c);
        if (characterTypeRange != null) {
            return characterTypeRange.isHyphen();
        }
        return false;
    }

    boolean isPeriod(char c) {
        CharacterTypeRange characterTypeRange = this.findCharacterType(c);
        if (characterTypeRange != null) {
            return characterTypeRange.isPeriod();
        }
        return false;
    }

    boolean isDigit(char c) {
        CharacterTypeRange characterTypeRange = this.findCharacterType(c);
        if (characterTypeRange != null) {
            return characterTypeRange.isDigit();
        }
        return false;
    }

    boolean isLetter(char c) {
        CharacterTypeRange characterTypeRange = this.findCharacterType(c);
        if (characterTypeRange != null) {
            return characterTypeRange.isLetter();
        }
        return false;
    }

    boolean isUppercase(char c) {
        CharacterTypeRange characterTypeRange = this.findCharacterType(c);
        if (characterTypeRange != null) {
            return characterTypeRange.isUppercase();
        }
        return false;
    }

    boolean isSoftHyphen(char c) {
        CharacterTypeRange characterTypeRange = this.findCharacterType(c);
        if (characterTypeRange != null) {
            return characterTypeRange.isSoftHyphen();
        }
        return false;
    }

    boolean isLigature(char c) {
        CharacterTypeRange characterTypeRange = this.findCharacterType(c);
        if (characterTypeRange != null) {
            return characterTypeRange.isLigature();
        }
        return false;
    }
}

