/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdfedit;

class CharacterTypeRange {
    static int WORD_BREAK = 1;
    static int WHITESPACE = 2;
    static int PUNCTUATION = 4;
    static int COMMA = 8;
    static int HYPHEN = 16;
    static int PERIOD = 32;
    static int DIGIT = 64;
    static int LETTER = 128;
    static int UPPERCASE = 256;
    static int SOFT_HYPHEN = 512;
    static int LIGATURE = 1024;
    private char rangeStart;
    private char rangeEnd;
    private int type;

    CharacterTypeRange(char c, char c2, int n) {
        this.rangeStart = c;
        this.rangeEnd = c2;
        this.type = n;
    }

    boolean contains(char c) {
        return c >= this.rangeStart && c <= this.rangeEnd;
    }

    boolean isWordBreak() {
        return (this.type & WORD_BREAK) != 0;
    }

    boolean isPunctuation() {
        return (this.type & PUNCTUATION) != 0;
    }

    boolean isWhitespace() {
        return (this.type & WHITESPACE) != 0;
    }

    boolean isComma() {
        return (this.type & COMMA) != 0;
    }

    boolean isHyphen() {
        return (this.type & HYPHEN) != 0;
    }

    boolean isPeriod() {
        return (this.type & PERIOD) != 0;
    }

    boolean isDigit() {
        return (this.type & DIGIT) != 0;
    }

    boolean isLetter() {
        return (this.type & LETTER) != 0;
    }

    boolean isUppercase() {
        return (this.type & UPPERCASE) != 0;
    }

    boolean isSoftHyphen() {
        return (this.type & SOFT_HYPHEN) != 0;
    }

    boolean isLigature() {
        return (this.type & LIGATURE) != 0;
    }
}

