/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdfedit;

import com.adobe.internal.pdf.cos.ByteArrayUtility;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ASNumber;
import com.adobe.internal.pdf.cos.util.ASString;
import com.adobe.internal.pdf.cos.util.ByteOps;
import com.adobe.internal.pdf.cos.util.ByteStream;
import com.adobe.internal.pdfedit.PDEOperandStack;
import com.adobe.pdf.exceptions.PDFParseException;

class ByteStreamTokenizer {
    private static byte[] sReadBuffer = new byte[128];
    public static final int RSLT_END = -1;
    public static final int RSLT_OPERAND = 0;
    public static final int RSLT_OPERATOR = 1;

    ByteStreamTokenizer() {
    }

    static byte readHexDigit(ByteStream byteStream) {
        return ByteStreamTokenizer.toHexDigit(byteStream.get());
    }

    public static byte toHexDigit(byte by) {
        int n = 0;
        if (by >= 48 && by <= 57) {
            n = by - 48;
        } else if (by >= 65 && by <= 70) {
            n = by - 65 + 10;
        } else if (by >= 97 && by <= 102) {
            n = by - 97 + 10;
        } else {
            throw new PDFParseException(0L);
        }
        return (byte)n;
    }

    static ASName readName(ByteStream byteStream) {
        int n = 0;
        int n2 = byteStream.get();
        while (ByteOps.isRegular((byte)n2)) {
            if (n2 == 35) {
                n2 = ByteStreamTokenizer.readHexDigit(byteStream) * 16 + ByteStreamTokenizer.readHexDigit(byteStream);
            }
            ByteStreamTokenizer.sReadBuffer[n++] = (byte)n2;
            if (byteStream.eof()) break;
            n2 = byteStream.get();
        }
        if (!ByteOps.isRegular((byte)n2)) {
            byteStream.unget();
        }
        return ASName.getName(sReadBuffer, 0, n);
    }

    public static ASNumber readNumber(ByteStream byteStream) {
        int n = 0;
        byte by = byteStream.get();
        if (by == 45 || by == 43) {
            ByteStreamTokenizer.sReadBuffer[n++] = by;
            by = byteStream.get();
        }
        while (ByteOps.isDigit(by)) {
            ByteStreamTokenizer.sReadBuffer[n++] = by;
            if (byteStream.eof()) break;
            by = byteStream.get();
        }
        if (by == 46) {
            ByteStreamTokenizer.sReadBuffer[n++] = by;
            if (!byteStream.eof()) {
                by = byteStream.get();
                while (ByteOps.isDigit(by)) {
                    ByteStreamTokenizer.sReadBuffer[n++] = by;
                    if (byteStream.eof()) break;
                    by = byteStream.get();
                }
            }
        }
        if (ByteOps.isRegular(by) && !ByteOps.isDigit(by)) {
            throw new PDFParseException(byteStream.getPosition() - 1L);
        }
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = sReadBuffer[i];
        }
        ASString aSString = new ASString(byArray);
        ASNumber aSNumber = new ASNumber(aSString);
        if (!ByteOps.isRegular(by)) {
            byteStream.unget();
        }
        return aSNumber;
    }

    public static byte skipWhitespace(ByteStream byteStream) {
        byte by = 32;
        while (ByteOps.isWhitespace(by) && !byteStream.eof()) {
            by = byteStream.get();
            if (by != 37) continue;
            while (by != 13 && by != 10 && !byteStream.eof()) {
                by = byteStream.get();
            }
        }
        return by;
    }

    private static Boolean readTrue(ByteStream byteStream) {
        if (byteStream.get() != 114) {
            throw new PDFParseException(byteStream.getPosition() - 1L);
        }
        if (byteStream.get() != 117) {
            throw new PDFParseException(byteStream.getPosition() - 1L);
        }
        if (byteStream.get() != 101) {
            throw new PDFParseException(byteStream.getPosition() - 1L);
        }
        return Boolean.TRUE;
    }

    private static Boolean readFalse(ByteStream byteStream) {
        if (byteStream.get() != 97) {
            throw new PDFParseException(byteStream.getPosition() - 1L);
        }
        if (byteStream.get() != 108) {
            throw new PDFParseException(byteStream.getPosition() - 1L);
        }
        if (byteStream.get() != 115) {
            throw new PDFParseException(byteStream.getPosition() - 1L);
        }
        if (byteStream.get() != 101) {
            throw new PDFParseException(byteStream.getPosition() - 1L);
        }
        return Boolean.FALSE;
    }

    private static Boolean readNull(ByteStream byteStream) {
        if (byteStream.get() != 117) {
            throw new PDFParseException(byteStream.getPosition() - 1L);
        }
        if (byteStream.get() != 108) {
            throw new PDFParseException(byteStream.getPosition() - 1L);
        }
        if (byteStream.get() != 108) {
            throw new PDFParseException(byteStream.getPosition() - 1L);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int nextToken(ByteStream byteStream, RefOperand refOperand, RefOperator refOperator) {
        int n = -1;
        byte by = ByteStreamTokenizer.skipWhitespace(byteStream);
        if (ByteOps.isWhitespace(by)) return n;
        n = 0;
        if (ByteOps.isDigit(by) || by == 43 || by == 45 || by == 46) {
            byteStream.unget();
            refOperand.operand = ByteStreamTokenizer.readNumber(byteStream);
            return n;
        }
        if (by == 47) {
            refOperand.operand = ByteStreamTokenizer.readName(byteStream);
            return n;
        }
        if (by == 40) {
            byte[] byArray = ByteArrayUtility.readLiteral(byteStream);
            refOperand.operand = new ASString(byArray);
            return n;
        }
        if (by != 60 && by != 62 && by != 91 && by != 93) {
            byteStream.unget();
            ASName aSName = ByteStreamTokenizer.readName(byteStream);
            if (aSName == ASName.k_true) {
                refOperand.operand = new Boolean(true);
                return n;
            }
            if (aSName == ASName.k_false) {
                refOperand.operand = new Boolean(false);
                return n;
            }
            if (aSName == ASName.k_null) {
                refOperand.operand = null;
                return n;
            }
            refOperator.operator = aSName;
            return 1;
        }
        if (by == 60) {
            by = byteStream.get();
            if (by == 60) {
                refOperand.operand = PDEOperandStack.openDict;
                return n;
            }
            byteStream.unget();
            byte[] byArray = ByteArrayUtility.readHex(byteStream);
            refOperand.operand = new ASString(byArray);
            return n;
        }
        if (by == 62) {
            by = byteStream.get();
            if (by != 62) throw new PDFParseException(byteStream.getPosition() - 1L);
            refOperand.operand = PDEOperandStack.closeDict;
            return n;
        }
        if (by == 91) {
            refOperand.operand = PDEOperandStack.openArray;
            return n;
        }
        if (by != 93) throw new PDFParseException(byteStream.getPosition());
        refOperand.operand = PDEOperandStack.closeArray;
        return n;
    }

    public static class RefOperator {
        public ASName operator;
    }

    public static class RefOperand {
        public Object operand;
    }
}

