/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util.filter;

import com.adobe.internal.pdf.cos.util.filter.FilterParams;
import com.adobe.internal.pdf.cos.util.filter.TIFFEngine;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TIFFOutputStream
extends FilterOutputStream {
    private TIFFEngine tiff;

    public TIFFOutputStream(OutputStream outputStream, FilterParams filterParams) {
        super(outputStream);
        this.tiff = new TIFFEngine(outputStream, filterParams);
    }

    public TIFFOutputStream(OutputStream outputStream) {
        this(outputStream, null);
    }

    public void write(int n) throws IOException {
        this.tiff.put(n & 0xFF);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = byArray.length - n;
        if (n3 > n2) {
            n3 = n2;
        }
        while (n3-- > 0) {
            this.write(byArray[n++] & 0xFF);
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void close() throws IOException {
        super.close();
    }

    public long getTotalOut() {
        return this.tiff.getTotalOut();
    }
}

