/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util.filter;

import com.adobe.internal.pdf.cos.util.filter.DecodeInputStream;
import com.adobe.internal.pdf.cos.util.filter.FilterParams;
import com.adobe.internal.pdf.cos.util.filter.LZWEngine;
import com.adobe.internal.pdf.cos.util.filter.LZWFilterException;
import java.io.InputStream;

public class LZWInputStream
extends DecodeInputStream {
    private LZWEngine lzw;

    public LZWInputStream(InputStream inputStream, int n, int n2, FilterParams filterParams) {
        super(inputStream, n, n2, 0, filterParams);
        this.lzw = new LZWEngine(inputStream);
        if (filterParams.containsKey("EarlyChange")) {
            this.lzw.setEarlyChange((Integer)filterParams.get("EarlyChange"));
        }
    }

    public LZWInputStream(InputStream inputStream, FilterParams filterParams) {
        super(inputStream, 0, filterParams);
        this.lzw = new LZWEngine(this);
        if (this.diparams.containsKey("EarlyChange")) {
            this.lzw.setEarlyChange((Integer)this.diparams.get("EarlyChange"));
        }
    }

    public LZWInputStream(InputStream inputStream) {
        this(inputStream, null);
    }

    int read1() {
        if (this.inCount <= this.inPos && !this.fillInputBuffer()) {
            if (this.pendingException == null) {
                this.pendingException = new LZWFilterException("LZW no EOF");
            }
            return -1;
        }
        return this.inBuf[this.inPos++] & 0xFF;
    }

    int read2() {
        if (this.inCount - this.inPos >= 2) {
            this.inPos += 2;
            return ((this.inBuf[this.inPos - 2] & 0xFF) << 8) + (this.inBuf[this.inPos - 1] & 0xFF);
        }
        return -1;
    }

    int read3() {
        if (this.inCount - this.inPos >= 3) {
            this.inPos += 3;
            return ((this.inBuf[this.inPos - 3] & 0xFF) << 16) + ((this.inBuf[this.inPos - 2] & 0xFF) << 8) + (this.inBuf[this.inPos - 1] & 0xFF);
        }
        return -1;
    }

    public void fill() {
        while (this.outCount < this.outBuf.length && !this.pendingEOF && this.pendingException == null) {
            int n = this.lzw.get(this.outBuf, this.outCount, this.outBuf.length - this.outCount);
            this.outCount += n;
            if (n != 0) continue;
            this.pendingEOF = true;
            break;
        }
    }
}

