/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util.filter;

import com.adobe.internal.pdf.cos.util.filter.LZWInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class LZWEngine {
    private static final int LZWMAXCODE = 4096;
    private static final int LZWMINCODELEN = 9;
    private static final int LZWMAXCODELEN = 12;
    private static final int HASHTABSIZE = 8191;
    private boolean reading;
    private LZWInputStream rdr;
    private OutputStream wtr;
    private long totalOut;
    private int earlyChange;
    private int codeSize;
    private int wordSize;
    private int clearCode;
    private int stopCode;
    private int nextCode;
    private int lastCode;
    private int sendCode;
    private int sendLength;
    private int residualBits;
    private int codeMask;
    private int codeMaskChange;
    private int codeWord;
    private int[] lzwEntry;
    private short[] hashTab;

    private LZWEngine(boolean bl) {
        this.reading = bl;
        this.earlyChange = 1;
        this.residualBits = 0;
        this.codeWord = 0;
        this.lzwEntry = new int[4097];
        this.hashTab = new short[8192];
        this.LZWInit(8);
    }

    public LZWEngine(InputStream inputStream) {
        this(true);
        this.rdr = (LZWInputStream)inputStream;
    }

    public LZWEngine(OutputStream outputStream) {
        this(false);
        this.wtr = outputStream;
    }

    protected void setEarlyChange(int n) {
        this.earlyChange = n;
    }

    private void LZWInit(int n) {
        int n2;
        int n3;
        this.codeSize = n;
        this.wordSize = n + 1;
        this.codeMask = (1 << this.wordSize) - 1;
        this.codeMaskChange = this.codeMask + 1 - this.earlyChange;
        this.clearCode = n3 = 1 << n;
        this.stopCode = n3 + 1;
        this.nextCode = n3 + 2;
        this.lastCode = -1;
        this.sendCode = -1;
        for (n2 = 0; n2 < this.nextCode; ++n2) {
            this.lzwEntry[n2] = -1048320 + n2;
        }
        for (n2 = 0; n2 < 32; ++n2) {
            this.hashTab[n2] = 0;
        }
        System.arraycopy(this.hashTab, 0, this.hashTab, 32, 32);
        System.arraycopy(this.hashTab, 0, this.hashTab, 64, 64);
        System.arraycopy(this.hashTab, 0, this.hashTab, 128, 128);
        System.arraycopy(this.hashTab, 0, this.hashTab, 256, 256);
        System.arraycopy(this.hashTab, 0, this.hashTab, 512, 512);
        System.arraycopy(this.hashTab, 0, this.hashTab, 1024, 1024);
        System.arraycopy(this.hashTab, 0, this.hashTab, 2048, 2048);
        System.arraycopy(this.hashTab, 0, this.hashTab, 4096, 4096);
    }

    private int LZWSearchTable(int n) {
        short s;
        int n2;
        int n3 = n << 5;
        do {
            n3 += this.lastCode + 1;
            while (n3 >= 8191) {
                n3 -= 8191;
            }
            s = this.hashTab[n3];
            if (s != 0) continue;
            this.hashTab[n3] = (short)this.nextCode;
            return -1;
        } while (((n2 = this.lzwEntry[s]) & 0xFF) != n || n2 >>> 20 != this.lastCode);
        return s;
    }

    private void LZWAddTable(int n) {
        this.lzwEntry[this.nextCode] = (this.lastCode << 20) + (this.lzwEntry[this.lastCode] & 0xFFF00) + 256 + n;
        if (this.reading) {
            ++this.nextCode;
        }
        if (this.nextCode == this.codeMaskChange) {
            if (++this.wordSize > 12) {
                this.wordSize = 12;
            }
            this.codeMask = (1 << this.wordSize) - 1;
            this.codeMaskChange = this.codeMask + 1 - this.earlyChange;
        }
        if (!this.reading) {
            ++this.nextCode;
        }
    }

    protected int get(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n2 > 0) {
            int n4;
            int n5;
            int n6;
            if (this.sendCode < 0) {
                int n7;
                while (this.residualBits < this.wordSize) {
                    if (this.residualBits <= 8 && (n6 = this.rdr.read3()) >= 0) {
                        this.codeWord = (this.codeWord << 24) + n6;
                        this.residualBits += 24;
                        continue;
                    }
                    n6 = this.rdr.read2();
                    if (n6 >= 0) {
                        this.codeWord = (this.codeWord << 16) + n6;
                        this.residualBits += 16;
                        continue;
                    }
                    n6 = this.rdr.read1();
                    if (n6 >= 0) {
                        this.codeWord = (this.codeWord << 8) + n6;
                        this.residualBits += 8;
                        continue;
                    }
                    this.codeWord = this.stopCode;
                    this.residualBits = this.wordSize;
                }
                this.residualBits -= this.wordSize;
                int n8 = this.codeWord >> this.residualBits & this.codeMask;
                if (n8 == this.stopCode) {
                    this.sendCode = this.stopCode;
                    break;
                }
                if (n8 == this.clearCode) {
                    this.LZWInit(this.codeSize);
                    continue;
                }
                if (n8 >= this.nextCode) {
                    n7 = this.lastCode;
                    if (n8 > this.nextCode) {
                        this.sendCode = this.stopCode;
                        break;
                    }
                } else {
                    n7 = n8;
                }
                if (this.nextCode < 4096 && this.lastCode >= 0) {
                    n5 = this.lzwEntry[n7];
                    while ((n6 = n5 >>> 20) != 4095) {
                        n5 = this.lzwEntry[n6];
                    }
                    this.LZWAddTable(n5 & 0xFF);
                }
                if ((n6 = this.lzwEntry[n8] >> 8 & 0xFFF) <= n2) {
                    this.lastCode = n7 = n8;
                    n2 -= n6;
                    n3 += n6;
                    this.sendCode = -1;
                    n5 = n += n6;
                    n4 = this.lzwEntry[n7];
                    while (n6-- > 1) {
                        byArray[--n5] = (byte)n4;
                        n4 = this.lzwEntry[n4 >>> 20];
                    }
                    byArray[--n5] = (byte)n4;
                } else {
                    this.lastCode = n7 = n8;
                    this.sendCode = n7;
                    this.sendLength = n6;
                }
            } else if (this.sendCode == this.stopCode) break;
            if (this.sendCode < 0) continue;
            n6 = this.sendLength;
            if (n6 > n2) {
                n6 = n2;
            }
            n5 = this.sendLength -= n6;
            n2 -= n6;
            n3 += n6;
            n4 = this.lzwEntry[this.sendCode];
            while (n5-- > 0) {
                n4 = this.lzwEntry[n4 >>> 20];
            }
            int n9 = n += n6;
            while (n6-- > 1) {
                byArray[--n9] = (byte)n4;
                n4 = this.lzwEntry[n4 >>> 20];
            }
            byArray[--n9] = (byte)n4;
            if (this.sendLength != 0) continue;
            this.sendCode = -1;
        }
        return n3;
    }

    private void LZWPutEOF() throws IOException {
        if (this.lastCode != -1) {
            this.codeWord = (this.codeWord << this.wordSize) + this.lastCode;
            this.residualBits += this.wordSize;
            while (this.residualBits >= 8) {
                this.residualBits -= 8;
                this.wtr.write((byte)(this.codeWord >> this.residualBits));
                ++this.totalOut;
            }
            this.LZWAddTable(0);
        }
        this.codeWord = (this.codeWord << this.wordSize) + this.stopCode;
        this.residualBits += this.wordSize;
        while (this.residualBits >= 8) {
            this.residualBits -= 8;
            this.wtr.write((byte)(this.codeWord >> this.residualBits));
            ++this.totalOut;
        }
        if (this.residualBits != 0) {
            this.wtr.write((byte)(this.codeWord << 8 - this.residualBits));
            ++this.totalOut;
        }
    }

    protected void put(int n) throws IOException {
        if (n == -1) {
            this.LZWPutEOF();
        } else if (this.lastCode == -1) {
            this.lastCode = n;
        } else {
            int n2 = this.LZWSearchTable(n);
            if (n2 == -1) {
                this.codeWord = (this.codeWord << this.wordSize) + this.lastCode;
                this.residualBits += this.wordSize;
                while (this.residualBits >= 8) {
                    this.residualBits -= 8;
                    this.wtr.write((byte)(this.codeWord >> this.residualBits));
                    ++this.totalOut;
                }
                if (this.nextCode < 4093) {
                    this.LZWAddTable(n);
                } else {
                    this.codeWord = (this.codeWord << this.wordSize) + this.clearCode;
                    this.residualBits += this.wordSize;
                    while (this.residualBits >= 8) {
                        this.residualBits -= 8;
                        this.wtr.write((byte)(this.codeWord >> this.residualBits));
                        ++this.totalOut;
                    }
                    this.LZWInit(this.codeSize);
                }
                this.lastCode = n;
            } else {
                this.lastCode = n2;
            }
        }
    }

    protected long getTotalOut() {
        return this.totalOut;
    }
}

