/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util.filter;

class FlateTree {
    int[] freq;
    int[] code;
    int[] dad;
    int[] len;
    int elems;
    int max_code;
    int max_length;
    int opt_len;
    int[] extra_bits;
    int extra_base;
    FlateTree static_tree;
    short[] heap;
    short[] depth;
    int heap_len;
    int heap_max;

    public FlateTree(FlateTree flateTree, int n, int n2, int n3, int[] nArray, int n4) {
        this.elems = n2;
        this.max_length = n3;
        this.static_tree = flateTree;
        this.extra_bits = nArray;
        this.extra_base = n4;
        this.code = new int[n];
        this.freq = this.code;
        this.len = new int[n];
        this.dad = this.len;
        this.heap = null;
        this.depth = null;
    }

    void InitStaticLTree() {
        int n;
        int[] nArray = new int[this.max_length + 1];
        for (n = 0; n <= this.max_length; ++n) {
            nArray[n] = 0;
        }
        n = 0;
        while (n <= 143) {
            this.len[n++] = 8;
            nArray[8] = nArray[8] + 1;
        }
        while (n <= 255) {
            this.len[n++] = 9;
            nArray[9] = nArray[9] + 1;
        }
        while (n <= 279) {
            this.len[n++] = 7;
            nArray[7] = nArray[7] + 1;
        }
        while (n <= 287) {
            this.len[n++] = 8;
            nArray[8] = nArray[8] + 1;
        }
        this.max_code = this.elems + 1;
        this.gen_codes(nArray);
    }

    void InitStaticDTree() {
        for (int i = 0; i < this.elems; ++i) {
            this.code[i] = this.bi_reverse(i, 5);
            this.len[i] = 5;
        }
    }

    void InitTree() {
        for (int i = 0; i < this.elems; ++i) {
            this.freq[i] = 0;
        }
        if (this.elems > 256) {
            this.freq[256] = 1;
        }
        this.opt_len = 0;
        if (this.static_tree != null) {
            this.static_tree.opt_len = 0;
        }
    }

    private int bi_reverse(int n, int n2) {
        int n3 = 0;
        n <<= 1;
        while (n2-- > 0) {
            n3 <<= 1;
            n3 |= (n >>>= 1) & 1;
        }
        return n3;
    }

    private void gen_codes(int[] nArray) {
        int[] nArray2 = new int[this.max_length + 1];
        int n = 0;
        nArray2[0] = 0;
        for (int i = 1; i <= this.max_length; ++i) {
            nArray2[i] = n = n + nArray[i - 1] << 1;
        }
        for (int i = 0; i <= this.max_code; ++i) {
            int n2 = this.len[i];
            if (n2 == 0) continue;
            int n3 = n2;
            int n4 = nArray2[n3];
            nArray2[n3] = n4 + 1;
            this.code[i] = this.bi_reverse(n4, n2);
        }
    }

    private void gen_bitlen(int[] nArray) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = nArray.length;
        while (n4-- > 0) {
            nArray[n4] = 0;
        }
        this.len[this.heap[this.heap_max]] = 0;
        for (n2 = this.heap_max + 1; n2 < this.heap.length; ++n2) {
            n = this.heap[n2];
            n4 = this.len[this.dad[n]] + 1;
            if (n4 > this.max_length) {
                n4 = this.max_length;
                ++n3;
            }
            this.len[n] = n4;
            if (n > this.max_code) continue;
            int n5 = n4;
            nArray[n5] = nArray[n5] + 1;
            int n6 = 0;
            if (n >= this.extra_base) {
                n6 = this.extra_bits[n - this.extra_base];
            }
            int n7 = this.freq[n];
            this.opt_len += n7 * (n4 + n6);
            if (this.static_tree == null) continue;
            this.static_tree.opt_len += n7 * (this.static_tree.len[n] + n6);
        }
        if (n3 == 0) {
            return;
        }
        do {
            n4 = this.max_length - 1;
            while (nArray[n4] == 0) {
                --n4;
            }
            int n8 = n4;
            nArray[n8] = nArray[n8] - 1;
            int n9 = n4 + 1;
            nArray[n9] = nArray[n9] + 2;
            int n10 = this.max_length;
            nArray[n10] = nArray[n10] - 1;
        } while ((n3 -= 2) > 0);
        for (n4 = this.max_length; n4 != 0; --n4) {
            n = nArray[n4];
            while (n != 0) {
                short s;
                if ((s = this.heap[--n2]) > this.max_code) continue;
                if (this.len[s] != n4) {
                    this.opt_len += (n4 - this.len[s]) * this.freq[s];
                    this.len[s] = n4;
                }
                --n;
            }
        }
    }

    private int pqremove() {
        short s = this.heap[1];
        this.heap[1] = this.heap[this.heap_len--];
        this.pqdownheap(1);
        return s;
    }

    private boolean smaller(int n, int n2) {
        return this.freq[n] < this.freq[n2] || this.freq[n] == this.freq[n2] && this.depth[n] <= this.depth[n2];
    }

    private void pqdownheap(int n) {
        short s = this.heap[n];
        for (int i = n << 1; i <= this.heap_len; i <<= 1) {
            if (i < this.heap_len && this.smaller(this.heap[i + 1], this.heap[i])) {
                ++i;
            }
            if (this.smaller(s, this.heap[i])) break;
            this.heap[n] = this.heap[i];
            n = i;
        }
        this.heap[n] = s;
    }

    void build_tree() {
        int n;
        int n2;
        this.max_code = -1;
        this.heap_len = 0;
        this.heap_max = 2 * this.elems + 1;
        this.heap = new short[this.heap_max];
        this.depth = new short[this.heap_max];
        for (n2 = 0; n2 < this.elems; ++n2) {
            if (this.freq[n2] != 0) {
                this.max_code = n2;
                this.heap[++this.heap_len] = (short)this.max_code;
                this.depth[n2] = 0;
                continue;
            }
            this.len[n2] = 0;
        }
        while (this.heap_len < 2) {
            int n3;
            ++this.heap_len;
            if (this.max_code < 2) {
                n3 = this.max_code + 1;
                this.max_code = this.max_code;
            } else {
                n3 = 0;
            }
            this.heap[this.heap_len] = (short)n3;
            n = this.heap[this.heap_len];
            this.freq[n] = 1;
            this.depth[n] = 0;
            --this.opt_len;
            if (this.static_tree == null) continue;
            this.static_tree.opt_len -= this.static_tree.len[n];
        }
        for (n2 = this.heap_len / 2; n2 >= 1; --n2) {
            this.pqdownheap(n2);
        }
        n = this.elems;
        do {
            n2 = this.pqremove();
            short s = this.heap[1];
            this.heap[--this.heap_max] = (short)n2;
            this.heap[--this.heap_max] = s;
            this.freq[n] = this.freq[n2] + this.freq[s];
            this.depth[n] = (short)(Math.max(this.depth[n2], this.depth[s]) + 1);
            this.dad[n2] = this.dad[s] = n;
            this.heap[1] = (short)n++;
            this.pqdownheap(1);
        } while (this.heap_len >= 2);
        this.heap[--this.heap_max] = this.heap[1];
        int[] nArray = new int[this.max_length + 1];
        this.gen_bitlen(nArray);
        this.gen_codes(nArray);
        this.heap = null;
        this.depth = null;
    }
}

