/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util.filter;

import com.adobe.internal.pdf.cos.util.filter.DecodeInputStream;
import com.adobe.internal.pdf.cos.util.filter.FilterParams;
import com.adobe.internal.pdf.cos.util.filter.FlateFilterException;
import com.adobe.internal.pdf.cos.util.filter.HuffTree;
import java.io.InputStream;

public class FlateInputStream
extends DecodeInputStream {
    private boolean streamError;
    private boolean isInit;
    private static final byte[] border = new byte[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
    private static final short[] cplens = new short[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0};
    private static final byte[] cplext = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, -128, -128};
    private static final short[] cpdist = new short[]{1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577};
    private static final byte[] cpdext = new byte[]{0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13};
    private static final int TYPE = 0;
    private static final int LENS = 1;
    private static final int STORED = 2;
    private static final int TABLE = 3;
    private static final int BTREE = 4;
    private static final int DTREE = 5;
    private static final int CODES = 6;
    private static final int COPY = 7;
    private static final int DONE = 8;
    private static final int BAD = 9;
    private static final int FINAL = 10;
    private int blockMode;
    private int blockIndex;
    private int copyLen;
    private int copyOffset;
    private HuffTree blockLengthTree;
    private HuffTree fixedLengthTree;
    private HuffTree blockDistTree;
    private HuffTree fixedDistTree;
    private boolean lastBlock;
    private boolean localEOF;
    private int wbits;
    private int wmask;
    private byte[] window;
    private int windex;
    private int rawBits;
    private int rawBitsLeft;
    private static final int Adler_BASE = 65521;
    private int adler_s1;
    private int adler_s2;

    public FlateInputStream(InputStream inputStream, int n, int n2, FilterParams filterParams) {
        super(inputStream, n, n2, 0, filterParams);
        this.initInput();
    }

    public FlateInputStream(InputStream inputStream, FilterParams filterParams) {
        super(inputStream, 0, filterParams);
        this.initInput();
    }

    public FlateInputStream(InputStream inputStream) {
        this(inputStream, null);
    }

    private void initInput() {
        this.isInit = false;
    }

    public void fill() {
        if (!this.isInit) {
            this.inflateInit();
            this.isInit = true;
        }
        this.inflate_blocks();
    }

    private int GetBits(int n) {
        while (n > this.rawBitsLeft && !this.pendingEOF && this.pendingException == null) {
            if (this.inCount <= this.inPos && !this.fillInputBuffer()) {
                this.pendingException = new FlateFilterException("Flate: missing EOF");
                break;
            }
            int n2 = this.inBuf[this.inPos++] & 0xFF;
            this.rawBits += n2 << this.rawBitsLeft;
            this.rawBitsLeft += 8;
        }
        if (n > this.rawBitsLeft) {
            n = this.rawBitsLeft;
        }
        return this.rawBits & (1 << n) - 1;
    }

    private void DumpBits(int n) {
        if (n > this.rawBitsLeft) {
            this.GetBits(n);
            if (n > this.rawBitsLeft) {
                n = this.rawBitsLeft;
            }
        }
        this.rawBits >>>= n;
        this.rawBitsLeft -= n;
    }

    private void DumpBitsToByte() {
        this.DumpBits(this.rawBitsLeft & 7);
    }

    private boolean AtEOF() {
        return this.localEOF && this.rawBitsLeft == 0;
    }

    private void Adler32(int n) {
        this.adler_s1 += n & 0xFF;
        if (this.adler_s1 >= 65521) {
            this.adler_s1 -= 65521;
        }
        this.adler_s2 += this.adler_s1;
        if (this.adler_s2 >= 65521) {
            this.adler_s2 -= 65521;
        }
    }

    private void checkAdler() {
        this.DumpBitsToByte();
        int n = this.adler_s1;
        int n2 = this.adler_s2;
        int n3 = this.GetBits(8) << 8;
        this.DumpBits(8);
        this.DumpBits(8);
        int n4 = this.GetBits(8) << 8;
        this.DumpBits(8);
        this.DumpBits(8);
        if ((n4 += this.GetBits(8)) != n || (n3 += this.GetBits(8)) != n2) {
            this.streamError = true;
            this.blockMode = 9;
        }
        this.localEOF = true;
    }

    void inflate_blocks() {
        block26: while (this.outCount < this.outBuf.length && !this.pendingEOF && this.pendingException == null) {
            switch (this.blockMode) {
                case 0: {
                    int n4;
                    int n2 = this.GetBits(3);
                    this.DumpBits(3);
                    if ((n2 & 1) != 0) {
                        this.lastBlock = (n2 & 1) != 0 || this.AtEOF();
                    }
                    switch (n2 >> 1) {
                        case 0: {
                            this.DumpBitsToByte();
                            this.blockMode = 1;
                            break;
                        }
                        case 1: {
                            int[] nArray;
                            if (this.fixedLengthTree == null) {
                                nArray = new int[288];
                                for (n4 = 0; n4 <= 143; ++n4) {
                                    nArray[n4] = 8;
                                }
                                for (n4 = 144; n4 <= 255; ++n4) {
                                    nArray[n4] = 9;
                                }
                                for (n4 = 256; n4 <= 279; ++n4) {
                                    nArray[n4] = 7;
                                }
                                for (n4 = 280; n4 <= 287; ++n4) {
                                    nArray[n4] = 8;
                                }
                                this.fixedLengthTree = new HuffTree(nArray, 288, 257, cplens, cplext, 9);
                            }
                            if (this.fixedDistTree == null) {
                                nArray = new int[31];
                                for (n4 = 0; n4 < 31; ++n4) {
                                    nArray[n4] = 5;
                                }
                                this.fixedDistTree = new HuffTree(nArray, 30, 0, cpdist, cpdext, 6);
                            }
                            this.blockLengthTree = this.fixedLengthTree;
                            this.blockDistTree = this.fixedDistTree;
                            this.blockMode = 6;
                            break;
                        }
                        case 2: {
                            this.blockMode = 3;
                            break;
                        }
                        case 3: {
                            this.blockMode = 9;
                            break;
                        }
                    }
                    continue block26;
                }
                case 1: {
                    this.copyLen = this.GetBits(16);
                    this.DumpBits(16);
                    if (this.GetBits(16) != (this.copyLen ^ 0xFFFF)) {
                        this.blockMode = 9;
                        continue block26;
                    }
                    this.DumpBits(16);
                    this.blockMode = this.copyLen > 0 ? 2 : (this.lastBlock ? 8 : 0);
                    continue block26;
                }
                case 2: {
                    int n2 = this.GetBits(8);
                    this.DumpBits(8);
                    --this.copyLen;
                    if (this.AtEOF()) {
                        this.lastBlock = true;
                        this.copyLen = 0;
                    }
                    this.outBuf[this.outCount++] = this.window[this.windex] = (byte)n2;
                    this.Adler32(n2);
                    this.windex = this.windex + 1 & this.wmask;
                    this.blockMode = this.copyLen > 0 ? 2 : (this.lastBlock ? 8 : 0);
                    continue block26;
                }
                case 3: {
                    int n;
                    int n2 = 257 + this.GetBits(5);
                    this.DumpBits(5);
                    int n3 = 1 + this.GetBits(5);
                    this.DumpBits(5);
                    int n4 = 4 + this.GetBits(4);
                    this.DumpBits(4);
                    if (n2 > 288 || n3 > 30) {
                        this.blockMode = 9;
                        continue block26;
                    }
                    int n5 = n2 + n3;
                    if (n5 < 19) {
                        n5 = 19;
                    }
                    int[] nArray = new int[n5];
                    int[] nArray2 = new int[19];
                    for (n = 0; n < 19; ++n) {
                        nArray2[n] = 0;
                    }
                    for (n = 0; n < n4; ++n) {
                        nArray2[FlateInputStream.border[n]] = this.GetBits(3);
                        this.DumpBits(3);
                    }
                    HuffTree huffTree = new HuffTree(nArray2, 19, 19, null, null, 7);
                    int n6 = 0;
                    while (n6 < n5) {
                        int n7;
                        int n8 = 0 + huffTree.maxLook;
                        int n9 = 0;
                        while ((n8 & 0xE0) == 0 && n8 != 0) {
                            n7 = this.GetBits(n8 & 0xF);
                            this.DumpBits(huffTree.Bits[n9 + n7]);
                            n8 = huffTree.Exop[n9 + n7];
                            n9 = huffTree.Base[n9 + n7];
                        }
                        if (n8 != 0) {
                            this.blockMode = 9;
                            continue block26;
                        }
                        if (n9 < 16) {
                            nArray[n6++] = n9;
                            continue;
                        }
                        switch (n9) {
                            case 16: {
                                n = 2;
                                n7 = 3;
                                break;
                            }
                            case 17: {
                                n = 3;
                                n7 = 3;
                                break;
                            }
                            case 18: {
                                n = 7;
                                n7 = 11;
                                break;
                            }
                            default: {
                                this.blockMode = 9;
                                n7 = 0;
                                n = 0;
                                continue block26;
                            }
                        }
                        this.DumpBits(n);
                        if ((n7 += n6 + this.GetBits(n)) > n5 || n9 == 16 && n6 == 0) {
                            this.blockMode = 9;
                            continue block26;
                        }
                        if (n9 == 16) {
                            while (n6 < n7) {
                                nArray[n6] = nArray[n6 - 1];
                                ++n6;
                            }
                            continue;
                        }
                        while (n6 < n7) {
                            nArray[n6++] = 0;
                        }
                    }
                    this.blockLengthTree = new HuffTree(nArray, n2, 257, cplens, cplext, 9);
                    for (n = 0; n < n3; ++n) {
                        nArray[n] = nArray[n2 + n];
                    }
                    this.blockDistTree = new HuffTree(nArray, n3, 0, cpdist, cpdext, 6);
                    if (this.blockLengthTree.Bits == null || this.blockDistTree.Bits == null) {
                        this.blockMode = 9;
                        continue block26;
                    }
                    this.blockMode = 6;
                }
                case 6: {
                    int n4 = 0 + this.blockLengthTree.maxLook;
                    int n2 = 0;
                    while ((n4 & 0xE0) == 0 && n4 != 0) {
                        int n = this.GetBits(n4 & 0xF);
                        this.DumpBits(this.blockLengthTree.Bits[n2 + n]);
                        n4 = this.blockLengthTree.Exop[n2 + n];
                        n2 = this.blockLengthTree.Base[n2 + n];
                    }
                    switch (n4 & 0xE0) {
                        case 0: {
                            this.outBuf[this.outCount++] = this.window[this.windex] = (byte)n2;
                            this.Adler32(n2);
                            this.windex = this.windex + 1 & this.wmask;
                            continue block26;
                        }
                        case 64: {
                            this.copyLen = n2 + this.GetBits(n4 & 0xF);
                            this.DumpBits(n4 & 0xF);
                            n4 = 0 + this.blockDistTree.maxLook;
                            n2 = 0;
                            while ((n4 & 0xE0) == 0 && n4 != 0) {
                                int n = this.GetBits(n4 & 0xF);
                                this.DumpBits(this.blockDistTree.Bits[n2 + n]);
                                n4 = this.blockDistTree.Exop[n2 + n];
                                n2 = this.blockDistTree.Base[n2 + n];
                            }
                            if ((n4 & 0xE0) != 64) {
                                this.blockMode = 9;
                                continue block26;
                            }
                            this.copyOffset = n2 + this.GetBits(n4 & 0xF);
                            this.DumpBits(n4 & 0xF);
                            this.blockMode = 7;
                            continue block26;
                        }
                        case 96: {
                            this.blockLengthTree = null;
                            this.blockDistTree = null;
                            this.blockMode = this.lastBlock ? 8 : 0;
                            continue block26;
                        }
                    }
                    this.blockLengthTree = null;
                    this.blockDistTree = null;
                    this.blockMode = 9;
                    continue block26;
                }
                case 7: {
                    int n2 = this.window[this.windex - this.copyOffset & this.wmask] & 0xFF;
                    this.outBuf[this.outCount++] = this.window[this.windex] = (byte)n2;
                    this.Adler32(n2);
                    this.windex = this.windex + 1 & this.wmask;
                    if (--this.copyLen > 0) continue block26;
                    this.blockMode = 6;
                    continue block26;
                }
                default: {
                    this.streamError = true;
                    this.blockMode = 10;
                    if (this.pendingException != null) break block26;
                    this.pendingException = new FlateFilterException("Flate: bad input stream");
                    break block26;
                }
                case 8: {
                    this.blockMode = 10;
                    this.checkAdler();
                    continue block26;
                }
                case 10: {
                    this.blockLengthTree = null;
                    this.blockDistTree = null;
                    this.fixedLengthTree = null;
                    this.fixedDistTree = null;
                    this.pendingEOF = true;
                    break block26;
                }
            }
        }
    }

    private void inflateInit() {
        this.localEOF = false;
        this.streamError = false;
        this.rawBitsLeft = 0;
        this.rawBits = 0;
        this.blockLengthTree = null;
        this.fixedLengthTree = null;
        this.blockDistTree = null;
        this.fixedDistTree = null;
        int n = this.GetBits(8);
        this.DumpBits(8);
        int n2 = this.GetBits(8);
        this.DumpBits(8);
        if (this.localEOF || ((n << 8) + n2) % 31 != 0 || (n & 0xF) != 8 || (n2 & 0x20) != 0) {
            this.localEOF = true;
            this.streamError = true;
            this.blockMode = 9;
            this.lastBlock = true;
        } else {
            this.adler_s1 = 1;
            this.adler_s2 = 0;
            this.wbits = (n >> 4) + 8;
            this.wmask = (1 << this.wbits) - 1;
            this.window = new byte[this.wmask + 1];
            this.windex = 0;
            this.blockMode = 0;
            this.lastBlock = false;
        }
    }
}

