/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util.filter;

import com.adobe.internal.pdf.cos.util.filter.FlateTree;
import java.io.IOException;
import java.io.OutputStream;

class FlateEncode {
    static final int Z_DEFLATED = 8;
    static final int Z_NO_COMPRESSION = 0;
    static final int Z_BEST_SPEED = 1;
    static final int Z_BEST_COMPRESSION = 9;
    static final int Z_DEFAULT_COMPRESSION = -1;
    static final int Z_FILTERED = 1;
    static final int Z_HUFFMAN_ONLY = 2;
    static final int Z_DEFAULT_STRATEGY = 0;
    static final int MAX_MEM_LEVEL = 9;
    static final int DEF_MEM_LEVEL = 8;
    static final int MAX_WBITS = 15;
    private static final int STORED_BLOCK = 0;
    private static final int STATIC_TREES = 1;
    private static final int DYN_TREES = 2;
    private static final int MIN_MATCH = 3;
    private static final int MAX_MATCH = 258;
    private static final int TOO_FAR = 4096;
    private static final int MIN_LOOKAHEAD = 262;
    private static final int LENGTH_CODES = 29;
    private static final int LITERALS = 256;
    private static final int L_CODES = 286;
    private static final int D_CODES = 30;
    private static final int BL_CODES = 19;
    private static final int MAX_BITS = 15;
    private static final int INIT_STATE = 42;
    private static final int BUSY_STATE = 113;
    private static final int FINISH_STATE = 666;
    private static final int MAX_BL_BITS = 7;
    private static final int END_BLOCK = 256;
    private static final int REP_3_6 = 16;
    private static final int REPZ_3_10 = 17;
    private static final int REPZ_11_138 = 18;
    private static final int[] extra_lbits = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0};
    private static final int[] extra_dbits = new int[]{0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13};
    private static final int[] extra_blbits = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 7};
    private static final int[] bl_order = new int[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
    FlateTree static_ltree = new FlateTree(null, 288, 286, 15, extra_lbits, 257);
    FlateTree static_dtree;
    int[] dist_code;
    int[] length_code;
    int[] base_length;
    int[] base_dist;
    FlateTree dyn_ltree;
    FlateTree dyn_dtree;
    FlateTree bl_tree;
    short[] l_buf;
    short[] d_buf;
    int lit_bufsize;
    int last_lit;
    int matches;
    int last_eob_len;
    int level;
    int strategy;
    int status;
    private int rawBits;
    private int rawBitsLeft;
    private OutputStream out;
    private long totalOut;
    int noheader;
    int w_size;
    int w_bits;
    int w_mask;
    int max_dist;
    byte[] window;
    int window_size;
    short[] prev;
    short[] head;
    int ins_h;
    int hash_size;
    int hash_bits;
    int hash_mask;
    int hash_shift;
    int block_start;
    int match_length;
    int prev_match;
    boolean match_available;
    int strstart;
    int match_start;
    int lookahead;
    int prev_length;
    int max_chain_length;
    int max_lazy_match;
    int good_match;
    int nice_match;
    private static final int Adler_BASE = 65521;
    private int adler_s1;
    private int adler_s2;

    public FlateEncode(OutputStream outputStream) {
        int n;
        int n2;
        this.static_ltree.InitStaticLTree();
        this.static_dtree = new FlateTree(null, 30, 30, 15, extra_dbits, 0);
        this.static_dtree.InitStaticDTree();
        this.dyn_ltree = new FlateTree(this.static_ltree, 573, 286, 15, extra_lbits, 257);
        this.dyn_dtree = new FlateTree(this.static_dtree, 61, 30, 15, extra_dbits, 0);
        this.bl_tree = new FlateTree(null, 39, 19, 7, extra_blbits, 0);
        this.dyn_ltree.InitTree();
        this.dyn_dtree.InitTree();
        this.bl_tree.InitTree();
        this.dist_code = new int[512];
        this.length_code = new int[256];
        this.base_length = new int[29];
        this.base_dist = new int[30];
        int n3 = 0;
        for (n2 = 0; n2 < 28; ++n2) {
            this.base_length[n2] = n3;
            for (n = 0; n < 1 << extra_lbits[n2]; ++n) {
                this.length_code[n3++] = n2;
            }
        }
        this.length_code[n3 - 1] = n2;
        int n4 = 0;
        for (n2 = 0; n2 < 16; ++n2) {
            this.base_dist[n2] = n4;
            for (n = 0; n < 1 << extra_dbits[n2]; ++n) {
                this.dist_code[n4++] = n2;
            }
        }
        n4 >>>= 7;
        while (n2 < 30) {
            this.base_dist[n2] = n4 << 7;
            for (n = 0; n < 1 << extra_dbits[n2] - 7; ++n) {
                this.dist_code[256 + n4++] = n2;
            }
            ++n2;
        }
        this.out = outputStream;
        this.rawBitsLeft = 0;
        this.rawBits = 0;
        this.level = -1;
        this.status = 0;
    }

    private void sendBits(int n, int n2) throws IOException {
        this.rawBits += (n & (1 << n2) - 1) << this.rawBitsLeft;
        this.rawBitsLeft += n2;
        while (this.rawBitsLeft >= 8) {
            this.out.write(this.rawBits & 0xFF);
            this.rawBits >>>= 8;
            this.rawBitsLeft -= 8;
            ++this.totalOut;
        }
    }

    private void sendCode(int n, FlateTree flateTree) throws IOException {
        this.sendBits(flateTree.code[n], flateTree.len[n]);
    }

    private void putByte(int n) throws IOException {
        this.sendBits(n, 8);
    }

    private void putShort(int n) throws IOException {
        this.sendBits(n, 16);
    }

    private void flushToByte() throws IOException {
        if ((this.rawBitsLeft & 7) != 0) {
            this.sendBits(0, 8 - (this.rawBitsLeft & 7));
        }
    }

    private void putShortMSB(int n) throws IOException {
        this.flushToByte();
        this.sendBits(n >>> 8, 8);
        this.sendBits(n, 8);
    }

    private void scan_tree(FlateTree flateTree) {
        int n = -1;
        flateTree.len[flateTree.max_code + 1] = -1;
        int n2 = 0;
        int n3 = 7;
        int n4 = 4;
        int n5 = flateTree.len[0];
        if (n5 == 0) {
            n3 = 138;
            n4 = 3;
        }
        for (int i = 0; i <= flateTree.max_code; ++i) {
            int n6 = n5;
            n5 = flateTree.len[i + 1];
            if (++n2 < n3 && n6 == n5) continue;
            if (n2 < n4) {
                int n7 = n6;
                this.bl_tree.freq[n7] = this.bl_tree.freq[n7] + n2;
            } else if (n6 != 0) {
                if (n6 != n) {
                    int n8 = n6;
                    this.bl_tree.freq[n8] = this.bl_tree.freq[n8] + 1;
                }
                this.bl_tree.freq[16] = this.bl_tree.freq[16] + 1;
            } else if (n2 <= 10) {
                this.bl_tree.freq[17] = this.bl_tree.freq[17] + 1;
            } else {
                this.bl_tree.freq[18] = this.bl_tree.freq[18] + 1;
            }
            n2 = 0;
            n = n6;
            if (n5 == 0) {
                n3 = 138;
                n4 = 3;
                continue;
            }
            if (n6 == n5) {
                n3 = 6;
                n4 = 3;
                continue;
            }
            n3 = 7;
            n4 = 4;
        }
    }

    private void send_tree(FlateTree flateTree) throws IOException {
        int n = -1;
        int n2 = 0;
        int n3 = 7;
        int n4 = 4;
        int n5 = flateTree.len[0];
        if (n5 == 0) {
            n3 = 138;
            n4 = 3;
        }
        for (int i = 0; i <= flateTree.max_code; ++i) {
            int n6 = n5;
            n5 = flateTree.len[i + 1];
            if (++n2 < n3 && n6 == n5) continue;
            if (n2 < n4) {
                do {
                    this.sendCode(n6, this.bl_tree);
                } while (--n2 > 0);
            } else if (n6 != 0) {
                if (n6 != n) {
                    this.sendCode(n6, this.bl_tree);
                    --n2;
                }
                this.sendCode(16, this.bl_tree);
                this.sendBits(n2 - 3, 2);
            } else if (n2 <= 10) {
                this.sendCode(17, this.bl_tree);
                this.sendBits(n2 - 3, 3);
            } else {
                this.sendCode(18, this.bl_tree);
                this.sendBits(n2 - 11, 7);
            }
            n2 = 0;
            n = n6;
            if (n5 == 0) {
                n3 = 138;
                n4 = 3;
                continue;
            }
            if (n6 == n5) {
                n3 = 6;
                n4 = 3;
                continue;
            }
            n3 = 7;
            n4 = 4;
        }
    }

    private void send_all_trees(int n) throws IOException {
        this.sendBits(this.dyn_ltree.max_code + 1 - 257, 5);
        this.sendBits(this.dyn_dtree.max_code + 1 - 1, 5);
        this.sendBits(n + 1 - 4, 4);
        for (int i = 0; i <= n; ++i) {
            this.sendBits(this.bl_tree.len[bl_order[i]], 3);
        }
        this.send_tree(this.dyn_ltree);
        this.send_tree(this.dyn_dtree);
    }

    private int build_bl_tree() {
        int n;
        this.scan_tree(this.dyn_ltree);
        this.scan_tree(this.dyn_dtree);
        this.bl_tree.build_tree();
        for (n = 18; n >= 3 && this.bl_tree.len[bl_order[n]] == 0; --n) {
        }
        this.bl_tree.opt_len += 3 * (n + 1) + 5 + 5 + 4;
        return n;
    }

    private void copy_block(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        this.flushToByte();
        this.last_eob_len = 8;
        if (bl) {
            this.putShort(n2);
            this.putShort(~n2);
        }
        for (int i = 0; i < n2; ++i) {
            this.putByte(byArray[n + i]);
        }
    }

    private void tr_stored_block(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        this.sendBits(0 + (bl ? 1 : 0), 3);
        this.copy_block(byArray, n, n2, true);
    }

    private void tr_align() throws IOException {
        this.sendBits(2, 3);
        this.sendCode(256, this.static_ltree);
        if (1 + this.last_eob_len + 10 - this.rawBitsLeft < 9) {
            this.sendBits(2, 3);
            this.sendCode(256, this.static_ltree);
        }
        this.last_eob_len = 7;
    }

    private void tr_flush_block(boolean bl) throws IOException {
        int n;
        int n2;
        int n3 = 0;
        int n4 = this.strstart - this.block_start;
        if (this.level > 0) {
            this.dyn_ltree.build_tree();
            this.dyn_dtree.build_tree();
            n3 = this.build_bl_tree();
            int n5 = this.dyn_ltree.opt_len + this.dyn_dtree.opt_len + this.bl_tree.opt_len;
            int n6 = this.static_ltree.opt_len + this.static_dtree.opt_len;
            n2 = n5 + 3 + 7 >>> 3;
            n = n6 + 3 + 7 >>> 3;
            if (n <= n2) {
                n2 = n;
            }
        } else {
            n2 = n = n4 + 5;
        }
        if (n4 + 4 <= n2 && this.block_start >= 0) {
            this.tr_stored_block(this.window, this.block_start, n4, bl);
        } else if (n == n2) {
            this.sendBits(2 + (bl ? 1 : 0), 3);
            this.compress_block(this.static_ltree, this.static_dtree);
        } else {
            this.sendBits(4 + (bl ? 1 : 0), 3);
            this.send_all_trees(n3);
            this.compress_block(this.dyn_ltree, this.dyn_dtree);
        }
        this.dyn_ltree.InitTree();
        this.dyn_dtree.InitTree();
        this.bl_tree.InitTree();
        this.block_start = this.strstart;
        this.last_lit = 0;
        if (bl) {
            this.flushToByte();
        }
    }

    private int d_code(int n) {
        return n < 256 ? this.dist_code[n] : this.dist_code[256 + (n >>> 7)];
    }

    private boolean tr_tally(int n, int n2) {
        if (n == 0) {
            n2 &= 0xFF;
        }
        this.d_buf[this.last_lit] = (short)n;
        this.l_buf[this.last_lit++] = (short)n2;
        if (n == 0) {
            int n3 = n2;
            this.dyn_ltree.freq[n3] = this.dyn_ltree.freq[n3] + 1;
        } else {
            ++this.matches;
            int n4 = this.length_code[n2] + 256 + 1;
            this.dyn_ltree.freq[n4] = this.dyn_ltree.freq[n4] + 1;
            int n5 = this.d_code(--n);
            this.dyn_dtree.freq[n5] = this.dyn_dtree.freq[n5] + 1;
        }
        if (this.level > 2 && (this.last_lit & 0xFFF) == 0) {
            int n6 = this.last_lit * 8;
            int n7 = this.strstart - this.block_start;
            for (int i = 0; i < 30; ++i) {
                n6 += this.dyn_dtree.freq[i] * (5 + extra_dbits[i]);
            }
            if (this.matches < this.last_lit / 2 && (n6 >>>= 3) < n7 / 2) {
                return true;
            }
        }
        return this.last_lit == this.lit_bufsize - 1;
    }

    private void compress_block(FlateTree flateTree, FlateTree flateTree2) throws IOException {
        int n = 0;
        if (this.last_lit != 0) {
            do {
                int n2 = this.d_buf[n];
                int n3 = this.l_buf[n++];
                if (n2 == 0) {
                    this.sendCode(n3, flateTree);
                    continue;
                }
                int n4 = this.length_code[n3];
                this.sendCode(n4 + 256 + 1, flateTree);
                int n5 = extra_lbits[n4];
                if (n5 != 0) {
                    this.sendBits(n3 -= this.base_length[n4], n5);
                }
                n4 = this.d_code(--n2);
                this.sendCode(n4, flateTree2);
                n5 = extra_dbits[n4];
                if (n5 == 0) continue;
                this.sendBits(n2 -= this.base_dist[n4], n5);
            } while (n < this.last_lit);
        }
        this.sendCode(256, flateTree);
        this.last_eob_len = flateTree.len[256];
    }

    private void Adler32(int n) {
        this.adler_s1 += n & 0xFF;
        if (this.adler_s1 >= 65521) {
            this.adler_s1 -= 65521;
        }
        this.adler_s2 += this.adler_s1;
        if (this.adler_s2 >= 65521) {
            this.adler_s2 -= 65521;
        }
    }

    private void UPDATE_HASH(int n) {
        this.ins_h = (this.ins_h << this.hash_shift ^ n & 0xFF) & this.hash_mask;
    }

    private int INSERT_STRING() {
        this.UPDATE_HASH(this.window[this.strstart + 3 - 1]);
        short s = this.head[this.ins_h];
        this.prev[this.strstart & this.w_mask] = s;
        short s2 = s;
        this.head[this.ins_h] = (short)this.strstart;
        return s2 & 0xFFFF;
    }

    private void CLEAR_HASH() {
        int n = this.head.length;
        while (n-- > 0) {
            this.head[n] = 0;
        }
    }

    void DeflateInit(int n) {
        this.DeflateInit2(n, 15, 8, 0);
    }

    void DeflateInit2(int n, int n2, int n3, int n4) {
        if (this.level != -1) {
            return;
        }
        this.level = n;
        if (this.level == -1 || this.level < 0 || this.level > 9) {
            this.level = 6;
        }
        if (n3 < 1 || n3 > 9) {
            n3 = 8;
        }
        this.noheader = 0;
        if (n2 < 0) {
            this.noheader = 1;
            n2 = -n2;
        }
        if (n2 < 8) {
            n2 = 8;
        } else if (n2 > 15) {
            n2 = 15;
        }
        if (n4 < 0 || n4 > 2) {
            n4 = 0;
        }
        this.strategy = n4;
        this.w_bits = n2;
        this.w_size = 1 << this.w_bits;
        this.w_mask = this.w_size - 1;
        this.max_dist = this.w_size - 262;
        this.hash_bits = n3 + 7;
        this.hash_size = 1 << this.hash_bits;
        this.hash_mask = this.hash_size - 1;
        this.hash_shift = (this.hash_bits + 3 - 1) / 3;
        this.window = new byte[2 * this.w_size];
        this.prev = new short[this.w_size];
        this.head = new short[this.hash_size];
        this.lit_bufsize = 1 << n3 + 6;
        this.l_buf = new short[this.lit_bufsize];
        this.d_buf = new short[this.lit_bufsize];
        this.deflateReset();
    }

    void deflateReset() {
        if (this.noheader < 0) {
            this.noheader = 0;
        }
        this.status = this.noheader != 0 ? 113 : 42;
        this.adler_s1 = 1;
        this.adler_s2 = 0;
        this.lm_init();
    }

    private void lm_init() {
        this.window_size = 2 * this.w_size;
        this.CLEAR_HASH();
        switch (this.level) {
            case 0: {
                this.good_match = 0;
                this.max_lazy_match = 0;
                this.nice_match = 0;
                this.max_chain_length = 0;
                break;
            }
            case 1: {
                this.good_match = 4;
                this.max_lazy_match = 4;
                this.nice_match = 8;
                this.max_chain_length = 4;
                break;
            }
            case 2: {
                this.good_match = 4;
                this.max_lazy_match = 5;
                this.nice_match = 16;
                this.max_chain_length = 8;
                break;
            }
            case 3: {
                this.good_match = 4;
                this.max_lazy_match = 6;
                this.nice_match = 32;
                this.max_chain_length = 32;
                break;
            }
            case 4: {
                this.good_match = 4;
                this.max_lazy_match = 4;
                this.nice_match = 16;
                this.max_chain_length = 16;
                break;
            }
            case 5: {
                this.good_match = 8;
                this.max_lazy_match = 16;
                this.nice_match = 32;
                this.max_chain_length = 32;
                break;
            }
            default: {
                this.good_match = 8;
                this.max_lazy_match = 16;
                this.nice_match = 128;
                this.max_chain_length = 128;
                break;
            }
            case 7: {
                this.good_match = 8;
                this.max_lazy_match = 32;
                this.nice_match = 128;
                this.max_chain_length = 256;
                break;
            }
            case 8: {
                this.good_match = 32;
                this.max_lazy_match = 128;
                this.nice_match = 258;
                this.max_chain_length = 1024;
                break;
            }
            case 9: {
                this.good_match = 32;
                this.max_lazy_match = 258;
                this.nice_match = 258;
                this.max_chain_length = 4096;
            }
        }
        this.strstart = 0;
        this.block_start = 0;
        this.lookahead = 0;
        this.prev_length = 2;
        this.match_length = 2;
        this.match_available = false;
        this.ins_h = 0;
    }

    private int longest_match(int n) {
        int n2 = this.max_chain_length;
        int n3 = this.strstart;
        int n4 = this.prev_length;
        int n5 = this.nice_match;
        int n6 = this.strstart > this.max_dist ? this.strstart - this.max_dist : 0;
        int n7 = this.strstart + 258;
        byte by = this.window[n3 + n4 - 1];
        byte by2 = this.window[n3 + n4];
        if (this.prev_length >= this.good_match) {
            n2 >>= 2;
        }
        if (n5 > this.lookahead) {
            n5 = this.lookahead;
        }
        do {
            int n8;
            if (this.window[(n8 = n) + n4] != by2 || this.window[n8 + n4 - 1] != by || this.window[n8] != this.window[n3] || this.window[++n8] != this.window[n3 + 1]) continue;
            n3 += 2;
            ++n8;
            while (this.window[++n3] == this.window[++n8] && n3 < n7) {
            }
            int n9 = n3 - this.strstart;
            n3 = this.strstart;
            if (n9 <= n4) continue;
            this.match_start = n;
            n4 = n9;
            if (n9 >= n5) break;
            by = this.window[n3 + n4 - 1];
            by2 = this.window[n3 + n4];
        } while ((n = this.prev[n & this.w_mask]) > n6 && --n2 != 0);
        return n4 <= this.lookahead ? n4 : this.lookahead;
    }

    private void fill_window(int n) {
        if (this.strstart >= this.w_size + this.max_dist) {
            int n2;
            int n3;
            System.arraycopy(this.window, this.w_size, this.window, 0, this.w_size);
            this.match_start -= this.w_size;
            this.strstart -= this.w_size;
            this.block_start -= this.w_size;
            for (n3 = 0; n3 < this.hash_size; ++n3) {
                n2 = (this.head[n3] & 0xFFFF) - this.w_size;
                this.head[n3] = (short)(n2 >= 0 ? n2 : 0);
            }
            for (n3 = 0; n3 < this.w_size; ++n3) {
                n2 = (this.prev[n3] & 0xFFFF) - this.w_size;
                this.prev[n3] = (short)(n2 >= 0 ? n2 : 0);
            }
        }
        this.window[this.strstart + this.lookahead++] = (byte)n;
    }

    private void deflate_stored(int n) throws IOException {
        boolean bl;
        boolean bl2 = bl = n < 0;
        if (!bl) {
            this.window[this.strstart++] = (byte)n;
            if (this.strstart < this.window_size && this.strstart - this.block_start < 65535) {
                return;
            }
        }
        if (this.strstart - this.block_start > 0) {
            this.tr_flush_block(bl);
            this.block_start = 0;
            this.strstart = 0;
        }
    }

    private void deflate_fast(int n) throws IOException {
        boolean bl = n < 0;
        int n2 = 0;
        if (!bl) {
            this.fill_window(n);
            if (this.lookahead < 262) {
                return;
            }
        }
        if (this.lookahead > 0) {
            do {
                boolean bl2;
                if (this.lookahead >= 3) {
                    this.ins_h = this.window[this.strstart];
                    this.UPDATE_HASH(this.window[this.strstart + 1]);
                    n2 = this.INSERT_STRING();
                }
                if (n2 != 0 && this.strstart - n2 <= this.max_dist && this.strategy != 2) {
                    this.match_length = this.longest_match(n2);
                }
                if (this.match_length >= 3) {
                    bl2 = this.tr_tally(this.strstart - this.match_start, this.match_length - 3);
                    this.lookahead -= this.match_length;
                    if (this.match_length <= this.max_lazy_match && this.lookahead >= 3) {
                        --this.match_length;
                        do {
                            ++this.strstart;
                            this.INSERT_STRING();
                        } while (--this.match_length != 0);
                        ++this.strstart;
                    } else {
                        this.strstart += this.match_length;
                        this.match_length = 0;
                        this.ins_h = this.window[this.strstart];
                        this.UPDATE_HASH(this.window[this.strstart + 1]);
                    }
                } else {
                    bl2 = this.tr_tally(0, this.window[this.strstart]);
                    --this.lookahead;
                    ++this.strstart;
                }
                if (!bl2) continue;
                this.tr_flush_block(false);
            } while (bl && this.lookahead > 0);
        }
        if (bl) {
            this.tr_flush_block(bl);
        }
    }

    private void deflate_slow(int n) throws IOException {
        boolean bl = n < 0;
        boolean bl2 = false;
        int n2 = 0;
        if (!bl) {
            this.fill_window(n);
            if (this.lookahead < 262) {
                return;
            }
        }
        if (this.lookahead > 0) {
            do {
                if (this.lookahead >= 3) {
                    this.ins_h = this.window[this.strstart];
                    this.UPDATE_HASH(this.window[this.strstart + 1]);
                    n2 = this.INSERT_STRING();
                }
                this.prev_length = this.match_length;
                this.prev_match = this.match_start;
                this.match_length = 2;
                if (n2 != 0 && this.prev_length < this.max_lazy_match && this.strstart - n2 <= this.max_dist) {
                    if (this.strategy != 2) {
                        this.match_length = this.longest_match(n2);
                    }
                    if (this.match_length <= 5 && (this.strategy == 1 || this.match_length == 3 && this.strstart - this.match_start > 4096)) {
                        this.match_length = 2;
                    }
                }
                if (this.prev_length >= 3 && this.match_length <= this.prev_length) {
                    int n3 = this.strstart + this.lookahead - 3;
                    bl2 = this.tr_tally(this.strstart - 1 - this.prev_match, this.prev_length - 3);
                    this.lookahead -= this.prev_length - 1;
                    this.prev_length -= 2;
                    do {
                        if (++this.strstart > n3) continue;
                        this.INSERT_STRING();
                    } while (--this.prev_length != 0);
                    this.match_available = false;
                    this.match_length = 2;
                    ++this.strstart;
                } else if (this.match_available) {
                    bl2 = this.tr_tally(0, this.window[this.strstart - 1]);
                    ++this.strstart;
                    --this.lookahead;
                } else {
                    bl2 = false;
                    this.match_available = true;
                    ++this.strstart;
                    --this.lookahead;
                }
                if (!bl2) continue;
                this.tr_flush_block(false);
            } while (bl && this.lookahead > 0);
        }
        if (bl) {
            if (this.match_available) {
                this.tr_tally(0, this.window[this.strstart - 1]);
            }
            this.tr_flush_block(bl);
        }
    }

    void write(int n) throws IOException {
        if (n >= 0) {
            this.Adler32(n);
            if (this.level == -1) {
                this.DeflateInit(-1);
            }
            if (this.status == 42) {
                int n2 = 8 + (this.w_bits - 8 << 4) << 8;
                int n3 = this.level - 1 >> 1;
                if (n3 < 0 || n3 > 3) {
                    n3 = 3;
                }
                n2 |= n3 << 6;
                n2 += 31 - n2 % 31;
                this.status = 113;
                this.putShortMSB(n2);
                this.adler_s1 = 1;
                this.adler_s2 = 0;
            }
            if (this.level == 0) {
                this.deflate_stored(n & 0xFF);
            } else if (this.level <= 3) {
                this.deflate_fast(n & 0xFF);
            } else {
                this.deflate_slow(n & 0xFF);
            }
        } else if (this.status != 666) {
            if (this.level == 0) {
                this.deflate_stored(-1);
            } else if (this.level <= 3) {
                this.deflate_fast(-1);
            } else {
                this.deflate_slow(-1);
            }
            this.status = 666;
            int n4 = this.adler_s2;
            int n5 = this.adler_s1;
            this.putShortMSB(n4);
            this.putShortMSB(n5);
        }
    }

    long getTotalOut() {
        return this.totalOut;
    }
}

