/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util.filter;

import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosDictionary;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.filter.ASCII85InputStream;
import com.adobe.internal.pdf.cos.util.filter.ASCII85OutputStream;
import com.adobe.internal.pdf.cos.util.filter.ASCIIHexInputStream;
import com.adobe.internal.pdf.cos.util.filter.ASCIIHexOutputStream;
import com.adobe.internal.pdf.cos.util.filter.FilterParams;
import com.adobe.internal.pdf.cos.util.filter.FlateInputStream;
import com.adobe.internal.pdf.cos.util.filter.LZWInputStream;
import com.adobe.internal.pdf.cos.util.filter.LZWOutputStream;
import com.adobe.internal.pdf.cos.util.filter.TIFFInputStream;
import com.adobe.internal.pdf.cos.util.filter.TIFFOutputStream;
import com.adobe.internal.pdf.cos.util.filter.UnsupportedFilterException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;

public class FilterStream {
    public static FilterParams buildFilterParams(Object object) {
        FilterParams filterParams = null;
        if (object instanceof CosDictionary) {
            filterParams = FilterStream.addToParms(new FilterParams(), object);
        } else if (object instanceof CosArray) {
            filterParams = new FilterParams();
            for (int i = 0; i < ((CosArray)object).size(); ++i) {
                filterParams = FilterStream.addToParms(filterParams, ((CosArray)object).get(i));
            }
        }
        return filterParams;
    }

    private static FilterParams addToParms(FilterParams filterParams, Object object) {
        CosObject cosObject;
        CosObject cosObject2;
        CosObject cosObject3;
        CosObject cosObject4;
        CosObject cosObject5;
        CosObject cosObject6;
        CosObject cosObject7;
        CosObject cosObject8;
        CosObject cosObject9;
        CosObject cosObject10;
        if (!(object instanceof CosDictionary)) {
            return null;
        }
        CosDictionary cosDictionary = (CosDictionary)object;
        CosObject cosObject11 = cosDictionary.get(ASName.k_Predictor);
        if (cosObject11 != null) {
            filterParams.put("Predictor", new Integer(cosObject11.intValue()));
        }
        if ((cosObject10 = cosDictionary.get(ASName.k_Columns)) != null) {
            filterParams.put("Cols", new Integer(cosObject10.intValue()));
        }
        if ((cosObject9 = cosDictionary.get(ASName.k_Colors)) != null) {
            filterParams.put("Components", new Integer(cosObject9.intValue()));
        }
        if ((cosObject8 = cosDictionary.get(ASName.k_EarlyChange)) != null) {
            filterParams.put("EarlyChange", new Integer(cosObject8.intValue()));
        }
        if ((cosObject7 = cosDictionary.get(ASName.k_K)) != null) {
            filterParams.put("K", new Integer(cosObject7.intValue()));
        }
        if ((cosObject6 = cosDictionary.get(ASName.k_EndOfLine)) != null) {
            filterParams.put("DoEOL", new Boolean(cosObject6.booleanValue()));
        }
        if ((cosObject5 = cosDictionary.get(ASName.k_EncodedByteAlign)) != null) {
            filterParams.put("ByteAlign", new Boolean(cosObject5.booleanValue()));
        }
        if ((cosObject4 = cosDictionary.get(ASName.k_Rows)) != null) {
            filterParams.put("Rows", new Integer(cosObject4.intValue()));
        }
        if ((cosObject3 = cosDictionary.get(ASName.k_EndOfBlock)) != null) {
            filterParams.put("DoRTC", new Boolean(cosObject3.booleanValue()));
        }
        if ((cosObject2 = cosDictionary.get(ASName.k_BlackIs1)) != null) {
            filterParams.put("BlackIs1", new Boolean(cosObject2.booleanValue()));
        }
        if ((cosObject = cosDictionary.get(ASName.k_DamagedRowsBeforeError)) != null) {
            filterParams.put("DamagedRowsBeforeError", new Integer(cosObject.intValue()));
        }
        return filterParams;
    }

    public static InputStream applyFilter(InputStream inputStream, ASName aSName, FilterParams filterParams) {
        InputStream inputStream2 = inputStream;
        if (aSName.equals(ASName.k_FlateDecode)) {
            inputStream2 = new FlateInputStream(inputStream);
            if (filterParams != null && filterParams.containsKey("Predictor") && (Integer)filterParams.get("Predictor") != 1) {
                inputStream2 = new TIFFInputStream(inputStream2, filterParams);
            }
        } else if (aSName.equals(ASName.k_ASCII85Decode)) {
            inputStream2 = new ASCII85InputStream(inputStream, filterParams);
        } else if (aSName.equals(ASName.k_ASCIIHexDecode)) {
            inputStream2 = new ASCIIHexInputStream(inputStream, filterParams);
        } else if (aSName.equals(ASName.k_LZWDecode)) {
            inputStream2 = new LZWInputStream(inputStream, filterParams);
        } else {
            String string = aSName.toString();
            throw new UnsupportedFilterException("unsupported filter " + string + " called for");
        }
        return inputStream2;
    }

    public static OutputStream applyFilter(OutputStream outputStream, ASName aSName, FilterParams filterParams) {
        OutputStream outputStream2 = outputStream;
        if (aSName.equals(ASName.k_FlateDecode)) {
            outputStream2 = outputStream;
            if (filterParams != null && filterParams.containsKey("Predictor") && (Integer)filterParams.get("Predictor") != 1) {
                outputStream2 = new TIFFOutputStream(outputStream2, filterParams);
            }
            outputStream2 = new DeflaterOutputStream(outputStream);
        } else if (aSName.equals(ASName.k_ASCII85Encode)) {
            outputStream2 = new ASCII85OutputStream(outputStream, filterParams);
        } else if (aSName.equals(ASName.k_ASCIIHexEncode)) {
            outputStream2 = new ASCIIHexOutputStream(outputStream, filterParams);
        } else if (aSName.equals(ASName.k_LZWEncode)) {
            outputStream2 = new LZWOutputStream(outputStream, filterParams);
        } else {
            throw new UnsupportedFilterException("unsupported filter called for");
        }
        return outputStream2;
    }
}

