/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util.filter;

import com.adobe.internal.pdf.cos.util.filter.FilterException;
import com.adobe.internal.pdf.cos.util.filter.FilterParams;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class DecodeInputStream
extends FilterInputStream {
    protected boolean useInMark = false;
    protected byte[] inBuf = null;
    protected int inCount = 0;
    protected int inPos = 0;
    protected byte[] outBuf = null;
    protected int outCount = 0;
    protected int outPos = 0;
    protected int outHeadroom = 0;
    protected int markPos = -1;
    protected int markLimit = 0;
    protected FilterParams diparams = null;
    protected IOException pendingException = null;
    protected boolean avoidOverrun = false;
    protected boolean closeSource = true;
    protected boolean pendingEOF = false;

    public DecodeInputStream(InputStream inputStream, int n, int n2, int n3, FilterParams filterParams) {
        super(inputStream);
        if (filterParams == null) {
            filterParams = new FilterParams();
        }
        this.diparams = filterParams;
        this.outHeadroom = n3;
        this.outBuf = new byte[n2 + n3 + 1];
        if (filterParams.containsKey("AvoidInOverrun")) {
            this.avoidOverrun = (Boolean)filterParams.get("AvoidInOverrun");
        }
        if (filterParams.containsKey("CloseSource")) {
            this.closeSource = (Boolean)filterParams.get("CloseSource");
        }
        if (inputStream instanceof DecodeInputStream) {
            this.inBuf = ((DecodeInputStream)inputStream).outBuf;
            this.useInMark = false;
        } else if (this.avoidOverrun) {
            this.useInMark = inputStream.markSupported();
            this.inBuf = new byte[this.useInMark ? n : 1];
        } else {
            this.inBuf = new byte[n];
        }
    }

    public DecodeInputStream(InputStream inputStream, int n, FilterParams filterParams) {
        this(inputStream, 2048, 2048, n, filterParams);
    }

    public DecodeInputStream(InputStream inputStream, FilterParams filterParams) {
        this(inputStream, 2048, 2048, 128, filterParams);
    }

    public DecodeInputStream(InputStream inputStream) {
        this(inputStream, null);
    }

    public abstract void fill();

    protected void doFill() {
        if (this.pendingEOF || this.pendingException != null) {
            return;
        }
        this.makeBufferSpace();
        this.fill();
    }

    protected boolean fillInputBuffer() {
        if (this.inCount <= this.inPos) {
            if (this.pendingEOF || this.pendingException != null) {
                return false;
            }
            if (this.useInMark) {
                this.in.mark(this.inBuf.length);
            }
            try {
                if (this.in instanceof DecodeInputStream) {
                    DecodeInputStream decodeInputStream = (DecodeInputStream)this.in;
                    decodeInputStream.outPos = this.inPos;
                    decodeInputStream.doFill();
                    this.inBuf = decodeInputStream.outBuf;
                    this.inPos = decodeInputStream.outPos;
                    this.inCount = decodeInputStream.outCount;
                } else {
                    this.inPos = 0;
                    this.inCount = this.in.read(this.inBuf, this.inPos, this.inBuf.length);
                }
            }
            catch (IOException iOException) {
                this.pendingException = iOException;
                return false;
            }
            if (this.inCount <= this.inPos) {
                return false;
            }
        }
        return true;
    }

    protected void makeBufferSpace() {
        while (0 <= this.markPos && this.outBuf.length <= this.outPos + this.outHeadroom) {
            if (0 < this.markPos) {
                this.outPos -= this.markPos;
                System.arraycopy(this.outBuf, this.markPos, this.outBuf, 0, this.outPos);
                this.markPos = 0;
                continue;
            }
            int n = this.markLimit + this.outHeadroom + 1;
            if (n <= this.outBuf.length) {
                this.markPos = -1;
                continue;
            }
            int n2 = 2 * this.outBuf.length - (this.outHeadroom + 1);
            if (n < n2) {
                n2 = n;
            }
            byte[] byArray = new byte[n2];
            System.arraycopy(this.outBuf, 0, byArray, 0, this.outPos);
            this.outBuf = byArray;
        }
        if (this.markPos < 0) {
            this.outPos = 0;
        }
        this.outCount = this.outPos;
    }

    public synchronized int read() {
        if (this.outCount <= this.outPos) {
            this.doFill();
            if (this.outCount <= this.outPos) {
                return -1;
            }
        }
        return this.outBuf[this.outPos++] & 0xFF;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            return (int)this.skip(n2);
        }
        if (0 < n2) {
            int n3;
            if (this.outCount <= this.outPos) {
                this.doFill();
                if (this.outCount <= this.outPos) {
                    if (this.pendingException == null) {
                        return -1;
                    }
                    throw this.pendingException;
                }
            }
            if (n2 > (n3 = this.outCount - this.outPos)) {
                n2 = n3;
            }
            System.arraycopy(this.outBuf, this.outPos, byArray, n, n2);
            n += n2;
            this.outPos += n2;
        }
        return n2;
    }

    public synchronized long skip(long l) throws IOException {
        if (0L < l) {
            int n;
            if (this.outCount <= this.outPos) {
                this.doFill();
                if (this.outCount <= this.outPos) {
                    if (this.pendingException == null) {
                        return -1L;
                    }
                    throw this.pendingException;
                }
            }
            if (l > (long)(n = this.outCount - this.outPos)) {
                l = n;
            }
            this.outPos += (int)l;
        }
        return l;
    }

    public synchronized int available() {
        if (this.outCount <= this.outPos) {
            this.doFill();
        }
        return this.outCount - this.outPos;
    }

    public synchronized void mark(int n) {
        this.markLimit = n;
        this.markPos = this.outPos;
    }

    public synchronized void reset() throws IOException {
        if (this.markPos < 0) {
            throw new FilterException("DecodeInput reset to invalid mark");
        }
        this.outPos = this.markPos;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void releaseUnconsumedInput() {
        block4: {
            try {
                do {
                    if (this.skip(Long.MAX_VALUE) >= 0L) continue;
                    this.pendingEOF = true;
                } while (!this.pendingEOF && this.pendingException == null);
                if (this.useInMark && this.inPos < this.inCount) {
                    this.in.reset();
                    this.in.skip(this.inPos);
                    this.in.mark(0);
                }
            }
            catch (IOException iOException) {
                if (this.pendingException != null) break block4;
                this.pendingException = iOException;
            }
        }
        this.inCount = 0;
        this.inPos = 0;
    }

    public void close() throws IOException {
        if (this.avoidOverrun) {
            this.releaseUnconsumedInput();
        }
        if (this.closeSource) {
            super.close();
        }
    }
}

