/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util.filter;

import com.adobe.internal.pdf.cos.util.filter.Base64FilterException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Base64Engine {
    private static final byte ED = 64;
    private static final byte IL = 65;
    private static byte[] base64DecodeTable;
    private static byte[] base64EncodeTable;

    public static int decode(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = 0;
        int n5 = 0;
        if (byArray2 != null) {
            n4 = byArray2.length - n3;
        }
        if (n2 > byArray.length - n) {
            n2 = byArray.length - n;
        }
        while (n2 > 0) {
            int n6 = 0;
            int n7 = 0;
            while (n6 < 4 && n2-- > 0) {
                byte by;
                if ((by = base64DecodeTable[byArray[n++] & 0x7F]) < 64) {
                    n7 = (n7 << 6) + by;
                    ++n6;
                    continue;
                }
                if (by != 64 || n6 == 0) continue;
                n2 = 0;
                break;
            }
            switch (n6) {
                case 1: {
                    n7 <<= 6;
                }
                case 2: {
                    n7 <<= 6;
                }
                case 3: {
                    n7 <<= 6;
                }
            }
            if (n6 >= 1) {
                ++n5;
                if (n4-- > 0) {
                    byArray2[n3++] = (byte)(n7 >> 16);
                }
            }
            if (n6 >= 3) {
                ++n5;
                if (n4-- > 0) {
                    byArray2[n3++] = (byte)(n7 >> 8);
                }
            }
            if (n6 != 4) continue;
            ++n5;
            if (n4-- <= 0) continue;
            byArray2[n3++] = (byte)n7;
        }
        return n5;
    }

    public static byte[] decode(byte[] byArray, int n, int n2) {
        int n3 = Base64Engine.decode(byArray, n, n2, null, 0);
        byte[] byArray2 = new byte[n3];
        Base64Engine.decode(byArray, n, n2, byArray2, 0);
        return byArray2;
    }

    public static String decode(String string) {
        return new String(Base64Engine.decode(string.getBytes(), 0, string.length()));
    }

    public static int encode(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = 0;
        if (byArray2 != null) {
            n5 = byArray2.length - n3;
        }
        if (n2 > byArray.length - n) {
            n2 = byArray.length - n;
        }
        int n7 = 0;
        while (n2 >= 3) {
            if (n7 == 76) {
                if (n5-- > 0) {
                    byArray2[n3++] = 13;
                }
                if (n5-- > 0) {
                    byArray2[n3++] = 10;
                }
                n6 += 2;
                n7 = 0;
            }
            n4 = (byArray[n++] & 0xFF) << 16;
            n4 += (byArray[n++] & 0xFF) << 8;
            n4 += byArray[n++] & 0xFF;
            if (n5-- > 0) {
                byArray2[n3++] = base64EncodeTable[n4 >>> 18];
            }
            if (n5-- > 0) {
                byArray2[n3++] = base64EncodeTable[n4 >>> 12 & 0x3F];
            }
            if (n5-- > 0) {
                byArray2[n3++] = base64EncodeTable[n4 >>> 6 & 0x3F];
            }
            if (n5-- > 0) {
                byArray2[n3++] = base64EncodeTable[n4 & 0x3F];
            }
            n2 -= 3;
            n6 += 4;
            n7 += 4;
        }
        if (n2 > 0) {
            if (n7 == 76) {
                if (n5-- > 0) {
                    byArray2[n3++] = 13;
                }
                if (n5-- > 0) {
                    byArray2[n3++] = 10;
                }
                n6 += 2;
            }
            n4 = (byArray[n++] & 0xFF) << 16;
            if (n2 > 1) {
                n4 += (byArray[n] & 0xFF) << 8;
            }
            if (n5-- > 0) {
                byArray2[n3++] = base64EncodeTable[n4 >>> 18];
            }
            if (n5-- > 0) {
                byArray2[n3++] = base64EncodeTable[n4 >>> 12 & 0x3F];
            }
            if (n5-- > 0) {
                byArray2[n3++] = n2 > 1 ? base64EncodeTable[n4 >>> 6 & 0x3F] : 61;
            }
            if (n5-- > 0) {
                byArray2[n3++] = 61;
            }
            n6 += 4;
        }
        return n6;
    }

    public static byte[] encode(byte[] byArray, int n, int n2) {
        int n3 = Base64Engine.encode(byArray, n, n2, null, 0);
        byte[] byArray2 = new byte[n3];
        Base64Engine.encode(byArray, n, n2, byArray2, 0);
        return byArray2;
    }

    public static String encode(String string) {
        return new String(Base64Engine.encode(string.getBytes(), 0, string.length()));
    }

    static {
        int n;
        base64DecodeTable = new byte[128];
        base64EncodeTable = new byte[64];
        for (n = 0; n < 128; ++n) {
            Base64Engine.base64DecodeTable[n] = 65;
        }
        for (n = 0; n < 26; ++n) {
            Base64Engine.base64DecodeTable[65 + n] = (byte)n;
            Base64Engine.base64EncodeTable[n] = (byte)(65 + n);
            Base64Engine.base64DecodeTable[97 + n] = (byte)(n + 26);
            Base64Engine.base64EncodeTable[n + 26] = (byte)(97 + n);
        }
        for (n = 0; n < 10; ++n) {
            Base64Engine.base64DecodeTable[48 + n] = (byte)(n + 52);
            Base64Engine.base64EncodeTable[n + 52] = (byte)(48 + n);
        }
        Base64Engine.base64DecodeTable[43] = 62;
        Base64Engine.base64EncodeTable[62] = 43;
        Base64Engine.base64DecodeTable[47] = 63;
        Base64Engine.base64EncodeTable[63] = 47;
        Base64Engine.base64DecodeTable[61] = 64;
    }

    public static class InputEncodeStream
    extends InputStream {
        private InputStream mIn;
        byte[] mInbuf;
        byte[] mOutbuf;
        int mOutNdx;
        int mOnLine;
        boolean mSendLF;

        public InputEncodeStream(InputStream inputStream) {
            this.mIn = inputStream;
            this.mInbuf = new byte[3];
            this.mOutbuf = new byte[4];
            this.mOnLine = 0;
            this.mOutNdx = 4;
            this.mSendLF = false;
        }

        public int read() throws IOException {
            if (this.mSendLF) {
                this.mSendLF = false;
                return 10;
            }
            if (this.mOnLine == 76) {
                this.mSendLF = true;
                this.mOnLine = 0;
                return 13;
            }
            if (this.mOutNdx >= 4) {
                int n = this.mIn.read(this.mInbuf, 0, 3);
                if (n == -1) {
                    return -1;
                }
                Base64Engine.encode(this.mInbuf, 0, n, this.mOutbuf, 0);
                this.mOutNdx = 0;
            }
            ++this.mOnLine;
            return this.mOutbuf[this.mOutNdx++];
        }
    }

    public static class OutputDecodeStream
    extends OutputStream {
        private byte[] mInbuf = new byte[4];
        private byte[] mOutbuf = new byte[3];
        private int mInNdx = 0;
        private OutputStream mOut;

        public OutputDecodeStream(OutputStream outputStream) {
            this.mOut = outputStream;
        }

        public void write(int n) throws IOException {
            if (n < 0) {
                throw new Base64FilterException("invalid Base64 character");
            }
            if (base64DecodeTable[n & 0x7F] == 65) {
                return;
            }
            this.mInbuf[this.mInNdx++] = (byte)(n & 0x7F);
            if (this.mInNdx >= 4) {
                int n2 = Base64Engine.decode(this.mInbuf, 0, 4, this.mOutbuf, 0);
                this.mOut.write(this.mOutbuf, 0, n2);
                this.mInNdx = 0;
            }
        }

        public void close() throws IOException {
            if (this.mInNdx != 0) {
                throw new Base64FilterException("Incomplete Base64 data stream");
            }
        }
    }
}

