/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util.filter;

import com.adobe.internal.pdf.cos.util.filter.FilterParams;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ASCIIHexOutputStream
extends FilterOutputStream {
    private int NEWLINE_EVERY = 64;
    private int lineLength;
    private byte[] toHex;
    private long totalOut;

    public ASCIIHexOutputStream(OutputStream outputStream, FilterParams filterParams) {
        super(outputStream);
        this.initOutput();
        if (filterParams != null && filterParams.containsKey("NewlineEvery")) {
            this.NEWLINE_EVERY = (Integer)filterParams.get("NewlineEvery");
        }
    }

    public ASCIIHexOutputStream(OutputStream outputStream) {
        this(outputStream, null);
    }

    private void initOutput() {
        int n;
        this.lineLength = this.NEWLINE_EVERY;
        this.totalOut = 0L;
        this.toHex = new byte[16];
        for (n = 0; n <= 9; ++n) {
            this.toHex[n] = (byte)(n + 48);
        }
        for (n = 10; n <= 15; ++n) {
            this.toHex[n] = (byte)(n - 10 + 65);
        }
    }

    private void putEOL() throws IOException {
        this.out.write(13);
        this.out.write(10);
        this.lineLength = 0;
        this.totalOut += 2L;
    }

    public void write(int n) throws IOException {
        if (this.lineLength > this.NEWLINE_EVERY - 2) {
            this.putEOL();
        }
        this.out.write(this.toHex[n >>> 4 & 0xF]);
        this.out.write(this.toHex[n & 0xF]);
        this.lineLength += 2;
        this.totalOut += 2L;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = byArray.length - n;
        if (n3 > n2) {
            n3 = n2;
        }
        while (n3-- > 0) {
            this.write(byArray[n++] & 0xFF);
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void close() throws IOException {
        this.out.write(62);
        ++this.totalOut;
        this.out.flush();
        this.out.close();
        super.close();
    }

    public long getTotalOut() {
        return this.totalOut;
    }
}

