/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util.filter;

import com.adobe.internal.pdf.cos.util.filter.ASCIIHexFilterException;
import com.adobe.internal.pdf.cos.util.filter.DecodeInputStream;
import com.adobe.internal.pdf.cos.util.filter.FilterParams;
import java.io.InputStream;

public class ASCIIHexInputStream
extends DecodeInputStream {
    private static final byte WS = 85;
    private static final byte ED = 87;
    private static final byte IL = 88;
    private static byte[] ascHxDecodeTable = new byte[128];

    public ASCIIHexInputStream(InputStream inputStream, int n, int n2, FilterParams filterParams) {
        super(inputStream, n, n2, 1, filterParams);
    }

    public ASCIIHexInputStream(InputStream inputStream, FilterParams filterParams) {
        super(inputStream, 1, filterParams);
    }

    public ASCIIHexInputStream(InputStream inputStream) {
        this(inputStream, null);
    }

    public void fill() {
        block4: while (this.outCount <= this.outBuf.length - 1 && !this.pendingEOF && this.pendingException == null) {
            int n = 0;
            int n2 = 4;
            block5: while (n2 >= 0) {
                int n3;
                byte by;
                if (this.inCount <= this.inPos && !this.fillInputBuffer()) {
                    this.pendingException = new ASCIIHexFilterException("AscHx missing EOF");
                    break block4;
                }
                if ((by = ascHxDecodeTable[n3 = this.inBuf[this.inPos++] & 0x7F]) < 16) {
                    n += by << n2;
                    n2 -= 4;
                    continue;
                }
                switch (by) {
                    case 85: {
                        continue block5;
                    }
                    case 87: {
                        if (n2 != 0) {
                            this.pendingException = new ASCIIHexFilterException("AscHx odd number of nybbles");
                        }
                        this.pendingEOF = true;
                        break block5;
                    }
                    default: {
                        this.pendingException = new ASCIIHexFilterException("AscHx illegal char");
                        break block5;
                    }
                }
            }
            this.outBuf[this.outCount++] = (byte)n;
        }
    }

    static {
        block11: for (int i = 0; i < 128; ++i) {
            switch ((char)i) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    ASCIIHexInputStream.ascHxDecodeTable[i] = 85;
                    continue block11;
                }
                case '>': {
                    ASCIIHexInputStream.ascHxDecodeTable[i] = 87;
                    continue block11;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    ASCIIHexInputStream.ascHxDecodeTable[i] = (byte)(i - 48);
                    continue block11;
                }
                case 'A': 
                case 'a': {
                    ASCIIHexInputStream.ascHxDecodeTable[i] = 10;
                    continue block11;
                }
                case 'B': 
                case 'b': {
                    ASCIIHexInputStream.ascHxDecodeTable[i] = 11;
                    continue block11;
                }
                case 'C': 
                case 'c': {
                    ASCIIHexInputStream.ascHxDecodeTable[i] = 12;
                    continue block11;
                }
                case 'D': 
                case 'd': {
                    ASCIIHexInputStream.ascHxDecodeTable[i] = 13;
                    continue block11;
                }
                case 'E': 
                case 'e': {
                    ASCIIHexInputStream.ascHxDecodeTable[i] = 14;
                    continue block11;
                }
                case 'F': 
                case 'f': {
                    ASCIIHexInputStream.ascHxDecodeTable[i] = 15;
                    continue block11;
                }
                default: {
                    ASCIIHexInputStream.ascHxDecodeTable[i] = 88;
                }
            }
        }
    }
}

