/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util.filter;

import com.adobe.internal.pdf.cos.util.filter.FilterParams;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ASCII85OutputStream
extends FilterOutputStream {
    private int NEWLINE_EVERY = 64;
    private long value;
    private int nShift;
    private int lineLength;
    private long totalOut;

    public ASCII85OutputStream(OutputStream outputStream, FilterParams filterParams) {
        super(outputStream);
        this.initOutput();
        if (filterParams != null && filterParams.containsKey("NewlineEvery")) {
            this.NEWLINE_EVERY = (Integer)filterParams.get("NewlineEvery");
        }
    }

    public ASCII85OutputStream(OutputStream outputStream) {
        this(outputStream, null);
    }

    private void initOutput() {
        this.lineLength = this.NEWLINE_EVERY;
        this.nShift = 24;
        this.value = 0L;
        this.totalOut = 0L;
    }

    private void putEOL() throws IOException {
        this.out.write(13);
        this.out.write(10);
        this.lineLength = 0;
        this.totalOut += 2L;
    }

    private void put1(int n) throws IOException {
        if (this.lineLength > this.NEWLINE_EVERY - 1) {
            this.putEOL();
        }
        this.out.write((byte)n);
        ++this.lineLength;
        ++this.totalOut;
    }

    public void write(int n) throws IOException {
        this.value += (long)(n & 0xFF) << this.nShift;
        this.nShift -= 8;
        if (this.nShift < 0) {
            if (this.value == 0L) {
                this.put1(122);
            } else {
                int n2 = (int)(this.value / 7225L);
                int n3 = (int)(this.value - (long)(7225 * n2));
                int n4 = n2 / 7225;
                int n5 = (n2 -= 7225 * n4) / 85;
                int n6 = n2 - 85 * n5;
                int n7 = n3 / 85;
                int n8 = n3 - 85 * n7;
                this.put1(n4 + 33);
                this.put1(n5 + 33);
                this.put1(n6 + 33);
                this.put1(n7 + 33);
                this.put1(n8 + 33);
                this.value = 0L;
            }
            this.nShift = 24;
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = byArray.length - n;
        if (n3 > n2) {
            n3 = n2;
        }
        while (n3-- > 0) {
            this.write(byArray[n++] & 0xFF);
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void close() throws IOException {
        if (this.nShift >= 0 && this.nShift < 24) {
            int n = (int)(this.value / 7225L);
            int n2 = (int)(this.value - (long)(7225 * n));
            int n3 = n / 7225;
            int n4 = (n -= 7225 * n3) / 85;
            int n5 = n - 85 * n4;
            int n6 = n2 / 85;
            int n7 = n2 - 85 * n6;
            switch (this.nShift) {
                case 16: {
                    this.put1(n3 + 33);
                    this.put1(n4 + 33);
                    break;
                }
                case 8: {
                    this.put1(n3 + 33);
                    this.put1(n4 + 33);
                    this.put1(n5 + 33);
                    break;
                }
                case 0: {
                    this.put1(n3 + 33);
                    this.put1(n4 + 33);
                    this.put1(n5 + 33);
                    this.put1(n6 + 33);
                }
            }
        }
        if (this.lineLength > this.NEWLINE_EVERY - 2) {
            this.putEOL();
        }
        this.out.write(126);
        this.out.write(62);
        this.totalOut += 2L;
        this.out.flush();
        this.out.close();
        super.close();
    }

    public long getTotalOut() {
        return this.totalOut;
    }
}

