/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util.encodings;

import com.adobe.internal.pdf.cos.util.ASDictionary;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.encodings.CharSetEncoding;
import com.adobe.internal.pdf.cos.util.encodings.MacRomanEncoding;
import com.adobe.internal.pdf.cos.util.encodings.StandardEncoding;
import com.adobe.internal.pdf.cos.util.encodings.SymbolEncoding;
import com.adobe.internal.pdf.cos.util.encodings.WinAnsiEncoding;
import com.adobe.internal.pdf.cos.util.encodings.ZapfDingbatsEncoding;
import com.adobe.internal.pdf.cos.util.exceptions.PDFEncodingException;

public class StandardCharSetEncodings {
    private static ASDictionary encodings = new ASDictionary();

    StandardCharSetEncodings() {
    }

    public static CharSetEncoding get(ASName aSName) {
        if (encodings.containsKey(aSName)) {
            return (CharSetEncoding)encodings.get(aSName);
        }
        throw new PDFEncodingException("unrecognized encoding");
    }

    static {
        encodings.put(ASName.k_MacRomanEncoding, MacRomanEncoding.getEncoding());
        encodings.put(ASName.k_WinAnsiEncoding, WinAnsiEncoding.getEncoding());
        encodings.put(ASName.k_StandardEncoding, StandardEncoding.getEncoding());
        encodings.put(ASName.k_SymbolEncoding, SymbolEncoding.getEncoding());
        encodings.put(ASName.k_ZapfDingbatsEncoding, ZapfDingbatsEncoding.getEncoding());
    }
}

