/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util.encodings;

import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ASString;
import com.adobe.internal.pdf.cos.util.encodings.Encoding;

public abstract class CharSetEncoding
implements Encoding {
    private ASName name;
    private char[] toUnicodeMap;

    protected CharSetEncoding(ASName aSName, char[] cArray) {
        this.name = aSName;
        this.toUnicodeMap = cArray;
    }

    public ASName getName() {
        return this.name;
    }

    public String toUnicode(ASString aSString) {
        byte[] byArray = aSString.getBytes();
        return this.toUnicode(byArray, 0, byArray.length);
    }

    public String toUnicode(byte[] byArray, int n, int n2) {
        if (n2 > 0 && byArray != null) {
            StringBuffer stringBuffer = new StringBuffer(byArray.length);
            for (int i = n; i < n2; ++i) {
                stringBuffer.append(this.toUnicode(byArray[i]));
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public char[] toUnicode(byte n) {
        char[] cArray = new char[]{'\ufffd'};
        int n2 = n;
        if (n < 0) {
            n2 += 256;
        }
        cArray[0] = this.toUnicodeMap[n2];
        return cArray;
    }

    public int fromUnicode(char c) {
        for (int i = 0; i < this.toUnicodeMap.length; ++i) {
            if (this.toUnicodeMap[i] != c) continue;
            return i;
        }
        return 0;
    }
}

