/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util;

import com.adobe.internal.pdf.cos.util.ByteArrayByteRepository;
import com.adobe.internal.pdf.cos.util.ByteOps;
import com.adobe.internal.pdf.cos.util.ByteStream;
import com.adobe.internal.pdf.cos.util.OutputByteBuffer;
import com.adobe.internal.pdf.cos.util.exceptions.PDFEncodingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class Utility {
    private static String xfdfNS = "http://ns.adobe.com/xfdf/";

    public static ByteStream toByteStreamASCII(String string) {
        ByteStream byteStream;
        try {
            byteStream = new ByteStream(new ByteArrayByteRepository(string.getBytes("ASCII")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PDFEncodingException(unsupportedEncodingException.getMessage());
        }
        return byteStream;
    }

    public static boolean approximateMatch(double d, double d2) {
        return Math.abs(d - d2) < 1.0E-5;
    }

    public static boolean equals(InputStream inputStream, InputStream inputStream2, boolean bl) throws IOException {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        if (bl && System.getProperty("line.separator").equals("\r\n")) {
            bl2 = true;
        }
        int n3 = 0;
        do {
            if ((n2 = inputStream.read()) == 13 && bl2) {
                n2 = inputStream.read();
                ++n3;
            }
            if ((n = inputStream2.read()) == 13 && bl2) {
                n = inputStream2.read();
            }
            stringBuffer.append((char)n2);
            ++n3;
        } while (n2 == n && n2 != -1);
        if (n2 != n) {
            int n4 = Math.max(0, stringBuffer.length() - 33);
            int n5 = Math.max(0, stringBuffer.length() - 1);
            char[] cArray = new char[n5 - n4];
            stringBuffer.getChars(n4, n5, cArray, 0);
            String string = new String(cArray);
            System.out.println("TestUtil.equals failed. Common =" + string + " next char from a = " + n2 + " next char from b = " + n + " position = " + (n3 - 1));
        }
        return n2 == n;
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static String toString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append((char)byArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String toHexString(byte n) {
        StringBuffer stringBuffer = new StringBuffer(2);
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        if (n2 < 16) {
            stringBuffer.append('0');
        }
        stringBuffer.append(Integer.toHexString(n2).toUpperCase());
        return stringBuffer.toString();
    }

    public static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(Utility.toHexString(byArray[i]));
        }
        return stringBuffer.toString();
    }

    public static byte fromHexStr(String string) {
        return (byte)Integer.parseInt(string, 16);
    }

    public static byte[] fromHexString(String string) {
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        for (int i = 0; i < string.length(); i += 2) {
            while (i < string.length() && string.charAt(i) < ' ') {
                ++i;
            }
            if (i >= string.length()) break;
            byArray[n++] = Utility.fromHexStr(string.substring(i, i + 2));
        }
        if (n < byArray.length) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            return byArray2;
        }
        return byArray;
    }

    public static ArrayList parseNumbers(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        while (stringTokenizer.hasMoreTokens()) {
            StringBuffer stringBuffer = new StringBuffer(stringTokenizer.nextToken());
            int n = 0;
            while (n < stringBuffer.length()) {
                if (!ByteOps.isWhitespace(stringBuffer.charAt(n))) {
                    ++n;
                    continue;
                }
                stringBuffer.delete(n, n + 1);
            }
            arrayList.add(new Double(stringBuffer.toString()));
        }
        return arrayList.size() == 0 ? null : arrayList;
    }

    public static void transformToXML(XMLReader xMLReader, InputStream inputStream, OutputStream outputStream) throws SAXException, TransformerConfigurationException, TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        InputSource inputSource = inputStream == null ? new InputSource() : new InputSource(inputStream);
        SAXSource sAXSource = new SAXSource(xMLReader, inputSource);
        StreamResult streamResult = new StreamResult(outputStream);
        transformer.transform(sAXSource, streamResult);
    }

    public static AttributesImpl createXFDFAttributes() {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "xmlns", "xmlns", "string", xfdfNS);
        attributesImpl.addAttribute("", "xml:space", "xml:space", "string", "preserve");
        return attributesImpl;
    }

    public static int findStringInArray(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return i;
        }
        return -1;
    }

    public static String substituteStringFromArray(String string, String[] stringArray, String[] stringArray2) {
        int n = Utility.findStringInArray(string, stringArray);
        return n == -1 ? null : stringArray2[n];
    }

    public static String makeNumbersString(double[] dArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        for (int i = 0; i < dArray.length; ++i) {
            stringBuffer.append(string2);
            stringBuffer.append(dArray[i]);
            string2 = string;
        }
        return stringBuffer.toString();
    }

    public static int[] ComputeKMPNextArray(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        int[] nArray = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = -2;
        }
        n = -1;
        int n3 = 0;
        nArray[0] = -1;
        do {
            if (n == -1 || byArray[n] == byArray[n3]) {
                ++n;
                if (++n3 >= n2) continue;
                if (byArray[n] == byArray[n3]) {
                    nArray[n3] = nArray[n];
                    continue;
                }
                nArray[n3] = n;
                continue;
            }
            n = nArray[n];
        } while (n3 < n2);
        return nArray;
    }

    public static int KMPFindFirst(byte[] byArray, int[] nArray, byte[] byArray2) {
        int n = byArray.length;
        int n2 = byArray2.length;
        int n3 = 0;
        int n4 = 0;
        do {
            if (n3 == -1 || byArray[n3] == byArray2[n4]) {
                if (++n3 == n) {
                    return n4 + 1 - n;
                }
                ++n4;
                continue;
            }
            n3 = nArray[n3];
        } while (n4 < n2);
        return -1;
    }

    public static long KMPFindFirst(byte[] byArray, int[] nArray, ByteStream byteStream) {
        int n = byArray.length;
        int n2 = 0;
        byte by = byteStream.get();
        while (true) {
            if (n2 == -1 || byArray[n2] == by) {
                if (++n2 == n) {
                    return byteStream.getPosition() - (long)n;
                }
                if (byteStream.eof()) {
                    return -1L;
                }
                by = byteStream.get();
                continue;
            }
            n2 = nArray[n2];
        }
    }

    public static String exceptionStackTrace(Exception exception) {
        OutputByteBuffer outputByteBuffer = new OutputByteBuffer();
        PrintStream printStream = new PrintStream(outputByteBuffer);
        exception.printStackTrace(printStream);
        int n = (int)outputByteBuffer.getLength();
        byte[] byArray = new byte[n];
        outputByteBuffer.getBytes(0L, n, byArray);
        return new String(byArray);
    }
}

