/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util;

import com.adobe.internal.pdf.cos.util.ByteRepository;
import com.adobe.internal.pdf.cos.util.exceptions.PDFIOException;
import java.io.IOException;
import java.io.InputStream;

public class StreamByteRepository
extends ByteRepository {
    private InputStream mStream;
    private int mNextChunkToRead;

    public StreamByteRepository(InputStream inputStream, long l) {
        this.mStream = inputStream;
        this.mCurrentLength = this.mOriginalLength = l;
        this.mNextChunkToRead = 0;
        this.mChunks = new byte[(int)(l / 4096L) + 2][];
    }

    public StreamByteRepository(InputStream inputStream) {
        this.mStream = inputStream;
        this.mCurrentLength = 0L;
        this.mChunks = new byte[10][];
        this.mNextChunkToRead = 0;
        int n = 0;
        while (true) {
            this.createChunk(n);
            int n2 = this.readChunk(n);
            this.mCurrentLength += (long)n2;
            if (n2 < 4096) break;
            ++n;
        }
        this.mOriginalLength = this.mCurrentLength;
    }

    protected int readChunk(int n) {
        int n2 = 0;
        long l = n * 4096;
        while (this.mNextChunkToRead <= n) {
            n2 = 0;
            byte[] byArray = this.mChunks[n];
            if (byArray == null) {
                byArray = this.createChunk(n);
            }
            while (n2 < 4096) {
                int n3;
                try {
                    n3 = this.mStream.read(byArray, n2, 4096 - n2);
                }
                catch (IOException iOException) {
                    throw new PDFIOException(iOException.getMessage());
                }
                if (n3 < 0) break;
                n2 += n3;
            }
            ++this.mNextChunkToRead;
        }
        return n2;
    }
}

