/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util;

import com.adobe.internal.pdf.cos.util.ASDictionary;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.CourierBoldOblique_FDCreator;
import com.adobe.internal.pdf.cos.util.CourierBold_FDCreator;
import com.adobe.internal.pdf.cos.util.CourierOblique_FDCreator;
import com.adobe.internal.pdf.cos.util.Courier_FDCreator;
import com.adobe.internal.pdf.cos.util.FDCreator;
import com.adobe.internal.pdf.cos.util.HelveticaBoldOblique_FDCreator;
import com.adobe.internal.pdf.cos.util.HelveticaBold_FDCreator;
import com.adobe.internal.pdf.cos.util.HelveticaOblique_FDCreator;
import com.adobe.internal.pdf.cos.util.Helvetica_FDCreator;
import com.adobe.internal.pdf.cos.util.Symbol_FDCreator;
import com.adobe.internal.pdf.cos.util.TimesBoldItalic_FDCreator;
import com.adobe.internal.pdf.cos.util.TimesBold_FDCreator;
import com.adobe.internal.pdf.cos.util.TimesItalic_FDCreator;
import com.adobe.internal.pdf.cos.util.TimesRoman_FDCreator;
import com.adobe.internal.pdf.cos.util.ZapfDingbats_FDCreator;
import com.adobe.internal.pdf.cos.util.exceptions.PDFFontException;
import java.util.HashMap;

public class PDFStandardFontDescriptors {
    private static HashMap creators = new HashMap();
    private static ASDictionary descriptors;
    private ASDictionary fdHelvetica;
    private ASDictionary fdHelveticaOblique;
    private ASDictionary fdHelveticaBold;
    private ASDictionary fdHelveticaBoldOblique;
    private ASDictionary fdTimesRoman;
    private ASDictionary fdTimesItalic;
    private ASDictionary fdTimesBold;
    private ASDictionary fdTimesBoldItalic;
    private ASDictionary fdCourier;
    private ASDictionary fdCourierOblique;
    private ASDictionary fdCourierBold;
    private ASDictionary fdCourierBoldOblique;
    private ASDictionary fdSymbol;
    private ASDictionary fdZapfDingbats;

    private PDFStandardFontDescriptors() {
    }

    public static ASDictionary get(ASName aSName) {
        if (!descriptors.containsKey(aSName)) {
            descriptors.put(aSName, PDFStandardFontDescriptors.create(aSName));
        }
        return descriptors.getDictionary(aSName);
    }

    private static ASDictionary create(ASName aSName) {
        if (creators.containsKey(aSName)) {
            return ((FDCreator)creators.get(aSName)).create(aSName);
        }
        throw new PDFFontException("font name does not correspond to a standard 14 font");
    }

    static {
        creators.put(ASName.k_Helvetica, new Helvetica_FDCreator());
        creators.put(ASName.k_Helvetica_Oblique, new HelveticaOblique_FDCreator());
        creators.put(ASName.k_Helvetica_Bold, new HelveticaBold_FDCreator());
        creators.put(ASName.k_Helvetica_BoldOblique, new HelveticaBoldOblique_FDCreator());
        creators.put(ASName.k_Times_Roman, new TimesRoman_FDCreator());
        creators.put(ASName.k_Times_Italic, new TimesItalic_FDCreator());
        creators.put(ASName.k_Times_Bold, new TimesBold_FDCreator());
        creators.put(ASName.k_Times_BoldItalic, new TimesBoldItalic_FDCreator());
        creators.put(ASName.k_Courier, new Courier_FDCreator());
        creators.put(ASName.k_Courier_Oblique, new CourierOblique_FDCreator());
        creators.put(ASName.k_Courier_Bold, new CourierBold_FDCreator());
        creators.put(ASName.k_Courier_BoldOblique, new CourierBoldOblique_FDCreator());
        creators.put(ASName.k_Symbol, new Symbol_FDCreator());
        creators.put(ASName.k_ZapfDingbats, new ZapfDingbats_FDCreator());
        descriptors = new ASDictionary();
    }
}

