/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util;

import com.adobe.internal.pdf.cos.util.ByteOps;
import com.adobe.internal.pdf.cos.util.exceptions.PDFEncodingException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public abstract class PDFDocEncoding {
    private static final Charset utf8 = Charset.forName("UTF8");
    private static char[] toUnicodeMap = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\t', '\n', '\u0000', '\u0000', '\r', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u2022', '\u2020', '\u2021', '\u2026', '\u2014', '\u2013', '\u0192', '\u2044', '\u2039', '\u203a', '\u2212', '\u2030', '\u201e', '\u201c', '\u201d', '\u2018', '\u2019', '\u201a', '\u2122', '\u0000', '\u0000', '\u0141', '\u0152', '\u0160', '\u0178', '\u017d', '\u0131', '\u0142', '\u0153', '\u0161', '\u017e', '\u0000', '\u20ac', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};
    private static char[] fromUnicodeMap = new char[]{'\u0131', '\u009a', '\u0141', '\u0095', '\u0142', '\u009b', '\u0152', '\u0096', '\u0153', '\u009c', '\u0160', '\u0097', '\u0161', '\u009d', '\u0178', '\u0098', '\u017d', '\u0099', '\u017e', '\u009e', '\u0192', '\u0086', '\u02c6', '\u001a', '\u02c7', '\u0019', '\u02d8', '\u0018', '\u02d9', '\u001b', '\u02da', '\u001e', '\u02db', '\u001d', '\u02dc', '\u001f', '\u02dd', '\u001c', '\u2013', '\u0085', '\u2014', '\u0084', '\u2018', '\u008f', '\u2019', '\u0090', '\u201a', '\u0091', '\u201c', '\u008d', '\u201d', '\u008e', '\u201e', '\u008c', '\u2020', '\u0081', '\u2021', '\u0082', '\u2022', '\u0080', '\u2026', '\u0083', '\u2030', '\u008b', '\u2039', '\u0088', '\u203a', '\u0089', '\u2044', '\u0087', '\u20ac', '\u00a0', '\u2122', '\u0092', '\u2212', '\u008a'};
    private static final char ESCAPE_START = '\\';
    private static final char DEFAULT_CHARACTER = '.';

    public static String toAcrobatString(byte[] byArray) {
        return PDFDocEncoding.toAcrobatString(byArray, 0, byArray.length);
    }

    public static String toAcrobatString(byte[] byArray, int n, int n2) {
        CharSequence charSequence;
        if (n2 < 1 || byArray == null) {
            return null;
        }
        Exception exception = null;
        try {
            if (byArray[n] == -2 && byArray[n + 1] == -1 && (charSequence = new String(byArray, n, n2, "UTF-16BE")) != null) {
                return charSequence;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            exception = unsupportedEncodingException;
        }
        try {
            charSequence = new StringBuffer(byArray.length);
            for (int i = n; i < n2; ++i) {
                charSequence.append(PDFDocEncoding.toUnicodeChar(byArray[i], false));
            }
            return charSequence.toString();
        }
        catch (Exception exception2) {
            exception = exception2;
            return PDFDocEncoding.toEscapeString(byArray, n, n2);
        }
    }

    public static String toUnicodeString(byte[] byArray) {
        return PDFDocEncoding.toUnicodeString(byArray, 0, byArray.length);
    }

    public static String toUnicodeString(byte[] byArray, int n, int n2) {
        if (n2 > 0 && byArray != null) {
            if (n2 > 2 && byArray[n] == -2 && byArray[n + 1] == -1) {
                try {
                    return new String(byArray, n, n2, "UTF16");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new PDFEncodingException("Platform does not support UTF-16");
                }
            }
            StringBuffer stringBuffer = new StringBuffer(byArray.length);
            for (int i = n; i < n2; ++i) {
                stringBuffer.append(PDFDocEncoding.toUnicodeChar(byArray[i], true));
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public static byte[] toUTF8(String string) {
        int n;
        byte[] byArray = utf8.encode(string).array();
        for (n = byArray.length; n > 0 && byArray[n - 1] == 0; --n) {
        }
        if (byArray.length == n) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public static String toEscapeString(byte[] byArray) {
        return PDFDocEncoding.toEscapeString(byArray, 0, byArray.length);
    }

    public static String toEscapeString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        int n3 = n + n2;
        while (n < n3) {
            int n4;
            if ((n4 = byArray[n++]) < 0) {
                n4 += 256;
            }
            if (n4 < 32 && !ByteOps.isWhitespace((char)n4)) {
                stringBuffer.append('\\');
                stringBuffer.append(Integer.toOctalString(n4));
                continue;
            }
            stringBuffer.append((char)n4);
        }
        return stringBuffer.toString();
    }

    static boolean isEscapeChar(String string, int n) {
        if (string.length() < n + 3) {
            return false;
        }
        return string.charAt(n) == '\\' && Character.isDigit(string.charAt(n + 1)) && Character.isDigit(string.charAt(n + 2)) && Character.isDigit(string.charAt(n + 3));
    }

    static int getEscapeChar(String string, int n) {
        return Integer.parseInt(string.substring(n + 1, n + 3), 8);
    }

    public static byte[] fromEscapeString(String string) {
        int n;
        byte[] byArray = new byte[string.length()];
        int n2 = 0;
        for (n = 0; n < string.length(); ++n) {
            if (PDFDocEncoding.isEscapeChar(string, n)) {
                byArray[n2++] = (byte)PDFDocEncoding.getEscapeChar(string, n);
                n += 3;
                continue;
            }
            byArray[n2++] = (byte)string.charAt(n);
        }
        if (n2 < byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        for (n = 0; n < n2; ++n) {
            byArray2[n] = byArray[n];
        }
        return byArray2;
    }

    public static byte[] fromUnicodeString(String string) {
        if (PDFDocEncoding.isUnicode(string)) {
            int n = 0;
            int n2 = string.length() * 2 + 2;
            byte[] byArray = new byte[n2];
            byArray[n++] = -2;
            byArray[n++] = -1;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                byArray[n++] = (byte)(c >> 8);
                byArray[n++] = (byte)c;
            }
            return byArray;
        }
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            byte by = PDFDocEncoding.getPDFValue(string.charAt(i));
            if (by <= 0) continue;
            byArray[i] = by;
        }
        return byArray;
    }

    static char toUnicodeChar(byte n, boolean bl) {
        char c = '\u0000';
        int n2 = n;
        if (n < 0) {
            n2 += 256;
        }
        if ((c = toUnicodeMap[n2]) == '\u0000') {
            if (bl) {
                return '.';
            }
            throw new PDFEncodingException("Unrecognizable character in the PDF text object");
        }
        return c;
    }

    private static byte getPDFValue(char c) {
        if (c < '\u0100') {
            return (byte)c;
        }
        int n = PDFDocEncoding.findPDFValue(c);
        if (n >= 0) {
            return (byte)fromUnicodeMap[n + 1];
        }
        return 0;
    }

    public static boolean isUnicode(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) <= '\u00ff' || PDFDocEncoding.findPDFValue(string.charAt(i)) >= 0) continue;
            return true;
        }
        return false;
    }

    private static int findPDFValue(char c) {
        int n = 0;
        int n2 = fromUnicodeMap.length / 2;
        while (n2 > n) {
            int n3 = n + (n2 - n) / 2;
            int n4 = c - fromUnicodeMap[n3 * 2];
            if (n4 > 0) {
                n = n3 + 1;
            } else {
                n2 = n3;
            }
            if (n4 != 0) continue;
            return n3 * 2;
        }
        return -1;
    }
}

