/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util;

import com.adobe.internal.pdf.cos.util.ByteBuffer;
import com.adobe.internal.pdf.cos.util.CleanByteRepository;
import com.adobe.internal.pdf.cos.util.DataAccess;
import java.io.IOException;
import java.io.OutputStream;

public class OutputByteBuffer
extends OutputStream
implements DataAccess {
    private ByteBuffer mBuf;

    public OutputByteBuffer(ByteBuffer byteBuffer) {
        this.mBuf = byteBuffer;
    }

    public OutputByteBuffer() {
        this.mBuf = new ByteBuffer(new CleanByteRepository());
    }

    public void write(int n) throws IOException {
        try {
            this.mBuf.appendByte((byte)n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException();
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            for (int i = n; i < n + n2; ++i) {
                this.mBuf.appendByte(byArray[i]);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException();
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public long getLength() {
        return this.mBuf.getLength();
    }

    public long getBytes(long l, long l2, byte[] byArray) {
        return this.mBuf.getBytes(l, l2, byArray);
    }

    public ByteBuffer getBuffer() {
        return this.mBuf;
    }
}

