/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util;

import com.adobe.internal.pdf.cos.util.ByteBuffer;
import com.adobe.internal.pdf.cos.util.ByteRepository;
import com.adobe.internal.pdf.cos.util.StreamByteRepository;
import com.adobe.internal.pdf.cos.util.Utility;
import java.io.InputStream;

public class ByteStream
extends InputStream {
    private ByteBuffer mBuf;
    private byte[] mCurChunk;
    private int mBytesRemainingInChunk;
    private int mCurChunkIndex;
    private long mPos;

    public ByteStream(ByteBuffer byteBuffer) {
        this.init(byteBuffer);
    }

    public void init(ByteBuffer byteBuffer) {
        this.mBuf = byteBuffer;
        this.mPos = 0L;
        this.mCurChunk = null;
        this.mCurChunkIndex = 0;
        this.mBytesRemainingInChunk = 0;
    }

    public ByteStream(ByteRepository byteRepository) {
        this(new ByteBuffer(byteRepository));
    }

    public ByteStream(InputStream inputStream) {
        if (inputStream instanceof ByteStream) {
            ByteStream byteStream = (ByteStream)inputStream;
            ByteBuffer byteBuffer = byteStream.mBuf;
            if (byteStream.mPos != 0L) {
                byteBuffer = new ByteBuffer(byteBuffer, byteStream.mPos, byteBuffer.mLength - byteStream.mPos);
            }
            this.init(byteBuffer);
        } else {
            this.init(new ByteBuffer(new StreamByteRepository(inputStream)));
        }
    }

    public ByteStream(ByteStream byteStream, long l) {
        this.mBuf = byteStream.mBuf;
        this.mPos = byteStream.mPos;
        this.mCurChunk = byteStream.mCurChunk;
        this.mCurChunkIndex = byteStream.mCurChunkIndex;
        this.mBytesRemainingInChunk = byteStream.mBytesRemainingInChunk;
        this.setPosition(l);
    }

    public ByteStream slice(long l, long l2) {
        if (l < 0L || l2 < 0L || l + l2 > this.mBuf.mLength) {
            throw new IndexOutOfBoundsException("invalid slice of Bytestream");
        }
        ByteBuffer byteBuffer = new ByteBuffer(this.mBuf, l, l2);
        return new ByteStream(byteBuffer);
    }

    public byte get() {
        if (this.mBytesRemainingInChunk == 0) {
            if (this.mPos >= this.mBuf.mLength) {
                this.mCurChunk = null;
                ++this.mPos;
                return 0;
            }
            long l = this.mPos + this.mBuf.mOffset;
            this.mCurChunk = this.mBuf.mRep.getChunk(l);
            this.mCurChunkIndex = (int)l % 4096;
            this.mBytesRemainingInChunk = (int)Math.min((long)(4096 - this.mCurChunkIndex), this.mBuf.mLength - this.mPos);
        }
        ++this.mPos;
        --this.mBytesRemainingInChunk;
        return this.mCurChunk[this.mCurChunkIndex++];
    }

    public void get(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || this.mPos + (long)n2 > this.mBuf.mLength) {
            throw new IndexOutOfBoundsException("block read beyond end of ByteSource");
        }
        this.mBuf.getBytes(this.mPos, n2, byArray, n);
        this.mPos += (long)n2;
        this.mBytesRemainingInChunk = 0;
        this.mCurChunk = null;
    }

    public void unget() {
        if (this.mCurChunk != null) {
            --this.mCurChunkIndex;
            if (this.mCurChunkIndex < 0) {
                this.mCurChunk = null;
                this.mBytesRemainingInChunk = 0;
            } else {
                ++this.mBytesRemainingInChunk;
            }
        }
        --this.mPos;
        if (this.mPos < 0L) {
            throw new IndexOutOfBoundsException("unget ByteStream at pos==0");
        }
    }

    public ByteStream setPosition(long l) {
        if (l > this.mBuf.mLength) {
            throw new IndexOutOfBoundsException("positioning ByteSource off end");
        }
        long l2 = l - this.mPos;
        if (this.mCurChunk != null && l2 >= (long)(-this.mCurChunkIndex) && l2 < (long)this.mBytesRemainingInChunk) {
            this.mCurChunkIndex = (int)((long)this.mCurChunkIndex + l2);
            this.mBytesRemainingInChunk = (int)((long)this.mBytesRemainingInChunk - l2);
        } else {
            this.mBytesRemainingInChunk = 0;
            this.mCurChunk = null;
        }
        this.mPos = l;
        return this;
    }

    public long getPosition() {
        return this.mPos;
    }

    public boolean exists(byte[] byArray, long l) {
        ByteStream byteStream = this.slice(0L, l = Math.min(l, this.limit()));
        return byteStream.indexOf(byArray) >= 0L;
    }

    public long indexOf(byte[] byArray) {
        int[] nArray = Utility.ComputeKMPNextArray(byArray);
        return Utility.KMPFindFirst(byArray, nArray, this);
    }

    public long limit() {
        return this.mBuf.mLength;
    }

    public long bytesAvailable() {
        return this.mBuf.mLength - this.mPos;
    }

    public boolean eof() {
        return this.mPos >= this.mBuf.mLength;
    }

    public ByteBuffer getByteBuffer() {
        return this.mBuf;
    }

    public int available() {
        return (int)this.bytesAvailable();
    }

    public int read() {
        int n = -1;
        if (!this.eof() && (n = (int)this.get()) < 0) {
            n += 256;
        }
        return n;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) {
        int n3 = -1;
        if (!this.eof()) {
            n3 = Math.min(n2, this.available());
            this.get(byArray, n, n3);
        }
        return n3;
    }
}

