/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util;

public abstract class ByteRepository {
    public static final int CHUNKSIZE = 4096;
    protected byte[][] mChunks;
    protected long mOriginalLength;
    protected long mCurrentLength;

    protected abstract int readChunk(int var1);

    public void appendByte(byte by) {
        int n = (int)this.mCurrentLength / 4096;
        byte[] byArray = this.getChunk(this.mCurrentLength);
        int n2 = (int)this.mCurrentLength % 4096;
        byArray[n2] = by;
        ++this.mCurrentLength;
    }

    protected byte[] createChunk(int n) {
        if (n >= this.mChunks.length) {
            int n2 = Math.max(10, n + 1);
            n2 = Math.max(n2, this.mChunks.length * 3 / 2);
            byte[][] byArrayArray = new byte[n2][];
            for (int i = 0; i < this.mChunks.length; ++i) {
                byArrayArray[i] = this.mChunks[i];
            }
            this.mChunks = byArrayArray;
        }
        this.mChunks[n] = new byte[4096];
        return this.mChunks[n];
    }

    public byte[] getChunk(long l) {
        byte[] byArray;
        int n = (int)(l / 4096L);
        if (n < this.mChunks.length && this.mChunks[n] != null) {
            byArray = this.mChunks[n];
        } else {
            byArray = this.createChunk(n);
            if ((long)(n * 4096) < this.mOriginalLength) {
                this.readChunk(n);
            }
        }
        return byArray;
    }

    public long getLength() {
        return this.mCurrentLength;
    }
}

