/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util;

import com.adobe.internal.pdf.cos.util.ByteRepository;
import com.adobe.internal.pdf.cos.util.DataAccess;

public class ByteBuffer
implements DataAccess {
    protected ByteRepository mRep;
    protected long mOffset;
    protected long mLength;

    public ByteBuffer(ByteRepository byteRepository) {
        this.mRep = byteRepository;
        this.mOffset = 0L;
        this.mLength = byteRepository.getLength();
    }

    public ByteBuffer(ByteRepository byteRepository, long l, long l2) {
        if (l + l2 > byteRepository.getLength()) {
            throw new IndexOutOfBoundsException("slice extends beyond underlying data");
        }
        this.mRep = byteRepository;
        this.mOffset = l;
        this.mLength = l2;
    }

    public ByteBuffer(ByteBuffer byteBuffer, long l, long l2) {
        if (l + l2 > byteBuffer.mLength) {
            throw new IndexOutOfBoundsException("slice extends beyond underlying data");
        }
        this.mRep = byteBuffer.mRep;
        this.mOffset = byteBuffer.mOffset + l;
        this.mLength = l2;
    }

    public long getLength() {
        return this.mLength;
    }

    public long getBytes(long l, long l2, byte[] byArray) {
        return this.getBytes(l, l2, byArray, 0);
    }

    public long getBytes(long l, long l2, byte[] byArray, int n) {
        long l3 = Math.min(l2, this.mLength - l);
        if (l3 <= 0L) {
            return 0L;
        }
        long l4 = l3;
        long l5 = l + this.mOffset;
        int n2 = n;
        while (l3 > 0L) {
            byte[] byArray2 = this.mRep.getChunk(l5);
            int n3 = (int)(l5 % 4096L);
            int n4 = 4096 - n3;
            if ((long)n4 < l3) {
                l3 -= (long)n4;
                l5 += (long)n4;
                while (n4 > 0) {
                    byArray[n2++] = byArray2[n3++];
                    --n4;
                }
                continue;
            }
            while (l3 > 0L) {
                byArray[n2++] = byArray2[n3++];
                --l3;
            }
        }
        return l4;
    }

    public void appendByte(byte by) {
        if (this.mOffset + this.mLength != this.mRep.getLength()) {
            throw new IndexOutOfBoundsException("cannot append to middle of repository");
        }
        this.mRep.appendByte(by);
        ++this.mLength;
    }
}

