/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util;

import com.adobe.internal.pdf.cos.util.ASName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AdobeGlyphList {
    private static AdobeGlyphList glyphList;
    private HashMap toUnicodeMap = new HashMap();

    private AdobeGlyphList() {
        AdobeGlyphList.initList1(this.toUnicodeMap);
        AdobeGlyphList.initList2(this.toUnicodeMap);
    }

    public static AdobeGlyphList get() {
        if (glyphList == null) {
            glyphList = new AdobeGlyphList();
        }
        return glyphList;
    }

    public char[] toUnicode(ASName aSName) {
        char[] cArray;
        if (this.toUnicodeMap.containsKey(aSName)) {
            String string = (String)this.toUnicodeMap.get(aSName);
            int n = string.length() / 4;
            cArray = new char[n];
            for (int i = 0; i < n; i += 4) {
                String string2 = string.substring(i, i + 4);
                Integer n2 = Integer.valueOf(string2, 16);
                cArray[i] = (char)n2.intValue();
            }
        } else {
            cArray = new char[]{'\ufffd'};
        }
        return cArray;
    }

    public ASName[] fromUnicode(char c) {
        Object object;
        ArrayList<ASName> arrayList = new ArrayList<ASName>();
        String string = Integer.toString(c, 16);
        while (string.length() < 4) {
            string = "0" + string;
        }
        Set set = this.toUnicodeMap.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            object = (String)entry.getValue();
            if (!((String)object).equals(string)) continue;
            ASName aSName = (ASName)entry.getKey();
            arrayList.add(aSName);
        }
        int n = arrayList.size();
        object = new ASName[n];
        for (int i = 0; i < n; ++i) {
            object[i] = (ASName)arrayList.get(i);
        }
        return object;
    }

    private static void initList1(HashMap hashMap) {
        hashMap.put(ASName.create("0"), "0030");
        hashMap.put(ASName.create("1"), "0031");
        hashMap.put(ASName.create("2"), "0032");
        hashMap.put(ASName.create("3"), "0033");
        hashMap.put(ASName.create("4"), "0034");
        hashMap.put(ASName.create("5"), "0035");
        hashMap.put(ASName.create("6"), "0036");
        hashMap.put(ASName.create("7"), "0037");
        hashMap.put(ASName.create("8"), "0038");
        hashMap.put(ASName.create("9"), "0039");
        hashMap.put(ASName.create("AE"), "00C6");
        hashMap.put(ASName.create("AEacute"), "01FC");
        hashMap.put(ASName.create("AEmacron"), "01E2");
        hashMap.put(ASName.create("AEsmall"), "F7E6");
        hashMap.put(ASName.create("Aacute"), "00C1");
        hashMap.put(ASName.create("Aacutesmall"), "F7E1");
        hashMap.put(ASName.create("Abreve"), "0102");
        hashMap.put(ASName.create("Abreveacute"), "1EAE");
        hashMap.put(ASName.create("Abrevecyrillic"), "04D0");
        hashMap.put(ASName.create("Abrevedotbelow"), "1EB6");
        hashMap.put(ASName.create("Abrevegrave"), "1EB0");
        hashMap.put(ASName.create("Abrevehookabove"), "1EB2");
        hashMap.put(ASName.create("Abrevetilde"), "1EB4");
        hashMap.put(ASName.create("Acaron"), "01CD");
        hashMap.put(ASName.create("Acircle"), "24B6");
        hashMap.put(ASName.create("Acircumflex"), "00C2");
        hashMap.put(ASName.create("Acircumflexacute"), "1EA4");
        hashMap.put(ASName.create("Acircumflexdotbelow"), "1EAC");
        hashMap.put(ASName.create("Acircumflexgrave"), "1EA6");
        hashMap.put(ASName.create("Acircumflexhookabove"), "1EA8");
        hashMap.put(ASName.create("Acircumflexsmall"), "F7E2");
        hashMap.put(ASName.create("Acircumflextilde"), "1EAA");
        hashMap.put(ASName.create("Acute"), "F6C9");
        hashMap.put(ASName.create("Acutesmall"), "F7B4");
        hashMap.put(ASName.create("Acyrillic"), "0410");
        hashMap.put(ASName.create("Adblgrave"), "0200");
        hashMap.put(ASName.create("Adieresis"), "00C4");
        hashMap.put(ASName.create("Adieresiscyrillic"), "04D2");
        hashMap.put(ASName.create("Adieresismacron"), "01DE");
        hashMap.put(ASName.create("Adieresissmall"), "F7E4");
        hashMap.put(ASName.create("Adotbelow"), "1EA0");
        hashMap.put(ASName.create("Adotmacron"), "01E0");
        hashMap.put(ASName.create("Agrave"), "00C0");
        hashMap.put(ASName.create("Agravesmall"), "F7E0");
        hashMap.put(ASName.create("Ahookabove"), "1EA2");
        hashMap.put(ASName.create("Aiecyrillic"), "04D4");
        hashMap.put(ASName.create("Ainvertedbreve"), "0202");
        hashMap.put(ASName.create("Alpha"), "0391");
        hashMap.put(ASName.create("Alphatonos"), "0386");
        hashMap.put(ASName.create("Amacron"), "0100");
        hashMap.put(ASName.create("Amonospace"), "FF21");
        hashMap.put(ASName.create("Aogonek"), "0104");
        hashMap.put(ASName.create("Aring"), "00C5");
        hashMap.put(ASName.create("Aringacute"), "01FA");
        hashMap.put(ASName.create("Aringbelow"), "1E00");
        hashMap.put(ASName.create("Aringsmall"), "F7E5");
        hashMap.put(ASName.create("Asmall"), "F761");
        hashMap.put(ASName.create("Atilde"), "00C3");
        hashMap.put(ASName.create("Atildesmall"), "F7E3");
        hashMap.put(ASName.create("Aybarmenian"), "0531");
        hashMap.put(ASName.create("B"), "0042");
        hashMap.put(ASName.create("Bcircle"), "24B7");
        hashMap.put(ASName.create("Bdotaccent"), "1E02");
        hashMap.put(ASName.create("Bdotbelow"), "1E04");
        hashMap.put(ASName.create("Becyrillic"), "0411");
        hashMap.put(ASName.create("Benarmenian"), "0532");
        hashMap.put(ASName.create("Beta"), "0392");
        hashMap.put(ASName.create("Bhook"), "0181");
        hashMap.put(ASName.create("Blinebelow"), "1E06");
        hashMap.put(ASName.create("Bmonospace"), "FF22");
        hashMap.put(ASName.create("Brevesmall"), "F6F4");
        hashMap.put(ASName.create("Bsmall"), "F762");
        hashMap.put(ASName.create("Btopbar"), "0182");
        hashMap.put(ASName.create("C"), "0043");
        hashMap.put(ASName.create("Caarmenian"), "053E");
        hashMap.put(ASName.create("Cacute"), "0106");
        hashMap.put(ASName.create("Caron"), "F6CA");
        hashMap.put(ASName.create("Caronsmall"), "F6F5");
        hashMap.put(ASName.create("Ccaron"), "010C");
        hashMap.put(ASName.create("Ccedilla"), "00C7");
        hashMap.put(ASName.create("Ccedillaacute"), "1E08");
        hashMap.put(ASName.create("Ccedillasmall"), "F7E7");
        hashMap.put(ASName.create("Ccircle"), "24B8");
        hashMap.put(ASName.create("Ccircumflex"), "0108");
        hashMap.put(ASName.create("Cdot"), "010A");
        hashMap.put(ASName.create("Cdotaccent"), "010A");
        hashMap.put(ASName.create("Cedillasmall"), "F7B8");
        hashMap.put(ASName.create("Chaarmenian"), "0549");
        hashMap.put(ASName.create("Cheabkhasiancyrillic"), "04BC");
        hashMap.put(ASName.create("Checyrillic"), "0427");
        hashMap.put(ASName.create("Chedescenderabkhasiancyrillic"), "04BE");
        hashMap.put(ASName.create("Chedescendercyrillic"), "04B6");
        hashMap.put(ASName.create("Chedieresiscyrillic"), "04F4");
        hashMap.put(ASName.create("Cheharmenian"), "0543");
        hashMap.put(ASName.create("Chekhakassiancyrillic"), "04CB");
        hashMap.put(ASName.create("Cheverticalstrokecyrillic"), "04B8");
        hashMap.put(ASName.create("Chi"), "03A7");
        hashMap.put(ASName.create("Chook"), "0187");
        hashMap.put(ASName.create("Circumflexsmall"), "F6F6");
        hashMap.put(ASName.create("Cmonospace"), "FF23");
        hashMap.put(ASName.create("Coarmenian"), "0551");
        hashMap.put(ASName.create("Csmall"), "F763");
        hashMap.put(ASName.create("D"), "0044");
        hashMap.put(ASName.create("DZ"), "01F1");
        hashMap.put(ASName.create("DZcaron"), "01C4");
        hashMap.put(ASName.create("Daarmenian"), "0534");
        hashMap.put(ASName.create("Dafrican"), "0189");
        hashMap.put(ASName.create("Dcaron"), "010E");
        hashMap.put(ASName.create("Dcedilla"), "1E10");
        hashMap.put(ASName.create("Dcircle"), "24B9");
        hashMap.put(ASName.create("Dcircumflexbelow"), "1E12");
        hashMap.put(ASName.create("Dcroat"), "0110");
        hashMap.put(ASName.create("Ddotaccent"), "1E0A");
        hashMap.put(ASName.create("Ddotbelow"), "1E0C");
        hashMap.put(ASName.create("Decyrillic"), "0414");
        hashMap.put(ASName.create("Deicoptic"), "03EE");
        hashMap.put(ASName.create("Delta"), "2206");
        hashMap.put(ASName.create("Deltagreek"), "0394");
        hashMap.put(ASName.create("Dhook"), "018A");
        hashMap.put(ASName.create("Dieresis"), "F6CB");
        hashMap.put(ASName.create("DieresisAcute"), "F6CC");
        hashMap.put(ASName.create("DieresisGrave"), "F6CD");
        hashMap.put(ASName.create("Dieresissmall"), "F7A8");
        hashMap.put(ASName.create("Digammagreek"), "03DC");
        hashMap.put(ASName.create("Djecyrillic"), "0402");
        hashMap.put(ASName.create("Dlinebelow"), "1E0E");
        hashMap.put(ASName.create("Dmonospace"), "FF24");
        hashMap.put(ASName.create("Dotaccentsmall"), "F6F7");
        hashMap.put(ASName.create("Dslash"), "0110");
        hashMap.put(ASName.create("Dsmall"), "F764");
        hashMap.put(ASName.create("Dtopbar"), "018B");
        hashMap.put(ASName.create("Dz"), "01F2");
        hashMap.put(ASName.create("Dzcaron"), "01C5");
        hashMap.put(ASName.create("Dzeabkhasiancyrillic"), "04E0");
        hashMap.put(ASName.create("Dzecyrillic"), "0405");
        hashMap.put(ASName.create("Dzhecyrillic"), "040F");
        hashMap.put(ASName.create("E"), "0045");
        hashMap.put(ASName.create("Eacute"), "00C9");
        hashMap.put(ASName.create("Eacutesmall"), "F7E9");
        hashMap.put(ASName.create("Ebreve"), "0114");
        hashMap.put(ASName.create("Ecaron"), "011A");
        hashMap.put(ASName.create("Ecedillabreve"), "1E1C");
        hashMap.put(ASName.create("Echarmenian"), "0535");
        hashMap.put(ASName.create("Ecircle"), "24BA");
        hashMap.put(ASName.create("Ecircumflex"), "00CA");
        hashMap.put(ASName.create("Ecircumflexacute"), "1EBE");
        hashMap.put(ASName.create("Ecircumflexbelow"), "1E18");
        hashMap.put(ASName.create("Ecircumflexdotbelow"), "1EC6");
        hashMap.put(ASName.create("Ecircumflexgrave"), "1EC0");
        hashMap.put(ASName.create("Ecircumflexhookabove"), "1EC2");
        hashMap.put(ASName.create("Ecircumflexsmall"), "F7EA");
        hashMap.put(ASName.create("Ecircumflextilde"), "1EC4");
        hashMap.put(ASName.create("Ecyrillic"), "0404");
        hashMap.put(ASName.create("Edblgrave"), "0204");
        hashMap.put(ASName.create("Edieresis"), "00CB");
        hashMap.put(ASName.create("Edieresissmall"), "F7EB");
        hashMap.put(ASName.create("Edot"), "0116");
        hashMap.put(ASName.create("Edotaccent"), "0116");
        hashMap.put(ASName.create("Edotbelow"), "1EB8");
        hashMap.put(ASName.create("Efcyrillic"), "0424");
        hashMap.put(ASName.create("Egrave"), "00C8");
        hashMap.put(ASName.create("Egravesmall"), "F7E8");
        hashMap.put(ASName.create("Eharmenian"), "0537");
        hashMap.put(ASName.create("Ehookabove"), "1EBA");
        hashMap.put(ASName.create("Eightroman"), "2167");
        hashMap.put(ASName.create("Einvertedbreve"), "0206");
        hashMap.put(ASName.create("Eiotifiedcyrillic"), "0464");
        hashMap.put(ASName.create("Elcyrillic"), "041B");
        hashMap.put(ASName.create("Elevenroman"), "216A");
        hashMap.put(ASName.create("Emacron"), "0112");
        hashMap.put(ASName.create("Emacronacute"), "1E16");
        hashMap.put(ASName.create("Emacrongrave"), "1E14");
        hashMap.put(ASName.create("Emcyrillic"), "041C");
        hashMap.put(ASName.create("Emonospace"), "FF25");
        hashMap.put(ASName.create("Encyrillic"), "041D");
        hashMap.put(ASName.create("Endescendercyrillic"), "04A2");
        hashMap.put(ASName.create("Eng"), "014A");
        hashMap.put(ASName.create("Enghecyrillic"), "04A4");
        hashMap.put(ASName.create("Enhookcyrillic"), "04C7");
        hashMap.put(ASName.create("Eogonek"), "0118");
        hashMap.put(ASName.create("Eopen"), "0190");
        hashMap.put(ASName.create("Epsilon"), "0395");
        hashMap.put(ASName.create("Epsilontonos"), "0388");
        hashMap.put(ASName.create("Ercyrillic"), "0420");
        hashMap.put(ASName.create("Ereversed"), "018E");
        hashMap.put(ASName.create("Ereversedcyrillic"), "042D");
        hashMap.put(ASName.create("Escyrillic"), "0421");
        hashMap.put(ASName.create("Esdescendercyrillic"), "04AA");
        hashMap.put(ASName.create("Esh"), "01A9");
        hashMap.put(ASName.create("Esmall"), "F765");
        hashMap.put(ASName.create("Eta"), "0397");
        hashMap.put(ASName.create("Etarmenian"), "0538");
        hashMap.put(ASName.create("Etatonos"), "0389");
        hashMap.put(ASName.create("Eth"), "00D0");
        hashMap.put(ASName.create("Ethsmall"), "F7F0");
        hashMap.put(ASName.create("Etilde"), "1EBC");
        hashMap.put(ASName.create("Etildebelow"), "1E1A");
        hashMap.put(ASName.create("Euro"), "20AC");
        hashMap.put(ASName.create("Ezh"), "01B7");
        hashMap.put(ASName.create("Ezhcaron"), "01EE");
        hashMap.put(ASName.create("Ezhreversed"), "01B8");
        hashMap.put(ASName.create("F"), "0046");
        hashMap.put(ASName.create("Fcircle"), "24BB");
        hashMap.put(ASName.create("Fdotaccent"), "1E1E");
        hashMap.put(ASName.create("Feharmenian"), "0556");
        hashMap.put(ASName.create("Feicoptic"), "03E4");
        hashMap.put(ASName.create("Fhook"), "0191");
        hashMap.put(ASName.create("Fitacyrillic"), "0472");
        hashMap.put(ASName.create("Fiveroman"), "2164");
        hashMap.put(ASName.create("Fmonospace"), "FF26");
        hashMap.put(ASName.create("Fourroman"), "2163");
        hashMap.put(ASName.create("Fsmall"), "F766");
        hashMap.put(ASName.create("G"), "0047");
        hashMap.put(ASName.create("GBsquare"), "3387");
        hashMap.put(ASName.create("Gacute"), "01F4");
        hashMap.put(ASName.create("Gamma"), "0393");
        hashMap.put(ASName.create("Gammaafrican"), "0194");
        hashMap.put(ASName.create("Gangiacoptic"), "03EA");
        hashMap.put(ASName.create("Gbreve"), "011E");
        hashMap.put(ASName.create("Gcaron"), "01E6");
        hashMap.put(ASName.create("Gcedilla"), "0122");
        hashMap.put(ASName.create("Gcircle"), "24BC");
        hashMap.put(ASName.create("Gcircumflex"), "011C");
        hashMap.put(ASName.create("Gcommaaccent"), "0122");
        hashMap.put(ASName.create("Gdot"), "0120");
        hashMap.put(ASName.create("Gdotaccent"), "0120");
        hashMap.put(ASName.create("Gecyrillic"), "0413");
        hashMap.put(ASName.create("Ghadarmenian"), "0542");
        hashMap.put(ASName.create("Ghemiddlehookcyrillic"), "0494");
        hashMap.put(ASName.create("Ghestrokecyrillic"), "0492");
        hashMap.put(ASName.create("Gheupturncyrillic"), "0490");
        hashMap.put(ASName.create("Ghook"), "0193");
        hashMap.put(ASName.create("Gimarmenian"), "0533");
        hashMap.put(ASName.create("Gjecyrillic"), "0403");
        hashMap.put(ASName.create("Gmacron"), "1E20");
        hashMap.put(ASName.create("Gmonospace"), "FF27");
        hashMap.put(ASName.create("Grave"), "F6CE");
        hashMap.put(ASName.create("Gravesmall"), "F760");
        hashMap.put(ASName.create("Gsmall"), "F767");
        hashMap.put(ASName.create("Gsmallhook"), "029B");
        hashMap.put(ASName.create("Gstroke"), "01E4");
        hashMap.put(ASName.create("H"), "0048");
        hashMap.put(ASName.create("H18533"), "25CF");
        hashMap.put(ASName.create("H18543"), "25AA");
        hashMap.put(ASName.create("H18551"), "25AB");
        hashMap.put(ASName.create("H22073"), "25A1");
        hashMap.put(ASName.create("HPsquare"), "33CB");
        hashMap.put(ASName.create("Haabkhasiancyrillic"), "04A8");
        hashMap.put(ASName.create("Hadescendercyrillic"), "04B2");
        hashMap.put(ASName.create("Hardsigncyrillic"), "042A");
        hashMap.put(ASName.create("Hbar"), "0126");
        hashMap.put(ASName.create("Hbrevebelow"), "1E2A");
        hashMap.put(ASName.create("Hcedilla"), "1E28");
        hashMap.put(ASName.create("Hcircle"), "24BD");
        hashMap.put(ASName.create("Hcircumflex"), "0124");
        hashMap.put(ASName.create("Hdieresis"), "1E26");
        hashMap.put(ASName.create("Hdotaccent"), "1E22");
        hashMap.put(ASName.create("Hdotbelow"), "1E24");
        hashMap.put(ASName.create("Hmonospace"), "FF28");
        hashMap.put(ASName.create("Hoarmenian"), "0540");
        hashMap.put(ASName.create("Horicoptic"), "03E8");
        hashMap.put(ASName.create("Hsmall"), "F768");
        hashMap.put(ASName.create("Hungarumlaut"), "F6CF");
        hashMap.put(ASName.create("Hungarumlautsmall"), "F6F8");
        hashMap.put(ASName.create("Hzsquare"), "3390");
        hashMap.put(ASName.create("I"), "0049");
        hashMap.put(ASName.create("IAcyrillic"), "042F");
        hashMap.put(ASName.create("IJ"), "0132");
        hashMap.put(ASName.create("IUcyrillic"), "042E");
        hashMap.put(ASName.create("Iacute"), "00CD");
        hashMap.put(ASName.create("Iacutesmall"), "F7ED");
        hashMap.put(ASName.create("Ibreve"), "012C");
        hashMap.put(ASName.create("Icaron"), "01CF");
        hashMap.put(ASName.create("Icircle"), "24BE");
        hashMap.put(ASName.create("Icircumflex"), "00CE");
        hashMap.put(ASName.create("Icircumflexsmall"), "F7EE");
        hashMap.put(ASName.create("Icyrillic"), "0406");
        hashMap.put(ASName.create("Idblgrave"), "0208");
        hashMap.put(ASName.create("Idieresis"), "00CF");
        hashMap.put(ASName.create("Idieresisacute"), "1E2E");
        hashMap.put(ASName.create("Idieresiscyrillic"), "04E4");
        hashMap.put(ASName.create("Idieresissmall"), "F7EF");
        hashMap.put(ASName.create("Idot"), "0130");
        hashMap.put(ASName.create("Idotaccent"), "0130");
        hashMap.put(ASName.create("Idotbelow"), "1ECA");
        hashMap.put(ASName.create("Iebrevecyrillic"), "04D6");
        hashMap.put(ASName.create("Iecyrillic"), "0415");
        hashMap.put(ASName.create("Ifraktur"), "2111");
        hashMap.put(ASName.create("Igrave"), "00CC");
        hashMap.put(ASName.create("Igravesmall"), "F7EC");
        hashMap.put(ASName.create("Ihookabove"), "1EC8");
        hashMap.put(ASName.create("Iicyrillic"), "0418");
        hashMap.put(ASName.create("Iinvertedbreve"), "020A");
        hashMap.put(ASName.create("Iishortcyrillic"), "0419");
        hashMap.put(ASName.create("Imacron"), "012A");
        hashMap.put(ASName.create("Imacroncyrillic"), "04E2");
        hashMap.put(ASName.create("Imonospace"), "FF29");
        hashMap.put(ASName.create("Iniarmenian"), "053B");
        hashMap.put(ASName.create("Iocyrillic"), "0401");
        hashMap.put(ASName.create("Iogonek"), "012E");
        hashMap.put(ASName.create("Iota"), "0399");
        hashMap.put(ASName.create("Iotaafrican"), "0196");
        hashMap.put(ASName.create("Iotadieresis"), "03AA");
        hashMap.put(ASName.create("Iotatonos"), "038A");
        hashMap.put(ASName.create("Ismall"), "F769");
        hashMap.put(ASName.create("Istroke"), "0197");
        hashMap.put(ASName.create("Itilde"), "0128");
        hashMap.put(ASName.create("Itildebelow"), "1E2C");
        hashMap.put(ASName.create("Izhitsacyrillic"), "0474");
        hashMap.put(ASName.create("Izhitsadblgravecyrillic"), "0476");
        hashMap.put(ASName.create("J"), "004A");
        hashMap.put(ASName.create("Jaarmenian"), "0541");
        hashMap.put(ASName.create("Jcircle"), "24BF");
        hashMap.put(ASName.create("Jcircumflex"), "0134");
        hashMap.put(ASName.create("Jecyrillic"), "0408");
        hashMap.put(ASName.create("Jheharmenian"), "054B");
        hashMap.put(ASName.create("Jmonospace"), "FF2A");
        hashMap.put(ASName.create("Jsmall"), "F76A");
        hashMap.put(ASName.create("K"), "004B");
        hashMap.put(ASName.create("KBsquare"), "3385");
        hashMap.put(ASName.create("KKsquare"), "33CD");
        hashMap.put(ASName.create("Kabashkircyrillic"), "04A0");
        hashMap.put(ASName.create("Kacute"), "1E30");
        hashMap.put(ASName.create("Kacyrillic"), "041A");
        hashMap.put(ASName.create("Kadescendercyrillic"), "049A");
        hashMap.put(ASName.create("Kahookcyrillic"), "04C3");
        hashMap.put(ASName.create("Kappa"), "039A");
        hashMap.put(ASName.create("Kastrokecyrillic"), "049E");
        hashMap.put(ASName.create("Kaverticalstrokecyrillic"), "049C");
        hashMap.put(ASName.create("Kcaron"), "01E8");
        hashMap.put(ASName.create("Kcedilla"), "0136");
        hashMap.put(ASName.create("Kcircle"), "24C0");
        hashMap.put(ASName.create("Kcommaaccent"), "0136");
        hashMap.put(ASName.create("Kdotbelow"), "1E32");
        hashMap.put(ASName.create("Keharmenian"), "0554");
        hashMap.put(ASName.create("Kenarmenian"), "053F");
        hashMap.put(ASName.create("Khacyrillic"), "0425");
        hashMap.put(ASName.create("Kheicoptic"), "03E6");
        hashMap.put(ASName.create("Khook"), "0198");
        hashMap.put(ASName.create("Kjecyrillic"), "040C");
        hashMap.put(ASName.create("Klinebelow"), "1E34");
        hashMap.put(ASName.create("Kmonospace"), "FF2B");
        hashMap.put(ASName.create("Koppacyrillic"), "0480");
        hashMap.put(ASName.create("Koppagreek"), "03DE");
        hashMap.put(ASName.create("Ksicyrillic"), "046E");
        hashMap.put(ASName.create("Ksmall"), "F76B");
        hashMap.put(ASName.create("L"), "004C");
        hashMap.put(ASName.create("LJ"), "01C7");
        hashMap.put(ASName.create("LL"), "F6BF");
        hashMap.put(ASName.create("Lacute"), "0139");
        hashMap.put(ASName.create("Lambda"), "039B");
        hashMap.put(ASName.create("Lcaron"), "013D");
        hashMap.put(ASName.create("Lcedilla"), "013B");
        hashMap.put(ASName.create("Lcircle"), "24C1");
        hashMap.put(ASName.create("Lcircumflexbelow"), "1E3C");
        hashMap.put(ASName.create("Lcommaaccent"), "013B");
        hashMap.put(ASName.create("Ldot"), "013F");
        hashMap.put(ASName.create("Ldotaccent"), "013F");
        hashMap.put(ASName.create("Ldotbelow"), "1E36");
        hashMap.put(ASName.create("Ldotbelowmacron"), "1E38");
        hashMap.put(ASName.create("Liwnarmenian"), "053C");
        hashMap.put(ASName.create("Lj"), "01C8");
        hashMap.put(ASName.create("Ljecyrillic"), "0409");
        hashMap.put(ASName.create("Llinebelow"), "1E3A");
        hashMap.put(ASName.create("Lmonospace"), "FF2C");
        hashMap.put(ASName.create("Lslash"), "0141");
        hashMap.put(ASName.create("Lslashsmall"), "F6F9");
        hashMap.put(ASName.create("Lsmall"), "F76C");
        hashMap.put(ASName.create("M"), "004D");
        hashMap.put(ASName.create("MBsquare"), "3386");
        hashMap.put(ASName.create("Macron"), "F6D0");
        hashMap.put(ASName.create("Macronsmall"), "F7AF");
        hashMap.put(ASName.create("Macute"), "1E3E");
        hashMap.put(ASName.create("Mcircle"), "24C2");
        hashMap.put(ASName.create("Mdotaccent"), "1E40");
        hashMap.put(ASName.create("Mdotbelow"), "1E42");
        hashMap.put(ASName.create("Menarmenian"), "0544");
        hashMap.put(ASName.create("Mmonospace"), "FF2D");
        hashMap.put(ASName.create("Msmall"), "F76D");
        hashMap.put(ASName.create("Mturned"), "019C");
        hashMap.put(ASName.create("Mu"), "039C");
        hashMap.put(ASName.create("N"), "004E");
        hashMap.put(ASName.create("NJ"), "01CA");
        hashMap.put(ASName.create("Nacute"), "0143");
        hashMap.put(ASName.create("Ncaron"), "0147");
        hashMap.put(ASName.create("Ncedilla"), "0145");
        hashMap.put(ASName.create("Ncircle"), "24C3");
        hashMap.put(ASName.create("Ncircumflexbelow"), "1E4A");
        hashMap.put(ASName.create("Ncommaaccent"), "0145");
        hashMap.put(ASName.create("Ndotaccent"), "1E44");
        hashMap.put(ASName.create("Ndotbelow"), "1E46");
        hashMap.put(ASName.create("Nhookleft"), "019D");
        hashMap.put(ASName.create("Nineroman"), "2168");
        hashMap.put(ASName.create("Nj"), "01CB");
        hashMap.put(ASName.create("Njecyrillic"), "040A");
        hashMap.put(ASName.create("Nlinebelow"), "1E48");
        hashMap.put(ASName.create("Nmonospace"), "FF2E");
        hashMap.put(ASName.create("Nowarmenian"), "0546");
        hashMap.put(ASName.create("Nsmall"), "F76E");
        hashMap.put(ASName.create("Ntilde"), "00D1");
        hashMap.put(ASName.create("Ntildesmall"), "F7F1");
        hashMap.put(ASName.create("Nu"), "039D");
        hashMap.put(ASName.create("O"), "004F");
        hashMap.put(ASName.create("OE"), "0152");
        hashMap.put(ASName.create("OEsmall"), "F6FA");
        hashMap.put(ASName.create("Oacute"), "00D3");
        hashMap.put(ASName.create("Oacutesmall"), "F7F3");
        hashMap.put(ASName.create("Obarredcyrillic"), "04E8");
        hashMap.put(ASName.create("Obarreddieresiscyrillic"), "04EA");
        hashMap.put(ASName.create("Obreve"), "014E");
        hashMap.put(ASName.create("Ocaron"), "01D1");
        hashMap.put(ASName.create("Ocenteredtilde"), "019F");
        hashMap.put(ASName.create("Ocircle"), "24C4");
        hashMap.put(ASName.create("Ocircumflex"), "00D4");
        hashMap.put(ASName.create("Ocircumflexacute"), "1ED0");
        hashMap.put(ASName.create("Ocircumflexdotbelow"), "1ED8");
        hashMap.put(ASName.create("Ocircumflexgrave"), "1ED2");
        hashMap.put(ASName.create("Ocircumflexhookabove"), "1ED4");
        hashMap.put(ASName.create("Ocircumflexsmall"), "F7F4");
        hashMap.put(ASName.create("Ocircumflextilde"), "1ED6");
        hashMap.put(ASName.create("Ocyrillic"), "041E");
        hashMap.put(ASName.create("Odblacute"), "0150");
        hashMap.put(ASName.create("Odblgrave"), "020C");
        hashMap.put(ASName.create("Odieresis"), "00D6");
        hashMap.put(ASName.create("Odieresiscyrillic"), "04E6");
        hashMap.put(ASName.create("Odieresissmall"), "F7F6");
        hashMap.put(ASName.create("Odotbelow"), "1ECC");
        hashMap.put(ASName.create("Ogoneksmall"), "F6FB");
        hashMap.put(ASName.create("Ograve"), "00D2");
        hashMap.put(ASName.create("Ogravesmall"), "F7F2");
        hashMap.put(ASName.create("Oharmenian"), "0555");
        hashMap.put(ASName.create("Ohm"), "2126");
        hashMap.put(ASName.create("Ohookabove"), "1ECE");
        hashMap.put(ASName.create("Ohorn"), "01A0");
        hashMap.put(ASName.create("Ohornacute"), "1EDA");
        hashMap.put(ASName.create("Ohorndotbelow"), "1EE2");
        hashMap.put(ASName.create("Ohorngrave"), "1EDC");
        hashMap.put(ASName.create("Ohornhookabove"), "1EDE");
        hashMap.put(ASName.create("Ohorntilde"), "1EE0");
        hashMap.put(ASName.create("Ohungarumlaut"), "0150");
        hashMap.put(ASName.create("Oi"), "01A2");
        hashMap.put(ASName.create("Oinvertedbreve"), "020E");
        hashMap.put(ASName.create("Omacron"), "014C");
        hashMap.put(ASName.create("Omacronacute"), "1E52");
        hashMap.put(ASName.create("Omacrongrave"), "1E50");
        hashMap.put(ASName.create("Omega"), "2126");
        hashMap.put(ASName.create("Omegacyrillic"), "0460");
        hashMap.put(ASName.create("Omegagreek"), "03A9");
        hashMap.put(ASName.create("Omegaroundcyrillic"), "047A");
        hashMap.put(ASName.create("Omegatitlocyrillic"), "047C");
        hashMap.put(ASName.create("Omegatonos"), "038F");
        hashMap.put(ASName.create("Omicron"), "039F");
        hashMap.put(ASName.create("Omicrontonos"), "038C");
        hashMap.put(ASName.create("Omonospace"), "FF2F");
        hashMap.put(ASName.create("Oneroman"), "2160");
        hashMap.put(ASName.create("Oogonek"), "01EA");
        hashMap.put(ASName.create("Oogonekmacron"), "01EC");
        hashMap.put(ASName.create("Oopen"), "0186");
        hashMap.put(ASName.create("Oslash"), "00D8");
        hashMap.put(ASName.create("Oslashacute"), "01FE");
        hashMap.put(ASName.create("Oslashsmall"), "F7F8");
        hashMap.put(ASName.create("Osmall"), "F76F");
        hashMap.put(ASName.create("Ostrokeacute"), "01FE");
        hashMap.put(ASName.create("Otcyrillic"), "047E");
        hashMap.put(ASName.create("Otilde"), "00D5");
        hashMap.put(ASName.create("Otildeacute"), "1E4C");
        hashMap.put(ASName.create("Otildedieresis"), "1E4E");
        hashMap.put(ASName.create("Otildesmall"), "F7F5");
        hashMap.put(ASName.create("P"), "0050");
        hashMap.put(ASName.create("Pacute"), "1E54");
        hashMap.put(ASName.create("Pcircle"), "24C5");
        hashMap.put(ASName.create("Pdotaccent"), "1E56");
        hashMap.put(ASName.create("Pecyrillic"), "041F");
        hashMap.put(ASName.create("Peharmenian"), "054A");
        hashMap.put(ASName.create("Pemiddlehookcyrillic"), "04A6");
        hashMap.put(ASName.create("Phi"), "03A6");
        hashMap.put(ASName.create("Phook"), "01A4");
        hashMap.put(ASName.create("Pi"), "03A0");
        hashMap.put(ASName.create("Piwrarmenian"), "0553");
        hashMap.put(ASName.create("Pmonospace"), "FF30");
        hashMap.put(ASName.create("Psi"), "03A8");
        hashMap.put(ASName.create("Psicyrillic"), "0470");
        hashMap.put(ASName.create("Psmall"), "F770");
        hashMap.put(ASName.create("Q"), "0051");
        hashMap.put(ASName.create("Qcircle"), "24C6");
        hashMap.put(ASName.create("Qmonospace"), "FF31");
        hashMap.put(ASName.create("Qsmall"), "F771");
        hashMap.put(ASName.create("R"), "0052");
        hashMap.put(ASName.create("Raarmenian"), "054C");
        hashMap.put(ASName.create("Racute"), "0154");
        hashMap.put(ASName.create("Rcaron"), "0158");
        hashMap.put(ASName.create("Rcedilla"), "0156");
        hashMap.put(ASName.create("Rcircle"), "24C7");
        hashMap.put(ASName.create("Rcommaaccent"), "0156");
        hashMap.put(ASName.create("Rdblgrave"), "0210");
        hashMap.put(ASName.create("Rdotaccent"), "1E58");
        hashMap.put(ASName.create("Rdotbelow"), "1E5A");
        hashMap.put(ASName.create("Rdotbelowmacron"), "1E5C");
        hashMap.put(ASName.create("Reharmenian"), "0550");
        hashMap.put(ASName.create("Rfraktur"), "211C");
        hashMap.put(ASName.create("Rho"), "03A1");
        hashMap.put(ASName.create("Ringsmall"), "F6FC");
        hashMap.put(ASName.create("Rinvertedbreve"), "0212");
        hashMap.put(ASName.create("Rlinebelow"), "1E5E");
        hashMap.put(ASName.create("Rmonospace"), "FF32");
        hashMap.put(ASName.create("Rsmall"), "F772");
        hashMap.put(ASName.create("Rsmallinverted"), "0281");
        hashMap.put(ASName.create("Rsmallinvertedsuperior"), "02B6");
        hashMap.put(ASName.create("S"), "0053");
        hashMap.put(ASName.create("SF010000"), "250C");
        hashMap.put(ASName.create("SF020000"), "2514");
        hashMap.put(ASName.create("SF030000"), "2510");
        hashMap.put(ASName.create("SF040000"), "2518");
        hashMap.put(ASName.create("SF050000"), "253C");
        hashMap.put(ASName.create("SF060000"), "252C");
        hashMap.put(ASName.create("SF070000"), "2534");
        hashMap.put(ASName.create("SF080000"), "251C");
        hashMap.put(ASName.create("SF090000"), "2524");
        hashMap.put(ASName.create("SF100000"), "2500");
        hashMap.put(ASName.create("SF110000"), "2502");
        hashMap.put(ASName.create("SF190000"), "2561");
        hashMap.put(ASName.create("SF200000"), "2562");
        hashMap.put(ASName.create("SF210000"), "2556");
        hashMap.put(ASName.create("SF220000"), "2555");
        hashMap.put(ASName.create("SF230000"), "2563");
        hashMap.put(ASName.create("SF240000"), "2551");
        hashMap.put(ASName.create("SF250000"), "2557");
        hashMap.put(ASName.create("SF260000"), "255D");
        hashMap.put(ASName.create("SF270000"), "255C");
        hashMap.put(ASName.create("SF280000"), "255B");
        hashMap.put(ASName.create("SF360000"), "255E");
        hashMap.put(ASName.create("SF370000"), "255F");
        hashMap.put(ASName.create("SF380000"), "255A");
        hashMap.put(ASName.create("SF390000"), "2554");
        hashMap.put(ASName.create("SF400000"), "2569");
        hashMap.put(ASName.create("SF410000"), "2566");
        hashMap.put(ASName.create("SF420000"), "2560");
        hashMap.put(ASName.create("SF430000"), "2550");
        hashMap.put(ASName.create("SF440000"), "256C");
        hashMap.put(ASName.create("SF450000"), "2567");
        hashMap.put(ASName.create("SF460000"), "2568");
        hashMap.put(ASName.create("SF470000"), "2564");
        hashMap.put(ASName.create("SF480000"), "2565");
        hashMap.put(ASName.create("SF490000"), "2559");
        hashMap.put(ASName.create("SF500000"), "2558");
        hashMap.put(ASName.create("SF510000"), "2552");
        hashMap.put(ASName.create("SF520000"), "2553");
        hashMap.put(ASName.create("SF530000"), "256B");
        hashMap.put(ASName.create("SF540000"), "256A");
        hashMap.put(ASName.create("Sacute"), "015A");
        hashMap.put(ASName.create("Sacutedotaccent"), "1E64");
        hashMap.put(ASName.create("Sampigreek"), "03E0");
        hashMap.put(ASName.create("Scaron"), "0160");
        hashMap.put(ASName.create("Scarondotaccent"), "1E66");
        hashMap.put(ASName.create("Scaronsmall"), "F6FD");
        hashMap.put(ASName.create("Scedilla"), "015E");
        hashMap.put(ASName.create("Schwa"), "018F");
        hashMap.put(ASName.create("Schwacyrillic"), "04D8");
        hashMap.put(ASName.create("Schwadieresiscyrillic"), "04DA");
        hashMap.put(ASName.create("Scircle"), "24C8");
        hashMap.put(ASName.create("Scircumflex"), "015C");
        hashMap.put(ASName.create("Scommaaccent"), "0218");
        hashMap.put(ASName.create("Sdotaccent"), "1E60");
        hashMap.put(ASName.create("Sdotbelow"), "1E62");
        hashMap.put(ASName.create("Sdotbelowdotaccent"), "1E68");
        hashMap.put(ASName.create("Seharmenian"), "054D");
        hashMap.put(ASName.create("Sevenroman"), "2166");
        hashMap.put(ASName.create("Shaarmenian"), "0547");
        hashMap.put(ASName.create("Shacyrillic"), "0428");
        hashMap.put(ASName.create("Shchacyrillic"), "0429");
        hashMap.put(ASName.create("Sheicoptic"), "03E2");
        hashMap.put(ASName.create("Shhacyrillic"), "04BA");
        hashMap.put(ASName.create("Shimacoptic"), "03EC");
        hashMap.put(ASName.create("Sigma"), "03A3");
        hashMap.put(ASName.create("Sixroman"), "2165");
        hashMap.put(ASName.create("Smonospace"), "FF33");
        hashMap.put(ASName.create("Softsigncyrillic"), "042C");
        hashMap.put(ASName.create("Ssmall"), "F773");
        hashMap.put(ASName.create("Stigmagreek"), "03DA");
        hashMap.put(ASName.create("T"), "0054");
        hashMap.put(ASName.create("Tau"), "03A4");
        hashMap.put(ASName.create("Tbar"), "0166");
        hashMap.put(ASName.create("Tcaron"), "0164");
        hashMap.put(ASName.create("Tcedilla"), "0162");
        hashMap.put(ASName.create("Tcircle"), "24C9");
        hashMap.put(ASName.create("Tcircumflexbelow"), "1E70");
        hashMap.put(ASName.create("Tcommaaccent"), "0162");
        hashMap.put(ASName.create("Tdotaccent"), "1E6A");
        hashMap.put(ASName.create("Tdotbelow"), "1E6C");
        hashMap.put(ASName.create("Tecyrillic"), "0422");
        hashMap.put(ASName.create("Tedescendercyrillic"), "04AC");
        hashMap.put(ASName.create("Tenroman"), "2169");
        hashMap.put(ASName.create("Tetsecyrillic"), "04B4");
        hashMap.put(ASName.create("Theta"), "0398");
        hashMap.put(ASName.create("Thook"), "01AC");
        hashMap.put(ASName.create("Thorn"), "00DE");
        hashMap.put(ASName.create("Thornsmall"), "F7FE");
        hashMap.put(ASName.create("Threeroman"), "2162");
        hashMap.put(ASName.create("Tildesmall"), "F6FE");
        hashMap.put(ASName.create("Tiwnarmenian"), "054F");
        hashMap.put(ASName.create("Tlinebelow"), "1E6E");
        hashMap.put(ASName.create("Tmonospace"), "FF34");
        hashMap.put(ASName.create("Toarmenian"), "0539");
        hashMap.put(ASName.create("Tonefive"), "01BC");
        hashMap.put(ASName.create("Tonesix"), "0184");
        hashMap.put(ASName.create("Tonetwo"), "01A7");
        hashMap.put(ASName.create("Tretroflexhook"), "01AE");
        hashMap.put(ASName.create("Tsecyrillic"), "0426");
        hashMap.put(ASName.create("Tshecyrillic"), "040B");
        hashMap.put(ASName.create("Tsmall"), "F774");
        hashMap.put(ASName.create("Twelveroman"), "216B");
        hashMap.put(ASName.create("Tworoman"), "2161");
        hashMap.put(ASName.create("U"), "0055");
        hashMap.put(ASName.create("Uacute"), "00DA");
        hashMap.put(ASName.create("Uacutesmall"), "F7FA");
        hashMap.put(ASName.create("Ubreve"), "016C");
        hashMap.put(ASName.create("Ucaron"), "01D3");
        hashMap.put(ASName.create("Ucircle"), "24CA");
        hashMap.put(ASName.create("Ucircumflex"), "00DB");
        hashMap.put(ASName.create("Ucircumflexbelow"), "1E76");
        hashMap.put(ASName.create("Ucircumflexsmall"), "F7FB");
        hashMap.put(ASName.create("Ucyrillic"), "0423");
        hashMap.put(ASName.create("Udblacute"), "0170");
        hashMap.put(ASName.create("Udblgrave"), "0214");
        hashMap.put(ASName.create("Udieresis"), "00DC");
        hashMap.put(ASName.create("Udieresisacute"), "01D7");
        hashMap.put(ASName.create("Udieresisbelow"), "1E72");
        hashMap.put(ASName.create("Udieresiscaron"), "01D9");
        hashMap.put(ASName.create("Udieresiscyrillic"), "04F0");
        hashMap.put(ASName.create("Udieresisgrave"), "01DB");
        hashMap.put(ASName.create("Udieresismacron"), "01D5");
        hashMap.put(ASName.create("Udieresissmall"), "F7FC");
        hashMap.put(ASName.create("Udotbelow"), "1EE4");
        hashMap.put(ASName.create("Ugrave"), "00D9");
        hashMap.put(ASName.create("Ugravesmall"), "F7F9");
        hashMap.put(ASName.create("Uhookabove"), "1EE6");
        hashMap.put(ASName.create("Uhorn"), "01AF");
        hashMap.put(ASName.create("Uhornacute"), "1EE8");
        hashMap.put(ASName.create("Uhorndotbelow"), "1EF0");
        hashMap.put(ASName.create("Uhorngrave"), "1EEA");
        hashMap.put(ASName.create("Uhornhookabove"), "1EEC");
        hashMap.put(ASName.create("Uhorntilde"), "1EEE");
        hashMap.put(ASName.create("Uhungarumlaut"), "0170");
        hashMap.put(ASName.create("Uhungarumlautcyrillic"), "04F2");
        hashMap.put(ASName.create("Uinvertedbreve"), "0216");
        hashMap.put(ASName.create("Ukcyrillic"), "0478");
        hashMap.put(ASName.create("Umacron"), "016A");
        hashMap.put(ASName.create("Umacroncyrillic"), "04EE");
        hashMap.put(ASName.create("Umacrondieresis"), "1E7A");
        hashMap.put(ASName.create("Umonospace"), "FF35");
        hashMap.put(ASName.create("Uogonek"), "0172");
        hashMap.put(ASName.create("Upsilon"), "03A5");
        hashMap.put(ASName.create("Upsilon1"), "03D2");
        hashMap.put(ASName.create("Upsilonacutehooksymbolgreek"), "03D3");
        hashMap.put(ASName.create("Upsilonafrican"), "01B1");
        hashMap.put(ASName.create("Upsilondieresis"), "03AB");
        hashMap.put(ASName.create("Upsilondieresishooksymbolgreek"), "03D4");
        hashMap.put(ASName.create("Upsilonhooksymbol"), "03D2");
        hashMap.put(ASName.create("Upsilontonos"), "038E");
        hashMap.put(ASName.create("Uring"), "016E");
        hashMap.put(ASName.create("Ushortcyrillic"), "040E");
        hashMap.put(ASName.create("Usmall"), "F775");
        hashMap.put(ASName.create("Ustraightcyrillic"), "04AE");
        hashMap.put(ASName.create("Ustraightstrokecyrillic"), "04B0");
        hashMap.put(ASName.create("Utilde"), "0168");
        hashMap.put(ASName.create("Utildeacute"), "1E78");
        hashMap.put(ASName.create("Utildebelow"), "1E74");
        hashMap.put(ASName.create("V"), "0056");
        hashMap.put(ASName.create("Vcircle"), "24CB");
        hashMap.put(ASName.create("Vdotbelow"), "1E7E");
        hashMap.put(ASName.create("Vecyrillic"), "0412");
        hashMap.put(ASName.create("Vewarmenian"), "054E");
        hashMap.put(ASName.create("Vhook"), "01B2");
        hashMap.put(ASName.create("Vmonospace"), "FF36");
        hashMap.put(ASName.create("Voarmenian"), "0548");
        hashMap.put(ASName.create("Vsmall"), "F776");
        hashMap.put(ASName.create("Vtilde"), "1E7C");
        hashMap.put(ASName.create("W"), "0057");
        hashMap.put(ASName.create("Wacute"), "1E82");
        hashMap.put(ASName.create("Wcircle"), "24CC");
        hashMap.put(ASName.create("Wcircumflex"), "0174");
        hashMap.put(ASName.create("Wdieresis"), "1E84");
        hashMap.put(ASName.create("Wdotaccent"), "1E86");
        hashMap.put(ASName.create("Wdotbelow"), "1E88");
        hashMap.put(ASName.create("Wgrave"), "1E80");
        hashMap.put(ASName.create("Wmonospace"), "FF37");
        hashMap.put(ASName.create("Wsmall"), "F777");
        hashMap.put(ASName.create("X"), "0058");
        hashMap.put(ASName.create("Xcircle"), "24CD");
        hashMap.put(ASName.create("Xdieresis"), "1E8C");
        hashMap.put(ASName.create("Xdotaccent"), "1E8A");
        hashMap.put(ASName.create("Xeharmenian"), "053D");
        hashMap.put(ASName.create("Xi"), "039E");
        hashMap.put(ASName.create("Xmonospace"), "FF38");
        hashMap.put(ASName.create("Xsmall"), "F778");
        hashMap.put(ASName.create("Y"), "0059");
        hashMap.put(ASName.create("Yacute"), "00DD");
        hashMap.put(ASName.create("Yacutesmall"), "F7FD");
        hashMap.put(ASName.create("Yatcyrillic"), "0462");
        hashMap.put(ASName.create("Ycircle"), "24CE");
        hashMap.put(ASName.create("Ycircumflex"), "0176");
        hashMap.put(ASName.create("Ydieresis"), "0178");
        hashMap.put(ASName.create("Ydieresissmall"), "F7FF");
        hashMap.put(ASName.create("Ydotaccent"), "1E8E");
        hashMap.put(ASName.create("Ydotbelow"), "1EF4");
        hashMap.put(ASName.create("Yericyrillic"), "042B");
        hashMap.put(ASName.create("Yerudieresiscyrillic"), "04F8");
        hashMap.put(ASName.create("Ygrave"), "1EF2");
        hashMap.put(ASName.create("Yhook"), "01B3");
        hashMap.put(ASName.create("Yhookabove"), "1EF6");
        hashMap.put(ASName.create("Yiarmenian"), "0545");
        hashMap.put(ASName.create("Yicyrillic"), "0407");
        hashMap.put(ASName.create("Yiwnarmenian"), "0552");
        hashMap.put(ASName.create("Ymonospace"), "FF39");
        hashMap.put(ASName.create("Ysmall"), "F779");
        hashMap.put(ASName.create("Ytilde"), "1EF8");
        hashMap.put(ASName.create("Yusbigcyrillic"), "046A");
        hashMap.put(ASName.create("Yusbigiotifiedcyrillic"), "046C");
        hashMap.put(ASName.create("Yuslittlecyrillic"), "0466");
        hashMap.put(ASName.create("Yuslittleiotifiedcyrillic"), "0468");
        hashMap.put(ASName.create("Z"), "005A");
        hashMap.put(ASName.create("Zaarmenian"), "0536");
        hashMap.put(ASName.create("Zacute"), "0179");
        hashMap.put(ASName.create("Zcaron"), "017D");
        hashMap.put(ASName.create("Zcaronsmall"), "F6FF");
        hashMap.put(ASName.create("Zcircle"), "24CF");
        hashMap.put(ASName.create("Zcircumflex"), "1E90");
        hashMap.put(ASName.create("Zdot"), "017B");
        hashMap.put(ASName.create("Zdotaccent"), "017B");
        hashMap.put(ASName.create("Zdotbelow"), "1E92");
        hashMap.put(ASName.create("Zecyrillic"), "0417");
        hashMap.put(ASName.create("Zedescendercyrillic"), "0498");
        hashMap.put(ASName.create("Zedieresiscyrillic"), "04DE");
        hashMap.put(ASName.create("Zeta"), "0396");
        hashMap.put(ASName.create("Zhearmenian"), "053A");
        hashMap.put(ASName.create("Zhebrevecyrillic"), "04C1");
        hashMap.put(ASName.create("Zhecyrillic"), "0416");
        hashMap.put(ASName.create("Zhedescendercyrillic"), "0496");
        hashMap.put(ASName.create("Zhedieresiscyrillic"), "04DC");
        hashMap.put(ASName.create("Zlinebelow"), "1E94");
        hashMap.put(ASName.create("Zmonospace"), "FF3A");
        hashMap.put(ASName.create("Zsmall"), "F77A");
        hashMap.put(ASName.create("Zstroke"), "01B5");
        hashMap.put(ASName.create("a"), "0061");
        hashMap.put(ASName.create("aabengali"), "0986");
        hashMap.put(ASName.create("aacute"), "00E1");
        hashMap.put(ASName.create("aadeva"), "0906");
        hashMap.put(ASName.create("aagujarati"), "0A86");
        hashMap.put(ASName.create("aagurmukhi"), "0A06");
        hashMap.put(ASName.create("aamatragurmukhi"), "0A3E");
        hashMap.put(ASName.create("aarusquare"), "3303");
        hashMap.put(ASName.create("aavowelsignbengali"), "09BE");
        hashMap.put(ASName.create("aavowelsigndeva"), "093E");
        hashMap.put(ASName.create("aavowelsigngujarati"), "0ABE");
        hashMap.put(ASName.create("abbreviationmarkarmenian"), "055F");
        hashMap.put(ASName.create("abbreviationsigndeva"), "0970");
        hashMap.put(ASName.create("abengali"), "0985");
        hashMap.put(ASName.create("abopomofo"), "311A");
        hashMap.put(ASName.create("abreve"), "0103");
        hashMap.put(ASName.create("abreveacute"), "1EAF");
        hashMap.put(ASName.create("abrevecyrillic"), "04D1");
        hashMap.put(ASName.create("abrevedotbelow"), "1EB7");
        hashMap.put(ASName.create("abrevegrave"), "1EB1");
        hashMap.put(ASName.create("abrevehookabove"), "1EB3");
        hashMap.put(ASName.create("abrevetilde"), "1EB5");
        hashMap.put(ASName.create("acaron"), "01CE");
        hashMap.put(ASName.create("acircle"), "24D0");
        hashMap.put(ASName.create("acircumflex"), "00E2");
        hashMap.put(ASName.create("acircumflexacute"), "1EA5");
        hashMap.put(ASName.create("acircumflexdotbelow"), "1EAD");
        hashMap.put(ASName.create("acircumflexgrave"), "1EA7");
        hashMap.put(ASName.create("acircumflexhookabove"), "1EA9");
        hashMap.put(ASName.create("acircumflextilde"), "1EAB");
        hashMap.put(ASName.create("acute"), "00B4");
        hashMap.put(ASName.create("acutebelowcmb"), "0317");
        hashMap.put(ASName.create("acutecmb"), "0301");
        hashMap.put(ASName.create("acutecomb"), "0301");
        hashMap.put(ASName.create("acutedeva"), "0954");
        hashMap.put(ASName.create("acutelowmod"), "02CF");
        hashMap.put(ASName.create("acutetonecmb"), "0341");
        hashMap.put(ASName.create("acyrillic"), "0430");
        hashMap.put(ASName.create("adblgrave"), "0201");
        hashMap.put(ASName.create("addakgurmukhi"), "0A71");
        hashMap.put(ASName.create("adeva"), "0905");
        hashMap.put(ASName.create("adieresis"), "00E4");
        hashMap.put(ASName.create("adieresiscyrillic"), "04D3");
        hashMap.put(ASName.create("adieresismacron"), "01DF");
        hashMap.put(ASName.create("adotbelow"), "1EA1");
        hashMap.put(ASName.create("adotmacron"), "01E1");
        hashMap.put(ASName.create("ae"), "00E6");
        hashMap.put(ASName.create("aeacute"), "01FD");
        hashMap.put(ASName.create("aekorean"), "3150");
        hashMap.put(ASName.create("aemacron"), "01E3");
        hashMap.put(ASName.create("afii00208"), "2015");
        hashMap.put(ASName.create("afii08941"), "20A4");
        hashMap.put(ASName.create("afii10017"), "0410");
        hashMap.put(ASName.create("afii10018"), "0411");
        hashMap.put(ASName.create("afii10019"), "0412");
        hashMap.put(ASName.create("afii10020"), "0413");
        hashMap.put(ASName.create("afii10021"), "0414");
        hashMap.put(ASName.create("afii10022"), "0415");
        hashMap.put(ASName.create("afii10023"), "0401");
        hashMap.put(ASName.create("afii10024"), "0416");
        hashMap.put(ASName.create("afii10025"), "0417");
        hashMap.put(ASName.create("afii10026"), "0418");
        hashMap.put(ASName.create("afii10027"), "0419");
        hashMap.put(ASName.create("afii10028"), "041A");
        hashMap.put(ASName.create("afii10029"), "041B");
        hashMap.put(ASName.create("afii10030"), "041C");
        hashMap.put(ASName.create("afii10031"), "041D");
        hashMap.put(ASName.create("afii10032"), "041E");
        hashMap.put(ASName.create("afii10033"), "041F");
        hashMap.put(ASName.create("afii10034"), "0420");
        hashMap.put(ASName.create("afii10035"), "0421");
        hashMap.put(ASName.create("afii10036"), "0422");
        hashMap.put(ASName.create("afii10037"), "0423");
        hashMap.put(ASName.create("afii10038"), "0424");
        hashMap.put(ASName.create("afii10039"), "0425");
        hashMap.put(ASName.create("afii10040"), "0426");
        hashMap.put(ASName.create("afii10041"), "0427");
        hashMap.put(ASName.create("afii10042"), "0428");
        hashMap.put(ASName.create("afii10043"), "0429");
        hashMap.put(ASName.create("afii10044"), "042A");
        hashMap.put(ASName.create("afii10045"), "042B");
        hashMap.put(ASName.create("afii10046"), "042C");
        hashMap.put(ASName.create("afii10047"), "042D");
        hashMap.put(ASName.create("afii10048"), "042E");
        hashMap.put(ASName.create("afii10049"), "042F");
        hashMap.put(ASName.create("afii10050"), "0490");
        hashMap.put(ASName.create("afii10051"), "0402");
        hashMap.put(ASName.create("afii10052"), "0403");
        hashMap.put(ASName.create("afii10053"), "0404");
        hashMap.put(ASName.create("afii10054"), "0405");
        hashMap.put(ASName.create("afii10055"), "0406");
        hashMap.put(ASName.create("afii10056"), "0407");
        hashMap.put(ASName.create("afii10057"), "0408");
        hashMap.put(ASName.create("afii10058"), "0409");
        hashMap.put(ASName.create("afii10059"), "040A");
        hashMap.put(ASName.create("afii10060"), "040B");
        hashMap.put(ASName.create("afii10061"), "040C");
        hashMap.put(ASName.create("afii10062"), "040E");
        hashMap.put(ASName.create("afii10063"), "F6C4");
        hashMap.put(ASName.create("afii10064"), "F6C5");
        hashMap.put(ASName.create("afii10065"), "0430");
        hashMap.put(ASName.create("afii10066"), "0431");
        hashMap.put(ASName.create("afii10067"), "0432");
        hashMap.put(ASName.create("afii10068"), "0433");
        hashMap.put(ASName.create("afii10069"), "0434");
        hashMap.put(ASName.create("afii10070"), "0435");
        hashMap.put(ASName.create("afii10071"), "0451");
        hashMap.put(ASName.create("afii10072"), "0436");
        hashMap.put(ASName.create("afii10073"), "0437");
        hashMap.put(ASName.create("afii10074"), "0438");
        hashMap.put(ASName.create("afii10075"), "0439");
        hashMap.put(ASName.create("afii10076"), "043A");
        hashMap.put(ASName.create("afii10077"), "043B");
        hashMap.put(ASName.create("afii10078"), "043C");
        hashMap.put(ASName.create("afii10079"), "043D");
        hashMap.put(ASName.create("afii10080"), "043E");
        hashMap.put(ASName.create("afii10081"), "043F");
        hashMap.put(ASName.create("afii10082"), "0440");
        hashMap.put(ASName.create("afii10083"), "0441");
        hashMap.put(ASName.create("afii10084"), "0442");
        hashMap.put(ASName.create("afii10085"), "0443");
        hashMap.put(ASName.create("afii10086"), "0444");
        hashMap.put(ASName.create("afii10087"), "0445");
        hashMap.put(ASName.create("afii10088"), "0446");
        hashMap.put(ASName.create("afii10089"), "0447");
        hashMap.put(ASName.create("afii10090"), "0448");
        hashMap.put(ASName.create("afii10091"), "0449");
        hashMap.put(ASName.create("afii10092"), "044A");
        hashMap.put(ASName.create("afii10093"), "044B");
        hashMap.put(ASName.create("afii10094"), "044C");
        hashMap.put(ASName.create("afii10095"), "044D");
        hashMap.put(ASName.create("afii10096"), "044E");
        hashMap.put(ASName.create("afii10097"), "044F");
        hashMap.put(ASName.create("afii10098"), "0491");
        hashMap.put(ASName.create("afii10099"), "0452");
        hashMap.put(ASName.create("afii10100"), "0453");
        hashMap.put(ASName.create("afii10101"), "0454");
        hashMap.put(ASName.create("afii10102"), "0455");
        hashMap.put(ASName.create("afii10103"), "0456");
        hashMap.put(ASName.create("afii10104"), "0457");
        hashMap.put(ASName.create("afii10105"), "0458");
        hashMap.put(ASName.create("afii10106"), "0459");
        hashMap.put(ASName.create("afii10107"), "045A");
        hashMap.put(ASName.create("afii10108"), "045B");
        hashMap.put(ASName.create("afii10109"), "045C");
        hashMap.put(ASName.create("afii10110"), "045E");
        hashMap.put(ASName.create("afii10145"), "040F");
        hashMap.put(ASName.create("afii10146"), "0462");
        hashMap.put(ASName.create("afii10147"), "0472");
        hashMap.put(ASName.create("afii10148"), "0474");
        hashMap.put(ASName.create("afii10192"), "F6C6");
        hashMap.put(ASName.create("afii10193"), "045F");
        hashMap.put(ASName.create("afii10194"), "0463");
        hashMap.put(ASName.create("afii10195"), "0473");
        hashMap.put(ASName.create("afii10196"), "0475");
        hashMap.put(ASName.create("afii10831"), "F6C7");
        hashMap.put(ASName.create("afii10832"), "F6C8");
        hashMap.put(ASName.create("afii10846"), "04D9");
        hashMap.put(ASName.create("afii299"), "200E");
        hashMap.put(ASName.create("afii300"), "200F");
        hashMap.put(ASName.create("afii301"), "200D");
        hashMap.put(ASName.create("afii57381"), "066A");
        hashMap.put(ASName.create("afii57388"), "060C");
        hashMap.put(ASName.create("afii57392"), "0660");
        hashMap.put(ASName.create("afii57393"), "0661");
        hashMap.put(ASName.create("afii57394"), "0662");
        hashMap.put(ASName.create("afii57395"), "0663");
        hashMap.put(ASName.create("afii57396"), "0664");
        hashMap.put(ASName.create("afii57397"), "0665");
        hashMap.put(ASName.create("afii57398"), "0666");
        hashMap.put(ASName.create("afii57399"), "0667");
        hashMap.put(ASName.create("afii57400"), "0668");
        hashMap.put(ASName.create("afii57401"), "0669");
        hashMap.put(ASName.create("afii57403"), "061B");
        hashMap.put(ASName.create("afii57407"), "061F");
        hashMap.put(ASName.create("afii57409"), "0621");
        hashMap.put(ASName.create("afii57410"), "0622");
        hashMap.put(ASName.create("afii57411"), "0623");
        hashMap.put(ASName.create("afii57412"), "0624");
        hashMap.put(ASName.create("afii57413"), "0625");
        hashMap.put(ASName.create("afii57414"), "0626");
        hashMap.put(ASName.create("afii57415"), "0627");
        hashMap.put(ASName.create("afii57416"), "0628");
        hashMap.put(ASName.create("afii57417"), "0629");
        hashMap.put(ASName.create("afii57418"), "062A");
        hashMap.put(ASName.create("afii57419"), "062B");
        hashMap.put(ASName.create("afii57420"), "062C");
        hashMap.put(ASName.create("afii57421"), "062D");
        hashMap.put(ASName.create("afii57422"), "062E");
        hashMap.put(ASName.create("afii57423"), "062F");
        hashMap.put(ASName.create("afii57424"), "0630");
        hashMap.put(ASName.create("afii57425"), "0631");
        hashMap.put(ASName.create("afii57426"), "0632");
        hashMap.put(ASName.create("afii57427"), "0633");
        hashMap.put(ASName.create("afii57428"), "0634");
        hashMap.put(ASName.create("afii57429"), "0635");
        hashMap.put(ASName.create("afii57430"), "0636");
        hashMap.put(ASName.create("afii57431"), "0637");
        hashMap.put(ASName.create("afii57432"), "0638");
        hashMap.put(ASName.create("afii57433"), "0639");
        hashMap.put(ASName.create("afii57434"), "063A");
        hashMap.put(ASName.create("afii57440"), "0640");
        hashMap.put(ASName.create("afii57441"), "0641");
        hashMap.put(ASName.create("afii57442"), "0642");
        hashMap.put(ASName.create("afii57443"), "0643");
        hashMap.put(ASName.create("afii57444"), "0644");
        hashMap.put(ASName.create("afii57445"), "0645");
        hashMap.put(ASName.create("afii57446"), "0646");
        hashMap.put(ASName.create("afii57448"), "0648");
        hashMap.put(ASName.create("afii57449"), "0649");
        hashMap.put(ASName.create("afii57450"), "064A");
        hashMap.put(ASName.create("afii57451"), "064B");
        hashMap.put(ASName.create("afii57452"), "064C");
        hashMap.put(ASName.create("afii57453"), "064D");
        hashMap.put(ASName.create("afii57454"), "064E");
        hashMap.put(ASName.create("afii57455"), "064F");
        hashMap.put(ASName.create("afii57456"), "0650");
        hashMap.put(ASName.create("afii57457"), "0651");
        hashMap.put(ASName.create("afii57458"), "0652");
        hashMap.put(ASName.create("afii57470"), "0647");
        hashMap.put(ASName.create("afii57505"), "06A4");
        hashMap.put(ASName.create("afii57506"), "067E");
        hashMap.put(ASName.create("afii57507"), "0686");
        hashMap.put(ASName.create("afii57508"), "0698");
        hashMap.put(ASName.create("afii57509"), "06AF");
        hashMap.put(ASName.create("afii57511"), "0679");
        hashMap.put(ASName.create("afii57512"), "0688");
        hashMap.put(ASName.create("afii57513"), "0691");
        hashMap.put(ASName.create("afii57514"), "06BA");
        hashMap.put(ASName.create("afii57519"), "06D2");
        hashMap.put(ASName.create("afii57534"), "06D5");
        hashMap.put(ASName.create("afii57636"), "20AA");
        hashMap.put(ASName.create("afii57645"), "05BE");
        hashMap.put(ASName.create("afii57658"), "05C3");
        hashMap.put(ASName.create("afii57664"), "05D0");
        hashMap.put(ASName.create("afii57665"), "05D1");
        hashMap.put(ASName.create("afii57666"), "05D2");
        hashMap.put(ASName.create("afii57667"), "05D3");
        hashMap.put(ASName.create("afii57668"), "05D4");
        hashMap.put(ASName.create("afii57669"), "05D5");
        hashMap.put(ASName.create("afii57670"), "05D6");
        hashMap.put(ASName.create("afii57671"), "05D7");
        hashMap.put(ASName.create("afii57672"), "05D8");
        hashMap.put(ASName.create("afii57673"), "05D9");
        hashMap.put(ASName.create("afii57674"), "05DA");
        hashMap.put(ASName.create("afii57675"), "05DB");
        hashMap.put(ASName.create("afii57676"), "05DC");
        hashMap.put(ASName.create("afii57677"), "05DD");
        hashMap.put(ASName.create("afii57678"), "05DE");
        hashMap.put(ASName.create("afii57679"), "05DF");
        hashMap.put(ASName.create("afii57680"), "05E0");
        hashMap.put(ASName.create("afii57681"), "05E1");
        hashMap.put(ASName.create("afii57682"), "05E2");
        hashMap.put(ASName.create("afii57683"), "05E3");
        hashMap.put(ASName.create("afii57684"), "05E4");
        hashMap.put(ASName.create("afii57685"), "05E5");
        hashMap.put(ASName.create("afii57686"), "05E6");
        hashMap.put(ASName.create("afii57687"), "05E7");
        hashMap.put(ASName.create("afii57688"), "05E8");
        hashMap.put(ASName.create("afii57689"), "05E9");
        hashMap.put(ASName.create("afii57690"), "05EA");
        hashMap.put(ASName.create("afii57694"), "FB2A");
        hashMap.put(ASName.create("afii57695"), "FB2B");
        hashMap.put(ASName.create("afii57700"), "FB4B");
        hashMap.put(ASName.create("afii57705"), "FB1F");
        hashMap.put(ASName.create("afii57716"), "05F0");
        hashMap.put(ASName.create("afii57717"), "05F1");
        hashMap.put(ASName.create("afii57718"), "05F2");
        hashMap.put(ASName.create("afii57723"), "FB35");
        hashMap.put(ASName.create("afii57793"), "05B4");
        hashMap.put(ASName.create("afii57794"), "05B5");
        hashMap.put(ASName.create("afii57795"), "05B6");
        hashMap.put(ASName.create("afii57796"), "05BB");
        hashMap.put(ASName.create("afii57797"), "05B8");
        hashMap.put(ASName.create("afii57798"), "05B7");
        hashMap.put(ASName.create("afii57799"), "05B0");
        hashMap.put(ASName.create("afii57800"), "05B2");
        hashMap.put(ASName.create("afii57801"), "05B1");
        hashMap.put(ASName.create("afii57802"), "05B3");
        hashMap.put(ASName.create("afii57803"), "05C2");
        hashMap.put(ASName.create("afii57804"), "05C1");
        hashMap.put(ASName.create("afii57806"), "05B9");
        hashMap.put(ASName.create("afii57807"), "05BC");
        hashMap.put(ASName.create("afii57839"), "05BD");
        hashMap.put(ASName.create("afii57841"), "05BF");
        hashMap.put(ASName.create("afii57842"), "05C0");
        hashMap.put(ASName.create("afii57929"), "02BC");
        hashMap.put(ASName.create("afii61248"), "2105");
        hashMap.put(ASName.create("afii61289"), "2113");
        hashMap.put(ASName.create("afii61352"), "2116");
        hashMap.put(ASName.create("afii61573"), "202C");
        hashMap.put(ASName.create("afii61574"), "202D");
        hashMap.put(ASName.create("afii61575"), "202E");
        hashMap.put(ASName.create("afii61664"), "200C");
        hashMap.put(ASName.create("afii63167"), "066D");
        hashMap.put(ASName.create("afii64937"), "02BD");
        hashMap.put(ASName.create("agrave"), "00E0");
        hashMap.put(ASName.create("agujarati"), "0A85");
        hashMap.put(ASName.create("agurmukhi"), "0A05");
        hashMap.put(ASName.create("ahiragana"), "3042");
        hashMap.put(ASName.create("ahookabove"), "1EA3");
        hashMap.put(ASName.create("aibengali"), "0990");
        hashMap.put(ASName.create("aibopomofo"), "311E");
        hashMap.put(ASName.create("aideva"), "0910");
        hashMap.put(ASName.create("aiecyrillic"), "04D5");
        hashMap.put(ASName.create("aigujarati"), "0A90");
        hashMap.put(ASName.create("aigurmukhi"), "0A10");
        hashMap.put(ASName.create("aimatragurmukhi"), "0A48");
        hashMap.put(ASName.create("ainarabic"), "0639");
        hashMap.put(ASName.create("ainfinalarabic"), "FECA");
        hashMap.put(ASName.create("aininitialarabic"), "FECB");
        hashMap.put(ASName.create("ainmedialarabic"), "FECC");
        hashMap.put(ASName.create("ainvertedbreve"), "0203");
        hashMap.put(ASName.create("aivowelsignbengali"), "09C8");
        hashMap.put(ASName.create("aivowelsigndeva"), "0948");
        hashMap.put(ASName.create("aivowelsigngujarati"), "0AC8");
        hashMap.put(ASName.create("akatakana"), "30A2");
        hashMap.put(ASName.create("akatakanahalfwidth"), "FF71");
        hashMap.put(ASName.create("akorean"), "314F");
        hashMap.put(ASName.create("alef"), "05D0");
        hashMap.put(ASName.create("alefarabic"), "0627");
        hashMap.put(ASName.create("alefdageshhebrew"), "FB30");
        hashMap.put(ASName.create("aleffinalarabic"), "FE8E");
        hashMap.put(ASName.create("alefhamzaabovearabic"), "0623");
        hashMap.put(ASName.create("alefhamzaabovefinalarabic"), "FE84");
        hashMap.put(ASName.create("alefhamzabelowarabic"), "0625");
        hashMap.put(ASName.create("alefhamzabelowfinalarabic"), "FE88");
        hashMap.put(ASName.create("alefhebrew"), "05D0");
        hashMap.put(ASName.create("aleflamedhebrew"), "FB4F");
        hashMap.put(ASName.create("alefmaddaabovearabic"), "0622");
        hashMap.put(ASName.create("alefmaddaabovefinalarabic"), "FE82");
        hashMap.put(ASName.create("alefmaksuraarabic"), "0649");
        hashMap.put(ASName.create("alefmaksurafinalarabic"), "FEF0");
        hashMap.put(ASName.create("alefmaksurainitialarabic"), "FEF3");
        hashMap.put(ASName.create("alefmaksuramedialarabic"), "FEF4");
        hashMap.put(ASName.create("alefpatahhebrew"), "FB2E");
        hashMap.put(ASName.create("alefqamatshebrew"), "FB2F");
        hashMap.put(ASName.create("aleph"), "2135");
        hashMap.put(ASName.create("allequal"), "224C");
        hashMap.put(ASName.create("alpha"), "03B1");
        hashMap.put(ASName.create("alphatonos"), "03AC");
        hashMap.put(ASName.create("amacron"), "0101");
        hashMap.put(ASName.create("amonospace"), "FF41");
        hashMap.put(ASName.create("ampersand"), "0026");
        hashMap.put(ASName.create("ampersandmonospace"), "FF06");
        hashMap.put(ASName.create("ampersandsmall"), "F726");
        hashMap.put(ASName.create("amsquare"), "33C2");
        hashMap.put(ASName.create("anbopomofo"), "3122");
        hashMap.put(ASName.create("angbopomofo"), "3124");
        hashMap.put(ASName.create("angkhankhuthai"), "0E5A");
        hashMap.put(ASName.create("angle"), "2220");
        hashMap.put(ASName.create("anglebracketleft"), "3008");
        hashMap.put(ASName.create("anglebracketleftvertical"), "FE3F");
        hashMap.put(ASName.create("anglebracketright"), "3009");
        hashMap.put(ASName.create("anglebracketrightvertical"), "FE40");
        hashMap.put(ASName.create("angleleft"), "2329");
        hashMap.put(ASName.create("angleright"), "232A");
        hashMap.put(ASName.create("angstrom"), "212B");
        hashMap.put(ASName.create("anoteleia"), "0387");
        hashMap.put(ASName.create("anudattadeva"), "0952");
        hashMap.put(ASName.create("anusvarabengali"), "0982");
        hashMap.put(ASName.create("anusvaradeva"), "0902");
        hashMap.put(ASName.create("anusvaragujarati"), "0A82");
        hashMap.put(ASName.create("aogonek"), "0105");
        hashMap.put(ASName.create("apaatosquare"), "3300");
        hashMap.put(ASName.create("aparen"), "249C");
        hashMap.put(ASName.create("apostrophearmenian"), "055A");
        hashMap.put(ASName.create("apostrophemod"), "02BC");
        hashMap.put(ASName.create("apple"), "F8FF");
        hashMap.put(ASName.create("approaches"), "2250");
        hashMap.put(ASName.create("approxequal"), "2248");
        hashMap.put(ASName.create("approxequalorimage"), "2252");
        hashMap.put(ASName.create("approximatelyequal"), "2245");
        hashMap.put(ASName.create("araeaekorean"), "318E");
        hashMap.put(ASName.create("araeakorean"), "318D");
        hashMap.put(ASName.create("arc"), "2312");
        hashMap.put(ASName.create("arighthalfring"), "1E9A");
        hashMap.put(ASName.create("aring"), "00E5");
        hashMap.put(ASName.create("aringacute"), "01FB");
        hashMap.put(ASName.create("aringbelow"), "1E01");
        hashMap.put(ASName.create("arrowboth"), "2194");
        hashMap.put(ASName.create("arrowdashdown"), "21E3");
        hashMap.put(ASName.create("arrowdashleft"), "21E0");
        hashMap.put(ASName.create("arrowdashright"), "21E2");
        hashMap.put(ASName.create("arrowdashup"), "21E1");
        hashMap.put(ASName.create("arrowdblboth"), "21D4");
        hashMap.put(ASName.create("arrowdbldown"), "21D3");
        hashMap.put(ASName.create("arrowdblleft"), "21D0");
        hashMap.put(ASName.create("arrowdblright"), "21D2");
        hashMap.put(ASName.create("arrowdblup"), "21D1");
        hashMap.put(ASName.create("arrowdown"), "2193");
        hashMap.put(ASName.create("arrowdownleft"), "2199");
        hashMap.put(ASName.create("arrowdownright"), "2198");
        hashMap.put(ASName.create("arrowdownwhite"), "21E9");
        hashMap.put(ASName.create("arrowheaddownmod"), "02C5");
        hashMap.put(ASName.create("arrowheadleftmod"), "02C2");
        hashMap.put(ASName.create("arrowheadrightmod"), "02C3");
        hashMap.put(ASName.create("arrowheadupmod"), "02C4");
        hashMap.put(ASName.create("arrowhorizex"), "F8E7");
        hashMap.put(ASName.create("arrowleft"), "2190");
        hashMap.put(ASName.create("arrowleftdbl"), "21D0");
        hashMap.put(ASName.create("arrowleftdblstroke"), "21CD");
        hashMap.put(ASName.create("arrowleftoverright"), "21C6");
        hashMap.put(ASName.create("arrowleftwhite"), "21E6");
        hashMap.put(ASName.create("arrowright"), "2192");
        hashMap.put(ASName.create("arrowrightdblstroke"), "21CF");
        hashMap.put(ASName.create("arrowrightheavy"), "279E");
        hashMap.put(ASName.create("arrowrightoverleft"), "21C4");
        hashMap.put(ASName.create("arrowrightwhite"), "21E8");
        hashMap.put(ASName.create("arrowtableft"), "21E4");
        hashMap.put(ASName.create("arrowtabright"), "21E5");
        hashMap.put(ASName.create("arrowup"), "2191");
        hashMap.put(ASName.create("arrowupdn"), "2195");
        hashMap.put(ASName.create("arrowupdnbse"), "21A8");
        hashMap.put(ASName.create("arrowupdownbase"), "21A8");
        hashMap.put(ASName.create("arrowupleft"), "2196");
        hashMap.put(ASName.create("arrowupleftofdown"), "21C5");
        hashMap.put(ASName.create("arrowupright"), "2197");
        hashMap.put(ASName.create("arrowupwhite"), "21E7");
        hashMap.put(ASName.create("arrowvertex"), "F8E6");
        hashMap.put(ASName.create("asciicircum"), "005E");
        hashMap.put(ASName.create("asciicircummonospace"), "FF3E");
        hashMap.put(ASName.create("asciitilde"), "007E");
        hashMap.put(ASName.create("asciitildemonospace"), "FF5E");
        hashMap.put(ASName.create("ascript"), "0251");
        hashMap.put(ASName.create("ascriptturned"), "0252");
        hashMap.put(ASName.create("asmallhiragana"), "3041");
        hashMap.put(ASName.create("asmallkatakana"), "30A1");
        hashMap.put(ASName.create("asmallkatakanahalfwidth"), "FF67");
        hashMap.put(ASName.create("asterisk"), "002A");
        hashMap.put(ASName.create("asteriskaltonearabic"), "066D");
        hashMap.put(ASName.create("asteriskarabic"), "066D");
        hashMap.put(ASName.create("asteriskmath"), "2217");
        hashMap.put(ASName.create("asteriskmonospace"), "FF0A");
        hashMap.put(ASName.create("asterisksmall"), "FE61");
        hashMap.put(ASName.create("asterism"), "2042");
        hashMap.put(ASName.create("asuperior"), "F6E9");
        hashMap.put(ASName.create("asymptoticallyequal"), "2243");
        hashMap.put(ASName.create("at"), "0040");
        hashMap.put(ASName.create("atilde"), "00E3");
        hashMap.put(ASName.create("atmonospace"), "FF20");
        hashMap.put(ASName.create("atsmall"), "FE6B");
        hashMap.put(ASName.create("aturned"), "0250");
        hashMap.put(ASName.create("aubengali"), "0994");
        hashMap.put(ASName.create("aubopomofo"), "3120");
        hashMap.put(ASName.create("audeva"), "0914");
        hashMap.put(ASName.create("augujarati"), "0A94");
        hashMap.put(ASName.create("augurmukhi"), "0A14");
        hashMap.put(ASName.create("aulengthmarkbengali"), "09D7");
        hashMap.put(ASName.create("aumatragurmukhi"), "0A4C");
        hashMap.put(ASName.create("auvowelsignbengali"), "09CC");
        hashMap.put(ASName.create("auvowelsigndeva"), "094C");
        hashMap.put(ASName.create("auvowelsigngujarati"), "0ACC");
        hashMap.put(ASName.create("avagrahadeva"), "093D");
        hashMap.put(ASName.create("aybarmenian"), "0561");
        hashMap.put(ASName.create("ayin"), "05E2");
        hashMap.put(ASName.create("ayinaltonehebrew"), "FB20");
        hashMap.put(ASName.create("ayinhebrew"), "05E2");
        hashMap.put(ASName.create("b"), "0062");
        hashMap.put(ASName.create("babengali"), "09AC");
        hashMap.put(ASName.create("backslash"), "005C");
        hashMap.put(ASName.create("backslashmonospace"), "FF3C");
        hashMap.put(ASName.create("badeva"), "092C");
        hashMap.put(ASName.create("bagujarati"), "0AAC");
        hashMap.put(ASName.create("bagurmukhi"), "0A2C");
        hashMap.put(ASName.create("bahiragana"), "3070");
        hashMap.put(ASName.create("bahtthai"), "0E3F");
        hashMap.put(ASName.create("bakatakana"), "30D0");
        hashMap.put(ASName.create("bar"), "007C");
        hashMap.put(ASName.create("barmonospace"), "FF5C");
        hashMap.put(ASName.create("bbopomofo"), "3105");
        hashMap.put(ASName.create("bcircle"), "24D1");
        hashMap.put(ASName.create("bdotaccent"), "1E03");
        hashMap.put(ASName.create("bdotbelow"), "1E05");
        hashMap.put(ASName.create("beamedsixteenthnotes"), "266C");
        hashMap.put(ASName.create("because"), "2235");
        hashMap.put(ASName.create("becyrillic"), "0431");
        hashMap.put(ASName.create("beharabic"), "0628");
        hashMap.put(ASName.create("behfinalarabic"), "FE90");
        hashMap.put(ASName.create("behinitialarabic"), "FE91");
        hashMap.put(ASName.create("behiragana"), "3079");
        hashMap.put(ASName.create("behmedialarabic"), "FE92");
        hashMap.put(ASName.create("behmeeminitialarabic"), "FC9F");
        hashMap.put(ASName.create("behmeemisolatedarabic"), "FC08");
        hashMap.put(ASName.create("behnoonfinalarabic"), "FC6D");
        hashMap.put(ASName.create("bekatakana"), "30D9");
        hashMap.put(ASName.create("benarmenian"), "0562");
        hashMap.put(ASName.create("bet"), "05D1");
        hashMap.put(ASName.create("beta"), "03B2");
        hashMap.put(ASName.create("betasymbolgreek"), "03D0");
        hashMap.put(ASName.create("betdagesh"), "FB31");
        hashMap.put(ASName.create("betdageshhebrew"), "FB31");
        hashMap.put(ASName.create("bethebrew"), "05D1");
        hashMap.put(ASName.create("betrafehebrew"), "FB4C");
        hashMap.put(ASName.create("bhabengali"), "09AD");
        hashMap.put(ASName.create("bhadeva"), "092D");
        hashMap.put(ASName.create("bhagujarati"), "0AAD");
        hashMap.put(ASName.create("bhagurmukhi"), "0A2D");
        hashMap.put(ASName.create("bhook"), "0253");
        hashMap.put(ASName.create("bihiragana"), "3073");
        hashMap.put(ASName.create("bikatakana"), "30D3");
        hashMap.put(ASName.create("bilabialclick"), "0298");
        hashMap.put(ASName.create("bindigurmukhi"), "0A02");
        hashMap.put(ASName.create("birusquare"), "3331");
        hashMap.put(ASName.create("blackcircle"), "25CF");
        hashMap.put(ASName.create("blackdiamond"), "25C6");
        hashMap.put(ASName.create("blackdownpointingtriangle"), "25BC");
        hashMap.put(ASName.create("blackleftpointingpointer"), "25C4");
        hashMap.put(ASName.create("blackleftpointingtriangle"), "25C0");
        hashMap.put(ASName.create("blacklenticularbracketleft"), "3010");
        hashMap.put(ASName.create("blacklenticularbracketleftvertical"), "FE3B");
        hashMap.put(ASName.create("blacklenticularbracketright"), "3011");
        hashMap.put(ASName.create("blacklenticularbracketrightvertical"), "FE3C");
        hashMap.put(ASName.create("blacklowerlefttriangle"), "25E3");
        hashMap.put(ASName.create("blacklowerrighttriangle"), "25E2");
        hashMap.put(ASName.create("blackrectangle"), "25AC");
        hashMap.put(ASName.create("blackrightpointingpointer"), "25BA");
        hashMap.put(ASName.create("blackrightpointingtriangle"), "25B6");
        hashMap.put(ASName.create("blacksmallsquare"), "25AA");
        hashMap.put(ASName.create("blacksmilingface"), "263B");
        hashMap.put(ASName.create("blacksquare"), "25A0");
        hashMap.put(ASName.create("blackstar"), "2605");
        hashMap.put(ASName.create("blackupperlefttriangle"), "25E4");
        hashMap.put(ASName.create("blackupperrighttriangle"), "25E5");
        hashMap.put(ASName.create("blackuppointingsmalltriangle"), "25B4");
        hashMap.put(ASName.create("blackuppointingtriangle"), "25B2");
        hashMap.put(ASName.create("blank"), "2423");
        hashMap.put(ASName.create("blinebelow"), "1E07");
        hashMap.put(ASName.create("block"), "2588");
        hashMap.put(ASName.create("bmonospace"), "FF42");
        hashMap.put(ASName.create("bobaimaithai"), "0E1A");
        hashMap.put(ASName.create("bohiragana"), "307C");
        hashMap.put(ASName.create("bokatakana"), "30DC");
        hashMap.put(ASName.create("bparen"), "249D");
        hashMap.put(ASName.create("bqsquare"), "33C3");
        hashMap.put(ASName.create("braceex"), "F8F4");
        hashMap.put(ASName.create("braceleft"), "007B");
        hashMap.put(ASName.create("braceleftbt"), "F8F3");
        hashMap.put(ASName.create("braceleftmid"), "F8F2");
        hashMap.put(ASName.create("braceleftmonospace"), "FF5B");
        hashMap.put(ASName.create("braceleftsmall"), "FE5B");
        hashMap.put(ASName.create("bracelefttp"), "F8F1");
        hashMap.put(ASName.create("braceleftvertical"), "FE37");
        hashMap.put(ASName.create("braceright"), "007D");
        hashMap.put(ASName.create("bracerightbt"), "F8FE");
        hashMap.put(ASName.create("bracerightmid"), "F8FD");
        hashMap.put(ASName.create("bracerightmonospace"), "FF5D");
        hashMap.put(ASName.create("bracerightsmall"), "FE5C");
        hashMap.put(ASName.create("bracerighttp"), "F8FC");
        hashMap.put(ASName.create("bracerightvertical"), "FE38");
        hashMap.put(ASName.create("bracketleft"), "005B");
        hashMap.put(ASName.create("bracketleftbt"), "F8F0");
        hashMap.put(ASName.create("bracketleftex"), "F8EF");
        hashMap.put(ASName.create("bracketleftmonospace"), "FF3B");
        hashMap.put(ASName.create("bracketlefttp"), "F8EE");
        hashMap.put(ASName.create("bracketright"), "005D");
        hashMap.put(ASName.create("bracketrightbt"), "F8FB");
        hashMap.put(ASName.create("bracketrightex"), "F8FA");
        hashMap.put(ASName.create("bracketrightmonospace"), "FF3D");
        hashMap.put(ASName.create("bracketrighttp"), "F8F9");
        hashMap.put(ASName.create("breve"), "02D8");
        hashMap.put(ASName.create("brevebelowcmb"), "032E");
        hashMap.put(ASName.create("brevecmb"), "0306");
        hashMap.put(ASName.create("breveinvertedbelowcmb"), "032F");
        hashMap.put(ASName.create("breveinvertedcmb"), "0311");
        hashMap.put(ASName.create("breveinverteddoublecmb"), "0361");
        hashMap.put(ASName.create("bridgebelowcmb"), "032A");
        hashMap.put(ASName.create("bridgeinvertedbelowcmb"), "033A");
        hashMap.put(ASName.create("brokenbar"), "00A6");
        hashMap.put(ASName.create("bstroke"), "0180");
        hashMap.put(ASName.create("bsuperior"), "F6EA");
        hashMap.put(ASName.create("btopbar"), "0183");
        hashMap.put(ASName.create("buhiragana"), "3076");
        hashMap.put(ASName.create("bukatakana"), "30D6");
        hashMap.put(ASName.create("bullet"), "2022");
        hashMap.put(ASName.create("bulletinverse"), "25D8");
        hashMap.put(ASName.create("bulletoperator"), "2219");
        hashMap.put(ASName.create("bullseye"), "25CE");
        hashMap.put(ASName.create("c"), "0063");
        hashMap.put(ASName.create("caarmenian"), "056E");
        hashMap.put(ASName.create("cabengali"), "099A");
        hashMap.put(ASName.create("cacute"), "0107");
        hashMap.put(ASName.create("cadeva"), "091A");
        hashMap.put(ASName.create("cagujarati"), "0A9A");
        hashMap.put(ASName.create("cagurmukhi"), "0A1A");
        hashMap.put(ASName.create("calsquare"), "3388");
        hashMap.put(ASName.create("candrabindubengali"), "0981");
        hashMap.put(ASName.create("candrabinducmb"), "0310");
        hashMap.put(ASName.create("candrabindudeva"), "0901");
        hashMap.put(ASName.create("candrabindugujarati"), "0A81");
        hashMap.put(ASName.create("capslock"), "21EA");
        hashMap.put(ASName.create("careof"), "2105");
        hashMap.put(ASName.create("caron"), "02C7");
        hashMap.put(ASName.create("caronbelowcmb"), "032C");
        hashMap.put(ASName.create("caroncmb"), "030C");
        hashMap.put(ASName.create("carriagereturn"), "21B5");
        hashMap.put(ASName.create("cbopomofo"), "3118");
        hashMap.put(ASName.create("ccaron"), "010D");
        hashMap.put(ASName.create("ccedilla"), "00E7");
        hashMap.put(ASName.create("ccedillaacute"), "1E09");
        hashMap.put(ASName.create("ccircle"), "24D2");
        hashMap.put(ASName.create("ccircumflex"), "0109");
        hashMap.put(ASName.create("ccurl"), "0255");
        hashMap.put(ASName.create("cdot"), "010B");
        hashMap.put(ASName.create("cdotaccent"), "010B");
        hashMap.put(ASName.create("cdsquare"), "33C5");
        hashMap.put(ASName.create("cedilla"), "00B8");
        hashMap.put(ASName.create("cedillacmb"), "0327");
        hashMap.put(ASName.create("cent"), "00A2");
        hashMap.put(ASName.create("centigrade"), "2103");
        hashMap.put(ASName.create("centinferior"), "F6DF");
        hashMap.put(ASName.create("centmonospace"), "FFE0");
        hashMap.put(ASName.create("centoldstyle"), "F7A2");
        hashMap.put(ASName.create("centsuperior"), "F6E0");
        hashMap.put(ASName.create("chaarmenian"), "0579");
        hashMap.put(ASName.create("chabengali"), "099B");
        hashMap.put(ASName.create("chadeva"), "091B");
        hashMap.put(ASName.create("chagujarati"), "0A9B");
        hashMap.put(ASName.create("chagurmukhi"), "0A1B");
        hashMap.put(ASName.create("chbopomofo"), "3114");
        hashMap.put(ASName.create("cheabkhasiancyrillic"), "04BD");
        hashMap.put(ASName.create("checkmark"), "2713");
        hashMap.put(ASName.create("checyrillic"), "0447");
        hashMap.put(ASName.create("chedescenderabkhasiancyrillic"), "04BF");
        hashMap.put(ASName.create("chedescendercyrillic"), "04B7");
        hashMap.put(ASName.create("chedieresiscyrillic"), "04F5");
        hashMap.put(ASName.create("cheharmenian"), "0573");
        hashMap.put(ASName.create("chekhakassiancyrillic"), "04CC");
        hashMap.put(ASName.create("cheverticalstrokecyrillic"), "04B9");
        hashMap.put(ASName.create("chi"), "03C7");
        hashMap.put(ASName.create("chieuchacirclekorean"), "3277");
        hashMap.put(ASName.create("chieuchaparenkorean"), "3217");
        hashMap.put(ASName.create("chieuchcirclekorean"), "3269");
        hashMap.put(ASName.create("chieuchkorean"), "314A");
        hashMap.put(ASName.create("chieuchparenkorean"), "3209");
        hashMap.put(ASName.create("chochangthai"), "0E0A");
        hashMap.put(ASName.create("chochanthai"), "0E08");
        hashMap.put(ASName.create("chochingthai"), "0E09");
        hashMap.put(ASName.create("chochoethai"), "0E0C");
        hashMap.put(ASName.create("chook"), "0188");
        hashMap.put(ASName.create("cieucacirclekorean"), "3276");
        hashMap.put(ASName.create("cieucaparenkorean"), "3216");
        hashMap.put(ASName.create("cieuccirclekorean"), "3268");
        hashMap.put(ASName.create("cieuckorean"), "3148");
        hashMap.put(ASName.create("cieucparenkorean"), "3208");
        hashMap.put(ASName.create("cieucuparenkorean"), "321C");
        hashMap.put(ASName.create("circle"), "25CB");
        hashMap.put(ASName.create("circlemultiply"), "2297");
        hashMap.put(ASName.create("circleot"), "2299");
        hashMap.put(ASName.create("circleplus"), "2295");
        hashMap.put(ASName.create("circlepostalmark"), "3036");
        hashMap.put(ASName.create("circlewithlefthalfblack"), "25D0");
        hashMap.put(ASName.create("circlewithrighthalfblack"), "25D1");
        hashMap.put(ASName.create("circumflex"), "02C6");
        hashMap.put(ASName.create("circumflexbelowcmb"), "032D");
        hashMap.put(ASName.create("circumflexcmb"), "0302");
        hashMap.put(ASName.create("clear"), "2327");
        hashMap.put(ASName.create("clickalveolar"), "01C2");
        hashMap.put(ASName.create("clickdental"), "01C0");
        hashMap.put(ASName.create("clicklateral"), "01C1");
        hashMap.put(ASName.create("clickretroflex"), "01C3");
        hashMap.put(ASName.create("club"), "2663");
        hashMap.put(ASName.create("clubsuitblack"), "2663");
        hashMap.put(ASName.create("clubsuitwhite"), "2667");
        hashMap.put(ASName.create("cmcubedsquare"), "33A4");
        hashMap.put(ASName.create("cmonospace"), "FF43");
        hashMap.put(ASName.create("cmsquaredsquare"), "33A0");
        hashMap.put(ASName.create("coarmenian"), "0581");
        hashMap.put(ASName.create("colon"), "003A");
        hashMap.put(ASName.create("colonmonetary"), "20A1");
        hashMap.put(ASName.create("colonmonospace"), "FF1A");
        hashMap.put(ASName.create("colonsign"), "20A1");
        hashMap.put(ASName.create("colonsmall"), "FE55");
        hashMap.put(ASName.create("colontriangularhalfmod"), "02D1");
        hashMap.put(ASName.create("colontriangularmod"), "02D0");
        hashMap.put(ASName.create("comma"), "002C");
        hashMap.put(ASName.create("commaabovecmb"), "0313");
        hashMap.put(ASName.create("commaaboverightcmb"), "0315");
        hashMap.put(ASName.create("commaaccent"), "F6C3");
        hashMap.put(ASName.create("commaarabic"), "060C");
        hashMap.put(ASName.create("commaarmenian"), "055D");
        hashMap.put(ASName.create("commainferior"), "F6E1");
        hashMap.put(ASName.create("commamonospace"), "FF0C");
        hashMap.put(ASName.create("commareversedabovecmb"), "0314");
        hashMap.put(ASName.create("commareversedmod"), "02BD");
        hashMap.put(ASName.create("commasmall"), "FE50");
        hashMap.put(ASName.create("commasuperior"), "F6E2");
        hashMap.put(ASName.create("commaturnedabovecmb"), "0312");
        hashMap.put(ASName.create("commaturnedmod"), "02BB");
        hashMap.put(ASName.create("compass"), "263C");
        hashMap.put(ASName.create("congruent"), "2245");
        hashMap.put(ASName.create("contourintegral"), "222E");
        hashMap.put(ASName.create("control"), "2303");
        hashMap.put(ASName.create("controlACK"), "0006");
        hashMap.put(ASName.create("controlBEL"), "0007");
        hashMap.put(ASName.create("controlBS"), "0008");
        hashMap.put(ASName.create("controlCAN"), "0018");
        hashMap.put(ASName.create("controlCR"), "000D");
        hashMap.put(ASName.create("controlDC1"), "0011");
        hashMap.put(ASName.create("controlDC2"), "0012");
        hashMap.put(ASName.create("controlDC3"), "0013");
        hashMap.put(ASName.create("controlDC4"), "0014");
        hashMap.put(ASName.create("controlDEL"), "007F");
        hashMap.put(ASName.create("controlDLE"), "0010");
        hashMap.put(ASName.create("controlEM"), "0019");
        hashMap.put(ASName.create("controlENQ"), "0005");
        hashMap.put(ASName.create("controlEOT"), "0004");
        hashMap.put(ASName.create("controlESC"), "001B");
        hashMap.put(ASName.create("controlETB"), "0017");
        hashMap.put(ASName.create("controlETX"), "0003");
        hashMap.put(ASName.create("controlFF"), "000C");
        hashMap.put(ASName.create("controlFS"), "001C");
        hashMap.put(ASName.create("controlGS"), "001D");
        hashMap.put(ASName.create("controlHT"), "0009");
        hashMap.put(ASName.create("controlLF"), "000A");
        hashMap.put(ASName.create("controlNAK"), "0015");
        hashMap.put(ASName.create("controlRS"), "001E");
        hashMap.put(ASName.create("controlSI"), "000F");
        hashMap.put(ASName.create("controlSO"), "000E");
        hashMap.put(ASName.create("controlSOT"), "0002");
        hashMap.put(ASName.create("controlSTX"), "0001");
        hashMap.put(ASName.create("controlSUB"), "001A");
        hashMap.put(ASName.create("controlSYN"), "0016");
        hashMap.put(ASName.create("controlUS"), "001F");
        hashMap.put(ASName.create("controlVT"), "000B");
        hashMap.put(ASName.create("copyright"), "00A9");
        hashMap.put(ASName.create("copyrightsans"), "F8E9");
        hashMap.put(ASName.create("copyrightserif"), "F6D9");
        hashMap.put(ASName.create("cornerbracketleft"), "300C");
        hashMap.put(ASName.create("cornerbracketlefthalfwidth"), "FF62");
        hashMap.put(ASName.create("cornerbracketleftvertical"), "FE41");
        hashMap.put(ASName.create("cornerbracketright"), "300D");
        hashMap.put(ASName.create("cornerbracketrighthalfwidth"), "FF63");
        hashMap.put(ASName.create("cornerbracketrightvertical"), "FE42");
        hashMap.put(ASName.create("corporationsquare"), "337F");
        hashMap.put(ASName.create("cosquare"), "33C7");
        hashMap.put(ASName.create("coverkgsquare"), "33C6");
        hashMap.put(ASName.create("cparen"), "249E");
        hashMap.put(ASName.create("cruzeiro"), "20A2");
        hashMap.put(ASName.create("cstretched"), "0297");
        hashMap.put(ASName.create("curlyand"), "22CF");
        hashMap.put(ASName.create("curlyor"), "22CE");
        hashMap.put(ASName.create("currency"), "00A4");
        hashMap.put(ASName.create("cyrBreve"), "F6D1");
        hashMap.put(ASName.create("cyrFlex"), "F6D2");
        hashMap.put(ASName.create("cyrbreve"), "F6D4");
        hashMap.put(ASName.create("cyrflex"), "F6D5");
        hashMap.put(ASName.create("d"), "0064");
        hashMap.put(ASName.create("daarmenian"), "0564");
        hashMap.put(ASName.create("dabengali"), "09A6");
        hashMap.put(ASName.create("dadarabic"), "0636");
        hashMap.put(ASName.create("dadeva"), "0926");
        hashMap.put(ASName.create("dadfinalarabic"), "FEBE");
        hashMap.put(ASName.create("dadinitialarabic"), "FEBF");
        hashMap.put(ASName.create("dadmedialarabic"), "FEC0");
        hashMap.put(ASName.create("dagesh"), "05BC");
        hashMap.put(ASName.create("dageshhebrew"), "05BC");
        hashMap.put(ASName.create("dagger"), "2020");
        hashMap.put(ASName.create("daggerdbl"), "2021");
        hashMap.put(ASName.create("dagujarati"), "0AA6");
        hashMap.put(ASName.create("dagurmukhi"), "0A26");
        hashMap.put(ASName.create("dahiragana"), "3060");
        hashMap.put(ASName.create("dakatakana"), "30C0");
        hashMap.put(ASName.create("dalarabic"), "062F");
        hashMap.put(ASName.create("dalet"), "05D3");
        hashMap.put(ASName.create("daletdagesh"), "FB33");
        hashMap.put(ASName.create("daletdageshhebrew"), "FB33");
        hashMap.put(ASName.create("dalethatafpatah"), "05D305B2");
        hashMap.put(ASName.create("dalethatafpatahhebrew"), "05D305B2");
        hashMap.put(ASName.create("dalethatafsegol"), "05D305B1");
        hashMap.put(ASName.create("dalethatafsegolhebrew"), "05D305B1");
        hashMap.put(ASName.create("dalethebrew"), "05D3");
        hashMap.put(ASName.create("dalethiriq"), "05D305B4");
        hashMap.put(ASName.create("dalethiriqhebrew"), "05D305B4");
        hashMap.put(ASName.create("daletholam"), "05D305B9");
        hashMap.put(ASName.create("daletholamhebrew"), "05D305B9");
        hashMap.put(ASName.create("daletpatah"), "05D305B7");
        hashMap.put(ASName.create("daletpatahhebrew"), "05D305B7");
        hashMap.put(ASName.create("daletqamats"), "05D305B8");
        hashMap.put(ASName.create("daletqamatshebrew"), "05D305B8");
        hashMap.put(ASName.create("daletqubuts"), "05D305BB");
        hashMap.put(ASName.create("daletqubutshebrew"), "05D305BB");
        hashMap.put(ASName.create("daletsegol"), "05D305B6");
        hashMap.put(ASName.create("daletsegolhebrew"), "05D305B6");
        hashMap.put(ASName.create("daletsheva"), "05D305B0");
        hashMap.put(ASName.create("daletshevahebrew"), "05D305B0");
        hashMap.put(ASName.create("dalettsere"), "05D305B5");
        hashMap.put(ASName.create("dalettserehebrew"), "05D305B5");
        hashMap.put(ASName.create("dalfinalarabic"), "FEAA");
        hashMap.put(ASName.create("dammaarabic"), "064F");
        hashMap.put(ASName.create("dammalowarabic"), "064F");
        hashMap.put(ASName.create("dammatanaltonearabic"), "064C");
        hashMap.put(ASName.create("dammatanarabic"), "064C");
        hashMap.put(ASName.create("danda"), "0964");
        hashMap.put(ASName.create("dargahebrew"), "05A7");
        hashMap.put(ASName.create("dargalefthebrew"), "05A7");
        hashMap.put(ASName.create("dasiapneumatacyrilliccmb"), "0485");
        hashMap.put(ASName.create("dblGrave"), "F6D3");
        hashMap.put(ASName.create("dblanglebracketleft"), "300A");
        hashMap.put(ASName.create("dblanglebracketleftvertical"), "FE3D");
        hashMap.put(ASName.create("dblanglebracketright"), "300B");
        hashMap.put(ASName.create("dblanglebracketrightvertical"), "FE3E");
        hashMap.put(ASName.create("dblarchinvertedbelowcmb"), "032B");
        hashMap.put(ASName.create("dblarrowleft"), "21D4");
        hashMap.put(ASName.create("dblarrowright"), "21D2");
        hashMap.put(ASName.create("dbldanda"), "0965");
        hashMap.put(ASName.create("dblgrave"), "F6D6");
        hashMap.put(ASName.create("dblgravecmb"), "030F");
        hashMap.put(ASName.create("dblintegral"), "222C");
        hashMap.put(ASName.create("dbllowline"), "2017");
        hashMap.put(ASName.create("dbllowlinecmb"), "0333");
        hashMap.put(ASName.create("dbloverlinecmb"), "033F");
        hashMap.put(ASName.create("dblprimemod"), "02BA");
        hashMap.put(ASName.create("dblverticalbar"), "2016");
        hashMap.put(ASName.create("dblverticallineabovecmb"), "030E");
        hashMap.put(ASName.create("dbopomofo"), "3109");
        hashMap.put(ASName.create("dbsquare"), "33C8");
        hashMap.put(ASName.create("dcaron"), "010F");
        hashMap.put(ASName.create("dcedilla"), "1E11");
        hashMap.put(ASName.create("dcircle"), "24D3");
        hashMap.put(ASName.create("dcircumflexbelow"), "1E13");
        hashMap.put(ASName.create("dcroat"), "0111");
        hashMap.put(ASName.create("ddabengali"), "09A1");
        hashMap.put(ASName.create("ddadeva"), "0921");
        hashMap.put(ASName.create("ddagujarati"), "0AA1");
        hashMap.put(ASName.create("ddagurmukhi"), "0A21");
        hashMap.put(ASName.create("ddalarabic"), "0688");
        hashMap.put(ASName.create("ddalfinalarabic"), "FB89");
        hashMap.put(ASName.create("dddhadeva"), "095C");
        hashMap.put(ASName.create("ddhabengali"), "09A2");
        hashMap.put(ASName.create("ddhadeva"), "0922");
        hashMap.put(ASName.create("ddhagujarati"), "0AA2");
        hashMap.put(ASName.create("ddhagurmukhi"), "0A22");
        hashMap.put(ASName.create("ddotaccent"), "1E0B");
        hashMap.put(ASName.create("ddotbelow"), "1E0D");
        hashMap.put(ASName.create("decimalseparatorarabic"), "066B");
        hashMap.put(ASName.create("decimalseparatorpersian"), "066B");
        hashMap.put(ASName.create("decyrillic"), "0434");
        hashMap.put(ASName.create("degree"), "00B0");
        hashMap.put(ASName.create("dehihebrew"), "05AD");
        hashMap.put(ASName.create("dehiragana"), "3067");
        hashMap.put(ASName.create("deicoptic"), "03EF");
        hashMap.put(ASName.create("dekatakana"), "30C7");
        hashMap.put(ASName.create("deleteleft"), "232B");
        hashMap.put(ASName.create("deleteright"), "2326");
        hashMap.put(ASName.create("delta"), "03B4");
        hashMap.put(ASName.create("deltaturned"), "018D");
        hashMap.put(ASName.create("denominatorminusonenumeratorbengali"), "09F8");
        hashMap.put(ASName.create("dezh"), "02A4");
        hashMap.put(ASName.create("dhabengali"), "09A7");
        hashMap.put(ASName.create("dhadeva"), "0927");
        hashMap.put(ASName.create("dhagujarati"), "0AA7");
        hashMap.put(ASName.create("dhagurmukhi"), "0A27");
        hashMap.put(ASName.create("dhook"), "0257");
        hashMap.put(ASName.create("dialytikatonos"), "0385");
        hashMap.put(ASName.create("dialytikatonoscmb"), "0344");
        hashMap.put(ASName.create("diamond"), "2666");
        hashMap.put(ASName.create("diamondsuitwhite"), "2662");
        hashMap.put(ASName.create("dieresis"), "00A8");
        hashMap.put(ASName.create("dieresisacute"), "F6D7");
        hashMap.put(ASName.create("dieresisbelowcmb"), "0324");
        hashMap.put(ASName.create("dieresiscmb"), "0308");
        hashMap.put(ASName.create("dieresisgrave"), "F6D8");
        hashMap.put(ASName.create("dieresistonos"), "0385");
        hashMap.put(ASName.create("dihiragana"), "3062");
        hashMap.put(ASName.create("dikatakana"), "30C2");
        hashMap.put(ASName.create("dittomark"), "3003");
        hashMap.put(ASName.create("divide"), "00F7");
        hashMap.put(ASName.create("divides"), "2223");
        hashMap.put(ASName.create("divisionslash"), "2215");
        hashMap.put(ASName.create("djecyrillic"), "0452");
        hashMap.put(ASName.create("dkshade"), "2593");
        hashMap.put(ASName.create("dlinebelow"), "1E0F");
        hashMap.put(ASName.create("dlsquare"), "3397");
        hashMap.put(ASName.create("dmacron"), "0111");
        hashMap.put(ASName.create("dmonospace"), "FF44");
        hashMap.put(ASName.create("dnblock"), "2584");
        hashMap.put(ASName.create("dochadathai"), "0E0E");
        hashMap.put(ASName.create("dodekthai"), "0E14");
        hashMap.put(ASName.create("dohiragana"), "3069");
        hashMap.put(ASName.create("dokatakana"), "30C9");
        hashMap.put(ASName.create("dollar"), "0024");
        hashMap.put(ASName.create("dollarinferior"), "F6E3");
        hashMap.put(ASName.create("dollarmonospace"), "FF04");
        hashMap.put(ASName.create("dollaroldstyle"), "F724");
        hashMap.put(ASName.create("dollarsmall"), "FE69");
        hashMap.put(ASName.create("dollarsuperior"), "F6E4");
        hashMap.put(ASName.create("dong"), "20AB");
        hashMap.put(ASName.create("dorusquare"), "3326");
        hashMap.put(ASName.create("dotaccent"), "02D9");
        hashMap.put(ASName.create("dotaccentcmb"), "0307");
        hashMap.put(ASName.create("dotbelowcmb"), "0323");
        hashMap.put(ASName.create("dotbelowcomb"), "0323");
        hashMap.put(ASName.create("dotkatakana"), "30FB");
        hashMap.put(ASName.create("dotlessi"), "0131");
        hashMap.put(ASName.create("dotlessj"), "F6BE");
        hashMap.put(ASName.create("dotlessjstrokehook"), "0284");
        hashMap.put(ASName.create("dotmath"), "22C5");
        hashMap.put(ASName.create("dottedcircle"), "25CC");
        hashMap.put(ASName.create("doubleyodpatah"), "FB1F");
        hashMap.put(ASName.create("doubleyodpatahhebrew"), "FB1F");
        hashMap.put(ASName.create("downtackbelowcmb"), "031E");
        hashMap.put(ASName.create("downtackmod"), "02D5");
        hashMap.put(ASName.create("dparen"), "249F");
        hashMap.put(ASName.create("dsuperior"), "F6EB");
        hashMap.put(ASName.create("dtail"), "0256");
        hashMap.put(ASName.create("dtopbar"), "018C");
        hashMap.put(ASName.create("duhiragana"), "3065");
        hashMap.put(ASName.create("dukatakana"), "30C5");
        hashMap.put(ASName.create("dz"), "01F3");
        hashMap.put(ASName.create("dzaltone"), "02A3");
        hashMap.put(ASName.create("dzcaron"), "01C6");
        hashMap.put(ASName.create("dzcurl"), "02A5");
        hashMap.put(ASName.create("dzeabkhasiancyrillic"), "04E1");
        hashMap.put(ASName.create("dzecyrillic"), "0455");
        hashMap.put(ASName.create("dzhecyrillic"), "045F");
        hashMap.put(ASName.create("e"), "0065");
        hashMap.put(ASName.create("eacute"), "00E9");
        hashMap.put(ASName.create("earth"), "2641");
        hashMap.put(ASName.create("ebengali"), "098F");
        hashMap.put(ASName.create("ebopomofo"), "311C");
        hashMap.put(ASName.create("ebreve"), "0115");
        hashMap.put(ASName.create("ecandradeva"), "090D");
        hashMap.put(ASName.create("ecandragujarati"), "0A8D");
        hashMap.put(ASName.create("ecandravowelsigndeva"), "0945");
        hashMap.put(ASName.create("ecandravowelsigngujarati"), "0AC5");
        hashMap.put(ASName.create("ecaron"), "011B");
        hashMap.put(ASName.create("ecedillabreve"), "1E1D");
        hashMap.put(ASName.create("echarmenian"), "0565");
        hashMap.put(ASName.create("echyiwnarmenian"), "0587");
        hashMap.put(ASName.create("ecircle"), "24D4");
        hashMap.put(ASName.create("ecircumflex"), "00EA");
        hashMap.put(ASName.create("ecircumflexacute"), "1EBF");
        hashMap.put(ASName.create("ecircumflexbelow"), "1E19");
        hashMap.put(ASName.create("ecircumflexdotbelow"), "1EC7");
        hashMap.put(ASName.create("ecircumflexgrave"), "1EC1");
        hashMap.put(ASName.create("ecircumflexhookabove"), "1EC3");
        hashMap.put(ASName.create("ecircumflextilde"), "1EC5");
        hashMap.put(ASName.create("ecyrillic"), "0454");
        hashMap.put(ASName.create("edblgrave"), "0205");
        hashMap.put(ASName.create("edeva"), "090F");
        hashMap.put(ASName.create("edieresis"), "00EB");
        hashMap.put(ASName.create("edot"), "0117");
        hashMap.put(ASName.create("edotaccent"), "0117");
        hashMap.put(ASName.create("edotbelow"), "1EB9");
        hashMap.put(ASName.create("eegurmukhi"), "0A0F");
        hashMap.put(ASName.create("eematragurmukhi"), "0A47");
        hashMap.put(ASName.create("efcyrillic"), "0444");
        hashMap.put(ASName.create("egrave"), "00E8");
        hashMap.put(ASName.create("egujarati"), "0A8F");
        hashMap.put(ASName.create("eharmenian"), "0567");
        hashMap.put(ASName.create("ehbopomofo"), "311D");
        hashMap.put(ASName.create("ehiragana"), "3048");
        hashMap.put(ASName.create("ehookabove"), "1EBB");
        hashMap.put(ASName.create("eibopomofo"), "311F");
        hashMap.put(ASName.create("eight"), "0038");
        hashMap.put(ASName.create("eightarabic"), "0668");
        hashMap.put(ASName.create("eightbengali"), "09EE");
        hashMap.put(ASName.create("eightcircle"), "2467");
        hashMap.put(ASName.create("eightcircleinversesansserif"), "2791");
        hashMap.put(ASName.create("eightdeva"), "096E");
        hashMap.put(ASName.create("eighteencircle"), "2471");
        hashMap.put(ASName.create("eighteenparen"), "2485");
        hashMap.put(ASName.create("eighteenperiod"), "2499");
        hashMap.put(ASName.create("eightgujarati"), "0AEE");
        hashMap.put(ASName.create("eightgurmukhi"), "0A6E");
        hashMap.put(ASName.create("eighthackarabic"), "0668");
        hashMap.put(ASName.create("eighthangzhou"), "3028");
        hashMap.put(ASName.create("eighthnotebeamed"), "266B");
        hashMap.put(ASName.create("eightideographicparen"), "3227");
        hashMap.put(ASName.create("eightinferior"), "2088");
        hashMap.put(ASName.create("eightmonospace"), "FF18");
        hashMap.put(ASName.create("eightoldstyle"), "F738");
        hashMap.put(ASName.create("eightparen"), "247B");
        hashMap.put(ASName.create("eightperiod"), "248F");
        hashMap.put(ASName.create("eightpersian"), "06F8");
        hashMap.put(ASName.create("eightroman"), "2177");
        hashMap.put(ASName.create("eightsuperior"), "2078");
        hashMap.put(ASName.create("eightthai"), "0E58");
        hashMap.put(ASName.create("einvertedbreve"), "0207");
        hashMap.put(ASName.create("eiotifiedcyrillic"), "0465");
        hashMap.put(ASName.create("ekatakana"), "30A8");
        hashMap.put(ASName.create("ekatakanahalfwidth"), "FF74");
        hashMap.put(ASName.create("ekonkargurmukhi"), "0A74");
        hashMap.put(ASName.create("ekorean"), "3154");
        hashMap.put(ASName.create("elcyrillic"), "043B");
        hashMap.put(ASName.create("element"), "2208");
        hashMap.put(ASName.create("elevencircle"), "246A");
        hashMap.put(ASName.create("elevenparen"), "247E");
        hashMap.put(ASName.create("elevenperiod"), "2492");
        hashMap.put(ASName.create("elevenroman"), "217A");
        hashMap.put(ASName.create("ellipsis"), "2026");
        hashMap.put(ASName.create("ellipsisvertical"), "22EE");
        hashMap.put(ASName.create("emacron"), "0113");
        hashMap.put(ASName.create("emacronacute"), "1E17");
        hashMap.put(ASName.create("emacrongrave"), "1E15");
        hashMap.put(ASName.create("emcyrillic"), "043C");
        hashMap.put(ASName.create("emdash"), "2014");
        hashMap.put(ASName.create("emdashvertical"), "FE31");
        hashMap.put(ASName.create("emonospace"), "FF45");
        hashMap.put(ASName.create("emphasismarkarmenian"), "055B");
        hashMap.put(ASName.create("emptyset"), "2205");
        hashMap.put(ASName.create("enbopomofo"), "3123");
        hashMap.put(ASName.create("encyrillic"), "043D");
        hashMap.put(ASName.create("endash"), "2013");
        hashMap.put(ASName.create("endashvertical"), "FE32");
        hashMap.put(ASName.create("endescendercyrillic"), "04A3");
        hashMap.put(ASName.create("eng"), "014B");
        hashMap.put(ASName.create("engbopomofo"), "3125");
        hashMap.put(ASName.create("enghecyrillic"), "04A5");
        hashMap.put(ASName.create("enhookcyrillic"), "04C8");
        hashMap.put(ASName.create("enspace"), "2002");
        hashMap.put(ASName.create("eogonek"), "0119");
        hashMap.put(ASName.create("eokorean"), "3153");
        hashMap.put(ASName.create("eopen"), "025B");
        hashMap.put(ASName.create("eopenclosed"), "029A");
        hashMap.put(ASName.create("eopenreversed"), "025C");
        hashMap.put(ASName.create("eopenreversedclosed"), "025E");
        hashMap.put(ASName.create("eopenreversedhook"), "025D");
        hashMap.put(ASName.create("eparen"), "24A0");
        hashMap.put(ASName.create("epsilon"), "03B5");
        hashMap.put(ASName.create("epsilontonos"), "03AD");
        hashMap.put(ASName.create("equal"), "003D");
        hashMap.put(ASName.create("equalmonospace"), "FF1D");
        hashMap.put(ASName.create("equalsmall"), "FE66");
        hashMap.put(ASName.create("equalsuperior"), "207C");
        hashMap.put(ASName.create("equivalence"), "2261");
        hashMap.put(ASName.create("erbopomofo"), "3126");
        hashMap.put(ASName.create("ercyrillic"), "0440");
        hashMap.put(ASName.create("ereversed"), "0258");
        hashMap.put(ASName.create("ereversedcyrillic"), "044D");
        hashMap.put(ASName.create("escyrillic"), "0441");
        hashMap.put(ASName.create("esdescendercyrillic"), "04AB");
        hashMap.put(ASName.create("esh"), "0283");
        hashMap.put(ASName.create("eshcurl"), "0286");
        hashMap.put(ASName.create("eshortdeva"), "090E");
        hashMap.put(ASName.create("eshortvowelsigndeva"), "0946");
        hashMap.put(ASName.create("eshreversedloop"), "01AA");
        hashMap.put(ASName.create("eshsquatreversed"), "0285");
        hashMap.put(ASName.create("esmallhiragana"), "3047");
        hashMap.put(ASName.create("esmallkatakana"), "30A7");
        hashMap.put(ASName.create("esmallkatakanahalfwidth"), "FF6A");
        hashMap.put(ASName.create("estimated"), "212E");
        hashMap.put(ASName.create("esuperior"), "F6EC");
        hashMap.put(ASName.create("eta"), "03B7");
        hashMap.put(ASName.create("etarmenian"), "0568");
        hashMap.put(ASName.create("etatonos"), "03AE");
        hashMap.put(ASName.create("eth"), "00F0");
        hashMap.put(ASName.create("etilde"), "1EBD");
        hashMap.put(ASName.create("etildebelow"), "1E1B");
        hashMap.put(ASName.create("etnahtafoukhhebrew"), "0591");
        hashMap.put(ASName.create("etnahtafoukhlefthebrew"), "0591");
        hashMap.put(ASName.create("etnahtahebrew"), "0591");
        hashMap.put(ASName.create("etnahtalefthebrew"), "0591");
        hashMap.put(ASName.create("eturned"), "01DD");
        hashMap.put(ASName.create("eukorean"), "3161");
        hashMap.put(ASName.create("euro"), "20AC");
        hashMap.put(ASName.create("evowelsignbengali"), "09C7");
        hashMap.put(ASName.create("evowelsigndeva"), "0947");
        hashMap.put(ASName.create("evowelsigngujarati"), "0AC7");
        hashMap.put(ASName.create("exclam"), "0021");
        hashMap.put(ASName.create("exclamarmenian"), "055C");
        hashMap.put(ASName.create("exclamdbl"), "203C");
        hashMap.put(ASName.create("exclamdown"), "00A1");
        hashMap.put(ASName.create("exclamdownsmall"), "F7A1");
        hashMap.put(ASName.create("exclammonospace"), "FF01");
        hashMap.put(ASName.create("exclamsmall"), "F721");
        hashMap.put(ASName.create("existential"), "2203");
        hashMap.put(ASName.create("ezh"), "0292");
        hashMap.put(ASName.create("ezhcaron"), "01EF");
        hashMap.put(ASName.create("ezhcurl"), "0293");
        hashMap.put(ASName.create("ezhreversed"), "01B9");
        hashMap.put(ASName.create("ezhtail"), "01BA");
        hashMap.put(ASName.create("f"), "0066");
        hashMap.put(ASName.create("fadeva"), "095E");
        hashMap.put(ASName.create("fagurmukhi"), "0A5E");
        hashMap.put(ASName.create("fahrenheit"), "2109");
        hashMap.put(ASName.create("fathaarabic"), "064E");
        hashMap.put(ASName.create("fathalowarabic"), "064E");
        hashMap.put(ASName.create("fathatanarabic"), "064B");
        hashMap.put(ASName.create("fbopomofo"), "3108");
        hashMap.put(ASName.create("fcircle"), "24D5");
        hashMap.put(ASName.create("fdotaccent"), "1E1F");
        hashMap.put(ASName.create("feharabic"), "0641");
        hashMap.put(ASName.create("feharmenian"), "0586");
        hashMap.put(ASName.create("fehfinalarabic"), "FED2");
        hashMap.put(ASName.create("fehinitialarabic"), "FED3");
        hashMap.put(ASName.create("fehmedialarabic"), "FED4");
        hashMap.put(ASName.create("feicoptic"), "03E5");
        hashMap.put(ASName.create("female"), "2640");
        hashMap.put(ASName.create("ff"), "FB00");
        hashMap.put(ASName.create("ffi"), "FB03");
        hashMap.put(ASName.create("ffl"), "FB04");
        hashMap.put(ASName.create("fi"), "FB01");
        hashMap.put(ASName.create("fifteencircle"), "246E");
        hashMap.put(ASName.create("fifteenparen"), "2482");
        hashMap.put(ASName.create("fifteenperiod"), "2496");
        hashMap.put(ASName.create("figuredash"), "2012");
        hashMap.put(ASName.create("filledbox"), "25A0");
        hashMap.put(ASName.create("filledrect"), "25AC");
        hashMap.put(ASName.create("finalkaf"), "05DA");
        hashMap.put(ASName.create("finalkafdagesh"), "FB3A");
        hashMap.put(ASName.create("finalkafdageshhebrew"), "FB3A");
        hashMap.put(ASName.create("finalkafhebrew"), "05DA");
        hashMap.put(ASName.create("finalkafqamats"), "05DA05B8");
        hashMap.put(ASName.create("finalkafqamatshebrew"), "05DA05B8");
        hashMap.put(ASName.create("finalkafsheva"), "05DA05B0");
        hashMap.put(ASName.create("finalkafshevahebrew"), "05DA05B0");
        hashMap.put(ASName.create("finalmem"), "05DD");
        hashMap.put(ASName.create("finalmemhebrew"), "05DD");
        hashMap.put(ASName.create("finalnun"), "05DF");
        hashMap.put(ASName.create("finalnunhebrew"), "05DF");
        hashMap.put(ASName.create("finalpe"), "05E3");
        hashMap.put(ASName.create("finalpehebrew"), "05E3");
        hashMap.put(ASName.create("finaltsadi"), "05E5");
        hashMap.put(ASName.create("finaltsadihebrew"), "05E5");
        hashMap.put(ASName.create("firsttonechinese"), "02C9");
        hashMap.put(ASName.create("fisheye"), "25C9");
        hashMap.put(ASName.create("fitacyrillic"), "0473");
        hashMap.put(ASName.create("five"), "0035");
        hashMap.put(ASName.create("fivearabic"), "0665");
        hashMap.put(ASName.create("fivebengali"), "09EB");
        hashMap.put(ASName.create("fivecircle"), "2464");
        hashMap.put(ASName.create("fivecircleinversesansserif"), "278E");
        hashMap.put(ASName.create("fivedeva"), "096B");
        hashMap.put(ASName.create("fiveeighths"), "215D");
        hashMap.put(ASName.create("fivegujarati"), "0AEB");
        hashMap.put(ASName.create("fivegurmukhi"), "0A6B");
        hashMap.put(ASName.create("fivehackarabic"), "0665");
        hashMap.put(ASName.create("fivehangzhou"), "3025");
        hashMap.put(ASName.create("fiveideographicparen"), "3224");
        hashMap.put(ASName.create("fiveinferior"), "2085");
        hashMap.put(ASName.create("fivemonospace"), "FF15");
        hashMap.put(ASName.create("fiveoldstyle"), "F735");
        hashMap.put(ASName.create("fiveparen"), "2478");
        hashMap.put(ASName.create("fiveperiod"), "248C");
        hashMap.put(ASName.create("fivepersian"), "06F5");
        hashMap.put(ASName.create("fiveroman"), "2174");
        hashMap.put(ASName.create("fivesuperior"), "2075");
        hashMap.put(ASName.create("fivethai"), "0E55");
        hashMap.put(ASName.create("fl"), "FB02");
        hashMap.put(ASName.create("florin"), "0192");
        hashMap.put(ASName.create("fmonospace"), "FF46");
        hashMap.put(ASName.create("fmsquare"), "3399");
        hashMap.put(ASName.create("fofanthai"), "0E1F");
        hashMap.put(ASName.create("fofathai"), "0E1D");
        hashMap.put(ASName.create("fongmanthai"), "0E4F");
        hashMap.put(ASName.create("forall"), "2200");
        hashMap.put(ASName.create("four"), "0034");
        hashMap.put(ASName.create("fourarabic"), "0664");
        hashMap.put(ASName.create("fourbengali"), "09EA");
        hashMap.put(ASName.create("fourcircle"), "2463");
        hashMap.put(ASName.create("fourcircleinversesansserif"), "278D");
        hashMap.put(ASName.create("fourdeva"), "096A");
        hashMap.put(ASName.create("fourgujarati"), "0AEA");
        hashMap.put(ASName.create("fourgurmukhi"), "0A6A");
        hashMap.put(ASName.create("fourhackarabic"), "0664");
        hashMap.put(ASName.create("fourhangzhou"), "3024");
        hashMap.put(ASName.create("fourideographicparen"), "3223");
        hashMap.put(ASName.create("fourinferior"), "2084");
        hashMap.put(ASName.create("fourmonospace"), "FF14");
        hashMap.put(ASName.create("fournumeratorbengali"), "09F7");
        hashMap.put(ASName.create("fouroldstyle"), "F734");
        hashMap.put(ASName.create("fourparen"), "2477");
        hashMap.put(ASName.create("fourperiod"), "248B");
        hashMap.put(ASName.create("fourpersian"), "06F4");
        hashMap.put(ASName.create("fourroman"), "2173");
        hashMap.put(ASName.create("foursuperior"), "2074");
        hashMap.put(ASName.create("fourteencircle"), "246D");
        hashMap.put(ASName.create("fourteenparen"), "2481");
        hashMap.put(ASName.create("fourteenperiod"), "2495");
        hashMap.put(ASName.create("fourthai"), "0E54");
        hashMap.put(ASName.create("fourthtonechinese"), "02CB");
        hashMap.put(ASName.create("fparen"), "24A1");
        hashMap.put(ASName.create("fraction"), "2044");
        hashMap.put(ASName.create("franc"), "20A3");
    }

    /*
     * Opcode count of 14222 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static void initList2(HashMap hashMap) {
        hashMap.put(ASName.create("g"), "0067");
        hashMap.put(ASName.create("gabengali"), "0997");
        hashMap.put(ASName.create("gacute"), "01F5");
        hashMap.put(ASName.create("gadeva"), "0917");
        hashMap.put(ASName.create("gafarabic"), "06AF");
        hashMap.put(ASName.create("gaffinalarabic"), "FB93");
        hashMap.put(ASName.create("gafinitialarabic"), "FB94");
        hashMap.put(ASName.create("gafmedialarabic"), "FB95");
        hashMap.put(ASName.create("gagujarati"), "0A97");
        hashMap.put(ASName.create("gagurmukhi"), "0A17");
        hashMap.put(ASName.create("gahiragana"), "304C");
        hashMap.put(ASName.create("gakatakana"), "30AC");
        hashMap.put(ASName.create("gamma"), "03B3");
        hashMap.put(ASName.create("gammalatinsmall"), "0263");
        hashMap.put(ASName.create("gammasuperior"), "02E0");
        hashMap.put(ASName.create("gangiacoptic"), "03EB");
        hashMap.put(ASName.create("gbopomofo"), "310D");
        hashMap.put(ASName.create("gbreve"), "011F");
        hashMap.put(ASName.create("gcaron"), "01E7");
        hashMap.put(ASName.create("gcedilla"), "0123");
        hashMap.put(ASName.create("gcircle"), "24D6");
        hashMap.put(ASName.create("gcircumflex"), "011D");
        hashMap.put(ASName.create("gcommaaccent"), "0123");
        hashMap.put(ASName.create("gdot"), "0121");
        hashMap.put(ASName.create("gdotaccent"), "0121");
        hashMap.put(ASName.create("gecyrillic"), "0433");
        hashMap.put(ASName.create("gehiragana"), "3052");
        hashMap.put(ASName.create("gekatakana"), "30B2");
        hashMap.put(ASName.create("geometricallyequal"), "2251");
        hashMap.put(ASName.create("gereshaccenthebrew"), "059C");
        hashMap.put(ASName.create("gereshhebrew"), "05F3");
        hashMap.put(ASName.create("gereshmuqdamhebrew"), "059D");
        hashMap.put(ASName.create("germandbls"), "00DF");
        hashMap.put(ASName.create("gershayimaccenthebrew"), "059E");
        hashMap.put(ASName.create("gershayimhebrew"), "05F4");
        hashMap.put(ASName.create("getamark"), "3013");
        hashMap.put(ASName.create("ghabengali"), "0998");
        hashMap.put(ASName.create("ghadarmenian"), "0572");
        hashMap.put(ASName.create("ghadeva"), "0918");
        hashMap.put(ASName.create("ghagujarati"), "0A98");
        hashMap.put(ASName.create("ghagurmukhi"), "0A18");
        hashMap.put(ASName.create("ghainarabic"), "063A");
        hashMap.put(ASName.create("ghainfinalarabic"), "FECE");
        hashMap.put(ASName.create("ghaininitialarabic"), "FECF");
        hashMap.put(ASName.create("ghainmedialarabic"), "FED0");
        hashMap.put(ASName.create("ghemiddlehookcyrillic"), "0495");
        hashMap.put(ASName.create("ghestrokecyrillic"), "0493");
        hashMap.put(ASName.create("gheupturncyrillic"), "0491");
        hashMap.put(ASName.create("ghhadeva"), "095A");
        hashMap.put(ASName.create("ghhagurmukhi"), "0A5A");
        hashMap.put(ASName.create("ghook"), "0260");
        hashMap.put(ASName.create("ghzsquare"), "3393");
        hashMap.put(ASName.create("gihiragana"), "304E");
        hashMap.put(ASName.create("gikatakana"), "30AE");
        hashMap.put(ASName.create("gimarmenian"), "0563");
        hashMap.put(ASName.create("gimel"), "05D2");
        hashMap.put(ASName.create("gimeldagesh"), "FB32");
        hashMap.put(ASName.create("gimeldageshhebrew"), "FB32");
        hashMap.put(ASName.create("gimelhebrew"), "05D2");
        hashMap.put(ASName.create("gjecyrillic"), "0453");
        hashMap.put(ASName.create("glottalinvertedstroke"), "01BE");
        hashMap.put(ASName.create("glottalstop"), "0294");
        hashMap.put(ASName.create("glottalstopinverted"), "0296");
        hashMap.put(ASName.create("glottalstopmod"), "02C0");
        hashMap.put(ASName.create("glottalstopreversed"), "0295");
        hashMap.put(ASName.create("glottalstopreversedmod"), "02C1");
        hashMap.put(ASName.create("glottalstopreversedsuperior"), "02E4");
        hashMap.put(ASName.create("glottalstopstroke"), "02A1");
        hashMap.put(ASName.create("glottalstopstrokereversed"), "02A2");
        hashMap.put(ASName.create("gmacron"), "1E21");
        hashMap.put(ASName.create("gmonospace"), "FF47");
        hashMap.put(ASName.create("gohiragana"), "3054");
        hashMap.put(ASName.create("gokatakana"), "30B4");
        hashMap.put(ASName.create("gparen"), "24A2");
        hashMap.put(ASName.create("gpasquare"), "33AC");
        hashMap.put(ASName.create("gradient"), "2207");
        hashMap.put(ASName.create("grave"), "0060");
        hashMap.put(ASName.create("gravebelowcmb"), "0316");
        hashMap.put(ASName.create("gravecmb"), "0300");
        hashMap.put(ASName.create("gravecomb"), "0300");
        hashMap.put(ASName.create("gravedeva"), "0953");
        hashMap.put(ASName.create("gravelowmod"), "02CE");
        hashMap.put(ASName.create("gravemonospace"), "FF40");
        hashMap.put(ASName.create("gravetonecmb"), "0340");
        hashMap.put(ASName.create("greater"), "003E");
        hashMap.put(ASName.create("greaterequal"), "2265");
        hashMap.put(ASName.create("greaterequalorless"), "22DB");
        hashMap.put(ASName.create("greatermonospace"), "FF1E");
        hashMap.put(ASName.create("greaterorequivalent"), "2273");
        hashMap.put(ASName.create("greaterorless"), "2277");
        hashMap.put(ASName.create("greateroverequal"), "2267");
        hashMap.put(ASName.create("greatersmall"), "FE65");
        hashMap.put(ASName.create("gscript"), "0261");
        hashMap.put(ASName.create("gstroke"), "01E5");
        hashMap.put(ASName.create("guhiragana"), "3050");
        hashMap.put(ASName.create("guillemotleft"), "00AB");
        hashMap.put(ASName.create("guillemotright"), "00BB");
        hashMap.put(ASName.create("guilsinglleft"), "2039");
        hashMap.put(ASName.create("guilsinglright"), "203A");
        hashMap.put(ASName.create("gukatakana"), "30B0");
        hashMap.put(ASName.create("guramusquare"), "3318");
        hashMap.put(ASName.create("gysquare"), "33C9");
        hashMap.put(ASName.create("h"), "0068");
        hashMap.put(ASName.create("haabkhasiancyrillic"), "04A9");
        hashMap.put(ASName.create("haaltonearabic"), "06C1");
        hashMap.put(ASName.create("habengali"), "09B9");
        hashMap.put(ASName.create("hadescendercyrillic"), "04B3");
        hashMap.put(ASName.create("hadeva"), "0939");
        hashMap.put(ASName.create("hagujarati"), "0AB9");
        hashMap.put(ASName.create("hagurmukhi"), "0A39");
        hashMap.put(ASName.create("haharabic"), "062D");
        hashMap.put(ASName.create("hahfinalarabic"), "FEA2");
        hashMap.put(ASName.create("hahinitialarabic"), "FEA3");
        hashMap.put(ASName.create("hahiragana"), "306F");
        hashMap.put(ASName.create("hahmedialarabic"), "FEA4");
        hashMap.put(ASName.create("haitusquare"), "332A");
        hashMap.put(ASName.create("hakatakana"), "30CF");
        hashMap.put(ASName.create("hakatakanahalfwidth"), "FF8A");
        hashMap.put(ASName.create("halantgurmukhi"), "0A4D");
        hashMap.put(ASName.create("hamzaarabic"), "0621");
        hashMap.put(ASName.create("hamzadammaarabic"), "0621064F");
        hashMap.put(ASName.create("hamzadammatanarabic"), "0621064C");
        hashMap.put(ASName.create("hamzafathaarabic"), "0621064E");
        hashMap.put(ASName.create("hamzafathatanarabic"), "0621064B");
        hashMap.put(ASName.create("hamzalowarabic"), "0621");
        hashMap.put(ASName.create("hamzalowkasraarabic"), "06210650");
        hashMap.put(ASName.create("hamzalowkasratanarabic"), "0621064D");
        hashMap.put(ASName.create("hamzasukunarabic"), "06210652");
        hashMap.put(ASName.create("hangulfiller"), "3164");
        hashMap.put(ASName.create("hardsigncyrillic"), "044A");
        hashMap.put(ASName.create("harpoonleftbarbup"), "21BC");
        hashMap.put(ASName.create("harpoonrightbarbup"), "21C0");
        hashMap.put(ASName.create("hasquare"), "33CA");
        hashMap.put(ASName.create("hatafpatah"), "05B2");
        hashMap.put(ASName.create("hatafpatah16"), "05B2");
        hashMap.put(ASName.create("hatafpatah23"), "05B2");
        hashMap.put(ASName.create("hatafpatah2f"), "05B2");
        hashMap.put(ASName.create("hatafpatahhebrew"), "05B2");
        hashMap.put(ASName.create("hatafpatahnarrowhebrew"), "05B2");
        hashMap.put(ASName.create("hatafpatahquarterhebrew"), "05B2");
        hashMap.put(ASName.create("hatafpatahwidehebrew"), "05B2");
        hashMap.put(ASName.create("hatafqamats"), "05B3");
        hashMap.put(ASName.create("hatafqamats1b"), "05B3");
        hashMap.put(ASName.create("hatafqamats28"), "05B3");
        hashMap.put(ASName.create("hatafqamats34"), "05B3");
        hashMap.put(ASName.create("hatafqamatshebrew"), "05B3");
        hashMap.put(ASName.create("hatafqamatsnarrowhebrew"), "05B3");
        hashMap.put(ASName.create("hatafqamatsquarterhebrew"), "05B3");
        hashMap.put(ASName.create("hatafqamatswidehebrew"), "05B3");
        hashMap.put(ASName.create("hatafsegol"), "05B1");
        hashMap.put(ASName.create("hatafsegol17"), "05B1");
        hashMap.put(ASName.create("hatafsegol24"), "05B1");
        hashMap.put(ASName.create("hatafsegol30"), "05B1");
        hashMap.put(ASName.create("hatafsegolhebrew"), "05B1");
        hashMap.put(ASName.create("hatafsegolnarrowhebrew"), "05B1");
        hashMap.put(ASName.create("hatafsegolquarterhebrew"), "05B1");
        hashMap.put(ASName.create("hatafsegolwidehebrew"), "05B1");
        hashMap.put(ASName.create("hbar"), "0127");
        hashMap.put(ASName.create("hbopomofo"), "310F");
        hashMap.put(ASName.create("hbrevebelow"), "1E2B");
        hashMap.put(ASName.create("hcedilla"), "1E29");
        hashMap.put(ASName.create("hcircle"), "24D7");
        hashMap.put(ASName.create("hcircumflex"), "0125");
        hashMap.put(ASName.create("hdieresis"), "1E27");
        hashMap.put(ASName.create("hdotaccent"), "1E23");
        hashMap.put(ASName.create("hdotbelow"), "1E25");
        hashMap.put(ASName.create("he"), "05D4");
        hashMap.put(ASName.create("heart"), "2665");
        hashMap.put(ASName.create("heartsuitblack"), "2665");
        hashMap.put(ASName.create("heartsuitwhite"), "2661");
        hashMap.put(ASName.create("hedagesh"), "FB34");
        hashMap.put(ASName.create("hedageshhebrew"), "FB34");
        hashMap.put(ASName.create("hehaltonearabic"), "06C1");
        hashMap.put(ASName.create("heharabic"), "0647");
        hashMap.put(ASName.create("hehebrew"), "05D4");
        hashMap.put(ASName.create("hehfinalaltonearabic"), "FBA7");
        hashMap.put(ASName.create("hehfinalalttwoarabic"), "FEEA");
        hashMap.put(ASName.create("hehfinalarabic"), "FEEA");
        hashMap.put(ASName.create("hehhamzaabovefinalarabic"), "FBA5");
        hashMap.put(ASName.create("hehhamzaaboveisolatedarabic"), "FBA4");
        hashMap.put(ASName.create("hehinitialaltonearabic"), "FBA8");
        hashMap.put(ASName.create("hehinitialarabic"), "FEEB");
        hashMap.put(ASName.create("hehiragana"), "3078");
        hashMap.put(ASName.create("hehmedialaltonearabic"), "FBA9");
        hashMap.put(ASName.create("hehmedialarabic"), "FEEC");
        hashMap.put(ASName.create("heiseierasquare"), "337B");
        hashMap.put(ASName.create("hekatakana"), "30D8");
        hashMap.put(ASName.create("hekatakanahalfwidth"), "FF8D");
        hashMap.put(ASName.create("hekutaarusquare"), "3336");
        hashMap.put(ASName.create("henghook"), "0267");
        hashMap.put(ASName.create("herutusquare"), "3339");
        hashMap.put(ASName.create("het"), "05D7");
        hashMap.put(ASName.create("hethebrew"), "05D7");
        hashMap.put(ASName.create("hhook"), "0266");
        hashMap.put(ASName.create("hhooksuperior"), "02B1");
        hashMap.put(ASName.create("hieuhacirclekorean"), "327B");
        hashMap.put(ASName.create("hieuhaparenkorean"), "321B");
        hashMap.put(ASName.create("hieuhcirclekorean"), "326D");
        hashMap.put(ASName.create("hieuhkorean"), "314E");
        hashMap.put(ASName.create("hieuhparenkorean"), "320D");
        hashMap.put(ASName.create("hihiragana"), "3072");
        hashMap.put(ASName.create("hikatakana"), "30D2");
        hashMap.put(ASName.create("hikatakanahalfwidth"), "FF8B");
        hashMap.put(ASName.create("hiriq"), "05B4");
        hashMap.put(ASName.create("hiriq14"), "05B4");
        hashMap.put(ASName.create("hiriq21"), "05B4");
        hashMap.put(ASName.create("hiriq2d"), "05B4");
        hashMap.put(ASName.create("hiriqhebrew"), "05B4");
        hashMap.put(ASName.create("hiriqnarrowhebrew"), "05B4");
        hashMap.put(ASName.create("hiriqquarterhebrew"), "05B4");
        hashMap.put(ASName.create("hiriqwidehebrew"), "05B4");
        hashMap.put(ASName.create("hlinebelow"), "1E96");
        hashMap.put(ASName.create("hmonospace"), "FF48");
        hashMap.put(ASName.create("hoarmenian"), "0570");
        hashMap.put(ASName.create("hohipthai"), "0E2B");
        hashMap.put(ASName.create("hohiragana"), "307B");
        hashMap.put(ASName.create("hokatakana"), "30DB");
        hashMap.put(ASName.create("hokatakanahalfwidth"), "FF8E");
        hashMap.put(ASName.create("holam"), "05B9");
        hashMap.put(ASName.create("holam19"), "05B9");
        hashMap.put(ASName.create("holam26"), "05B9");
        hashMap.put(ASName.create("holam32"), "05B9");
        hashMap.put(ASName.create("holamhebrew"), "05B9");
        hashMap.put(ASName.create("holamnarrowhebrew"), "05B9");
        hashMap.put(ASName.create("holamquarterhebrew"), "05B9");
        hashMap.put(ASName.create("holamwidehebrew"), "05B9");
        hashMap.put(ASName.create("honokhukthai"), "0E2E");
        hashMap.put(ASName.create("hookabovecomb"), "0309");
        hashMap.put(ASName.create("hookcmb"), "0309");
        hashMap.put(ASName.create("hookpalatalizedbelowcmb"), "0321");
        hashMap.put(ASName.create("hookretroflexbelowcmb"), "0322");
        hashMap.put(ASName.create("hoonsquare"), "3342");
        hashMap.put(ASName.create("horicoptic"), "03E9");
        hashMap.put(ASName.create("horizontalbar"), "2015");
        hashMap.put(ASName.create("horncmb"), "031B");
        hashMap.put(ASName.create("hotsprings"), "2668");
        hashMap.put(ASName.create("house"), "2302");
        hashMap.put(ASName.create("hparen"), "24A3");
        hashMap.put(ASName.create("hsuperior"), "02B0");
        hashMap.put(ASName.create("hturned"), "0265");
        hashMap.put(ASName.create("huhiragana"), "3075");
        hashMap.put(ASName.create("huiitosquare"), "3333");
        hashMap.put(ASName.create("hukatakana"), "30D5");
        hashMap.put(ASName.create("hukatakanahalfwidth"), "FF8C");
        hashMap.put(ASName.create("hungarumlaut"), "02DD");
        hashMap.put(ASName.create("hungarumlautcmb"), "030B");
        hashMap.put(ASName.create("hv"), "0195");
        hashMap.put(ASName.create("hyphen"), "002D");
        hashMap.put(ASName.create("hypheninferior"), "F6E5");
        hashMap.put(ASName.create("hyphenmonospace"), "FF0D");
        hashMap.put(ASName.create("hyphensmall"), "FE63");
        hashMap.put(ASName.create("hyphensuperior"), "F6E6");
        hashMap.put(ASName.create("hyphentwo"), "2010");
        hashMap.put(ASName.create("i"), "0069");
        hashMap.put(ASName.create("iacute"), "00ED");
        hashMap.put(ASName.create("iacyrillic"), "044F");
        hashMap.put(ASName.create("ibengali"), "0987");
        hashMap.put(ASName.create("ibopomofo"), "3127");
        hashMap.put(ASName.create("ibreve"), "012D");
        hashMap.put(ASName.create("icaron"), "01D0");
        hashMap.put(ASName.create("icircle"), "24D8");
        hashMap.put(ASName.create("icircumflex"), "00EE");
        hashMap.put(ASName.create("icyrillic"), "0456");
        hashMap.put(ASName.create("idblgrave"), "0209");
        hashMap.put(ASName.create("ideographearthcircle"), "328F");
        hashMap.put(ASName.create("ideographfirecircle"), "328B");
        hashMap.put(ASName.create("ideographicallianceparen"), "323F");
        hashMap.put(ASName.create("ideographiccallparen"), "323A");
        hashMap.put(ASName.create("ideographiccentrecircle"), "32A5");
        hashMap.put(ASName.create("ideographicclose"), "3006");
        hashMap.put(ASName.create("ideographiccomma"), "3001");
        hashMap.put(ASName.create("ideographiccommaleft"), "FF64");
        hashMap.put(ASName.create("ideographiccongratulationparen"), "3237");
        hashMap.put(ASName.create("ideographiccorrectcircle"), "32A3");
        hashMap.put(ASName.create("ideographicearthparen"), "322F");
        hashMap.put(ASName.create("ideographicenterpriseparen"), "323D");
        hashMap.put(ASName.create("ideographicexcellentcircle"), "329D");
        hashMap.put(ASName.create("ideographicfestivalparen"), "3240");
        hashMap.put(ASName.create("ideographicfinancialcircle"), "3296");
        hashMap.put(ASName.create("ideographicfinancialparen"), "3236");
        hashMap.put(ASName.create("ideographicfireparen"), "322B");
        hashMap.put(ASName.create("ideographichaveparen"), "3232");
        hashMap.put(ASName.create("ideographichighcircle"), "32A4");
        hashMap.put(ASName.create("ideographiciterationmark"), "3005");
        hashMap.put(ASName.create("ideographiclaborcircle"), "3298");
        hashMap.put(ASName.create("ideographiclaborparen"), "3238");
        hashMap.put(ASName.create("ideographicleftcircle"), "32A7");
        hashMap.put(ASName.create("ideographiclowcircle"), "32A6");
        hashMap.put(ASName.create("ideographicmedicinecircle"), "32A9");
        hashMap.put(ASName.create("ideographicmetalparen"), "322E");
        hashMap.put(ASName.create("ideographicmoonparen"), "322A");
        hashMap.put(ASName.create("ideographicnameparen"), "3234");
        hashMap.put(ASName.create("ideographicperiod"), "3002");
        hashMap.put(ASName.create("ideographicprintcircle"), "329E");
        hashMap.put(ASName.create("ideographicreachparen"), "3243");
        hashMap.put(ASName.create("ideographicrepresentparen"), "3239");
        hashMap.put(ASName.create("ideographicresourceparen"), "323E");
        hashMap.put(ASName.create("ideographicrightcircle"), "32A8");
        hashMap.put(ASName.create("ideographicsecretcircle"), "3299");
        hashMap.put(ASName.create("ideographicselfparen"), "3242");
        hashMap.put(ASName.create("ideographicsocietyparen"), "3233");
        hashMap.put(ASName.create("ideographicspace"), "3000");
        hashMap.put(ASName.create("ideographicspecialparen"), "3235");
        hashMap.put(ASName.create("ideographicstockparen"), "3231");
        hashMap.put(ASName.create("ideographicstudyparen"), "323B");
        hashMap.put(ASName.create("ideographicsunparen"), "3230");
        hashMap.put(ASName.create("ideographicsuperviseparen"), "323C");
        hashMap.put(ASName.create("ideographicwaterparen"), "322C");
        hashMap.put(ASName.create("ideographicwoodparen"), "322D");
        hashMap.put(ASName.create("ideographiczero"), "3007");
        hashMap.put(ASName.create("ideographmetalcircle"), "328E");
        hashMap.put(ASName.create("ideographmooncircle"), "328A");
        hashMap.put(ASName.create("ideographnamecircle"), "3294");
        hashMap.put(ASName.create("ideographsuncircle"), "3290");
        hashMap.put(ASName.create("ideographwatercircle"), "328C");
        hashMap.put(ASName.create("ideographwoodcircle"), "328D");
        hashMap.put(ASName.create("ideva"), "0907");
        hashMap.put(ASName.create("idieresis"), "00EF");
        hashMap.put(ASName.create("idieresisacute"), "1E2F");
        hashMap.put(ASName.create("idieresiscyrillic"), "04E5");
        hashMap.put(ASName.create("idotbelow"), "1ECB");
        hashMap.put(ASName.create("iebrevecyrillic"), "04D7");
        hashMap.put(ASName.create("iecyrillic"), "0435");
        hashMap.put(ASName.create("ieungacirclekorean"), "3275");
        hashMap.put(ASName.create("ieungaparenkorean"), "3215");
        hashMap.put(ASName.create("ieungcirclekorean"), "3267");
        hashMap.put(ASName.create("ieungkorean"), "3147");
        hashMap.put(ASName.create("ieungparenkorean"), "3207");
        hashMap.put(ASName.create("igrave"), "00EC");
        hashMap.put(ASName.create("igujarati"), "0A87");
        hashMap.put(ASName.create("igurmukhi"), "0A07");
        hashMap.put(ASName.create("ihiragana"), "3044");
        hashMap.put(ASName.create("ihookabove"), "1EC9");
        hashMap.put(ASName.create("iibengali"), "0988");
        hashMap.put(ASName.create("iicyrillic"), "0438");
        hashMap.put(ASName.create("iideva"), "0908");
        hashMap.put(ASName.create("iigujarati"), "0A88");
        hashMap.put(ASName.create("iigurmukhi"), "0A08");
        hashMap.put(ASName.create("iimatragurmukhi"), "0A40");
        hashMap.put(ASName.create("iinvertedbreve"), "020B");
        hashMap.put(ASName.create("iishortcyrillic"), "0439");
        hashMap.put(ASName.create("iivowelsignbengali"), "09C0");
        hashMap.put(ASName.create("iivowelsigndeva"), "0940");
        hashMap.put(ASName.create("iivowelsigngujarati"), "0AC0");
        hashMap.put(ASName.create("ij"), "0133");
        hashMap.put(ASName.create("ikatakana"), "30A4");
        hashMap.put(ASName.create("ikatakanahalfwidth"), "FF72");
        hashMap.put(ASName.create("ikorean"), "3163");
        hashMap.put(ASName.create("ilde"), "02DC");
        hashMap.put(ASName.create("iluyhebrew"), "05AC");
        hashMap.put(ASName.create("imacron"), "012B");
        hashMap.put(ASName.create("imacroncyrillic"), "04E3");
        hashMap.put(ASName.create("imageorapproximatelyequal"), "2253");
        hashMap.put(ASName.create("imatragurmukhi"), "0A3F");
        hashMap.put(ASName.create("imonospace"), "FF49");
        hashMap.put(ASName.create("increment"), "2206");
        hashMap.put(ASName.create("infinity"), "221E");
        hashMap.put(ASName.create("iniarmenian"), "056B");
        hashMap.put(ASName.create("integral"), "222B");
        hashMap.put(ASName.create("integralbottom"), "2321");
        hashMap.put(ASName.create("integralbt"), "2321");
        hashMap.put(ASName.create("integralex"), "F8F5");
        hashMap.put(ASName.create("integraltop"), "2320");
        hashMap.put(ASName.create("integraltp"), "2320");
        hashMap.put(ASName.create("intersection"), "2229");
        hashMap.put(ASName.create("intisquare"), "3305");
        hashMap.put(ASName.create("invbullet"), "25D8");
        hashMap.put(ASName.create("invcircle"), "25D9");
        hashMap.put(ASName.create("invsmileface"), "263B");
        hashMap.put(ASName.create("iocyrillic"), "0451");
        hashMap.put(ASName.create("iogonek"), "012F");
        hashMap.put(ASName.create("iota"), "03B9");
        hashMap.put(ASName.create("iotadieresis"), "03CA");
        hashMap.put(ASName.create("iotadieresistonos"), "0390");
        hashMap.put(ASName.create("iotalatin"), "0269");
        hashMap.put(ASName.create("iotatonos"), "03AF");
        hashMap.put(ASName.create("iparen"), "24A4");
        hashMap.put(ASName.create("irigurmukhi"), "0A72");
        hashMap.put(ASName.create("ismallhiragana"), "3043");
        hashMap.put(ASName.create("ismallkatakana"), "30A3");
        hashMap.put(ASName.create("ismallkatakanahalfwidth"), "FF68");
        hashMap.put(ASName.create("issharbengali"), "09FA");
        hashMap.put(ASName.create("istroke"), "0268");
        hashMap.put(ASName.create("isuperior"), "F6ED");
        hashMap.put(ASName.create("iterationhiragana"), "309D");
        hashMap.put(ASName.create("iterationkatakana"), "30FD");
        hashMap.put(ASName.create("itilde"), "0129");
        hashMap.put(ASName.create("itildebelow"), "1E2D");
        hashMap.put(ASName.create("iubopomofo"), "3129");
        hashMap.put(ASName.create("iucyrillic"), "044E");
        hashMap.put(ASName.create("ivowelsignbengali"), "09BF");
        hashMap.put(ASName.create("ivowelsigndeva"), "093F");
        hashMap.put(ASName.create("ivowelsigngujarati"), "0ABF");
        hashMap.put(ASName.create("izhitsacyrillic"), "0475");
        hashMap.put(ASName.create("izhitsadblgravecyrillic"), "0477");
        hashMap.put(ASName.create("j"), "006A");
        hashMap.put(ASName.create("jaarmenian"), "0571");
        hashMap.put(ASName.create("jabengali"), "099C");
        hashMap.put(ASName.create("jadeva"), "091C");
        hashMap.put(ASName.create("jagujarati"), "0A9C");
        hashMap.put(ASName.create("jagurmukhi"), "0A1C");
        hashMap.put(ASName.create("jbopomofo"), "3110");
        hashMap.put(ASName.create("jcaron"), "01F0");
        hashMap.put(ASName.create("jcircle"), "24D9");
        hashMap.put(ASName.create("jcircumflex"), "0135");
        hashMap.put(ASName.create("jcrossedtail"), "029D");
        hashMap.put(ASName.create("jdotlessstroke"), "025F");
        hashMap.put(ASName.create("jecyrillic"), "0458");
        hashMap.put(ASName.create("jeemarabic"), "062C");
        hashMap.put(ASName.create("jeemfinalarabic"), "FE9E");
        hashMap.put(ASName.create("jeeminitialarabic"), "FE9F");
        hashMap.put(ASName.create("jeemmedialarabic"), "FEA0");
        hashMap.put(ASName.create("jeharabic"), "0698");
        hashMap.put(ASName.create("jehfinalarabic"), "FB8B");
        hashMap.put(ASName.create("jhabengali"), "099D");
        hashMap.put(ASName.create("jhadeva"), "091D");
        hashMap.put(ASName.create("jhagujarati"), "0A9D");
        hashMap.put(ASName.create("jhagurmukhi"), "0A1D");
        hashMap.put(ASName.create("jheharmenian"), "057B");
        hashMap.put(ASName.create("jis"), "3004");
        hashMap.put(ASName.create("jmonospace"), "FF4A");
        hashMap.put(ASName.create("jparen"), "24A5");
        hashMap.put(ASName.create("jsuperior"), "02B2");
        hashMap.put(ASName.create("k"), "006B");
        hashMap.put(ASName.create("kabashkircyrillic"), "04A1");
        hashMap.put(ASName.create("kabengali"), "0995");
        hashMap.put(ASName.create("kacute"), "1E31");
        hashMap.put(ASName.create("kacyrillic"), "043A");
        hashMap.put(ASName.create("kadescendercyrillic"), "049B");
        hashMap.put(ASName.create("kadeva"), "0915");
        hashMap.put(ASName.create("kaf"), "05DB");
        hashMap.put(ASName.create("kafarabic"), "0643");
        hashMap.put(ASName.create("kafdagesh"), "FB3B");
        hashMap.put(ASName.create("kafdageshhebrew"), "FB3B");
        hashMap.put(ASName.create("kaffinalarabic"), "FEDA");
        hashMap.put(ASName.create("kafhebrew"), "05DB");
        hashMap.put(ASName.create("kafinitialarabic"), "FEDB");
        hashMap.put(ASName.create("kafmedialarabic"), "FEDC");
        hashMap.put(ASName.create("kafrafehebrew"), "FB4D");
        hashMap.put(ASName.create("kagujarati"), "0A95");
        hashMap.put(ASName.create("kagurmukhi"), "0A15");
        hashMap.put(ASName.create("kahiragana"), "304B");
        hashMap.put(ASName.create("kahookcyrillic"), "04C4");
        hashMap.put(ASName.create("kakatakana"), "30AB");
        hashMap.put(ASName.create("kakatakanahalfwidth"), "FF76");
        hashMap.put(ASName.create("kappa"), "03BA");
        hashMap.put(ASName.create("kappasymbolgreek"), "03F0");
        hashMap.put(ASName.create("kapyeounmieumkorean"), "3171");
        hashMap.put(ASName.create("kapyeounphieuphkorean"), "3184");
        hashMap.put(ASName.create("kapyeounpieupkorean"), "3178");
        hashMap.put(ASName.create("kapyeounssangpieupkorean"), "3179");
        hashMap.put(ASName.create("karoriisquare"), "330D");
        hashMap.put(ASName.create("kashidaautoarabic"), "0640");
        hashMap.put(ASName.create("kashidaautonosidebearingarabic"), "0640");
        hashMap.put(ASName.create("kasmallkatakana"), "30F5");
        hashMap.put(ASName.create("kasquare"), "3384");
        hashMap.put(ASName.create("kasraarabic"), "0650");
        hashMap.put(ASName.create("kasratanarabic"), "064D");
        hashMap.put(ASName.create("kastrokecyrillic"), "049F");
        hashMap.put(ASName.create("katahiraprolongmarkhalfwidth"), "FF70");
        hashMap.put(ASName.create("kaverticalstrokecyrillic"), "049D");
        hashMap.put(ASName.create("kbopomofo"), "310E");
        hashMap.put(ASName.create("kcalsquare"), "3389");
        hashMap.put(ASName.create("kcaron"), "01E9");
        hashMap.put(ASName.create("kcedilla"), "0137");
        hashMap.put(ASName.create("kcircle"), "24DA");
        hashMap.put(ASName.create("kcommaaccent"), "0137");
        hashMap.put(ASName.create("kdotbelow"), "1E33");
        hashMap.put(ASName.create("keharmenian"), "0584");
        hashMap.put(ASName.create("kehiragana"), "3051");
        hashMap.put(ASName.create("kekatakana"), "30B1");
        hashMap.put(ASName.create("kekatakanahalfwidth"), "FF79");
        hashMap.put(ASName.create("kenarmenian"), "056F");
        hashMap.put(ASName.create("kesmallkatakana"), "30F6");
        hashMap.put(ASName.create("kgreenlandic"), "0138");
        hashMap.put(ASName.create("khabengali"), "0996");
        hashMap.put(ASName.create("khacyrillic"), "0445");
        hashMap.put(ASName.create("khadeva"), "0916");
        hashMap.put(ASName.create("khagujarati"), "0A96");
        hashMap.put(ASName.create("khagurmukhi"), "0A16");
        hashMap.put(ASName.create("khaharabic"), "062E");
        hashMap.put(ASName.create("khahfinalarabic"), "FEA6");
        hashMap.put(ASName.create("khahinitialarabic"), "FEA7");
        hashMap.put(ASName.create("khahmedialarabic"), "FEA8");
        hashMap.put(ASName.create("kheicoptic"), "03E7");
        hashMap.put(ASName.create("khhadeva"), "0959");
        hashMap.put(ASName.create("khhagurmukhi"), "0A59");
        hashMap.put(ASName.create("khieukhacirclekorean"), "3278");
        hashMap.put(ASName.create("khieukhaparenkorean"), "3218");
        hashMap.put(ASName.create("khieukhcirclekorean"), "326A");
        hashMap.put(ASName.create("khieukhkorean"), "314B");
        hashMap.put(ASName.create("khieukhparenkorean"), "320A");
        hashMap.put(ASName.create("khokhaithai"), "0E02");
        hashMap.put(ASName.create("khokhonthai"), "0E05");
        hashMap.put(ASName.create("khokhuatthai"), "0E03");
        hashMap.put(ASName.create("khokhwaithai"), "0E04");
        hashMap.put(ASName.create("khomutthai"), "0E5B");
        hashMap.put(ASName.create("khook"), "0199");
        hashMap.put(ASName.create("khorakhangthai"), "0E06");
        hashMap.put(ASName.create("khzsquare"), "3391");
        hashMap.put(ASName.create("kihiragana"), "304D");
        hashMap.put(ASName.create("kikatakana"), "30AD");
        hashMap.put(ASName.create("kikatakanahalfwidth"), "FF77");
        hashMap.put(ASName.create("kiroguramusquare"), "3315");
        hashMap.put(ASName.create("kiromeetorusquare"), "3316");
        hashMap.put(ASName.create("kirosquare"), "3314");
        hashMap.put(ASName.create("kiyeokacirclekorean"), "326E");
        hashMap.put(ASName.create("kiyeokaparenkorean"), "320E");
        hashMap.put(ASName.create("kiyeokcirclekorean"), "3260");
        hashMap.put(ASName.create("kiyeokkorean"), "3131");
        hashMap.put(ASName.create("kiyeokparenkorean"), "3200");
        hashMap.put(ASName.create("kiyeoksioskorean"), "3133");
        hashMap.put(ASName.create("kjecyrillic"), "045C");
        hashMap.put(ASName.create("klinebelow"), "1E35");
        hashMap.put(ASName.create("klsquare"), "3398");
        hashMap.put(ASName.create("kmcubedsquare"), "33A6");
        hashMap.put(ASName.create("kmonospace"), "FF4B");
        hashMap.put(ASName.create("kmsquaredsquare"), "33A2");
        hashMap.put(ASName.create("kohiragana"), "3053");
        hashMap.put(ASName.create("kohmsquare"), "33C0");
        hashMap.put(ASName.create("kokaithai"), "0E01");
        hashMap.put(ASName.create("kokatakana"), "30B3");
        hashMap.put(ASName.create("kokatakanahalfwidth"), "FF7A");
        hashMap.put(ASName.create("kooposquare"), "331E");
        hashMap.put(ASName.create("koppacyrillic"), "0481");
        hashMap.put(ASName.create("koreanstandardsymbol"), "327F");
        hashMap.put(ASName.create("koroniscmb"), "0343");
        hashMap.put(ASName.create("kparen"), "24A6");
        hashMap.put(ASName.create("kpasquare"), "33AA");
        hashMap.put(ASName.create("ksicyrillic"), "046F");
        hashMap.put(ASName.create("ktsquare"), "33CF");
        hashMap.put(ASName.create("kturned"), "029E");
        hashMap.put(ASName.create("kuhiragana"), "304F");
        hashMap.put(ASName.create("kukatakana"), "30AF");
        hashMap.put(ASName.create("kukatakanahalfwidth"), "FF78");
        hashMap.put(ASName.create("kvsquare"), "33B8");
        hashMap.put(ASName.create("kwsquare"), "33BE");
        hashMap.put(ASName.create("l"), "006C");
        hashMap.put(ASName.create("labengali"), "09B2");
        hashMap.put(ASName.create("lacute"), "013A");
        hashMap.put(ASName.create("ladeva"), "0932");
        hashMap.put(ASName.create("lagujarati"), "0AB2");
        hashMap.put(ASName.create("lagurmukhi"), "0A32");
        hashMap.put(ASName.create("lakkhangyaothai"), "0E45");
        hashMap.put(ASName.create("lamaleffinalarabic"), "FEFC");
        hashMap.put(ASName.create("lamalefhamzaabovefinalarabic"), "FEF8");
        hashMap.put(ASName.create("lamalefhamzaaboveisolatedarabic"), "FEF7");
        hashMap.put(ASName.create("lamalefhamzabelowfinalarabic"), "FEFA");
        hashMap.put(ASName.create("lamalefhamzabelowisolatedarabic"), "FEF9");
        hashMap.put(ASName.create("lamalefisolatedarabic"), "FEFB");
        hashMap.put(ASName.create("lamalefmaddaabovefinalarabic"), "FEF6");
        hashMap.put(ASName.create("lamalefmaddaaboveisolatedarabic"), "FEF5");
        hashMap.put(ASName.create("lamarabic"), "0644");
        hashMap.put(ASName.create("lambda"), "03BB");
        hashMap.put(ASName.create("lambdastroke"), "019B");
        hashMap.put(ASName.create("lamed"), "05DC");
        hashMap.put(ASName.create("lameddagesh"), "FB3C");
        hashMap.put(ASName.create("lameddageshhebrew"), "FB3C");
        hashMap.put(ASName.create("lamedhebrew"), "05DC");
        hashMap.put(ASName.create("lamedholam"), "05DC05B9");
        hashMap.put(ASName.create("lamedholamdagesh"), "05DC05B905BC");
        hashMap.put(ASName.create("lamedholamdageshhebrew"), "05DC05B905BC");
        hashMap.put(ASName.create("lamedholamhebrew"), "05DC05B9");
        hashMap.put(ASName.create("lamfinalarabic"), "FEDE");
        hashMap.put(ASName.create("lamhahinitialarabic"), "FCCA");
        hashMap.put(ASName.create("laminitialarabic"), "FEDF");
        hashMap.put(ASName.create("lamjeeminitialarabic"), "FCC9");
        hashMap.put(ASName.create("lamkhahinitialarabic"), "FCCB");
        hashMap.put(ASName.create("lamlamhehisolatedarabic"), "FDF2");
        hashMap.put(ASName.create("lammedialarabic"), "FEE0");
        hashMap.put(ASName.create("lammeemhahinitialarabic"), "FD88");
        hashMap.put(ASName.create("lammeeminitialarabic"), "FCCC");
        hashMap.put(ASName.create("lammeemjeeminitialarabic"), "FEDFFEE4FEA0");
        hashMap.put(ASName.create("lammeemkhahinitialarabic"), "FEDFFEE4FEA8");
        hashMap.put(ASName.create("largecircle"), "25EF");
        hashMap.put(ASName.create("lbar"), "019A");
        hashMap.put(ASName.create("lbelt"), "026C");
        hashMap.put(ASName.create("lbopomofo"), "310C");
        hashMap.put(ASName.create("lcaron"), "013E");
        hashMap.put(ASName.create("lcedilla"), "013C");
        hashMap.put(ASName.create("lcircle"), "24DB");
        hashMap.put(ASName.create("lcircumflexbelow"), "1E3D");
        hashMap.put(ASName.create("lcommaaccent"), "013C");
        hashMap.put(ASName.create("ldot"), "0140");
        hashMap.put(ASName.create("ldotaccent"), "0140");
        hashMap.put(ASName.create("ldotbelow"), "1E37");
        hashMap.put(ASName.create("ldotbelowmacron"), "1E39");
        hashMap.put(ASName.create("leftangleabovecmb"), "031A");
        hashMap.put(ASName.create("lefttackbelowcmb"), "0318");
        hashMap.put(ASName.create("less"), "003C");
        hashMap.put(ASName.create("lessequal"), "2264");
        hashMap.put(ASName.create("lessequalorgreater"), "22DA");
        hashMap.put(ASName.create("lessmonospace"), "FF1C");
        hashMap.put(ASName.create("lessorequivalent"), "2272");
        hashMap.put(ASName.create("lessorgreater"), "2276");
        hashMap.put(ASName.create("lessoverequal"), "2266");
        hashMap.put(ASName.create("lesssmall"), "FE64");
        hashMap.put(ASName.create("lezh"), "026E");
        hashMap.put(ASName.create("lfblock"), "258C");
        hashMap.put(ASName.create("lhookretroflex"), "026D");
        hashMap.put(ASName.create("lira"), "20A4");
        hashMap.put(ASName.create("liwnarmenian"), "056C");
        hashMap.put(ASName.create("lj"), "01C9");
        hashMap.put(ASName.create("ljecyrillic"), "0459");
        hashMap.put(ASName.create("ll"), "F6C0");
        hashMap.put(ASName.create("lladeva"), "0933");
        hashMap.put(ASName.create("llagujarati"), "0AB3");
        hashMap.put(ASName.create("llinebelow"), "1E3B");
        hashMap.put(ASName.create("llladeva"), "0934");
        hashMap.put(ASName.create("llvocalicbengali"), "09E1");
        hashMap.put(ASName.create("llvocalicdeva"), "0961");
        hashMap.put(ASName.create("llvocalicvowelsignbengali"), "09E3");
        hashMap.put(ASName.create("llvocalicvowelsigndeva"), "0963");
        hashMap.put(ASName.create("lmiddletilde"), "026B");
        hashMap.put(ASName.create("lmonospace"), "FF4C");
        hashMap.put(ASName.create("lmsquare"), "33D0");
        hashMap.put(ASName.create("lochulathai"), "0E2C");
        hashMap.put(ASName.create("logicaland"), "2227");
        hashMap.put(ASName.create("logicalnot"), "00AC");
        hashMap.put(ASName.create("logicalnotreversed"), "2310");
        hashMap.put(ASName.create("logicalor"), "2228");
        hashMap.put(ASName.create("lolingthai"), "0E25");
        hashMap.put(ASName.create("longs"), "017F");
        hashMap.put(ASName.create("lowlinecenterline"), "FE4E");
        hashMap.put(ASName.create("lowlinecmb"), "0332");
        hashMap.put(ASName.create("lowlinedashed"), "FE4D");
        hashMap.put(ASName.create("lozenge"), "25CA");
        hashMap.put(ASName.create("lparen"), "24A7");
        hashMap.put(ASName.create("lslash"), "0142");
        hashMap.put(ASName.create("lsquare"), "2113");
        hashMap.put(ASName.create("lsuperior"), "F6EE");
        hashMap.put(ASName.create("ltshade"), "2591");
        hashMap.put(ASName.create("luthai"), "0E26");
        hashMap.put(ASName.create("lvocalicbengali"), "098C");
        hashMap.put(ASName.create("lvocalicdeva"), "090C");
        hashMap.put(ASName.create("lvocalicvowelsignbengali"), "09E2");
        hashMap.put(ASName.create("lvocalicvowelsigndeva"), "0962");
        hashMap.put(ASName.create("lxsquare"), "33D3");
        hashMap.put(ASName.create("m"), "006D");
        hashMap.put(ASName.create("mabengali"), "09AE");
        hashMap.put(ASName.create("macron"), "00AF");
        hashMap.put(ASName.create("macronbelowcmb"), "0331");
        hashMap.put(ASName.create("macroncmb"), "0304");
        hashMap.put(ASName.create("macronlowmod"), "02CD");
        hashMap.put(ASName.create("macronmonospace"), "FFE3");
        hashMap.put(ASName.create("macute"), "1E3F");
        hashMap.put(ASName.create("madeva"), "092E");
        hashMap.put(ASName.create("magujarati"), "0AAE");
        hashMap.put(ASName.create("magurmukhi"), "0A2E");
        hashMap.put(ASName.create("mahapakhhebrew"), "05A4");
        hashMap.put(ASName.create("mahapakhlefthebrew"), "05A4");
        hashMap.put(ASName.create("mahiragana"), "307E");
        hashMap.put(ASName.create("maichattawalowleftthai"), "F895");
        hashMap.put(ASName.create("maichattawalowrightthai"), "F894");
        hashMap.put(ASName.create("maichattawathai"), "0E4B");
        hashMap.put(ASName.create("maichattawaupperleftthai"), "F893");
        hashMap.put(ASName.create("maieklowleftthai"), "F88C");
        hashMap.put(ASName.create("maieklowrightthai"), "F88B");
        hashMap.put(ASName.create("maiekthai"), "0E48");
        hashMap.put(ASName.create("maiekupperleftthai"), "F88A");
        hashMap.put(ASName.create("maihanakatleftthai"), "F884");
        hashMap.put(ASName.create("maihanakatthai"), "0E31");
        hashMap.put(ASName.create("maitaikhuleftthai"), "F889");
        hashMap.put(ASName.create("maitaikhuthai"), "0E47");
        hashMap.put(ASName.create("maitholowleftthai"), "F88F");
        hashMap.put(ASName.create("maitholowrightthai"), "F88E");
        hashMap.put(ASName.create("maithothai"), "0E49");
        hashMap.put(ASName.create("maithoupperleftthai"), "F88D");
        hashMap.put(ASName.create("maitrilowleftthai"), "F892");
        hashMap.put(ASName.create("maitrilowrightthai"), "F891");
        hashMap.put(ASName.create("maitrithai"), "0E4A");
        hashMap.put(ASName.create("maitriupperleftthai"), "F890");
        hashMap.put(ASName.create("maiyamokthai"), "0E46");
        hashMap.put(ASName.create("makatakana"), "30DE");
        hashMap.put(ASName.create("makatakanahalfwidth"), "FF8F");
        hashMap.put(ASName.create("male"), "2642");
        hashMap.put(ASName.create("mansyonsquare"), "3347");
        hashMap.put(ASName.create("maqafhebrew"), "05BE");
        hashMap.put(ASName.create("mars"), "2642");
        hashMap.put(ASName.create("masoracirclehebrew"), "05AF");
        hashMap.put(ASName.create("masquare"), "3383");
        hashMap.put(ASName.create("mbopomofo"), "3107");
        hashMap.put(ASName.create("mbsquare"), "33D4");
        hashMap.put(ASName.create("mcircle"), "24DC");
        hashMap.put(ASName.create("mcubedsquare"), "33A5");
        hashMap.put(ASName.create("mdotaccent"), "1E41");
        hashMap.put(ASName.create("mdotbelow"), "1E43");
        hashMap.put(ASName.create("meemarabic"), "0645");
        hashMap.put(ASName.create("meemfinalarabic"), "FEE2");
        hashMap.put(ASName.create("meeminitialarabic"), "FEE3");
        hashMap.put(ASName.create("meemmedialarabic"), "FEE4");
        hashMap.put(ASName.create("meemmeeminitialarabic"), "FCD1");
        hashMap.put(ASName.create("meemmeemisolatedarabic"), "FC48");
        hashMap.put(ASName.create("meetorusquare"), "334D");
        hashMap.put(ASName.create("mehiragana"), "3081");
        hashMap.put(ASName.create("meizierasquare"), "337E");
        hashMap.put(ASName.create("mekatakana"), "30E1");
        hashMap.put(ASName.create("mekatakanahalfwidth"), "FF92");
        hashMap.put(ASName.create("mem"), "05DE");
        hashMap.put(ASName.create("memdagesh"), "FB3E");
        hashMap.put(ASName.create("memdageshhebrew"), "FB3E");
        hashMap.put(ASName.create("memhebrew"), "05DE");
        hashMap.put(ASName.create("menarmenian"), "0574");
        hashMap.put(ASName.create("merkhahebrew"), "05A5");
        hashMap.put(ASName.create("merkhakefulahebrew"), "05A6");
        hashMap.put(ASName.create("merkhakefulalefthebrew"), "05A6");
        hashMap.put(ASName.create("merkhalefthebrew"), "05A5");
        hashMap.put(ASName.create("mhook"), "0271");
        hashMap.put(ASName.create("mhzsquare"), "3392");
        hashMap.put(ASName.create("middledotkatakanahalfwidth"), "FF65");
        hashMap.put(ASName.create("middot"), "00B7");
        hashMap.put(ASName.create("mieumacirclekorean"), "3272");
        hashMap.put(ASName.create("mieumaparenkorean"), "3212");
        hashMap.put(ASName.create("mieumcirclekorean"), "3264");
        hashMap.put(ASName.create("mieumkorean"), "3141");
        hashMap.put(ASName.create("mieumpansioskorean"), "3170");
        hashMap.put(ASName.create("mieumparenkorean"), "3204");
        hashMap.put(ASName.create("mieumpieupkorean"), "316E");
        hashMap.put(ASName.create("mieumsioskorean"), "316F");
        hashMap.put(ASName.create("mihiragana"), "307F");
        hashMap.put(ASName.create("mikatakana"), "30DF");
        hashMap.put(ASName.create("mikatakanahalfwidth"), "FF90");
        hashMap.put(ASName.create("minus"), "2212");
        hashMap.put(ASName.create("minusbelowcmb"), "0320");
        hashMap.put(ASName.create("minuscircle"), "2296");
        hashMap.put(ASName.create("minusmod"), "02D7");
        hashMap.put(ASName.create("minusplus"), "2213");
        hashMap.put(ASName.create("minute"), "2032");
        hashMap.put(ASName.create("miribaarusquare"), "334A");
        hashMap.put(ASName.create("mirisquare"), "3349");
        hashMap.put(ASName.create("mlonglegturned"), "0270");
        hashMap.put(ASName.create("mlsquare"), "3396");
        hashMap.put(ASName.create("mmcubedsquare"), "33A3");
        hashMap.put(ASName.create("mmonospace"), "FF4D");
        hashMap.put(ASName.create("mmsquaredsquare"), "339F");
        hashMap.put(ASName.create("mohiragana"), "3082");
        hashMap.put(ASName.create("mohmsquare"), "33C1");
        hashMap.put(ASName.create("mokatakana"), "30E2");
        hashMap.put(ASName.create("mokatakanahalfwidth"), "FF93");
        hashMap.put(ASName.create("molsquare"), "33D6");
        hashMap.put(ASName.create("momathai"), "0E21");
        hashMap.put(ASName.create("moverssquare"), "33A7");
        hashMap.put(ASName.create("moverssquaredsquare"), "33A8");
        hashMap.put(ASName.create("mparen"), "24A8");
        hashMap.put(ASName.create("mpasquare"), "33AB");
        hashMap.put(ASName.create("mssquare"), "33B3");
        hashMap.put(ASName.create("msuperior"), "F6EF");
        hashMap.put(ASName.create("mturned"), "026F");
        hashMap.put(ASName.create("mu"), "00B5");
        hashMap.put(ASName.create("mu1"), "00B5");
        hashMap.put(ASName.create("muasquare"), "3382");
        hashMap.put(ASName.create("muchgreater"), "226B");
        hashMap.put(ASName.create("muchless"), "226A");
        hashMap.put(ASName.create("mufsquare"), "338C");
        hashMap.put(ASName.create("mugreek"), "03BC");
        hashMap.put(ASName.create("mugsquare"), "338D");
        hashMap.put(ASName.create("muhiragana"), "3080");
        hashMap.put(ASName.create("mukatakana"), "30E0");
        hashMap.put(ASName.create("mukatakanahalfwidth"), "FF91");
        hashMap.put(ASName.create("mulsquare"), "3395");
        hashMap.put(ASName.create("multiply"), "00D7");
        hashMap.put(ASName.create("mumsquare"), "339B");
        hashMap.put(ASName.create("munahhebrew"), "05A3");
        hashMap.put(ASName.create("munahlefthebrew"), "05A3");
        hashMap.put(ASName.create("musicalnote"), "266A");
        hashMap.put(ASName.create("musicalnotedbl"), "266B");
        hashMap.put(ASName.create("musicflatsign"), "266D");
        hashMap.put(ASName.create("musicsharpsign"), "266F");
        hashMap.put(ASName.create("mussquare"), "33B2");
        hashMap.put(ASName.create("muvsquare"), "33B6");
        hashMap.put(ASName.create("muwsquare"), "33BC");
        hashMap.put(ASName.create("mvmegasquare"), "33B9");
        hashMap.put(ASName.create("mvsquare"), "33B7");
        hashMap.put(ASName.create("mwmegasquare"), "33BF");
        hashMap.put(ASName.create("mwsquare"), "33BD");
        hashMap.put(ASName.create("n"), "006E");
        hashMap.put(ASName.create("nabengali"), "09A8");
        hashMap.put(ASName.create("nabla"), "2207");
        hashMap.put(ASName.create("nacute"), "0144");
        hashMap.put(ASName.create("nadeva"), "0928");
        hashMap.put(ASName.create("nagujarati"), "0AA8");
        hashMap.put(ASName.create("nagurmukhi"), "0A28");
        hashMap.put(ASName.create("nahiragana"), "306A");
        hashMap.put(ASName.create("nakatakana"), "30CA");
        hashMap.put(ASName.create("nakatakanahalfwidth"), "FF85");
        hashMap.put(ASName.create("napostrophe"), "0149");
        hashMap.put(ASName.create("nasquare"), "3381");
        hashMap.put(ASName.create("nbopomofo"), "310B");
        hashMap.put(ASName.create("nbspace"), "00A0");
        hashMap.put(ASName.create("ncaron"), "0148");
        hashMap.put(ASName.create("ncedilla"), "0146");
        hashMap.put(ASName.create("ncircle"), "24DD");
        hashMap.put(ASName.create("ncircumflexbelow"), "1E4B");
        hashMap.put(ASName.create("ncommaaccent"), "0146");
        hashMap.put(ASName.create("ndotaccent"), "1E45");
        hashMap.put(ASName.create("ndotbelow"), "1E47");
        hashMap.put(ASName.create("nehiragana"), "306D");
        hashMap.put(ASName.create("nekatakana"), "30CD");
        hashMap.put(ASName.create("nekatakanahalfwidth"), "FF88");
        hashMap.put(ASName.create("newsheqelsign"), "20AA");
        hashMap.put(ASName.create("nfsquare"), "338B");
        hashMap.put(ASName.create("ngabengali"), "0999");
        hashMap.put(ASName.create("ngadeva"), "0919");
        hashMap.put(ASName.create("ngagujarati"), "0A99");
        hashMap.put(ASName.create("ngagurmukhi"), "0A19");
        hashMap.put(ASName.create("ngonguthai"), "0E07");
        hashMap.put(ASName.create("nhiragana"), "3093");
        hashMap.put(ASName.create("nhookleft"), "0272");
        hashMap.put(ASName.create("nhookretroflex"), "0273");
        hashMap.put(ASName.create("nieunacirclekorean"), "326F");
        hashMap.put(ASName.create("nieunaparenkorean"), "320F");
        hashMap.put(ASName.create("nieuncieuckorean"), "3135");
        hashMap.put(ASName.create("nieuncirclekorean"), "3261");
        hashMap.put(ASName.create("nieunhieuhkorean"), "3136");
        hashMap.put(ASName.create("nieunkorean"), "3134");
        hashMap.put(ASName.create("nieunpansioskorean"), "3168");
        hashMap.put(ASName.create("nieunparenkorean"), "3201");
        hashMap.put(ASName.create("nieunsioskorean"), "3167");
        hashMap.put(ASName.create("nieuntikeutkorean"), "3166");
        hashMap.put(ASName.create("nihiragana"), "306B");
        hashMap.put(ASName.create("nikatakana"), "30CB");
        hashMap.put(ASName.create("nikatakanahalfwidth"), "FF86");
        hashMap.put(ASName.create("nikhahitleftthai"), "F899");
        hashMap.put(ASName.create("nikhahitthai"), "0E4D");
        hashMap.put(ASName.create("nine"), "0039");
        hashMap.put(ASName.create("ninearabic"), "0669");
        hashMap.put(ASName.create("ninebengali"), "09EF");
        hashMap.put(ASName.create("ninecircle"), "2468");
        hashMap.put(ASName.create("ninecircleinversesansserif"), "2792");
        hashMap.put(ASName.create("ninedeva"), "096F");
        hashMap.put(ASName.create("ninegujarati"), "0AEF");
        hashMap.put(ASName.create("ninegurmukhi"), "0A6F");
        hashMap.put(ASName.create("ninehackarabic"), "0669");
        hashMap.put(ASName.create("ninehangzhou"), "3029");
        hashMap.put(ASName.create("nineideographicparen"), "3228");
        hashMap.put(ASName.create("nineinferior"), "2089");
        hashMap.put(ASName.create("ninemonospace"), "FF19");
        hashMap.put(ASName.create("nineoldstyle"), "F739");
        hashMap.put(ASName.create("nineparen"), "247C");
        hashMap.put(ASName.create("nineperiod"), "2490");
        hashMap.put(ASName.create("ninepersian"), "06F9");
        hashMap.put(ASName.create("nineroman"), "2178");
        hashMap.put(ASName.create("ninesuperior"), "2079");
        hashMap.put(ASName.create("nineteencircle"), "2472");
        hashMap.put(ASName.create("nineteenparen"), "2486");
        hashMap.put(ASName.create("nineteenperiod"), "249A");
        hashMap.put(ASName.create("ninethai"), "0E59");
        hashMap.put(ASName.create("nj"), "01CC");
        hashMap.put(ASName.create("njecyrillic"), "045A");
        hashMap.put(ASName.create("nkatakana"), "30F3");
        hashMap.put(ASName.create("nkatakanahalfwidth"), "FF9D");
        hashMap.put(ASName.create("nlegrightlong"), "019E");
        hashMap.put(ASName.create("nlinebelow"), "1E49");
        hashMap.put(ASName.create("nmonospace"), "FF4E");
        hashMap.put(ASName.create("nmsquare"), "339A");
        hashMap.put(ASName.create("nnabengali"), "09A3");
        hashMap.put(ASName.create("nnadeva"), "0923");
        hashMap.put(ASName.create("nnagujarati"), "0AA3");
        hashMap.put(ASName.create("nnagurmukhi"), "0A23");
        hashMap.put(ASName.create("nnnadeva"), "0929");
        hashMap.put(ASName.create("nohiragana"), "306E");
        hashMap.put(ASName.create("nokatakana"), "30CE");
        hashMap.put(ASName.create("nokatakanahalfwidth"), "FF89");
        hashMap.put(ASName.create("nonbreakingspace"), "00A0");
        hashMap.put(ASName.create("nonenthai"), "0E13");
        hashMap.put(ASName.create("nonuthai"), "0E19");
        hashMap.put(ASName.create("noonarabic"), "0646");
        hashMap.put(ASName.create("noonfinalarabic"), "FEE6");
        hashMap.put(ASName.create("noonghunnaarabic"), "06BA");
        hashMap.put(ASName.create("noonghunnafinalarabic"), "FB9F");
        hashMap.put(ASName.create("noonhehinitialarabic"), "FEE7FEEC");
        hashMap.put(ASName.create("nooninitialarabic"), "FEE7");
        hashMap.put(ASName.create("noonjeeminitialarabic"), "FCD2");
        hashMap.put(ASName.create("noonjeemisolatedarabic"), "FC4B");
        hashMap.put(ASName.create("noonmedialarabic"), "FEE8");
        hashMap.put(ASName.create("noonmeeminitialarabic"), "FCD5");
        hashMap.put(ASName.create("noonmeemisolatedarabic"), "FC4E");
        hashMap.put(ASName.create("noonnoonfinalarabic"), "FC8D");
        hashMap.put(ASName.create("notcontains"), "220C");
        hashMap.put(ASName.create("notelement"), "2209");
        hashMap.put(ASName.create("notelementof"), "2209");
        hashMap.put(ASName.create("notequal"), "2260");
        hashMap.put(ASName.create("notgreater"), "226F");
        hashMap.put(ASName.create("notgreaternorequal"), "2271");
        hashMap.put(ASName.create("notgreaternorless"), "2279");
        hashMap.put(ASName.create("notidentical"), "2262");
        hashMap.put(ASName.create("notless"), "226E");
        hashMap.put(ASName.create("notlessnorequal"), "2270");
        hashMap.put(ASName.create("notparallel"), "2226");
        hashMap.put(ASName.create("notprecedes"), "2280");
        hashMap.put(ASName.create("notsubset"), "2284");
        hashMap.put(ASName.create("notsucceeds"), "2281");
        hashMap.put(ASName.create("notsuperset"), "2285");
        hashMap.put(ASName.create("nowarmenian"), "0576");
        hashMap.put(ASName.create("nparen"), "24A9");
        hashMap.put(ASName.create("nssquare"), "33B1");
        hashMap.put(ASName.create("nsuperior"), "207F");
        hashMap.put(ASName.create("ntilde"), "00F1");
        hashMap.put(ASName.create("nu"), "03BD");
        hashMap.put(ASName.create("nuhiragana"), "306C");
        hashMap.put(ASName.create("nukatakana"), "30CC");
        hashMap.put(ASName.create("nukatakanahalfwidth"), "FF87");
        hashMap.put(ASName.create("nuktabengali"), "09BC");
        hashMap.put(ASName.create("nuktadeva"), "093C");
        hashMap.put(ASName.create("nuktagujarati"), "0ABC");
        hashMap.put(ASName.create("nuktagurmukhi"), "0A3C");
        hashMap.put(ASName.create("numbersign"), "0023");
        hashMap.put(ASName.create("numbersignmonospace"), "FF03");
        hashMap.put(ASName.create("numbersignsmall"), "FE5F");
        hashMap.put(ASName.create("numeralsigngreek"), "0374");
        hashMap.put(ASName.create("numeralsignlowergreek"), "0375");
        hashMap.put(ASName.create("numero"), "2116");
        hashMap.put(ASName.create("nun"), "05E0");
        hashMap.put(ASName.create("nundagesh"), "FB40");
        hashMap.put(ASName.create("nundageshhebrew"), "FB40");
        hashMap.put(ASName.create("nunhebrew"), "05E0");
        hashMap.put(ASName.create("nvsquare"), "33B5");
        hashMap.put(ASName.create("nwsquare"), "33BB");
        hashMap.put(ASName.create("nyabengali"), "099E");
        hashMap.put(ASName.create("nyadeva"), "091E");
        hashMap.put(ASName.create("nyagujarati"), "0A9E");
        hashMap.put(ASName.create("nyagurmukhi"), "0A1E");
        hashMap.put(ASName.create("o"), "006F");
        hashMap.put(ASName.create("oacute"), "00F3");
        hashMap.put(ASName.create("oangthai"), "0E2D");
        hashMap.put(ASName.create("obarred"), "0275");
        hashMap.put(ASName.create("obarredcyrillic"), "04E9");
        hashMap.put(ASName.create("obarreddieresiscyrillic"), "04EB");
        hashMap.put(ASName.create("obengali"), "0993");
        hashMap.put(ASName.create("obopomofo"), "311B");
        hashMap.put(ASName.create("obreve"), "014F");
        hashMap.put(ASName.create("ocandradeva"), "0911");
        hashMap.put(ASName.create("ocandragujarati"), "0A91");
        hashMap.put(ASName.create("ocandravowelsigndeva"), "0949");
        hashMap.put(ASName.create("ocandravowelsigngujarati"), "0AC9");
        hashMap.put(ASName.create("ocaron"), "01D2");
        hashMap.put(ASName.create("ocircle"), "24DE");
        hashMap.put(ASName.create("ocircumflex"), "00F4");
        hashMap.put(ASName.create("ocircumflexacute"), "1ED1");
        hashMap.put(ASName.create("ocircumflexdotbelow"), "1ED9");
        hashMap.put(ASName.create("ocircumflexgrave"), "1ED3");
        hashMap.put(ASName.create("ocircumflexhookabove"), "1ED5");
        hashMap.put(ASName.create("ocircumflextilde"), "1ED7");
        hashMap.put(ASName.create("ocyrillic"), "043E");
        hashMap.put(ASName.create("odblacute"), "0151");
        hashMap.put(ASName.create("odblgrave"), "020D");
        hashMap.put(ASName.create("odeva"), "0913");
        hashMap.put(ASName.create("odieresis"), "00F6");
        hashMap.put(ASName.create("odieresiscyrillic"), "04E7");
        hashMap.put(ASName.create("odotbelow"), "1ECD");
        hashMap.put(ASName.create("oe"), "0153");
        hashMap.put(ASName.create("oekorean"), "315A");
        hashMap.put(ASName.create("ogonek"), "02DB");
        hashMap.put(ASName.create("ogonekcmb"), "0328");
        hashMap.put(ASName.create("ograve"), "00F2");
        hashMap.put(ASName.create("ogujarati"), "0A93");
        hashMap.put(ASName.create("oharmenian"), "0585");
        hashMap.put(ASName.create("ohiragana"), "304A");
        hashMap.put(ASName.create("ohookabove"), "1ECF");
        hashMap.put(ASName.create("ohorn"), "01A1");
        hashMap.put(ASName.create("ohornacute"), "1EDB");
        hashMap.put(ASName.create("ohorndotbelow"), "1EE3");
        hashMap.put(ASName.create("ohorngrave"), "1EDD");
        hashMap.put(ASName.create("ohornhookabove"), "1EDF");
        hashMap.put(ASName.create("ohorntilde"), "1EE1");
        hashMap.put(ASName.create("ohungarumlaut"), "0151");
        hashMap.put(ASName.create("oi"), "01A3");
        hashMap.put(ASName.create("oinvertedbreve"), "020F");
        hashMap.put(ASName.create("okatakana"), "30AA");
        hashMap.put(ASName.create("okatakanahalfwidth"), "FF75");
        hashMap.put(ASName.create("okorean"), "3157");
        hashMap.put(ASName.create("olehebrew"), "05AB");
        hashMap.put(ASName.create("omacron"), "014D");
        hashMap.put(ASName.create("omacronacute"), "1E53");
        hashMap.put(ASName.create("omacrongrave"), "1E51");
        hashMap.put(ASName.create("omdeva"), "0950");
        hashMap.put(ASName.create("omega"), "03C9");
        hashMap.put(ASName.create("omega1"), "03D6");
        hashMap.put(ASName.create("omegacyrillic"), "0461");
        hashMap.put(ASName.create("omegalatinclosed"), "0277");
        hashMap.put(ASName.create("omegaroundcyrillic"), "047B");
        hashMap.put(ASName.create("omegatitlocyrillic"), "047D");
        hashMap.put(ASName.create("omegatonos"), "03CE");
        hashMap.put(ASName.create("omgujarati"), "0AD0");
        hashMap.put(ASName.create("omicron"), "03BF");
        hashMap.put(ASName.create("omicrontonos"), "03CC");
        hashMap.put(ASName.create("omonospace"), "FF4F");
        hashMap.put(ASName.create("one"), "0031");
        hashMap.put(ASName.create("onearabic"), "0661");
        hashMap.put(ASName.create("onebengali"), "09E7");
        hashMap.put(ASName.create("onecircle"), "2460");
        hashMap.put(ASName.create("onecircleinversesansserif"), "278A");
        hashMap.put(ASName.create("onedeva"), "0967");
        hashMap.put(ASName.create("onedotenleader"), "2024");
        hashMap.put(ASName.create("oneeighth"), "215B");
        hashMap.put(ASName.create("onefitted"), "F6DC");
        hashMap.put(ASName.create("onegujarati"), "0AE7");
        hashMap.put(ASName.create("onegurmukhi"), "0A67");
        hashMap.put(ASName.create("onehackarabic"), "0661");
        hashMap.put(ASName.create("onehalf"), "00BD");
        hashMap.put(ASName.create("onehangzhou"), "3021");
        hashMap.put(ASName.create("oneideographicparen"), "3220");
        hashMap.put(ASName.create("oneinferior"), "2081");
        hashMap.put(ASName.create("onemonospace"), "FF11");
        hashMap.put(ASName.create("onenumeratorbengali"), "09F4");
        hashMap.put(ASName.create("oneoldstyle"), "F731");
        hashMap.put(ASName.create("oneparen"), "2474");
        hashMap.put(ASName.create("oneperiod"), "2488");
        hashMap.put(ASName.create("onepersian"), "06F1");
        hashMap.put(ASName.create("onequarter"), "00BC");
        hashMap.put(ASName.create("oneroman"), "2170");
        hashMap.put(ASName.create("onesuperior"), "00B9");
        hashMap.put(ASName.create("onethai"), "0E51");
        hashMap.put(ASName.create("onethird"), "2153");
        hashMap.put(ASName.create("oogonek"), "01EB");
        hashMap.put(ASName.create("oogonekmacron"), "01ED");
        hashMap.put(ASName.create("oogurmukhi"), "0A13");
        hashMap.put(ASName.create("oomatragurmukhi"), "0A4B");
        hashMap.put(ASName.create("oopen"), "0254");
        hashMap.put(ASName.create("oparen"), "24AA");
        hashMap.put(ASName.create("openbullet"), "25E6");
        hashMap.put(ASName.create("option"), "2325");
        hashMap.put(ASName.create("ordfeminine"), "00AA");
        hashMap.put(ASName.create("ordmasculine"), "00BA");
        hashMap.put(ASName.create("orthogonal"), "221F");
        hashMap.put(ASName.create("oshortdeva"), "0912");
        hashMap.put(ASName.create("oshortvowelsigndeva"), "094A");
        hashMap.put(ASName.create("oslash"), "00F8");
        hashMap.put(ASName.create("oslashacute"), "01FF");
        hashMap.put(ASName.create("osmallhiragana"), "3049");
        hashMap.put(ASName.create("osmallkatakana"), "30A9");
        hashMap.put(ASName.create("osmallkatakanahalfwidth"), "FF6B");
        hashMap.put(ASName.create("ostrokeacute"), "01FF");
        hashMap.put(ASName.create("osuperior"), "F6F0");
        hashMap.put(ASName.create("otcyrillic"), "047F");
        hashMap.put(ASName.create("otilde"), "00F5");
        hashMap.put(ASName.create("otildeacute"), "1E4D");
        hashMap.put(ASName.create("otildedieresis"), "1E4F");
        hashMap.put(ASName.create("oubopomofo"), "3121");
        hashMap.put(ASName.create("overline"), "203E");
        hashMap.put(ASName.create("overlinecenterline"), "FE4A");
        hashMap.put(ASName.create("overlinecmb"), "0305");
        hashMap.put(ASName.create("overlinedashed"), "FE49");
        hashMap.put(ASName.create("overlinedblwavy"), "FE4C");
        hashMap.put(ASName.create("overlinewavy"), "FE4B");
        hashMap.put(ASName.create("overscore"), "00AF");
        hashMap.put(ASName.create("ovowelsignbengali"), "09CB");
        hashMap.put(ASName.create("ovowelsigndeva"), "094B");
        hashMap.put(ASName.create("ovowelsigngujarati"), "0ACB");
        hashMap.put(ASName.create("p"), "0070");
        hashMap.put(ASName.create("paampssquare"), "3380");
        hashMap.put(ASName.create("paasentosquare"), "332B");
        hashMap.put(ASName.create("pabengali"), "09AA");
        hashMap.put(ASName.create("pacute"), "1E55");
        hashMap.put(ASName.create("padeva"), "092A");
        hashMap.put(ASName.create("pagedown"), "21DF");
        hashMap.put(ASName.create("pageup"), "21DE");
        hashMap.put(ASName.create("pagujarati"), "0AAA");
        hashMap.put(ASName.create("pagurmukhi"), "0A2A");
        hashMap.put(ASName.create("pahiragana"), "3071");
        hashMap.put(ASName.create("paiyannoithai"), "0E2F");
        hashMap.put(ASName.create("pakatakana"), "30D1");
        hashMap.put(ASName.create("palatalizationcyrilliccmb"), "0484");
        hashMap.put(ASName.create("palochkacyrillic"), "04C0");
        hashMap.put(ASName.create("pansioskorean"), "317F");
        hashMap.put(ASName.create("paragraph"), "00B6");
        hashMap.put(ASName.create("parallel"), "2225");
        hashMap.put(ASName.create("parenleft"), "0028");
        hashMap.put(ASName.create("parenleftaltonearabic"), "FD3E");
        hashMap.put(ASName.create("parenleftbt"), "F8ED");
        hashMap.put(ASName.create("parenleftex"), "F8EC");
        hashMap.put(ASName.create("parenleftinferior"), "208D");
        hashMap.put(ASName.create("parenleftmonospace"), "FF08");
        hashMap.put(ASName.create("parenleftsmall"), "FE59");
        hashMap.put(ASName.create("parenleftsuperior"), "207D");
        hashMap.put(ASName.create("parenlefttp"), "F8EB");
        hashMap.put(ASName.create("parenleftvertical"), "FE35");
        hashMap.put(ASName.create("parenright"), "0029");
        hashMap.put(ASName.create("parenrightaltonearabic"), "FD3F");
        hashMap.put(ASName.create("parenrightbt"), "F8F8");
        hashMap.put(ASName.create("parenrightex"), "F8F7");
        hashMap.put(ASName.create("parenrightinferior"), "208E");
        hashMap.put(ASName.create("parenrightmonospace"), "FF09");
        hashMap.put(ASName.create("parenrightsmall"), "FE5A");
        hashMap.put(ASName.create("parenrightsuperior"), "207E");
        hashMap.put(ASName.create("parenrighttp"), "F8F6");
        hashMap.put(ASName.create("parenrightvertical"), "FE36");
        hashMap.put(ASName.create("partialdiff"), "2202");
        hashMap.put(ASName.create("paseqhebrew"), "05C0");
        hashMap.put(ASName.create("pashtahebrew"), "0599");
        hashMap.put(ASName.create("pasquare"), "33A9");
        hashMap.put(ASName.create("patah"), "05B7");
        hashMap.put(ASName.create("patah11"), "05B7");
        hashMap.put(ASName.create("patah1d"), "05B7");
        hashMap.put(ASName.create("patah2a"), "05B7");
        hashMap.put(ASName.create("patahhebrew"), "05B7");
        hashMap.put(ASName.create("patahnarrowhebrew"), "05B7");
        hashMap.put(ASName.create("patahquarterhebrew"), "05B7");
        hashMap.put(ASName.create("patahwidehebrew"), "05B7");
        hashMap.put(ASName.create("pazerhebrew"), "05A1");
        hashMap.put(ASName.create("pbopomofo"), "3106");
        hashMap.put(ASName.create("pcircle"), "24DF");
        hashMap.put(ASName.create("pdotaccent"), "1E57");
        hashMap.put(ASName.create("pe"), "05E4");
        hashMap.put(ASName.create("pecyrillic"), "043F");
        hashMap.put(ASName.create("pedagesh"), "FB44");
        hashMap.put(ASName.create("pedageshhebrew"), "FB44");
        hashMap.put(ASName.create("peezisquare"), "333B");
        hashMap.put(ASName.create("pefinaldageshhebrew"), "FB43");
        hashMap.put(ASName.create("peharabic"), "067E");
        hashMap.put(ASName.create("peharmenian"), "057A");
        hashMap.put(ASName.create("pehebrew"), "05E4");
        hashMap.put(ASName.create("pehfinalarabic"), "FB57");
        hashMap.put(ASName.create("pehinitialarabic"), "FB58");
        hashMap.put(ASName.create("pehiragana"), "307A");
        hashMap.put(ASName.create("pehmedialarabic"), "FB59");
        hashMap.put(ASName.create("pekatakana"), "30DA");
        hashMap.put(ASName.create("pemiddlehookcyrillic"), "04A7");
        hashMap.put(ASName.create("perafehebrew"), "FB4E");
        hashMap.put(ASName.create("percent"), "0025");
        hashMap.put(ASName.create("percentarabic"), "066A");
        hashMap.put(ASName.create("percentmonospace"), "FF05");
        hashMap.put(ASName.create("percentsmall"), "FE6A");
        hashMap.put(ASName.create("period"), "002E");
        hashMap.put(ASName.create("periodarmenian"), "0589");
        hashMap.put(ASName.create("periodcentered"), "00B7");
        hashMap.put(ASName.create("periodhalfwidth"), "FF61");
        hashMap.put(ASName.create("periodinferior"), "F6E7");
        hashMap.put(ASName.create("periodmonospace"), "FF0E");
        hashMap.put(ASName.create("periodsmall"), "FE52");
        hashMap.put(ASName.create("periodsuperior"), "F6E8");
        hashMap.put(ASName.create("perispomenigreekcmb"), "0342");
        hashMap.put(ASName.create("perpendicular"), "22A5");
        hashMap.put(ASName.create("perthousand"), "2030");
        hashMap.put(ASName.create("peseta"), "20A7");
        hashMap.put(ASName.create("pfsquare"), "338A");
        hashMap.put(ASName.create("phabengali"), "09AB");
        hashMap.put(ASName.create("phadeva"), "092B");
        hashMap.put(ASName.create("phagujarati"), "0AAB");
        hashMap.put(ASName.create("phagurmukhi"), "0A2B");
        hashMap.put(ASName.create("phi"), "03C6");
        hashMap.put(ASName.create("phi1"), "03D5");
        hashMap.put(ASName.create("phieuphacirclekorean"), "327A");
        hashMap.put(ASName.create("phieuphaparenkorean"), "321A");
        hashMap.put(ASName.create("phieuphcirclekorean"), "326C");
        hashMap.put(ASName.create("phieuphkorean"), "314D");
        hashMap.put(ASName.create("phieuphparenkorean"), "320C");
        hashMap.put(ASName.create("philatin"), "0278");
        hashMap.put(ASName.create("phinthuthai"), "0E3A");
        hashMap.put(ASName.create("phisymbolgreek"), "03D5");
        hashMap.put(ASName.create("phook"), "01A5");
        hashMap.put(ASName.create("phophanthai"), "0E1E");
        hashMap.put(ASName.create("phophungthai"), "0E1C");
        hashMap.put(ASName.create("phosamphaothai"), "0E20");
        hashMap.put(ASName.create("pi"), "03C0");
        hashMap.put(ASName.create("pieupacirclekorean"), "3273");
        hashMap.put(ASName.create("pieupaparenkorean"), "3213");
        hashMap.put(ASName.create("pieupcieuckorean"), "3176");
        hashMap.put(ASName.create("pieupcirclekorean"), "3265");
        hashMap.put(ASName.create("pieupkiyeokkorean"), "3172");
        hashMap.put(ASName.create("pieupkorean"), "3142");
        hashMap.put(ASName.create("pieupparenkorean"), "3205");
        hashMap.put(ASName.create("pieupsioskiyeokkorean"), "3174");
        hashMap.put(ASName.create("pieupsioskorean"), "3144");
        hashMap.put(ASName.create("pieupsiostikeutkorean"), "3175");
        hashMap.put(ASName.create("pieupthieuthkorean"), "3177");
        hashMap.put(ASName.create("pieuptikeutkorean"), "3173");
        hashMap.put(ASName.create("pihiragana"), "3074");
        hashMap.put(ASName.create("pikatakana"), "30D4");
        hashMap.put(ASName.create("pisymbolgreek"), "03D6");
        hashMap.put(ASName.create("piwrarmenian"), "0583");
        hashMap.put(ASName.create("plus"), "002B");
        hashMap.put(ASName.create("plusbelowcmb"), "031F");
        hashMap.put(ASName.create("pluscircle"), "2295");
        hashMap.put(ASName.create("plusminus"), "00B1");
        hashMap.put(ASName.create("plusmod"), "02D6");
        hashMap.put(ASName.create("plusmonospace"), "FF0B");
        hashMap.put(ASName.create("plussmall"), "FE62");
        hashMap.put(ASName.create("plussuperior"), "207A");
        hashMap.put(ASName.create("pmonospace"), "FF50");
        hashMap.put(ASName.create("pmsquare"), "33D8");
        hashMap.put(ASName.create("pohiragana"), "307D");
        hashMap.put(ASName.create("pointingindexdownwhite"), "261F");
        hashMap.put(ASName.create("pointingindexleftwhite"), "261C");
        hashMap.put(ASName.create("pointingindexrightwhite"), "261E");
        hashMap.put(ASName.create("pointingindexupwhite"), "261D");
        hashMap.put(ASName.create("pokatakana"), "30DD");
        hashMap.put(ASName.create("poplathai"), "0E1B");
        hashMap.put(ASName.create("postalmark"), "3012");
        hashMap.put(ASName.create("postalmarkface"), "3020");
        hashMap.put(ASName.create("pparen"), "24AB");
        hashMap.put(ASName.create("precedes"), "227A");
        hashMap.put(ASName.create("prescription"), "211E");
        hashMap.put(ASName.create("primemod"), "02B9");
        hashMap.put(ASName.create("primereversed"), "2035");
        hashMap.put(ASName.create("product"), "220F");
        hashMap.put(ASName.create("projective"), "2305");
        hashMap.put(ASName.create("prolongedkana"), "30FC");
        hashMap.put(ASName.create("propellor"), "2318");
        hashMap.put(ASName.create("propersubset"), "2282");
        hashMap.put(ASName.create("propersuperset"), "2283");
        hashMap.put(ASName.create("proportion"), "2237");
        hashMap.put(ASName.create("proportional"), "221D");
        hashMap.put(ASName.create("psi"), "03C8");
        hashMap.put(ASName.create("psicyrillic"), "0471");
        hashMap.put(ASName.create("psilipneumatacyrilliccmb"), "0486");
        hashMap.put(ASName.create("pssquare"), "33B0");
        hashMap.put(ASName.create("puhiragana"), "3077");
        hashMap.put(ASName.create("pukatakana"), "30D7");
        hashMap.put(ASName.create("pvsquare"), "33B4");
        hashMap.put(ASName.create("pwsquare"), "33BA");
        hashMap.put(ASName.create("q"), "0071");
        hashMap.put(ASName.create("qadeva"), "0958");
        hashMap.put(ASName.create("qadmahebrew"), "05A8");
        hashMap.put(ASName.create("qafarabic"), "0642");
        hashMap.put(ASName.create("qaffinalarabic"), "FED6");
        hashMap.put(ASName.create("qafinitialarabic"), "FED7");
        hashMap.put(ASName.create("qafmedialarabic"), "FED8");
        hashMap.put(ASName.create("qamats"), "05B8");
        hashMap.put(ASName.create("qamats10"), "05B8");
        hashMap.put(ASName.create("qamats1a"), "05B8");
        hashMap.put(ASName.create("qamats1c"), "05B8");
        hashMap.put(ASName.create("qamats27"), "05B8");
        hashMap.put(ASName.create("qamats29"), "05B8");
        hashMap.put(ASName.create("qamats33"), "05B8");
        hashMap.put(ASName.create("qamatsde"), "05B8");
        hashMap.put(ASName.create("qamatshebrew"), "05B8");
        hashMap.put(ASName.create("qamatsnarrowhebrew"), "05B8");
        hashMap.put(ASName.create("qamatsqatanhebrew"), "05B8");
        hashMap.put(ASName.create("qamatsqatannarrowhebrew"), "05B8");
        hashMap.put(ASName.create("qamatsqatanquarterhebrew"), "05B8");
        hashMap.put(ASName.create("qamatsqatanwidehebrew"), "05B8");
        hashMap.put(ASName.create("qamatsquarterhebrew"), "05B8");
        hashMap.put(ASName.create("qamatswidehebrew"), "05B8");
        hashMap.put(ASName.create("qarneyparahebrew"), "059F");
        hashMap.put(ASName.create("qbopomofo"), "3111");
        hashMap.put(ASName.create("qcircle"), "24E0");
        hashMap.put(ASName.create("qhook"), "02A0");
        hashMap.put(ASName.create("qmonospace"), "FF51");
        hashMap.put(ASName.create("qof"), "05E7");
        hashMap.put(ASName.create("qofdagesh"), "FB47");
        hashMap.put(ASName.create("qofdageshhebrew"), "FB47");
        hashMap.put(ASName.create("qofhatafpatah"), "05E7 05B2");
        hashMap.put(ASName.create("qofhatafpatahhebrew"), "05E705B2");
        hashMap.put(ASName.create("qofhatafsegol"), "05E7 05B1");
        hashMap.put(ASName.create("qofhatafsegolhebrew"), "05E705B1");
        hashMap.put(ASName.create("qofhebrew"), "05E7");
        hashMap.put(ASName.create("qofhiriq"), "05E705B4");
        hashMap.put(ASName.create("qofhiriqhebrew"), "05E705B4");
        hashMap.put(ASName.create("qofholam"), "05E7 05B9");
        hashMap.put(ASName.create("qofholamhebrew"), "05E705B9");
        hashMap.put(ASName.create("qofpatah"), "05E7 05B7");
        hashMap.put(ASName.create("qofpatahhebrew"), "05E705B7");
        hashMap.put(ASName.create("qofqamats"), "05E705B8");
        hashMap.put(ASName.create("qofqamatshebrew"), "05E705B8");
        hashMap.put(ASName.create("qofqubuts"), "05E705BB");
        hashMap.put(ASName.create("qofqubutshebrew"), "05E705BB");
        hashMap.put(ASName.create("qofsegol"), "05E705B6");
        hashMap.put(ASName.create("qofsegolhebrew"), "05E705B6");
        hashMap.put(ASName.create("qofsheva"), "05E705B0");
        hashMap.put(ASName.create("qofshevahebrew"), "05E705B0");
        hashMap.put(ASName.create("qoftsere"), "05E705B5");
        hashMap.put(ASName.create("qoftserehebrew"), "05E705B5");
        hashMap.put(ASName.create("qparen"), "24AC");
        hashMap.put(ASName.create("quarternote"), "2669");
        hashMap.put(ASName.create("qubuts"), "05BB");
        hashMap.put(ASName.create("qubuts18"), "05BB");
        hashMap.put(ASName.create("qubuts25"), "05BB");
        hashMap.put(ASName.create("qubuts31"), "05BB");
        hashMap.put(ASName.create("qubutshebrew"), "05BB");
        hashMap.put(ASName.create("qubutsnarrowhebrew"), "05BB");
        hashMap.put(ASName.create("qubutsquarterhebrew"), "05BB");
        hashMap.put(ASName.create("qubutswidehebrew"), "05BB");
        hashMap.put(ASName.create("question"), "003F");
        hashMap.put(ASName.create("questionarabic"), "061F");
        hashMap.put(ASName.create("questionarmenian"), "055E");
        hashMap.put(ASName.create("questiondown"), "00BF");
        hashMap.put(ASName.create("questiondownsmall"), "F7BF");
        hashMap.put(ASName.create("questiongreek"), "037E");
        hashMap.put(ASName.create("questionmonospace"), "FF1F");
        hashMap.put(ASName.create("questionsmall"), "F73F");
        hashMap.put(ASName.create("quotedbl"), "0022");
        hashMap.put(ASName.create("quotedblbase"), "201E");
        hashMap.put(ASName.create("quotedblleft"), "201C");
        hashMap.put(ASName.create("quotedblmonospace"), "FF02");
        hashMap.put(ASName.create("quotedblprime"), "301E");
        hashMap.put(ASName.create("quotedblprimereversed"), "301D");
        hashMap.put(ASName.create("quotedblright"), "201D");
        hashMap.put(ASName.create("quoteleft"), "2018");
        hashMap.put(ASName.create("quoteleftreversed"), "201B");
        hashMap.put(ASName.create("quotereversed"), "201B");
        hashMap.put(ASName.create("quoteright"), "2019");
        hashMap.put(ASName.create("quoterightn"), "0149");
        hashMap.put(ASName.create("quotesinglbase"), "201A");
        hashMap.put(ASName.create("quotesingle"), "0027");
        hashMap.put(ASName.create("quotesinglemonospace"), "FF07");
        hashMap.put(ASName.create("r"), "0072");
        hashMap.put(ASName.create("raarmenian"), "057C");
        hashMap.put(ASName.create("rabengali"), "09B0");
        hashMap.put(ASName.create("racute"), "0155");
        hashMap.put(ASName.create("radeva"), "0930");
        hashMap.put(ASName.create("radical"), "221A");
        hashMap.put(ASName.create("radicalex"), "F8E5");
        hashMap.put(ASName.create("radoverssquare"), "33AE");
        hashMap.put(ASName.create("radoverssquaredsquare"), "33AF");
        hashMap.put(ASName.create("radsquare"), "33AD");
        hashMap.put(ASName.create("rafe"), "05BF");
        hashMap.put(ASName.create("rafehebrew"), "05BF");
        hashMap.put(ASName.create("ragujarati"), "0AB0");
        hashMap.put(ASName.create("ragurmukhi"), "0A30");
        hashMap.put(ASName.create("rahiragana"), "3089");
        hashMap.put(ASName.create("rakatakana"), "30E9");
        hashMap.put(ASName.create("rakatakanahalfwidth"), "FF97");
        hashMap.put(ASName.create("ralowerdiagonalbengali"), "09F1");
        hashMap.put(ASName.create("ramiddlediagonalbengali"), "09F0");
        hashMap.put(ASName.create("ramshorn"), "0264");
        hashMap.put(ASName.create("ratio"), "2236");
        hashMap.put(ASName.create("rbopomofo"), "3116");
        hashMap.put(ASName.create("rcaron"), "0159");
        hashMap.put(ASName.create("rcedilla"), "0157");
        hashMap.put(ASName.create("rcircle"), "24E1");
        hashMap.put(ASName.create("rcommaaccent"), "0157");
        hashMap.put(ASName.create("rdblgrave"), "0211");
        hashMap.put(ASName.create("rdotaccent"), "1E59");
        hashMap.put(ASName.create("rdotbelow"), "1E5B");
        hashMap.put(ASName.create("rdotbelowmacron"), "1E5D");
        hashMap.put(ASName.create("referencemark"), "203B");
        hashMap.put(ASName.create("reflexsubset"), "2286");
        hashMap.put(ASName.create("reflexsuperset"), "2287");
        hashMap.put(ASName.create("registered"), "00AE");
        hashMap.put(ASName.create("registersans"), "F8E8");
        hashMap.put(ASName.create("registerserif"), "F6DA");
        hashMap.put(ASName.create("reharabic"), "0631");
        hashMap.put(ASName.create("reharmenian"), "0580");
        hashMap.put(ASName.create("rehfinalarabic"), "FEAE");
        hashMap.put(ASName.create("rehiragana"), "308C");
        hashMap.put(ASName.create("rehyehaleflamarabic"), "0631FEF3FE8E0644");
        hashMap.put(ASName.create("rekatakana"), "30EC");
        hashMap.put(ASName.create("rekatakanahalfwidth"), "FF9A");
        hashMap.put(ASName.create("resh"), "05E8");
        hashMap.put(ASName.create("reshdageshhebrew"), "FB48");
        hashMap.put(ASName.create("reshhatafpatah"), "05E8 05B2");
        hashMap.put(ASName.create("reshhatafpatahhebrew"), "05E805B2");
        hashMap.put(ASName.create("reshhatafsegol"), "05E8 05B1");
        hashMap.put(ASName.create("reshhatafsegolhebrew"), "05E805B1");
        hashMap.put(ASName.create("reshhebrew"), "05E8");
        hashMap.put(ASName.create("reshhiriq"), "05E805B4");
        hashMap.put(ASName.create("reshhiriqhebrew"), "05E805B4");
        hashMap.put(ASName.create("reshholam"), "05E805B9");
        hashMap.put(ASName.create("reshholamhebrew"), "05E805B9");
        hashMap.put(ASName.create("reshpatah"), "05E805B7");
        hashMap.put(ASName.create("reshpatahhebrew"), "05E805B7");
        hashMap.put(ASName.create("reshqamats"), "05E805B8");
        hashMap.put(ASName.create("reshqamatshebrew"), "05E805B8");
        hashMap.put(ASName.create("reshqubuts"), "05E805BB");
        hashMap.put(ASName.create("reshqubutshebrew"), "05E805BB");
        hashMap.put(ASName.create("reshsegol"), "05E805B6");
        hashMap.put(ASName.create("reshsegolhebrew"), "05E805B6");
        hashMap.put(ASName.create("reshsheva"), "05E805B0");
        hashMap.put(ASName.create("reshshevahebrew"), "05E805B0");
        hashMap.put(ASName.create("reshtsere"), "05E805B5");
        hashMap.put(ASName.create("reshtserehebrew"), "05E805B5");
        hashMap.put(ASName.create("reversedtilde"), "223D");
        hashMap.put(ASName.create("reviahebrew"), "0597");
        hashMap.put(ASName.create("reviamugrashhebrew"), "0597");
        hashMap.put(ASName.create("revlogicalnot"), "2310");
        hashMap.put(ASName.create("rfishhook"), "027E");
        hashMap.put(ASName.create("rfishhookreversed"), "027F");
        hashMap.put(ASName.create("rhabengali"), "09DD");
        hashMap.put(ASName.create("rhadeva"), "095D");
        hashMap.put(ASName.create("rho"), "03C1");
        hashMap.put(ASName.create("rhook"), "027D");
        hashMap.put(ASName.create("rhookturned"), "027B");
        hashMap.put(ASName.create("rhookturnedsuperior"), "02B5");
        hashMap.put(ASName.create("rhosymbolgreek"), "03F1");
        hashMap.put(ASName.create("rhotichookmod"), "02DE");
        hashMap.put(ASName.create("rieulacirclekorean"), "3271");
        hashMap.put(ASName.create("rieulaparenkorean"), "3211");
        hashMap.put(ASName.create("rieulcirclekorean"), "3263");
        hashMap.put(ASName.create("rieulhieuhkorean"), "3140");
        hashMap.put(ASName.create("rieulkiyeokkorean"), "313A");
        hashMap.put(ASName.create("rieulkiyeoksioskorean"), "3169");
        hashMap.put(ASName.create("rieulkorean"), "3139");
        hashMap.put(ASName.create("rieulmieumkorean"), "313B");
        hashMap.put(ASName.create("rieulpansioskorean"), "316C");
        hashMap.put(ASName.create("rieulparenkorean"), "3203");
        hashMap.put(ASName.create("rieulphieuphkorean"), "313F");
        hashMap.put(ASName.create("rieulpieupkorean"), "313C");
        hashMap.put(ASName.create("rieulpieupsioskorean"), "316B");
        hashMap.put(ASName.create("rieulsioskorean"), "313D");
        hashMap.put(ASName.create("rieulthieuthkorean"), "313E");
        hashMap.put(ASName.create("rieultikeutkorean"), "316A");
        hashMap.put(ASName.create("rieulyeorinhieuhkorean"), "316D");
        hashMap.put(ASName.create("rightangle"), "221F");
        hashMap.put(ASName.create("righttackbelowcmb"), "0319");
        hashMap.put(ASName.create("righttriangle"), "22BF");
        hashMap.put(ASName.create("rihiragana"), "308A");
        hashMap.put(ASName.create("rikatakana"), "30EA");
        hashMap.put(ASName.create("rikatakanahalfwidth"), "FF98");
        hashMap.put(ASName.create("ring"), "02DA");
        hashMap.put(ASName.create("ringbelowcmb"), "0325");
        hashMap.put(ASName.create("ringcmb"), "030A");
        hashMap.put(ASName.create("ringhalfleft"), "02BF");
        hashMap.put(ASName.create("ringhalfleftarmenian"), "0559");
        hashMap.put(ASName.create("ringhalfleftbelowcmb"), "031C");
        hashMap.put(ASName.create("ringhalfleftcentered"), "02D3");
        hashMap.put(ASName.create("ringhalfright"), "02BE");
        hashMap.put(ASName.create("ringhalfrightbelowcmb"), "0339");
        hashMap.put(ASName.create("ringhalfrightcentered"), "02D2");
        hashMap.put(ASName.create("rinvertedbreve"), "0213");
        hashMap.put(ASName.create("rittorusquare"), "3351");
        hashMap.put(ASName.create("rlinebelow"), "1E5F");
        hashMap.put(ASName.create("rlongleg"), "027C");
        hashMap.put(ASName.create("rlonglegturned"), "027A");
        hashMap.put(ASName.create("rmonospace"), "FF52");
        hashMap.put(ASName.create("rohiragana"), "308D");
        hashMap.put(ASName.create("rokatakana"), "30ED");
        hashMap.put(ASName.create("rokatakanahalfwidth"), "FF9B");
        hashMap.put(ASName.create("roruathai"), "0E23");
        hashMap.put(ASName.create("rparen"), "24AD");
        hashMap.put(ASName.create("rrabengali"), "09DC");
        hashMap.put(ASName.create("rradeva"), "0931");
        hashMap.put(ASName.create("rragurmukhi"), "0A5C");
        hashMap.put(ASName.create("rreharabic"), "0691");
        hashMap.put(ASName.create("rrehfinalarabic"), "FB8D");
        hashMap.put(ASName.create("rrvocalicbengali"), "09E0");
        hashMap.put(ASName.create("rrvocalicdeva"), "0960");
        hashMap.put(ASName.create("rrvocalicgujarati"), "0AE0");
        hashMap.put(ASName.create("rrvocalicvowelsignbengali"), "09C4");
        hashMap.put(ASName.create("rrvocalicvowelsigndeva"), "0944");
        hashMap.put(ASName.create("rrvocalicvowelsigngujarati"), "0AC4");
        hashMap.put(ASName.create("rsuperior"), "F6F1");
        hashMap.put(ASName.create("rtblock"), "2590");
        hashMap.put(ASName.create("rturned"), "0279");
        hashMap.put(ASName.create("rturnedsuperior"), "02B4");
        hashMap.put(ASName.create("ruhiragana"), "308B");
        hashMap.put(ASName.create("rukatakana"), "30EB");
        hashMap.put(ASName.create("rukatakanahalfwidth"), "FF99");
        hashMap.put(ASName.create("rupeemarkbengali"), "09F2");
        hashMap.put(ASName.create("rupeesignbengali"), "09F3");
        hashMap.put(ASName.create("rupiah"), "F6DD");
        hashMap.put(ASName.create("ruthai"), "0E24");
        hashMap.put(ASName.create("rvocalicbengali"), "098B");
        hashMap.put(ASName.create("rvocalicdeva"), "090B");
        hashMap.put(ASName.create("rvocalicgujarati"), "0A8B");
        hashMap.put(ASName.create("rvocalicvowelsignbengali"), "09C3");
        hashMap.put(ASName.create("rvocalicvowelsigndeva"), "0943");
        hashMap.put(ASName.create("rvocalicvowelsigngujarati"), "0AC3");
        hashMap.put(ASName.create("s"), "0073");
        hashMap.put(ASName.create("sabengali"), "09B8");
        hashMap.put(ASName.create("sacute"), "015B");
        hashMap.put(ASName.create("sacutedotaccent"), "1E65");
        hashMap.put(ASName.create("sadarabic"), "0635");
        hashMap.put(ASName.create("sadeva"), "0938");
        hashMap.put(ASName.create("sadfinalarabic"), "FEBA");
        hashMap.put(ASName.create("sadinitialarabic"), "FEBB");
        hashMap.put(ASName.create("sadmedialarabic"), "FEBC");
        hashMap.put(ASName.create("sagujarati"), "0AB8");
        hashMap.put(ASName.create("sagurmukhi"), "0A38");
        hashMap.put(ASName.create("sahiragana"), "3055");
        hashMap.put(ASName.create("sakatakana"), "30B5");
        hashMap.put(ASName.create("sakatakanahalfwidth"), "FF7B");
        hashMap.put(ASName.create("sallallahoualayhewasallamarabic"), "FDFA");
        hashMap.put(ASName.create("samekh"), "05E1");
        hashMap.put(ASName.create("samekhdagesh"), "FB41");
        hashMap.put(ASName.create("samekhdageshhebrew"), "FB41");
        hashMap.put(ASName.create("samekhhebrew"), "05E1");
        hashMap.put(ASName.create("saraaathai"), "0E32");
        hashMap.put(ASName.create("saraaethai"), "0E41");
        hashMap.put(ASName.create("saraaimaimalaithai"), "0E44");
        hashMap.put(ASName.create("saraaimaimuanthai"), "0E43");
        hashMap.put(ASName.create("saraamthai"), "0E33");
        hashMap.put(ASName.create("saraathai"), "0E30");
        hashMap.put(ASName.create("saraethai"), "0E40");
        hashMap.put(ASName.create("saraiileftthai"), "F886");
        hashMap.put(ASName.create("saraiithai"), "0E35");
        hashMap.put(ASName.create("saraileftthai"), "F885");
        hashMap.put(ASName.create("saraithai"), "0E34");
        hashMap.put(ASName.create("saraothai"), "0E42");
        hashMap.put(ASName.create("saraueeleftthai"), "F888");
        hashMap.put(ASName.create("saraueethai"), "0E37");
        hashMap.put(ASName.create("saraueleftthai"), "F887");
        hashMap.put(ASName.create("sarauethai"), "0E36");
        hashMap.put(ASName.create("sarauthai"), "0E38");
        hashMap.put(ASName.create("sarauuthai"), "0E39");
        hashMap.put(ASName.create("sbopomofo"), "3119");
        hashMap.put(ASName.create("scaron"), "0161");
        hashMap.put(ASName.create("scarondotaccent"), "1E67");
        hashMap.put(ASName.create("scedilla"), "015F");
        hashMap.put(ASName.create("schwa"), "0259");
        hashMap.put(ASName.create("schwacyrillic"), "04D9");
        hashMap.put(ASName.create("schwadieresiscyrillic"), "04DB");
        hashMap.put(ASName.create("schwahook"), "025A");
        hashMap.put(ASName.create("scircle"), "24E2");
        hashMap.put(ASName.create("scircumflex"), "015D");
        hashMap.put(ASName.create("scommaaccent"), "0219");
        hashMap.put(ASName.create("sdotaccent"), "1E61");
        hashMap.put(ASName.create("sdotbelow"), "1E63");
        hashMap.put(ASName.create("sdotbelowdotaccent"), "1E69");
        hashMap.put(ASName.create("seagullbelowcmb"), "033C");
        hashMap.put(ASName.create("second"), "2033");
        hashMap.put(ASName.create("secondtonechinese"), "02CA");
        hashMap.put(ASName.create("section"), "00A7");
        hashMap.put(ASName.create("seenarabic"), "0633");
        hashMap.put(ASName.create("seenfinalarabic"), "FEB2");
        hashMap.put(ASName.create("seeninitialarabic"), "FEB3");
        hashMap.put(ASName.create("seenmedialarabic"), "FEB4");
        hashMap.put(ASName.create("segol"), "05B6");
        hashMap.put(ASName.create("segol13"), "05B6");
        hashMap.put(ASName.create("segol1f"), "05B6");
        hashMap.put(ASName.create("segol2c"), "05B6");
        hashMap.put(ASName.create("segolhebrew"), "05B6");
        hashMap.put(ASName.create("segolnarrowhebrew"), "05B6");
        hashMap.put(ASName.create("segolquarterhebrew"), "05B6");
        hashMap.put(ASName.create("segoltahebrew"), "0592");
        hashMap.put(ASName.create("segolwidehebrew"), "05B6");
        hashMap.put(ASName.create("seharmenian"), "057D");
        hashMap.put(ASName.create("sehiragana"), "305B");
        hashMap.put(ASName.create("sekatakana"), "30BB");
        hashMap.put(ASName.create("sekatakanahalfwidth"), "FF7E");
        hashMap.put(ASName.create("semicolon"), "003B");
        hashMap.put(ASName.create("semicolonarabic"), "061B");
        hashMap.put(ASName.create("semicolonmonospace"), "FF1B");
        hashMap.put(ASName.create("semicolonsmall"), "FE54");
        hashMap.put(ASName.create("semivoicedmarkkana"), "309C");
        hashMap.put(ASName.create("semivoicedmarkkanahalfwidth"), "FF9F");
        hashMap.put(ASName.create("sentisquare"), "3322");
        hashMap.put(ASName.create("sentosquare"), "3323");
        hashMap.put(ASName.create("seven"), "0037");
        hashMap.put(ASName.create("sevenarabic"), "0667");
        hashMap.put(ASName.create("sevenbengali"), "09ED");
        hashMap.put(ASName.create("sevencircle"), "2466");
        hashMap.put(ASName.create("sevencircleinversesansserif"), "2790");
        hashMap.put(ASName.create("sevendeva"), "096D");
        hashMap.put(ASName.create("seveneighths"), "215E");
        hashMap.put(ASName.create("sevengujarati"), "0AED");
        hashMap.put(ASName.create("sevengurmukhi"), "0A6D");
        hashMap.put(ASName.create("sevenhackarabic"), "0667");
        hashMap.put(ASName.create("sevenhangzhou"), "3027");
        hashMap.put(ASName.create("sevenideographicparen"), "3226");
        hashMap.put(ASName.create("seveninferior"), "2087");
        hashMap.put(ASName.create("sevenmonospace"), "FF17");
        hashMap.put(ASName.create("sevenoldstyle"), "F737");
        hashMap.put(ASName.create("sevenparen"), "247A");
        hashMap.put(ASName.create("sevenperiod"), "248E");
        hashMap.put(ASName.create("sevenpersian"), "06F7");
        hashMap.put(ASName.create("sevenroman"), "2176");
        hashMap.put(ASName.create("sevensuperior"), "2077");
        hashMap.put(ASName.create("seventeencircle"), "2470");
        hashMap.put(ASName.create("seventeenparen"), "2484");
        hashMap.put(ASName.create("seventeenperiod"), "2498");
        hashMap.put(ASName.create("seventhai"), "0E57");
        hashMap.put(ASName.create("sfthyphen"), "00AD");
        hashMap.put(ASName.create("shaarmenian"), "0577");
        hashMap.put(ASName.create("shabengali"), "09B6");
        hashMap.put(ASName.create("shacyrillic"), "0448");
        hashMap.put(ASName.create("shaddaarabic"), "0651");
        hashMap.put(ASName.create("shaddadammaarabic"), "FC61");
        hashMap.put(ASName.create("shaddadammatanarabic"), "FC5E");
        hashMap.put(ASName.create("shaddafathaarabic"), "FC60");
        hashMap.put(ASName.create("shaddafathatanarabic"), "0651 064B");
        hashMap.put(ASName.create("shaddakasraarabic"), "FC62");
        hashMap.put(ASName.create("shaddakasratanarabic"), "FC5F");
        hashMap.put(ASName.create("shade"), "2592");
        hashMap.put(ASName.create("shadedark"), "2593");
        hashMap.put(ASName.create("shadelight"), "2591");
        hashMap.put(ASName.create("shademedium"), "2592");
        hashMap.put(ASName.create("shadeva"), "0936");
        hashMap.put(ASName.create("shagujarati"), "0AB6");
        hashMap.put(ASName.create("shagurmukhi"), "0A36");
        hashMap.put(ASName.create("shalshelethebrew"), "0593");
        hashMap.put(ASName.create("shbopomofo"), "3115");
        hashMap.put(ASName.create("shchacyrillic"), "0449");
        hashMap.put(ASName.create("sheenarabic"), "0634");
        hashMap.put(ASName.create("sheenfinalarabic"), "FEB6");
        hashMap.put(ASName.create("sheeninitialarabic"), "FEB7");
        hashMap.put(ASName.create("sheenmedialarabic"), "FEB8");
        hashMap.put(ASName.create("sheicoptic"), "03E3");
        hashMap.put(ASName.create("sheqel"), "20AA");
        hashMap.put(ASName.create("sheqelhebrew"), "20AA");
        hashMap.put(ASName.create("sheva"), "05B0");
        hashMap.put(ASName.create("sheva115"), "05B0");
        hashMap.put(ASName.create("sheva15"), "05B0");
        hashMap.put(ASName.create("sheva22"), "05B0");
        hashMap.put(ASName.create("sheva2e"), "05B0");
        hashMap.put(ASName.create("shevahebrew"), "05B0");
        hashMap.put(ASName.create("shevanarrowhebrew"), "05B0");
        hashMap.put(ASName.create("shevaquarterhebrew"), "05B0");
        hashMap.put(ASName.create("shevawidehebrew"), "05B0");
        hashMap.put(ASName.create("shhacyrillic"), "04BB");
        hashMap.put(ASName.create("shimacoptic"), "03ED");
        hashMap.put(ASName.create("shin"), "05E9");
        hashMap.put(ASName.create("shindagesh"), "FB49");
        hashMap.put(ASName.create("shindageshhebrew"), "FB49");
        hashMap.put(ASName.create("shindageshshindot"), "FB2C");
        hashMap.put(ASName.create("shindageshshindothebrew"), "FB2C");
        hashMap.put(ASName.create("shindageshsindot"), "FB2D");
        hashMap.put(ASName.create("shindageshsindothebrew"), "FB2D");
        hashMap.put(ASName.create("shindothebrew"), "05C1");
        hashMap.put(ASName.create("shinhebrew"), "05E9");
        hashMap.put(ASName.create("shinshindot"), "FB2A");
        hashMap.put(ASName.create("shinshindothebrew"), "FB2A");
        hashMap.put(ASName.create("shinsindot"), "FB2B");
        hashMap.put(ASName.create("shinsindothebrew"), "FB2B");
        hashMap.put(ASName.create("shook"), "0282");
        hashMap.put(ASName.create("sigma"), "03C3");
        hashMap.put(ASName.create("sigma1"), "03C2");
        hashMap.put(ASName.create("sigmafinal"), "03C2");
        hashMap.put(ASName.create("sigmalunatesymbolgreek"), "03F2");
        hashMap.put(ASName.create("sihiragana"), "3057");
        hashMap.put(ASName.create("sikatakana"), "30B7");
        hashMap.put(ASName.create("sikatakanahalfwidth"), "FF7C");
        hashMap.put(ASName.create("siluqhebrew"), "05BD");
        hashMap.put(ASName.create("siluqlefthebrew"), "05BD");
        hashMap.put(ASName.create("similar"), "223C");
        hashMap.put(ASName.create("sindothebrew"), "05C2");
        hashMap.put(ASName.create("siosacirclekorean"), "3274");
        hashMap.put(ASName.create("siosaparenkorean"), "3214");
        hashMap.put(ASName.create("sioscieuckorean"), "317E");
        hashMap.put(ASName.create("sioscirclekorean"), "3266");
        hashMap.put(ASName.create("sioskiyeokkorean"), "317A");
        hashMap.put(ASName.create("sioskorean"), "3145");
        hashMap.put(ASName.create("siosnieunkorean"), "317B");
        hashMap.put(ASName.create("siosparenkorean"), "3206");
        hashMap.put(ASName.create("siospieupkorean"), "317D");
        hashMap.put(ASName.create("siostikeutkorean"), "317C");
        hashMap.put(ASName.create("six"), "0036");
        hashMap.put(ASName.create("sixarabic"), "0666");
        hashMap.put(ASName.create("sixbengali"), "09EC");
        hashMap.put(ASName.create("sixcircle"), "2465");
        hashMap.put(ASName.create("sixcircleinversesansserif"), "278F");
        hashMap.put(ASName.create("sixdeva"), "096C");
        hashMap.put(ASName.create("sixgujarati"), "0AEC");
        hashMap.put(ASName.create("sixgurmukhi"), "0A6C");
        hashMap.put(ASName.create("sixhackarabic"), "0666");
        hashMap.put(ASName.create("sixhangzhou"), "3026");
        hashMap.put(ASName.create("sixideographicparen"), "3225");
        hashMap.put(ASName.create("sixinferior"), "2086");
        hashMap.put(ASName.create("sixmonospace"), "FF16");
        hashMap.put(ASName.create("sixoldstyle"), "F736");
        hashMap.put(ASName.create("sixparen"), "2479");
        hashMap.put(ASName.create("sixperiod"), "248D");
        hashMap.put(ASName.create("sixpersian"), "06F6");
        hashMap.put(ASName.create("sixroman"), "2175");
        hashMap.put(ASName.create("sixsuperior"), "2076");
        hashMap.put(ASName.create("sixteencircle"), "246F");
        hashMap.put(ASName.create("sixteencurrencydenominatorbengali"), "09F9");
        hashMap.put(ASName.create("sixteenparen"), "2483");
        hashMap.put(ASName.create("sixteenperiod"), "2497");
        hashMap.put(ASName.create("sixthai"), "0E56");
        hashMap.put(ASName.create("slash"), "002F");
        hashMap.put(ASName.create("slashmonospace"), "FF0F");
        hashMap.put(ASName.create("slong"), "017F");
        hashMap.put(ASName.create("slongdotaccent"), "1E9B");
        hashMap.put(ASName.create("smileface"), "263A");
        hashMap.put(ASName.create("smonospace"), "FF53");
        hashMap.put(ASName.create("sofpasuqhebrew"), "05C3");
        hashMap.put(ASName.create("softhyphen"), "00AD");
        hashMap.put(ASName.create("softsigncyrillic"), "044C");
        hashMap.put(ASName.create("sohiragana"), "305D");
        hashMap.put(ASName.create("sokatakana"), "30BD");
        hashMap.put(ASName.create("sokatakanahalfwidth"), "FF7F");
        hashMap.put(ASName.create("soliduslongoverlaycmb"), "0338");
        hashMap.put(ASName.create("solidusshortoverlaycmb"), "0337");
        hashMap.put(ASName.create("sorusithai"), "0E29");
        hashMap.put(ASName.create("sosalathai"), "0E28");
        hashMap.put(ASName.create("sosothai"), "0E0B");
        hashMap.put(ASName.create("sosuathai"), "0E2A");
        hashMap.put(ASName.create("space"), "0020");
        hashMap.put(ASName.create("spade"), "2660");
        hashMap.put(ASName.create("spadesuitblack"), "2660");
        hashMap.put(ASName.create("spadesuitwhite"), "2664");
        hashMap.put(ASName.create("sparen"), "24AE");
        hashMap.put(ASName.create("squarebelowcmb"), "033B");
        hashMap.put(ASName.create("squarecc"), "33C4");
        hashMap.put(ASName.create("squarecm"), "339D");
        hashMap.put(ASName.create("squarediagonalcrosshatchfill"), "25A9");
        hashMap.put(ASName.create("squarehorizontalfill"), "25A4");
        hashMap.put(ASName.create("squarekg"), "338F");
        hashMap.put(ASName.create("squarekm"), "339E");
        hashMap.put(ASName.create("squarekmcapital"), "33CE");
        hashMap.put(ASName.create("squareln"), "33D1");
        hashMap.put(ASName.create("squarelog"), "33D2");
        hashMap.put(ASName.create("squaremg"), "338E");
        hashMap.put(ASName.create("squaremil"), "33D5");
        hashMap.put(ASName.create("squaremm"), "339C");
        hashMap.put(ASName.create("squaremsquared"), "33A1");
        hashMap.put(ASName.create("squareorthogonalcrosshatchfill"), "25A6");
        hashMap.put(ASName.create("squareupperlefttolowerrightfill"), "25A7");
        hashMap.put(ASName.create("squareupperrighttolowerleftfill"), "25A8");
        hashMap.put(ASName.create("squareverticalfill"), "25A5");
        hashMap.put(ASName.create("squarewhitewithsmallblack"), "25A3");
        hashMap.put(ASName.create("srsquare"), "33DB");
        hashMap.put(ASName.create("ssabengali"), "09B7");
        hashMap.put(ASName.create("ssadeva"), "0937");
        hashMap.put(ASName.create("ssagujarati"), "0AB7");
        hashMap.put(ASName.create("ssangcieuckorean"), "3149");
        hashMap.put(ASName.create("ssanghieuhkorean"), "3185");
        hashMap.put(ASName.create("ssangieungkorean"), "3180");
        hashMap.put(ASName.create("ssangkiyeokkorean"), "3132");
        hashMap.put(ASName.create("ssangnieunkorean"), "3165");
        hashMap.put(ASName.create("ssangpieupkorean"), "3143");
        hashMap.put(ASName.create("ssangsioskorean"), "3146");
        hashMap.put(ASName.create("ssangtikeutkorean"), "3138");
        hashMap.put(ASName.create("ssuperior"), "F6F2");
        hashMap.put(ASName.create("sterling"), "00A3");
        hashMap.put(ASName.create("sterlingmonospace"), "FFE1");
        hashMap.put(ASName.create("strokelongoverlaycmb"), "0336");
        hashMap.put(ASName.create("strokeshortoverlaycmb"), "0335");
        hashMap.put(ASName.create("subset"), "2282");
        hashMap.put(ASName.create("subsetnotequal"), "228A");
        hashMap.put(ASName.create("subsetorequal"), "2286");
        hashMap.put(ASName.create("succeeds"), "227B");
        hashMap.put(ASName.create("suchthat"), "220B");
        hashMap.put(ASName.create("suhiragana"), "3059");
        hashMap.put(ASName.create("sukatakana"), "30B9");
        hashMap.put(ASName.create("sukatakanahalfwidth"), "FF7D");
        hashMap.put(ASName.create("sukunarabic"), "0652");
        hashMap.put(ASName.create("summation"), "2211");
        hashMap.put(ASName.create("sun"), "263C");
        hashMap.put(ASName.create("superset"), "2283");
        hashMap.put(ASName.create("supersetnotequal"), "228B");
        hashMap.put(ASName.create("supersetorequal"), "2287");
        hashMap.put(ASName.create("svsquare"), "33DC");
        hashMap.put(ASName.create("syouwaerasquare"), "337C");
        hashMap.put(ASName.create("t"), "0074");
        hashMap.put(ASName.create("tabengali"), "09A4");
        hashMap.put(ASName.create("tackdown"), "22A4");
        hashMap.put(ASName.create("tackleft"), "22A3");
        hashMap.put(ASName.create("tadeva"), "0924");
        hashMap.put(ASName.create("tagujarati"), "0AA4");
        hashMap.put(ASName.create("tagurmukhi"), "0A24");
        hashMap.put(ASName.create("taharabic"), "0637");
        hashMap.put(ASName.create("tahfinalarabic"), "FEC2");
        hashMap.put(ASName.create("tahinitialarabic"), "FEC3");
        hashMap.put(ASName.create("tahiragana"), "305F");
        hashMap.put(ASName.create("tahmedialarabic"), "FEC4");
        hashMap.put(ASName.create("taisyouerasquare"), "337D");
        hashMap.put(ASName.create("takatakana"), "30BF");
        hashMap.put(ASName.create("takatakanahalfwidth"), "FF80");
        hashMap.put(ASName.create("tatweelarabic"), "0640");
        hashMap.put(ASName.create("tau"), "03C4");
        hashMap.put(ASName.create("tav"), "05EA");
        hashMap.put(ASName.create("tavdages"), "FB4A");
        hashMap.put(ASName.create("tavdagesh"), "FB4A");
        hashMap.put(ASName.create("tavdageshhebrew"), "FB4A");
        hashMap.put(ASName.create("tavhebrew"), "05EA");
        hashMap.put(ASName.create("tbar"), "0167");
        hashMap.put(ASName.create("tbopomofo"), "310A");
        hashMap.put(ASName.create("tcaron"), "0165");
        hashMap.put(ASName.create("tccurl"), "02A8");
        hashMap.put(ASName.create("tcedilla"), "0163");
        hashMap.put(ASName.create("tcheharabic"), "0686");
        hashMap.put(ASName.create("tchehfinalarabic"), "FB7B");
        hashMap.put(ASName.create("tchehinitialarabic"), "FB7C");
        hashMap.put(ASName.create("tchehmedialarabic"), "FB7D");
        hashMap.put(ASName.create("tchehmeeminitialarabic"), "FB7CFEE4");
        hashMap.put(ASName.create("tcircle"), "24E3");
        hashMap.put(ASName.create("tcircumflexbelow"), "1E71");
        hashMap.put(ASName.create("tcommaaccent"), "0163");
        hashMap.put(ASName.create("tdieresis"), "1E97");
        hashMap.put(ASName.create("tdotaccent"), "1E6B");
        hashMap.put(ASName.create("tdotbelow"), "1E6D");
        hashMap.put(ASName.create("tecyrillic"), "0442");
        hashMap.put(ASName.create("tedescendercyrillic"), "04AD");
        hashMap.put(ASName.create("teharabic"), "062A");
        hashMap.put(ASName.create("tehfinalarabic"), "FE96");
        hashMap.put(ASName.create("tehhahinitialarabic"), "FCA2");
        hashMap.put(ASName.create("tehhahisolatedarabic"), "FC0C");
        hashMap.put(ASName.create("tehinitialarabic"), "FE97");
        hashMap.put(ASName.create("tehiragana"), "3066");
        hashMap.put(ASName.create("tehjeeminitialarabic"), "FCA1");
        hashMap.put(ASName.create("tehjeemisolatedarabic"), "FC0B");
        hashMap.put(ASName.create("tehmarbutaarabic"), "0629");
        hashMap.put(ASName.create("tehmarbutafinalarabic"), "FE94");
        hashMap.put(ASName.create("tehmedialarabic"), "FE98");
        hashMap.put(ASName.create("tehmeeminitialarabic"), "FCA4");
        hashMap.put(ASName.create("tehmeemisolatedarabic"), "FC0E");
        hashMap.put(ASName.create("tehnoonfinalarabic"), "FC73");
        hashMap.put(ASName.create("tekatakana"), "30C6");
        hashMap.put(ASName.create("tekatakanahalfwidth"), "FF83");
        hashMap.put(ASName.create("telephone"), "2121");
        hashMap.put(ASName.create("telephoneblack"), "260E");
        hashMap.put(ASName.create("telishagedolahebrew"), "05A0");
        hashMap.put(ASName.create("telishaqetanahebrew"), "05A9");
        hashMap.put(ASName.create("tencircle"), "2469");
        hashMap.put(ASName.create("tenideographicparen"), "3229");
        hashMap.put(ASName.create("tenparen"), "247D");
        hashMap.put(ASName.create("tenperiod"), "2491");
        hashMap.put(ASName.create("tenroman"), "2179");
        hashMap.put(ASName.create("tesh"), "02A7");
        hashMap.put(ASName.create("tet"), "05D8");
        hashMap.put(ASName.create("tetdagesh"), "FB38");
        hashMap.put(ASName.create("tetdageshhebrew"), "FB38");
        hashMap.put(ASName.create("tethebrew"), "05D8");
        hashMap.put(ASName.create("tetsecyrillic"), "04B5");
        hashMap.put(ASName.create("tevirhebrew"), "059B");
        hashMap.put(ASName.create("tevirlefthebrew"), "059B");
        hashMap.put(ASName.create("thabengali"), "09A5");
        hashMap.put(ASName.create("thadeva"), "0925");
        hashMap.put(ASName.create("thagujarati"), "0AA5");
        hashMap.put(ASName.create("thagurmukhi"), "0A25");
        hashMap.put(ASName.create("thalarabic"), "0630");
        hashMap.put(ASName.create("thalfinalarabic"), "FEAC");
        hashMap.put(ASName.create("thanthakhatlowleftthai"), "F898");
        hashMap.put(ASName.create("thanthakhatlowrightthai"), "F897");
        hashMap.put(ASName.create("thanthakhatthai"), "0E4C");
        hashMap.put(ASName.create("thanthakhatupperleftthai"), "F896");
        hashMap.put(ASName.create("theharabic"), "062B");
        hashMap.put(ASName.create("thehfinalarabic"), "FE9A");
        hashMap.put(ASName.create("thehinitialarabic"), "FE9B");
        hashMap.put(ASName.create("thehmedialarabic"), "FE9C");
        hashMap.put(ASName.create("thereexists"), "2203");
        hashMap.put(ASName.create("therefore"), "2234");
        hashMap.put(ASName.create("theta"), "03B8");
        hashMap.put(ASName.create("theta1"), "03D1");
        hashMap.put(ASName.create("thetasymbolgreek"), "03D1");
        hashMap.put(ASName.create("thieuthacirclekorean"), "3279");
        hashMap.put(ASName.create("thieuthaparenkorean"), "3219");
        hashMap.put(ASName.create("thieuthcirclekorean"), "326B");
        hashMap.put(ASName.create("thieuthkorean"), "314C");
        hashMap.put(ASName.create("thieuthparenkorean"), "320B");
        hashMap.put(ASName.create("thirteencircle"), "246C");
        hashMap.put(ASName.create("thirteenparen"), "2480");
        hashMap.put(ASName.create("thirteenperiod"), "2494");
        hashMap.put(ASName.create("thonangmonthothai"), "0E11");
        hashMap.put(ASName.create("thook"), "01AD");
        hashMap.put(ASName.create("thophuthaothai"), "0E12");
        hashMap.put(ASName.create("thorn"), "00FE");
        hashMap.put(ASName.create("thothahanthai"), "0E17");
        hashMap.put(ASName.create("thothanthai"), "0E10");
        hashMap.put(ASName.create("thothongthai"), "0E18");
        hashMap.put(ASName.create("thothungthai"), "0E16");
        hashMap.put(ASName.create("thousandcyrillic"), "0482");
        hashMap.put(ASName.create("thousandsseparatorarabic"), "066C");
        hashMap.put(ASName.create("thousandsseparatorpersian"), "066C");
        hashMap.put(ASName.create("three"), "0033");
        hashMap.put(ASName.create("threearabic"), "0663");
        hashMap.put(ASName.create("threebengali"), "09E9");
        hashMap.put(ASName.create("threecircle"), "2462");
        hashMap.put(ASName.create("threecircleinversesansserif"), "278C");
        hashMap.put(ASName.create("threedeva"), "0969");
        hashMap.put(ASName.create("threeeighths"), "215C");
        hashMap.put(ASName.create("threegujarati"), "0AE9");
        hashMap.put(ASName.create("threegurmukhi"), "0A69");
        hashMap.put(ASName.create("threehackarabic"), "0663");
        hashMap.put(ASName.create("threehangzhou"), "3023");
        hashMap.put(ASName.create("threeideographicparen"), "3222");
        hashMap.put(ASName.create("threeinferior"), "2083");
        hashMap.put(ASName.create("threemonospace"), "FF13");
        hashMap.put(ASName.create("threenumeratorbengali"), "09F6");
        hashMap.put(ASName.create("threeoldstyle"), "F733");
        hashMap.put(ASName.create("threeparen"), "2476");
        hashMap.put(ASName.create("threeperiod"), "248A");
        hashMap.put(ASName.create("threepersian"), "06F3");
        hashMap.put(ASName.create("threequarters"), "00BE");
        hashMap.put(ASName.create("threequartersemdash"), "F6DE");
        hashMap.put(ASName.create("threeroman"), "2172");
        hashMap.put(ASName.create("threesuperior"), "00B3");
        hashMap.put(ASName.create("threethai"), "0E53");
        hashMap.put(ASName.create("thzsquare"), "3394");
        hashMap.put(ASName.create("tihiragana"), "3061");
        hashMap.put(ASName.create("tikatakana"), "30C1");
        hashMap.put(ASName.create("tikatakanahalfwidth"), "FF81");
        hashMap.put(ASName.create("tikeutacirclekorean"), "3270");
        hashMap.put(ASName.create("tikeutaparenkorean"), "3210");
        hashMap.put(ASName.create("tikeutcirclekorean"), "3262");
        hashMap.put(ASName.create("tikeutkorean"), "3137");
        hashMap.put(ASName.create("tikeutparenkorean"), "3202");
        hashMap.put(ASName.create("tilde"), "02DC");
        hashMap.put(ASName.create("tildebelowcmb"), "0330");
        hashMap.put(ASName.create("tildecmb"), "0303");
        hashMap.put(ASName.create("tildecomb"), "0303");
        hashMap.put(ASName.create("tildedoublecmb"), "0360");
        hashMap.put(ASName.create("tildeoperator"), "223C");
        hashMap.put(ASName.create("tildeoverlaycmb"), "0334");
        hashMap.put(ASName.create("tildeverticalcmb"), "033E");
        hashMap.put(ASName.create("timescircle"), "2297");
        hashMap.put(ASName.create("tipehahebrew"), "0596");
        hashMap.put(ASName.create("tipehalefthebrew"), "0596");
        hashMap.put(ASName.create("tippigurmukhi"), "0A70");
        hashMap.put(ASName.create("titlocyrilliccmb"), "0483");
        hashMap.put(ASName.create("tiwnarmenian"), "057F");
        hashMap.put(ASName.create("tlinebelow"), "1E6F");
        hashMap.put(ASName.create("tmonospace"), "FF54");
        hashMap.put(ASName.create("toarmenian"), "0569");
        hashMap.put(ASName.create("tohiragana"), "3068");
        hashMap.put(ASName.create("tokatakana"), "30C8");
        hashMap.put(ASName.create("tokatakanahalfwidth"), "FF84");
        hashMap.put(ASName.create("tonebarextrahighmod"), "02E5");
        hashMap.put(ASName.create("tonebarextralowmod"), "02E9");
        hashMap.put(ASName.create("tonebarhighmod"), "02E6");
        hashMap.put(ASName.create("tonebarlowmod"), "02E8");
        hashMap.put(ASName.create("tonebarmidmod"), "02E7");
        hashMap.put(ASName.create("tonefive"), "01BD");
        hashMap.put(ASName.create("tonesix"), "0185");
        hashMap.put(ASName.create("tonetwo"), "01A8");
        hashMap.put(ASName.create("tonos"), "0384");
        hashMap.put(ASName.create("tonsquare"), "3327");
        hashMap.put(ASName.create("topatakthai"), "0E0F");
        hashMap.put(ASName.create("tortoiseshellbracketleft"), "3014");
        hashMap.put(ASName.create("tortoiseshellbracketleftsmall"), "FE5D");
        hashMap.put(ASName.create("tortoiseshellbracketleftvertical"), "FE39");
        hashMap.put(ASName.create("tortoiseshellbracketright"), "3015");
        hashMap.put(ASName.create("tortoiseshellbracketrightsmall"), "FE5E");
        hashMap.put(ASName.create("tortoiseshellbracketrightvertical"), "FE3A");
        hashMap.put(ASName.create("totaothai"), "0E15");
        hashMap.put(ASName.create("tpalatalhook"), "01AB");
        hashMap.put(ASName.create("tparen"), "24AF");
        hashMap.put(ASName.create("trademark"), "2122");
        hashMap.put(ASName.create("trademarksans"), "F8EA");
        hashMap.put(ASName.create("trademarkserif"), "F6DB");
        hashMap.put(ASName.create("tretroflexhook"), "0288");
        hashMap.put(ASName.create("triagdn"), "25BC");
        hashMap.put(ASName.create("triaglf"), "25C4");
        hashMap.put(ASName.create("triagrt"), "25BA");
        hashMap.put(ASName.create("triagup"), "25B2");
        hashMap.put(ASName.create("ts"), "02A6");
        hashMap.put(ASName.create("tsadi"), "05E6");
        hashMap.put(ASName.create("tsadidagesh"), "FB46");
        hashMap.put(ASName.create("tsadidageshhebrew"), "FB46");
        hashMap.put(ASName.create("tsadihebrew"), "05E6");
        hashMap.put(ASName.create("tsecyrillic"), "0446");
        hashMap.put(ASName.create("tsere"), "05B5");
        hashMap.put(ASName.create("tsere12"), "05B5");
        hashMap.put(ASName.create("tsere1e"), "05B5");
        hashMap.put(ASName.create("tsere2b"), "05B5");
        hashMap.put(ASName.create("tserehebrew"), "05B5");
        hashMap.put(ASName.create("tserenarrowhebrew"), "05B5");
        hashMap.put(ASName.create("tserequarterhebrew"), "05B5");
        hashMap.put(ASName.create("tserewidehebrew"), "05B5");
        hashMap.put(ASName.create("tshecyrillic"), "045B");
        hashMap.put(ASName.create("tsuperior"), "F6F3");
        hashMap.put(ASName.create("ttabengali"), "099F");
        hashMap.put(ASName.create("ttadeva"), "091F");
        hashMap.put(ASName.create("ttagujarati"), "0A9F");
        hashMap.put(ASName.create("ttagurmukhi"), "0A1F");
        hashMap.put(ASName.create("tteharabic"), "0679");
        hashMap.put(ASName.create("ttehfinalarabic"), "FB67");
        hashMap.put(ASName.create("ttehinitialarabic"), "FB68");
        hashMap.put(ASName.create("ttehmedialarabic"), "FB69");
        hashMap.put(ASName.create("tthabengali"), "09A0");
        hashMap.put(ASName.create("tthadeva"), "0920");
        hashMap.put(ASName.create("tthagujarati"), "0AA0");
        hashMap.put(ASName.create("tthagurmukhi"), "0A20");
        hashMap.put(ASName.create("tturned"), "0287");
        hashMap.put(ASName.create("tuhiragana"), "3064");
        hashMap.put(ASName.create("tukatakana"), "30C4");
        hashMap.put(ASName.create("tukatakanahalfwidth"), "FF82");
        hashMap.put(ASName.create("tusmallhiragana"), "3063");
        hashMap.put(ASName.create("tusmallkatakana"), "30C3");
        hashMap.put(ASName.create("tusmallkatakanahalfwidth"), "FF6F");
        hashMap.put(ASName.create("twelvecircle"), "246B");
        hashMap.put(ASName.create("twelveparen"), "247F");
        hashMap.put(ASName.create("twelveperiod"), "2493");
        hashMap.put(ASName.create("twelveroman"), "217B");
        hashMap.put(ASName.create("twentycircle"), "2473");
        hashMap.put(ASName.create("twentyhangzhou"), "5344");
        hashMap.put(ASName.create("twentyparen"), "2487");
        hashMap.put(ASName.create("twentyperiod"), "249B");
        hashMap.put(ASName.create("two"), "0032");
        hashMap.put(ASName.create("twoarabic"), "0662");
        hashMap.put(ASName.create("twobengali"), "09E8");
        hashMap.put(ASName.create("twocircle"), "2461");
        hashMap.put(ASName.create("twocircleinversesansserif"), "278B");
        hashMap.put(ASName.create("twodeva"), "0968");
        hashMap.put(ASName.create("twodotenleader"), "2025");
        hashMap.put(ASName.create("twodotleader"), "2025");
        hashMap.put(ASName.create("twodotleadervertical"), "FE30");
        hashMap.put(ASName.create("twogujarati"), "0AE8");
        hashMap.put(ASName.create("twogurmukhi"), "0A68");
        hashMap.put(ASName.create("twohackarabic"), "0662");
        hashMap.put(ASName.create("twohangzhou"), "3022");
        hashMap.put(ASName.create("twoideographicparen"), "3221");
        hashMap.put(ASName.create("twoinferior"), "2082");
        hashMap.put(ASName.create("twomonospace"), "FF12");
        hashMap.put(ASName.create("twonumeratorbengali"), "09F5");
        hashMap.put(ASName.create("twooldstyle"), "F732");
        hashMap.put(ASName.create("twoparen"), "2475");
        hashMap.put(ASName.create("twoperiod"), "2489");
        hashMap.put(ASName.create("twopersian"), "06F2");
        hashMap.put(ASName.create("tworoman"), "2171");
        hashMap.put(ASName.create("twostroke"), "01BB");
        hashMap.put(ASName.create("twosuperior"), "00B2");
        hashMap.put(ASName.create("twothai"), "0E52");
        hashMap.put(ASName.create("twothirds"), "2154");
        hashMap.put(ASName.create("u"), "0075");
        hashMap.put(ASName.create("uacute"), "00FA");
        hashMap.put(ASName.create("ubar"), "0289");
        hashMap.put(ASName.create("ubengali"), "0989");
        hashMap.put(ASName.create("ubopomofo"), "3128");
        hashMap.put(ASName.create("ubreve"), "016D");
        hashMap.put(ASName.create("ucaron"), "01D4");
        hashMap.put(ASName.create("ucircle"), "24E4");
        hashMap.put(ASName.create("ucircumflex"), "00FB");
        hashMap.put(ASName.create("ucircumflexbelow"), "1E77");
        hashMap.put(ASName.create("ucyrillic"), "0443");
        hashMap.put(ASName.create("udattadeva"), "0951");
        hashMap.put(ASName.create("udblacute"), "0171");
        hashMap.put(ASName.create("udblgrave"), "0215");
        hashMap.put(ASName.create("udeva"), "0909");
        hashMap.put(ASName.create("udieresis"), "00FC");
        hashMap.put(ASName.create("udieresisacute"), "01D8");
        hashMap.put(ASName.create("udieresisbelow"), "1E73");
        hashMap.put(ASName.create("udieresiscaron"), "01DA");
        hashMap.put(ASName.create("udieresiscyrillic"), "04F1");
        hashMap.put(ASName.create("udieresisgrave"), "01DC");
        hashMap.put(ASName.create("udieresismacron"), "01D6");
        hashMap.put(ASName.create("udotbelow"), "1EE5");
        hashMap.put(ASName.create("ugrave"), "00F9");
        hashMap.put(ASName.create("ugujarati"), "0A89");
        hashMap.put(ASName.create("ugurmukhi"), "0A09");
        hashMap.put(ASName.create("uhiragana"), "3046");
        hashMap.put(ASName.create("uhookabove"), "1EE7");
        hashMap.put(ASName.create("uhorn"), "01B0");
        hashMap.put(ASName.create("uhornacute"), "1EE9");
        hashMap.put(ASName.create("uhorndotbelow"), "1EF1");
        hashMap.put(ASName.create("uhorngrave"), "1EEB");
        hashMap.put(ASName.create("uhornhookabove"), "1EED");
        hashMap.put(ASName.create("uhorntilde"), "1EEF");
        hashMap.put(ASName.create("uhungarumlaut"), "0171");
        hashMap.put(ASName.create("uhungarumlautcyrillic"), "04F3");
        hashMap.put(ASName.create("uinvertedbreve"), "0217");
        hashMap.put(ASName.create("ukatakana"), "30A6");
        hashMap.put(ASName.create("ukatakanahalfwidth"), "FF73");
        hashMap.put(ASName.create("ukcyrillic"), "0479");
        hashMap.put(ASName.create("ukorean"), "315C");
        hashMap.put(ASName.create("umacron"), "016B");
        hashMap.put(ASName.create("umacroncyrillic"), "04EF");
        hashMap.put(ASName.create("umacrondieresis"), "1E7B");
        hashMap.put(ASName.create("umatragurmukhi"), "0A41");
        hashMap.put(ASName.create("umonospace"), "FF55");
        hashMap.put(ASName.create("underscore"), "005F");
        hashMap.put(ASName.create("underscoredbl"), "2017");
        hashMap.put(ASName.create("underscoremonospace"), "FF3F");
        hashMap.put(ASName.create("underscorevertical"), "FE33");
        hashMap.put(ASName.create("underscorewavy"), "FE4F");
        hashMap.put(ASName.create("union"), "222A");
        hashMap.put(ASName.create("universal"), "2200");
        hashMap.put(ASName.create("uogonek"), "0173");
        hashMap.put(ASName.create("uparen"), "24B0");
        hashMap.put(ASName.create("upblock"), "2580");
        hashMap.put(ASName.create("upperdothebrew"), "05C4");
        hashMap.put(ASName.create("upsilon"), "03C5");
        hashMap.put(ASName.create("upsilondieresis"), "03CB");
        hashMap.put(ASName.create("upsilondieresistonos"), "03B0");
        hashMap.put(ASName.create("upsilonlatin"), "028A");
        hashMap.put(ASName.create("upsilontonos"), "03CD");
        hashMap.put(ASName.create("uptackbelowcmb"), "031D");
        hashMap.put(ASName.create("uptackmod"), "02D4");
        hashMap.put(ASName.create("uragurmukhi"), "0A73");
        hashMap.put(ASName.create("uring"), "016F");
        hashMap.put(ASName.create("ushortcyrillic"), "045E");
        hashMap.put(ASName.create("usmallhiragana"), "3045");
        hashMap.put(ASName.create("usmallkatakana"), "30A5");
        hashMap.put(ASName.create("usmallkatakanahalfwidth"), "FF69");
        hashMap.put(ASName.create("ustraightcyrillic"), "04AF");
        hashMap.put(ASName.create("ustraightstrokecyrillic"), "04B1");
        hashMap.put(ASName.create("utilde"), "0169");
        hashMap.put(ASName.create("utildeacute"), "1E79");
        hashMap.put(ASName.create("utildebelow"), "1E75");
        hashMap.put(ASName.create("uubengali"), "098A");
        hashMap.put(ASName.create("uudeva"), "090A");
        hashMap.put(ASName.create("uugujarati"), "0A8A");
        hashMap.put(ASName.create("uugurmukhi"), "0A0A");
        hashMap.put(ASName.create("uumatragurmukhi"), "0A42");
        hashMap.put(ASName.create("uuvowelsignbengali"), "09C2");
        hashMap.put(ASName.create("uuvowelsigndeva"), "0942");
        hashMap.put(ASName.create("uuvowelsigngujarati"), "0AC2");
        hashMap.put(ASName.create("uvowelsignbengali"), "09C1");
        hashMap.put(ASName.create("uvowelsigndeva"), "0941");
        hashMap.put(ASName.create("uvowelsigngujarati"), "0AC1");
        hashMap.put(ASName.create("v"), "0076");
        hashMap.put(ASName.create("vadeva"), "0935");
        hashMap.put(ASName.create("vagujarati"), "0AB5");
        hashMap.put(ASName.create("vagurmukhi"), "0A35");
        hashMap.put(ASName.create("vakatakana"), "30F7");
        hashMap.put(ASName.create("vav"), "05D5");
        hashMap.put(ASName.create("vavdagesh"), "FB35");
        hashMap.put(ASName.create("vavdagesh65"), "FB35");
        hashMap.put(ASName.create("vavdageshhebrew"), "FB35");
        hashMap.put(ASName.create("vavhebrew"), "05D5");
        hashMap.put(ASName.create("vavholam"), "FB4B");
        hashMap.put(ASName.create("vavholamhebrew"), "FB4B");
        hashMap.put(ASName.create("vavvavhebrew"), "05F0");
        hashMap.put(ASName.create("vavyodhebrew"), "05F1");
        hashMap.put(ASName.create("vcircle"), "24E5");
        hashMap.put(ASName.create("vdotbelow"), "1E7F");
        hashMap.put(ASName.create("vecyrillic"), "0432");
        hashMap.put(ASName.create("veharabic"), "06A4");
        hashMap.put(ASName.create("vehfinalarabic"), "FB6B");
        hashMap.put(ASName.create("vehinitialarabic"), "FB6C");
        hashMap.put(ASName.create("vehmedialarabic"), "FB6D");
        hashMap.put(ASName.create("vekatakana"), "30F9");
        hashMap.put(ASName.create("venus"), "2640");
        hashMap.put(ASName.create("verticalbar"), "007C");
        hashMap.put(ASName.create("verticallineabovecmb"), "030D");
        hashMap.put(ASName.create("verticallinebelowcmb"), "0329");
        hashMap.put(ASName.create("verticallinelowmod"), "02CC");
        hashMap.put(ASName.create("verticallinemod"), "02C8");
        hashMap.put(ASName.create("vewarmenian"), "057E");
        hashMap.put(ASName.create("vhook"), "028B");
        hashMap.put(ASName.create("vikatakana"), "30F8");
        hashMap.put(ASName.create("viramabengali"), "09CD");
        hashMap.put(ASName.create("viramadeva"), "094D");
        hashMap.put(ASName.create("viramagujarati"), "0ACD");
        hashMap.put(ASName.create("visargabengali"), "0983");
        hashMap.put(ASName.create("visargadeva"), "0903");
        hashMap.put(ASName.create("visargagujarati"), "0A83");
        hashMap.put(ASName.create("vmonospace"), "FF56");
        hashMap.put(ASName.create("voarmenian"), "0578");
        hashMap.put(ASName.create("voicediterationhiragana"), "309E");
        hashMap.put(ASName.create("voicediterationkatakana"), "30FE");
        hashMap.put(ASName.create("voicedmarkkana"), "309B");
        hashMap.put(ASName.create("voicedmarkkanahalfwidth"), "FF9E");
        hashMap.put(ASName.create("vokatakana"), "30FA");
        hashMap.put(ASName.create("vparen"), "24B1");
        hashMap.put(ASName.create("vtilde"), "1E7D");
        hashMap.put(ASName.create("vturned"), "028C");
        hashMap.put(ASName.create("vuhiragana"), "3094");
        hashMap.put(ASName.create("vukatakana"), "30F4");
        hashMap.put(ASName.create("w"), "0077");
        hashMap.put(ASName.create("wacute"), "1E83");
        hashMap.put(ASName.create("waekorean"), "3159");
        hashMap.put(ASName.create("wahiragana"), "308F");
        hashMap.put(ASName.create("wakatakana"), "30EF");
        hashMap.put(ASName.create("wakatakanahalfwidth"), "FF9C");
        hashMap.put(ASName.create("wakorean"), "3158");
        hashMap.put(ASName.create("wasmallhiragana"), "308E");
        hashMap.put(ASName.create("wasmallkatakana"), "30EE");
        hashMap.put(ASName.create("wattosquare"), "3357");
        hashMap.put(ASName.create("wavedash"), "301C");
        hashMap.put(ASName.create("wavyunderscorevertical"), "FE34");
        hashMap.put(ASName.create("wawarabic"), "0648");
        hashMap.put(ASName.create("wawfinalarabic"), "FEEE");
        hashMap.put(ASName.create("wawhamzaabovearabic"), "0624");
        hashMap.put(ASName.create("wawhamzaabovefinalarabic"), "FE86");
        hashMap.put(ASName.create("wbsquare"), "33DD");
        hashMap.put(ASName.create("wcircle"), "24E6");
        hashMap.put(ASName.create("wcircumflex"), "0175");
        hashMap.put(ASName.create("wdieresis"), "1E85");
        hashMap.put(ASName.create("wdotaccent"), "1E87");
        hashMap.put(ASName.create("wdotbelow"), "1E89");
        hashMap.put(ASName.create("wehiragana"), "3091");
        hashMap.put(ASName.create("weierstrass"), "2118");
        hashMap.put(ASName.create("wekatakana"), "30F1");
        hashMap.put(ASName.create("wekorean"), "315E");
        hashMap.put(ASName.create("weokorean"), "315D");
        hashMap.put(ASName.create("wgrave"), "1E81");
        hashMap.put(ASName.create("whitebullet"), "25E6");
        hashMap.put(ASName.create("whitecircle"), "25CB");
        hashMap.put(ASName.create("whitecircleinverse"), "25D9");
        hashMap.put(ASName.create("whitecornerbracketleft"), "300E");
        hashMap.put(ASName.create("whitecornerbracketleftvertical"), "FE43");
        hashMap.put(ASName.create("whitecornerbracketright"), "300F");
        hashMap.put(ASName.create("whitecornerbracketrightvertical"), "FE44");
        hashMap.put(ASName.create("whitediamond"), "25C7");
        hashMap.put(ASName.create("whitediamondcontainingblacksmalldiamond"), "25C8");
        hashMap.put(ASName.create("whitedownpointingsmalltriangle"), "25BF");
        hashMap.put(ASName.create("whitedownpointingtriangle"), "25BD");
        hashMap.put(ASName.create("whiteleftpointingsmalltriangle"), "25C3");
        hashMap.put(ASName.create("whiteleftpointingtriangle"), "25C1");
        hashMap.put(ASName.create("whitelenticularbracketleft"), "3016");
        hashMap.put(ASName.create("whitelenticularbracketright"), "3017");
        hashMap.put(ASName.create("whiterightpointingsmalltriangle"), "25B9");
        hashMap.put(ASName.create("whiterightpointingtriangle"), "25B7");
        hashMap.put(ASName.create("whitesmallsquare"), "25AB");
        hashMap.put(ASName.create("whitesmilingface"), "263A");
        hashMap.put(ASName.create("whitesquare"), "25A1");
        hashMap.put(ASName.create("whitestar"), "2606");
        hashMap.put(ASName.create("whitetelephone"), "260F");
        hashMap.put(ASName.create("whitetortoiseshellbracketleft"), "3018");
        hashMap.put(ASName.create("whitetortoiseshellbracketright"), "3019");
        hashMap.put(ASName.create("whiteuppointingsmalltriangle"), "25B5");
        hashMap.put(ASName.create("whiteuppointingtriangle"), "25B3");
        hashMap.put(ASName.create("wihiragana"), "3090");
        hashMap.put(ASName.create("wikatakana"), "30F0");
        hashMap.put(ASName.create("wikorean"), "315F");
        hashMap.put(ASName.create("wmonospace"), "FF57");
        hashMap.put(ASName.create("wohiragana"), "3092");
        hashMap.put(ASName.create("wokatakana"), "30F2");
        hashMap.put(ASName.create("wokatakanahalfwidth"), "FF66");
        hashMap.put(ASName.create("won"), "20A9");
        hashMap.put(ASName.create("wonmonospace"), "FFE6");
        hashMap.put(ASName.create("wowaenthai"), "0E27");
        hashMap.put(ASName.create("wparen"), "24B2");
        hashMap.put(ASName.create("wring"), "1E98");
        hashMap.put(ASName.create("wsuperior"), "02B7");
        hashMap.put(ASName.create("wturned"), "028D");
        hashMap.put(ASName.create("wynn"), "01BF");
        hashMap.put(ASName.create("x"), "0078");
        hashMap.put(ASName.create("xabovecmb"), "033D");
        hashMap.put(ASName.create("xbopomofo"), "3112");
        hashMap.put(ASName.create("xcircle"), "24E7");
        hashMap.put(ASName.create("xdieresis"), "1E8D");
        hashMap.put(ASName.create("xdotaccent"), "1E8B");
        hashMap.put(ASName.create("xeharmenian"), "056D");
        hashMap.put(ASName.create("xi"), "03BE");
        hashMap.put(ASName.create("xmonospace"), "FF58");
        hashMap.put(ASName.create("xparen"), "24B3");
        hashMap.put(ASName.create("xsuperior"), "02E3");
        hashMap.put(ASName.create("y"), "0079");
        hashMap.put(ASName.create("yaadosquare"), "334E");
        hashMap.put(ASName.create("yabengali"), "09AF");
        hashMap.put(ASName.create("yacute"), "00FD");
        hashMap.put(ASName.create("yadeva"), "092F");
        hashMap.put(ASName.create("yaekorean"), "3152");
        hashMap.put(ASName.create("yagujarati"), "0AAF");
        hashMap.put(ASName.create("yagurmukhi"), "0A2F");
        hashMap.put(ASName.create("yahiragana"), "3084");
        hashMap.put(ASName.create("yakatakana"), "30E4");
        hashMap.put(ASName.create("yakatakanahalfwidth"), "FF94");
        hashMap.put(ASName.create("yakorean"), "3151");
        hashMap.put(ASName.create("yamakkanthai"), "0E4E");
        hashMap.put(ASName.create("yasmallhiragana"), "3083");
        hashMap.put(ASName.create("yasmallkatakana"), "30E3");
        hashMap.put(ASName.create("yasmallkatakanahalfwidth"), "FF6C");
        hashMap.put(ASName.create("yatcyrillic"), "0463");
        hashMap.put(ASName.create("ycircle"), "24E8");
        hashMap.put(ASName.create("ycircumflex"), "0177");
        hashMap.put(ASName.create("ydieresis"), "00FF");
        hashMap.put(ASName.create("ydotaccent"), "1E8F");
        hashMap.put(ASName.create("ydotbelow"), "1EF5");
        hashMap.put(ASName.create("yeharabic"), "064A");
        hashMap.put(ASName.create("yehbarreearabic"), "06D2");
        hashMap.put(ASName.create("yehbarreefinalarabic"), "FBAF");
        hashMap.put(ASName.create("yehfinalarabic"), "FEF2");
        hashMap.put(ASName.create("yehhamzaabovearabic"), "0626");
        hashMap.put(ASName.create("yehhamzaabovefinalarabic"), "FE8A");
        hashMap.put(ASName.create("yehhamzaaboveinitialarabic"), "FE8B");
        hashMap.put(ASName.create("yehhamzaabovemedialarabic"), "FE8C");
        hashMap.put(ASName.create("yehinitialarabic"), "FEF3");
        hashMap.put(ASName.create("yehmedialarabic"), "FEF4");
        hashMap.put(ASName.create("yehmeeminitialarabic"), "FCDD");
        hashMap.put(ASName.create("yehmeemisolatedarabic"), "FC58");
        hashMap.put(ASName.create("yehnoonfinalarabic"), "FC94");
        hashMap.put(ASName.create("yehthreedotsbelowarabic"), "06D1");
        hashMap.put(ASName.create("yekorean"), "3156");
        hashMap.put(ASName.create("yen"), "00A5");
        hashMap.put(ASName.create("yenmonospace"), "FFE5");
        hashMap.put(ASName.create("yeokorean"), "3155");
        hashMap.put(ASName.create("yeorinhieuhkorean"), "3186");
        hashMap.put(ASName.create("yerahbenyomohebrew"), "05AA");
        hashMap.put(ASName.create("yerahbenyomolefthebrew"), "05AA");
        hashMap.put(ASName.create("yericyrillic"), "044B");
        hashMap.put(ASName.create("yerudieresiscyrillic"), "04F9");
        hashMap.put(ASName.create("yesieungkorean"), "3181");
        hashMap.put(ASName.create("yesieungpansioskorean"), "3183");
        hashMap.put(ASName.create("yesieungsioskorean"), "3182");
        hashMap.put(ASName.create("yetivhebrew"), "059A");
        hashMap.put(ASName.create("ygrave"), "1EF3");
        hashMap.put(ASName.create("yhook"), "01B4");
        hashMap.put(ASName.create("yhookabove"), "1EF7");
        hashMap.put(ASName.create("yiarmenian"), "0575");
        hashMap.put(ASName.create("yicyrillic"), "0457");
        hashMap.put(ASName.create("yikorean"), "3162");
        hashMap.put(ASName.create("yinyang"), "262F");
        hashMap.put(ASName.create("yiwnarmenian"), "0582");
        hashMap.put(ASName.create("ymonospace"), "FF59");
        hashMap.put(ASName.create("yod"), "05D9");
        hashMap.put(ASName.create("yoddagesh"), "FB39");
        hashMap.put(ASName.create("yoddageshhebrew"), "FB39");
        hashMap.put(ASName.create("yodhebrew"), "05D9");
        hashMap.put(ASName.create("yodyodhebrew"), "05F2");
        hashMap.put(ASName.create("yodyodpatahhebrew"), "FB1F");
        hashMap.put(ASName.create("yohiragana"), "3088");
        hashMap.put(ASName.create("yoikorean"), "3189");
        hashMap.put(ASName.create("yokatakana"), "30E8");
        hashMap.put(ASName.create("yokatakanahalfwidth"), "FF96");
        hashMap.put(ASName.create("yokorean"), "315B");
        hashMap.put(ASName.create("yosmallhiragana"), "3087");
        hashMap.put(ASName.create("yosmallkatakana"), "30E7");
        hashMap.put(ASName.create("yosmallkatakanahalfwidth"), "FF6E");
        hashMap.put(ASName.create("yotgreek"), "03F3");
        hashMap.put(ASName.create("yoyaekorean"), "3188");
        hashMap.put(ASName.create("yoyakorean"), "3187");
        hashMap.put(ASName.create("yoyakthai"), "0E22");
        hashMap.put(ASName.create("yoyingthai"), "0E0D");
        hashMap.put(ASName.create("yparen"), "24B4");
        hashMap.put(ASName.create("ypogegrammeni"), "037A");
        hashMap.put(ASName.create("ypogegrammenigreekcmb"), "0345");
        hashMap.put(ASName.create("yr"), "01A6");
        hashMap.put(ASName.create("yring"), "1E99");
        hashMap.put(ASName.create("ysuperior"), "02B8");
        hashMap.put(ASName.create("ytilde"), "1EF9");
        hashMap.put(ASName.create("yturned"), "028E");
        hashMap.put(ASName.create("yuhiragana"), "3086");
        hashMap.put(ASName.create("yuikorean"), "318C");
        hashMap.put(ASName.create("yukatakana"), "30E6");
        hashMap.put(ASName.create("yukatakanahalfwidth"), "FF95");
        hashMap.put(ASName.create("yukorean"), "3160");
        hashMap.put(ASName.create("yusbigcyrillic"), "046B");
        hashMap.put(ASName.create("yusbigiotifiedcyrillic"), "046D");
        hashMap.put(ASName.create("yuslittlecyrillic"), "0467");
        hashMap.put(ASName.create("yuslittleiotifiedcyrillic"), "0469");
        hashMap.put(ASName.create("yusmallhiragana"), "3085");
        hashMap.put(ASName.create("yusmallkatakana"), "30E5");
        hashMap.put(ASName.create("yusmallkatakanahalfwidth"), "FF6D");
        hashMap.put(ASName.create("yuyekorean"), "318B");
        hashMap.put(ASName.create("yuyeokorean"), "318A");
        hashMap.put(ASName.create("yyabengali"), "09DF");
        hashMap.put(ASName.create("yyadeva"), "095F");
        hashMap.put(ASName.create("z"), "007A");
        hashMap.put(ASName.create("zaarmenian"), "0566");
        hashMap.put(ASName.create("zacute"), "017A");
        hashMap.put(ASName.create("zadeva"), "095B");
        hashMap.put(ASName.create("zagurmukhi"), "0A5B");
        hashMap.put(ASName.create("zaharabic"), "0638");
        hashMap.put(ASName.create("zahfinalarabic"), "FEC6");
        hashMap.put(ASName.create("zahinitialarabic"), "FEC7");
        hashMap.put(ASName.create("zahiragana"), "3056");
        hashMap.put(ASName.create("zahmedialarabic"), "FEC8");
        hashMap.put(ASName.create("zainarabic"), "0632");
        hashMap.put(ASName.create("zainfinalarabic"), "FEB0");
        hashMap.put(ASName.create("zakatakana"), "30B6");
        hashMap.put(ASName.create("zaqefgadolhebrew"), "0595");
        hashMap.put(ASName.create("zaqefqatanhebrew"), "0594");
        hashMap.put(ASName.create("zarqahebrew"), "0598");
        hashMap.put(ASName.create("zayin"), "05D6");
        hashMap.put(ASName.create("zayindagesh"), "FB36");
        hashMap.put(ASName.create("zayindageshhebrew"), "FB36");
        hashMap.put(ASName.create("zayinhebrew"), "05D6");
        hashMap.put(ASName.create("zbopomofo"), "3117");
        hashMap.put(ASName.create("zcaron"), "017E");
        hashMap.put(ASName.create("zcircle"), "24E9");
        hashMap.put(ASName.create("zcircumflex"), "1E91");
        hashMap.put(ASName.create("zcurl"), "0291");
        hashMap.put(ASName.create("zdot"), "017C");
        hashMap.put(ASName.create("zdotaccent"), "017C");
        hashMap.put(ASName.create("zdotbelow"), "1E93");
        hashMap.put(ASName.create("zecyrillic"), "0437");
        hashMap.put(ASName.create("zedescendercyrillic"), "0499");
        hashMap.put(ASName.create("zedieresiscyrillic"), "04DF");
        hashMap.put(ASName.create("zehiragana"), "305C");
        hashMap.put(ASName.create("zekatakana"), "30BC");
        hashMap.put(ASName.create("zero"), "0030");
        hashMap.put(ASName.create("zeroarabic"), "0660");
        hashMap.put(ASName.create("zerobengali"), "09E6");
        hashMap.put(ASName.create("zerodeva"), "0966");
        hashMap.put(ASName.create("zerogujarati"), "0AE6");
        hashMap.put(ASName.create("zerogurmukhi"), "0A66");
        hashMap.put(ASName.create("zerohackarabic"), "0660");
        hashMap.put(ASName.create("zeroinferior"), "2080");
        hashMap.put(ASName.create("zeromonospace"), "FF10");
        hashMap.put(ASName.create("zerooldstyle"), "F730");
        hashMap.put(ASName.create("zeropersian"), "06F0");
        hashMap.put(ASName.create("zerosuperior"), "2070");
        hashMap.put(ASName.create("zerothai"), "0E50");
        hashMap.put(ASName.create("zerowidthjoiner"), "FEFF");
        hashMap.put(ASName.create("zerowidthnonjoiner"), "200C");
        hashMap.put(ASName.create("zerowidthspace"), "200B");
        hashMap.put(ASName.create("zeta"), "03B6");
        hashMap.put(ASName.create("zhbopomofo"), "3113");
        hashMap.put(ASName.create("zhearmenian"), "056A");
        hashMap.put(ASName.create("zhebrevecyrillic"), "04C2");
        hashMap.put(ASName.create("zhecyrillic"), "0436");
        hashMap.put(ASName.create("zhedescendercyrillic"), "0497");
        hashMap.put(ASName.create("zhedieresiscyrillic"), "04DD");
        hashMap.put(ASName.create("zihiragana"), "3058");
        hashMap.put(ASName.create("zikatakana"), "30B8");
        hashMap.put(ASName.create("zinorhebrew"), "05AE");
        hashMap.put(ASName.create("zlinebelow"), "1E95");
        hashMap.put(ASName.create("zmonospace"), "FF5A");
        hashMap.put(ASName.create("zohiragana"), "305E");
        hashMap.put(ASName.create("zokatakana"), "30BE");
        hashMap.put(ASName.create("zparen"), "24B5");
        hashMap.put(ASName.create("zretroflexhook"), "0290");
        hashMap.put(ASName.create("zstroke"), "01B6");
        hashMap.put(ASName.create("zuhiragana"), "305A");
        hashMap.put(ASName.create("zukatakana"), "30BA");
    }
}

