/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util;

import com.adobe.internal.pdf.cos.util.PDFDocEncoding;
import com.adobe.internal.pdf.cos.util.Utility;

public class ASString {
    private byte[] bytes;
    private char[] chars;

    private void init(byte[] byArray) {
        this.bytes = byArray;
    }

    public ASString(byte[] byArray) {
        this.init(byArray);
    }

    public ASString(String string) {
        this.init(PDFDocEncoding.toUTF8(string));
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public char[] getChars() {
        if (this.chars == null) {
            if (this.bytes.length % 2 != 0) {
                throw new IllegalStateException("byte array does not contain an even number of bytes");
            }
            this.chars = new char[this.bytes.length / 2];
            for (int i = 0; i < this.chars.length; ++i) {
                this.chars[i] = this.getChar(i * 2);
            }
        }
        return this.chars;
    }

    public char getChar(int n) {
        return (char)(((this.bytes[n] & 0xFF) << 8) + (this.bytes[n + 1] & 0xFF));
    }

    public String asString() {
        String string = PDFDocEncoding.toAcrobatString(this.bytes);
        return string;
    }

    public String toString() {
        return this.asString();
    }

    public int compareTo(ASString aSString) {
        byte[] byArray = this.getBytes();
        byte[] byArray2 = aSString.getBytes();
        int n = byArray.length;
        int n2 = byArray2.length;
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return byArray[i] - byArray2[i];
        }
        return n - n2;
    }

    public boolean equals(ASString aSString) {
        return this.compareTo(aSString) == 0;
    }

    public int indexOf(byte[] byArray) {
        if (this.bytes == null) {
            return -1;
        }
        int[] nArray = Utility.ComputeKMPNextArray(byArray);
        return Utility.KMPFindFirst(byArray, nArray, this.bytes);
    }
}

