/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util;

import com.adobe.internal.pdf.cos.util.ASCoordinate;
import com.adobe.internal.pdf.cos.util.ASMatrix;

public class ASRectangle {
    private double left;
    private double bottom;
    private double right;
    private double top;

    public ASRectangle(ASCoordinate aSCoordinate, ASCoordinate aSCoordinate2) {
        this.left = aSCoordinate.x();
        this.bottom = aSCoordinate.y();
        this.right = aSCoordinate2.x();
        this.top = aSCoordinate2.y();
    }

    public ASRectangle(double d, double d2, double d3, double d4) {
        this.left = d;
        this.bottom = d2;
        this.right = d3;
        this.top = d4;
    }

    public ASRectangle(double[] dArray) {
        if (dArray.length != 4) {
            throw new IllegalArgumentException("attempt to construct ASRectangle with invalid parameters");
        }
        this.left = dArray[0];
        this.bottom = dArray[1];
        this.right = dArray[2];
        this.top = dArray[3];
    }

    public ASRectangle(ASRectangle aSRectangle) {
        this.left = aSRectangle.left;
        this.bottom = aSRectangle.bottom;
        this.right = aSRectangle.right;
        this.top = aSRectangle.top;
    }

    public String toString() {
        return "[ " + this.left + " " + this.bottom + " " + this.right + " " + this.top + " ]";
    }

    public double[] getValues() {
        double[] dArray = new double[]{this.left, this.bottom, this.right, this.top};
        return dArray;
    }

    public ASCoordinate ll() {
        return new ASCoordinate(this.left, this.bottom);
    }

    public ASCoordinate lr() {
        return new ASCoordinate(this.right, this.bottom);
    }

    public ASCoordinate ur() {
        return new ASCoordinate(this.right, this.top);
    }

    public ASCoordinate ul() {
        return new ASCoordinate(this.left, this.top);
    }

    public double left() {
        return this.left;
    }

    public double bottom() {
        return this.bottom;
    }

    public double right() {
        return this.right;
    }

    public double top() {
        return this.top;
    }

    public double width() {
        return Math.abs(this.right - this.left);
    }

    public double height() {
        return Math.abs(this.top - this.bottom);
    }

    public ASRectangle transform(ASMatrix aSMatrix) {
        ASCoordinate aSCoordinate = this.ll().transform(aSMatrix);
        ASCoordinate aSCoordinate2 = this.ur().transform(aSMatrix);
        return new ASRectangle(aSCoordinate, aSCoordinate2);
    }
}

