/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util;

import com.adobe.internal.pdf.cos.util.ASCoordinate;
import com.adobe.internal.pdf.cos.util.ASMatrix;
import com.adobe.internal.pdf.cos.util.ASRectangle;

public class ASQuad {
    private ASCoordinate p1;
    private ASCoordinate p2;
    private ASCoordinate p3;
    private ASCoordinate p4;

    public ASQuad(ASCoordinate aSCoordinate, ASCoordinate aSCoordinate2, ASCoordinate aSCoordinate3, ASCoordinate aSCoordinate4) {
        this.p1 = aSCoordinate;
        this.p2 = aSCoordinate2;
        this.p3 = aSCoordinate3;
        this.p4 = aSCoordinate4;
    }

    public ASQuad(ASRectangle aSRectangle) {
        this.p1 = new ASCoordinate(aSRectangle.ll());
        this.p2 = new ASCoordinate(aSRectangle.lr());
        this.p3 = new ASCoordinate(aSRectangle.ur());
        this.p4 = new ASCoordinate(aSRectangle.ul());
    }

    public ASQuad(ASQuad aSQuad) {
        this.p1 = new ASCoordinate(aSQuad.p1);
        this.p2 = new ASCoordinate(aSQuad.p2);
        this.p3 = new ASCoordinate(aSQuad.p3);
        this.p4 = new ASCoordinate(aSQuad.p4);
    }

    public ASCoordinate p1() {
        return this.p1;
    }

    public ASCoordinate p2() {
        return this.p2;
    }

    public ASCoordinate p3() {
        return this.p3;
    }

    public ASCoordinate p4() {
        return this.p4;
    }

    public ASQuad transform(ASMatrix aSMatrix) {
        ASCoordinate aSCoordinate = this.p1.transform(aSMatrix);
        ASCoordinate aSCoordinate2 = this.p2.transform(aSMatrix);
        ASCoordinate aSCoordinate3 = this.p3.transform(aSMatrix);
        ASCoordinate aSCoordinate4 = this.p4.transform(aSMatrix);
        return new ASQuad(aSCoordinate, aSCoordinate2, aSCoordinate3, aSCoordinate4);
    }

    public String toString() {
        return "[ " + this.p1.toString() + " " + this.p2.toString() + " " + this.p3.toString() + " " + this.p4.toString() + " ]";
    }
}

