/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util;

import com.adobe.internal.pdf.cos.util.ASString;
import com.adobe.pdf.exceptions.PDFParseException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class ASNumber
extends Number {
    private ASString strVal;
    private Number numVal;

    public ASNumber(ASString aSString) {
        this.strVal = aSString;
        this.numVal = ASNumber.convertString(aSString);
    }

    public ASNumber(String string) {
        this.strVal = new ASString(string);
        this.numVal = ASNumber.convertString(this.strVal);
    }

    public ASNumber(Number number) {
        this.strVal = new ASString(number.toString());
        this.numVal = number;
    }

    public ASNumber(int n) {
        this.strVal = new ASString(Integer.toString(n));
        this.numVal = new Integer(n);
    }

    public ASNumber(long l) {
        this.strVal = new ASString(Long.toString(l));
        this.numVal = new Long(l);
    }

    public ASNumber(float f) {
        this.strVal = new ASString(Float.toString(f));
        this.numVal = new Float(f);
    }

    public ASNumber(double d) {
        this.strVal = new ASString(Double.toString(d));
        this.numVal = new Double(d);
    }

    public ASString strValue() {
        return this.strVal;
    }

    public String toString() {
        return this.strVal.asString();
    }

    public int intValue() {
        return this.numVal.intValue();
    }

    public long longValue() {
        return this.numVal.longValue();
    }

    public float floatValue() {
        return this.numVal.floatValue();
    }

    public double doubleValue() {
        return this.numVal.doubleValue();
    }

    private static Number convertString(ASString aSString) {
        try {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            return numberFormat.parse(aSString.asString());
        }
        catch (ParseException parseException) {
            throw new PDFParseException(parseException.getMessage());
        }
    }
}

